/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Base64Binary;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class HexBinary
extends BinaryValue {
    public HexBinary(byte[] data) {
        super(data);
    }

    public HexBinary(String in) throws XPathException {
        in = StringValue.trimWhitespace(in);
        if ((in.length() & 1) != 0) {
            throw new XPathException("FORG0001: A hexBinary value must contain an even number of characters");
        }
        this.data = new byte[in.length() / 2];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)((this.fromHex(in.charAt(2 * i)) << 4) + this.fromHex(in.charAt(2 * i + 1)));
        }
    }

    public int getType() {
        return 27;
    }

    private int fromHex(char c) throws XPathException {
        int d = "0123456789ABCDEFabcdef".indexOf(c);
        if (d > 15) {
            d -= 6;
        }
        if (d < 0) {
            throw new XPathException("FORG0001: Invalid hexadecimal digit: " + c);
        }
        return d;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 27: {
                return this;
            }
            case 26: {
                return new Base64Binary(this.data);
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue().trim());
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
        }
        throw new XPathException("cannot convert " + Type.getTypeName(this.getType()) + " to " + Type.getTypeName(requiredType));
    }

    public String getStringValue() throws XPathException {
        String digits = "0123456789ABCDEF";
        StringBuffer sb = new StringBuffer(this.data.length * 2);
        for (int i = 0; i < this.data.length; ++i) {
            sb.append(digits.charAt(this.data[i] >> 4 & 0xF));
            sb.append(digits.charAt(this.data[i] & 0xF));
        }
        return sb.toString();
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(HexBinary.class)) {
            return this;
        }
        if (target.isArray() && target == Byte.class) {
            return this.data;
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("FORG0006: value of type " + Type.getTypeName(this.getType()) + " has no boolean value.");
    }
}

