/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.addons.ContactsEntryCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.ResourceMap;

public class CalendarEntryContactTableModel
extends DefaultTableModel {
    public static final int COLUMN_ENTRY = 0;
    public static final int COLUMN_ADRESS_ID = 1;
    public static final int COLUMN_ADRESS_COMPANY = 2;
    public static final int COLUMN_ADRESS_PERSON = 3;
    public static final int COLUMN_ADRESS_LINE1 = 4;
    public static final int COLUMN_ADRESS_LINE2 = 5;
    public static final int COLUMN_DESCRIPTION = 6;
    private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
    private static final Map<Integer, Class> COLUMN_CLASSES;
    private final ResourceMap resourceMap;

    public CalendarEntryContactTableModel() {
        this.setColumnCount(COLUMN_NAMES.size());
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryContactTableModel.class);
    }

    public void addContact(ContactsEntry.Row row, ContactsEntryCalendar contactsEntryCalendar) {
        this.addRow(this.buildRow(row, contactsEntryCalendar));
    }

    private Object[] buildRow(ContactsEntry.Row row, ContactsEntryCalendar contactsEntryCalendar) {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        treeMap.put(0, (Object)contactsEntryCalendar);
        treeMap.put(1, row.id);
        treeMap.put(2, row.company);
        treeMap.put(3, row.writePerson());
        treeMap.put(4, row.writeAdressLine1());
        treeMap.put(5, row.writeAdressLine2WithCountry());
        treeMap.put(6, contactsEntryCalendar != null && contactsEntryCalendar.getDescription() != null ? contactsEntryCalendar.getDescription().trim() : "");
        return treeMap.values().toArray(new Object[treeMap.size()]);
    }

    public void clear() {
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
    }

    public Class getColumnClass(int n) {
        return COLUMN_CLASSES.containsKey(n) ? COLUMN_CLASSES.get(n) : null;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES.containsKey(n) ? this.resourceMap.getString(COLUMN_NAMES.get(n), new Object[0]) : null;
    }

    public ContactsEntryCalendar getEntryAt(int n) {
        int n2 = n;
        return (ContactsEntryCalendar)((Object)this.getValueAt(n2, 0));
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setContactAt(int n, ContactsEntry.Row row, ContactsEntryCalendar contactsEntryCalendar) {
        Object[] objectArray = this.buildRow(row, contactsEntryCalendar);
        for (int i = 0; i < objectArray.length; ++i) {
            this.setValueAt(objectArray[i], n, i);
        }
    }

    static {
        COLUMN_NAMES.put(0, "col.entry");
        COLUMN_NAMES.put(1, "col.id");
        COLUMN_NAMES.put(2, "col.company");
        COLUMN_NAMES.put(3, "col.person");
        COLUMN_NAMES.put(4, "col.street");
        COLUMN_NAMES.put(5, "col.city");
        COLUMN_NAMES.put(6, "col.notes");
        COLUMN_CLASSES = new HashMap<Integer, Class>();
        COLUMN_CLASSES.put(0, ContactsEntryCalendar.class);
        COLUMN_CLASSES.put(1, Long.class);
        COLUMN_CLASSES.put(2, String.class);
        COLUMN_CLASSES.put(3, String.class);
        COLUMN_CLASSES.put(4, String.class);
        COLUMN_CLASSES.put(5, String.class);
        COLUMN_CLASSES.put(6, String.class);
    }
}

