/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEntryViewAddonPanel;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsEntryViewPanel;
import com.openindex.openestate.tool.contacts.addons.CalendarEntryContactTableModel;
import com.openindex.openestate.tool.contacts.addons.ContactsEntryCalendar;
import com.openindex.openestate.tool.contacts.addons.ContactsEntryCalendarDialog;
import com.openindex.openestate.tool.utils.QuickTableExport;
import com.openindex.openestate.tool.utils.TabComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import net.fortuna.ical4j.model.property.Uid;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;

public class CalendarEntryContactTablePanel
extends CalendarEntryViewAddonPanel {
    private static final Logger LOGGER = Logger.getLogger(CalendarEntryContactTablePanel.class);
    private ActionMap actionMap = null;
    private ResourceMap resourceMap = null;
    private JPopupMenu actionsMenu = null;
    private Uid selectedCalendarEntryUid = null;
    private CalendarEntry selectedCalendarEntry = null;
    private CalendarEntryContactTableModel contactsTableModel = null;
    private boolean editable = true;
    private boolean isModified = false;
    private JButton actionButton;
    private JButton addButton;
    private JButton contactsNotesButton;
    private JTextArea contactsNotesField;
    private JPanel contactsNotesPanel;
    private JScrollPane contactsNotesScroller;
    private JXTitledSeparator contactsNotesTitleLabel;
    private JXTable contactsTable;
    private JScrollPane contactsTableScroller;
    private JButton refreshButton;
    private JXTitledSeparator titleLabel;

    public CalendarEntryContactTablePanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(CalendarEntryContactTablePanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryContactTablePanel.class);
        this.initComponents();
        this.actionsMenu = new JPopupMenu();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doViewAdress")));
        this.actionsMenu.addSeparator();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doView")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doRemove")));
        this.contactsTableModel = new CalendarEntryContactTableModel();
        this.contactsTable.setModel((TableModel)this.contactsTableModel);
        this.contactsTable.removeColumn(this.contactsTable.getColumn(0));
        this.contactsTable.setSortable(true);
        this.contactsTable.getSelectionModel().setSelectionMode(0);
        this.contactsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    CalendarEntryContactTablePanel.this.doView();
                } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    int n = CalendarEntryContactTablePanel.this.contactsTable.rowAtPoint(mouseEvent.getPoint());
                    if (n >= 0 && n != CalendarEntryContactTablePanel.this.contactsTable.getSelectedRow() && n >= 0) {
                        CalendarEntryContactTablePanel.this.contactsTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    if (n < 0) {
                        n = CalendarEntryContactTablePanel.this.contactsTable.getSelectedRow();
                    }
                    if (n < 0) {
                        return;
                    }
                    CalendarEntryContactTablePanel.this.actionsMenu.show((Component)CalendarEntryContactTablePanel.this.contactsTable, ((CalendarEntryContactTablePanel)CalendarEntryContactTablePanel.this).contactsTable.getMousePosition().x, ((CalendarEntryContactTablePanel)CalendarEntryContactTablePanel.this).contactsTable.getMousePosition().y);
                }
            }
        });
        this.contactsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CalendarEntryContactTablePanel.this.actionButton.setEnabled(CalendarEntryContactTablePanel.this.contactsTable.getSelectedRowCount() > 0);
                if (CalendarEntryContactTablePanel.this.contactsTable.getSelectedRowCount() < 1) {
                    CalendarEntryContactTablePanel.this.contactsNotesField.setText("");
                    CalendarEntryContactTablePanel.this.contactsNotesPanel.setVisible(false);
                } else {
                    int n = CalendarEntryContactTablePanel.this.contactsTable.convertRowIndexToModel(CalendarEntryContactTablePanel.this.contactsTable.getSelectedRow());
                    String string = CalendarEntryContactTablePanel.this.contactsTableModel.getEntryAt(n).getDescription();
                    CalendarEntryContactTablePanel.this.contactsNotesField.setText(string != null ? string.trim() : "");
                    CalendarEntryContactTablePanel.this.contactsNotesField.setCaretPosition(0);
                    CalendarEntryContactTablePanel.this.contactsNotesPanel.setVisible(true);
                }
            }
        });
        this.contactsTable.setColumnControl((JComponent)QuickTableExport.createColumnControl((JXTable)this.contactsTable));
        ImmoToolUtils.configureTable((JXTable)this.contactsTable);
        this.resourceMap.injectComponents((Component)((Object)this));
        this.actionButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.contactsNotesPanel.setVisible(false);
    }

    @Action
    public void doAction() {
        this.actionsMenu.show(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doAdd() {
        ContactsEntryCalendarDialog contactsEntryCalendarDialog = null;
        try {
            contactsEntryCalendarDialog = new ContactsEntryCalendarDialog(2, ImmoToolApp.getApplication().getMainFrame(), true);
            contactsEntryCalendarDialog.load(null);
            contactsEntryCalendarDialog.loadContact(null);
            contactsEntryCalendarDialog.setVisible(true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant create dialog!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantCreateDialog", new Object[0]), (Throwable)exception);
            return;
        }
        try {
            if (contactsEntryCalendarDialog.getStatus() != 2) {
                return;
            }
            ContactsEntryCalendar contactsEntryCalendar = new ContactsEntryCalendar();
            contactsEntryCalendarDialog.save(contactsEntryCalendar);
            if (this.getRowForAdress(contactsEntryCalendar.getContactEntryId()) > -1) {
                LOGGER.error((Object)"contact is already mapped!");
                LOGGER.error((Object)("> contact #" + contactsEntryCalendar.getContactEntryId()));
                ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.contactIsAlreadyMapped", new Object[0]));
                return;
            }
            ContactsEntry.Row[] rowArray = ContactsEntry.loadRows((Long[])new Long[]{contactsEntryCalendar.getContactEntryId()}, (Long[])new Long[]{contactsEntryCalendar.getContactGroupId()}, null, null);
            if (rowArray != null && rowArray.length > 0) {
                this.contactsTableModel.addContact(rowArray[0], contactsEntryCalendar);
                this.isModified = true;
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant put adress!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantPutAdress", new Object[0]), (Throwable)exception);
            return;
        }
    }

    public final Task doLoadInBackground() {
        if (this.selectedCalendarEntryUid == null) {
            return null;
        }
        this.contactsTable.setEnabled(false);
        return new ImmoToolTask<CalendarEntryContactTableModel>(){

            protected CalendarEntryContactTableModel executeTask() throws Exception {
                CalendarEntryContactTableModel calendarEntryContactTableModel = new CalendarEntryContactTableModel();
                ContactsEntryCalendar[] contactsEntryCalendarArray = ContactsEntryCalendar.loadEntriesForCalendar(CalendarEntryContactTablePanel.this.selectedCalendarEntryUid.getValue());
                if (contactsEntryCalendarArray == null || contactsEntryCalendarArray.length <= 0) {
                    return calendarEntryContactTableModel;
                }
                HashMap<Long, ContactsEntryCalendar> hashMap = new HashMap<Long, ContactsEntryCalendar>();
                for (ContactsEntryCalendar contactsEntryCalendar : contactsEntryCalendarArray) {
                    hashMap.put(contactsEntryCalendar.getContactEntryId(), contactsEntryCalendar);
                }
                ContactsEntryCalendar[] contactsEntryCalendarArray2 = ContactsEntry.loadRows((Long[])hashMap.keySet().toArray(new Long[hashMap.size()]), null, null, null);
                if (contactsEntryCalendarArray2 != null) {
                    for (ContactsEntryCalendar contactsEntryCalendar : contactsEntryCalendarArray2) {
                        calendarEntryContactTableModel.addContact((ContactsEntry.Row)contactsEntryCalendar, (ContactsEntryCalendar)((Object)hashMap.get(((ContactsEntry.Row)contactsEntryCalendar).id)));
                    }
                }
                return calendarEntryContactTableModel;
            }

            protected void finished() {
                super.finished();
                CalendarEntryContactTablePanel.this.contactsTable.setEnabled(true);
            }

            protected void succeeded(CalendarEntryContactTableModel calendarEntryContactTableModel) {
                super.succeeded((Object)calendarEntryContactTableModel);
                CalendarEntryContactTablePanel.this.contactsTableModel = calendarEntryContactTableModel;
                CalendarEntryContactTablePanel.this.contactsTable.setModel((TableModel)calendarEntryContactTableModel);
                CalendarEntryContactTablePanel.this.contactsTable.removeColumn(CalendarEntryContactTablePanel.this.contactsTable.getColumn(0));
                CalendarEntryContactTablePanel.this.titleLabel.setTitle(CalendarEntryContactTablePanel.this.resourceMap.getString("titleLabel.title", new Object[0]) + " / " + CalendarEntryContactTablePanel.this.resourceMap.getString("message.resultCount", new Object[]{NumberFormat.getIntegerInstance().format(CalendarEntryContactTablePanel.this.contactsTable.getRowCount())}));
                CalendarEntryContactTablePanel.this.contactsTable.packAll();
            }
        };
    }

    @Action
    public Task doRefresh() {
        if (this.selectedCalendarEntry == null) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.noCalendarEntryFound", new Object[0]));
            return null;
        }
        this.contactsTable.setEnabled(false);
        this.refreshButton.setEnabled(false);
        return new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                CalendarEntryContactTablePanel.this.load(CalendarEntryContactTablePanel.this.selectedCalendarEntry);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                CalendarEntryContactTablePanel.this.contactsTable.setEnabled(true);
                CalendarEntryContactTablePanel.this.refreshButton.setEnabled(true);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryContactTablePanel.this.resourceMap.getString("error.cantRefresh", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                CalendarEntryContactTablePanel.this.contactsTable.packAll();
                CalendarEntryContactTablePanel.this.contactsTable.setEnabled(true);
                CalendarEntryContactTablePanel.this.refreshButton.setEnabled(true);
                CalendarEntryContactTablePanel.this.isModified = false;
            }
        };
    }

    @Action
    public void doRemove() {
        if (this.contactsTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.contactsTable.getSelectedRow();
        int n2 = this.contactsTable.convertRowIndexToModel(n);
        ContactsEntryCalendar contactsEntryCalendar = this.contactsTableModel.getEntryAt(n2);
        if (ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteContactEntry", new Object[]{contactsEntryCalendar.getContactEntryId()}))) {
            this.contactsTableModel.removeRow(n2);
            this.isModified = true;
        }
    }

    @Action
    public void doSaveNotes() {
        if (this.contactsTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.contactsTable.getSelectedRow();
        int n2 = this.contactsTable.convertRowIndexToModel(n);
        String string = this.contactsNotesField.getText().trim();
        ContactsEntryCalendar contactsEntryCalendar = this.contactsTableModel.getEntryAt(n2);
        if (contactsEntryCalendar != null) {
            contactsEntryCalendar.setDescription(string);
            this.contactsTableModel.setValueAt(string, n2, 6);
        }
    }

    @Action
    public void doView() {
        if (this.contactsTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.contactsTable.getSelectedRow();
        int n2 = this.contactsTable.convertRowIndexToModel(n);
        ContactsEntryCalendar contactsEntryCalendar = this.contactsTableModel.getEntryAt(n2);
        ContactsEntryCalendarDialog contactsEntryCalendarDialog = null;
        try {
            contactsEntryCalendarDialog = new ContactsEntryCalendarDialog(2, ImmoToolApp.getApplication().getMainFrame(), true);
            contactsEntryCalendarDialog.load(contactsEntryCalendar);
            contactsEntryCalendarDialog.loadContact(contactsEntryCalendar.getContactGroupId(), contactsEntryCalendar.getContactEntryId());
            contactsEntryCalendarDialog.setVisible(true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant create dialog!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantCreateDialog", new Object[0]), (Throwable)exception);
            return;
        }
        if (contactsEntryCalendarDialog.getStatus() != 2) {
            return;
        }
        try {
            int n3;
            contactsEntryCalendarDialog.save(contactsEntryCalendar);
            int n4 = this.getRowForAdress(contactsEntryCalendar.getContactEntryId());
            int n5 = n3 = n4 > -1 ? this.contactsTable.convertRowIndexToModel(n4) : -1;
            if (n3 > -1 && n3 != n2) {
                LOGGER.error((Object)"contact is already mapped!");
                LOGGER.error((Object)("> contact #" + contactsEntryCalendar.getContactEntryId()));
                ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.contactIsAlreadyMapped", new Object[0]));
                return;
            }
            ContactsEntry.Row[] rowArray = ContactsEntry.loadRows((Long[])new Long[]{contactsEntryCalendar.getContactEntryId()}, (Long[])new Long[]{contactsEntryCalendar.getContactGroupId()}, null, null);
            if (rowArray != null && rowArray.length > 0) {
                this.contactsTableModel.setContactAt(n2, rowArray[0], contactsEntryCalendar);
                this.isModified = true;
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant put adress!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantPutAdress", new Object[0]), (Throwable)exception);
            return;
        }
    }

    @Action
    public Task doViewAdress() {
        if (this.contactsTable.getSelectedRowCount() < 1) {
            return null;
        }
        int n = this.contactsTable.getSelectedRow();
        int n2 = this.contactsTable.convertRowIndexToModel(n);
        final ContactsEntryCalendar contactsEntryCalendar = this.contactsTableModel.getEntryAt(n2);
        String string = ContactsEntryViewPanel.getInstanceTabTitle((long)contactsEntryCalendar.getContactEntryId());
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        return new ImmoToolTask<ContactsEntryViewPanel>(){

            protected ContactsEntryViewPanel executeTask() throws Exception {
                ContactsEntryViewPanel contactsEntryViewPanel = new ContactsEntryViewPanel();
                contactsEntryViewPanel.setContact(contactsEntryCalendar.loadContactsEntry());
                return contactsEntryViewPanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryContactTablePanel.this.resourceMap.getString("error.cantLoadContact", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(ContactsEntryViewPanel contactsEntryViewPanel) {
                super.succeeded((Object)contactsEntryViewPanel);
                contactsEntryViewPanel.executeFormTasks();
                ImmoToolUtils.showPanel((TabComponent)contactsEntryViewPanel);
            }
        };
    }

    private int getRowForAdress(long l) {
        for (int i = 0; i < this.contactsTable.getRowCount(); ++i) {
            if (this.contactsTableModel.getEntryAt(i).getContactEntryId() != l) continue;
            return i;
        }
        return -1;
    }

    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    public boolean isFormEnabled() {
        return this.editable;
    }

    public boolean isFormModified() {
        return this.isModified;
    }

    public boolean isFormUsable() {
        return ImmoToolApp.getApplication().getProject().getPlugin("OpenEstate-Contacts") != null;
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    public void load(CalendarEntry calendarEntry) throws ImmoToolException {
        this.selectedCalendarEntry = calendarEntry;
        this.selectedCalendarEntryUid = calendarEntry != null ? calendarEntry.getUId() : null;
        this.contactsTableModel.clear();
        this.refreshButton.setEnabled(this.selectedCalendarEntryUid != null);
        this.isModified = false;
    }

    public void save(CalendarEntry calendarEntry) throws ImmoToolException {
    }

    public void saveFinished(CalendarObject calendarObject, CalendarEntry calendarEntry) throws ImmoToolException {
        Object object;
        for (ContactsEntryCalendar contactsEntryCalendarArray : ContactsEntryCalendar.loadEntriesForCalendar(calendarEntry.getUId().getValue())) {
            if (this.getRowForAdress(contactsEntryCalendarArray.getContactEntryId()) >= 0) continue;
            object = contactsEntryCalendarArray.loadContactsEntry();
            ContactsEntryCalendar[] contactsEntryCalendarArray2 = new ArrayList();
            ContactsEntryCalendar[] contactsEntryCalendarArray3 = ContactsEntryCalendar.getContactsEntryCalendars((ContactsEntry)object);
            int n = contactsEntryCalendarArray3.length;
            for (int contactsEntryCalendar2 = 0; contactsEntryCalendar2 < n; ++contactsEntryCalendar2) {
                ContactsEntryCalendar contactsEntryCalendar = contactsEntryCalendarArray3[contactsEntryCalendar2];
                if (contactsEntryCalendar.getCalendarUid().equals(calendarEntry.getUId().getValue())) continue;
                contactsEntryCalendarArray2.add(contactsEntryCalendar);
            }
            ContactsEntryCalendar.setContactsEntryCalendars((ContactsEntry)object, contactsEntryCalendarArray2.toArray(new ContactsEntryCalendar[contactsEntryCalendarArray2.size()]));
            object.save();
        }
        for (int i = 0; i < this.contactsTableModel.getRowCount(); ++i) {
            ContactsEntryCalendar contactsEntryCalendar = this.contactsTableModel.getEntryAt(i);
            if (contactsEntryCalendar == null) {
                LOGGER.warn((Object)("contact  #" + i + " not found!"));
                continue;
            }
            contactsEntryCalendar.setCalendarId(calendarEntry.getCalendarId());
            contactsEntryCalendar.setCalendarUid(calendarEntry.getUId().getValue());
            ContactsEntry contactsEntry = contactsEntryCalendar.loadContactsEntry();
            ContactsEntryCalendar[] contactsEntryCalendarArray = ContactsEntryCalendar.getContactsEntryCalendars(contactsEntry);
            object = new ArrayList();
            for (ContactsEntryCalendar contactsEntryCalendar2 : contactsEntryCalendarArray) {
                if (contactsEntryCalendar2.getCalendarUid().equals(calendarEntry.getUId().getValue())) continue;
                object.add(contactsEntryCalendar2);
            }
            object.add(contactsEntryCalendar);
            ContactsEntryCalendar.setContactsEntryCalendars(contactsEntry, object.toArray(new ContactsEntryCalendar[object.size()]));
            contactsEntry.save();
        }
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.editable = bl;
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.refreshButton = new JButton();
        this.addButton = new JButton();
        this.actionButton = new JButton();
        this.contactsTableScroller = new JScrollPane();
        this.contactsTable = new JXTable();
        this.contactsNotesPanel = new JPanel();
        this.contactsNotesTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.contactsNotesButton = new JButton();
        this.contactsNotesScroller = new JScrollPane();
        this.contactsNotesField = new RTextArea();
        this.titleLabel.setName("titleLabel");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(CalendarEntryContactTablePanel.class, (Object)this);
        this.refreshButton.setAction(applicationActionMap.get("doRefresh"));
        this.refreshButton.setName("refreshButton");
        this.addButton.setAction(applicationActionMap.get("doAdd"));
        this.addButton.setName("addButton");
        this.actionButton.setAction(applicationActionMap.get("doAction"));
        this.actionButton.setName("actionButton");
        this.contactsTableScroller.setName("contactsTableScroller");
        this.contactsTable.setColumnControlVisible(true);
        this.contactsTable.setName("contactsTable");
        this.contactsTableScroller.setViewportView((Component)this.contactsTable);
        this.contactsNotesPanel.setName("contactsNotesPanel");
        this.contactsNotesTitleLabel.setName("contactsNotesTitleLabel");
        this.contactsNotesButton.setAction(applicationActionMap.get("doSaveNotes"));
        this.contactsNotesButton.setName("contactsNotesButton");
        this.contactsNotesScroller.setName("contactsNotesScroller");
        this.contactsNotesField.setColumns(20);
        this.contactsNotesField.setLineWrap(true);
        this.contactsNotesField.setRows(5);
        this.contactsNotesField.setWrapStyleWord(true);
        this.contactsNotesField.setName("contactsNotesField");
        this.contactsNotesScroller.setViewportView(this.contactsNotesField);
        GroupLayout groupLayout = new GroupLayout(this.contactsNotesPanel);
        this.contactsNotesPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent((Component)this.contactsNotesTitleLabel, -1, 635, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contactsNotesButton)).addComponent(this.contactsNotesScroller, GroupLayout.Alignment.TRAILING, -1, 696, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contactsNotesButton).addComponent((Component)this.contactsNotesTitleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contactsNotesScroller, -2, -1, -2)));
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contactsTableScroller, GroupLayout.Alignment.TRAILING, -1, 696, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 507, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton)).addComponent(this.contactsNotesPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.titleLabel, -2, -1, -2).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.actionButton).addComponent(this.addButton).addComponent(this.refreshButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contactsTableScroller, -1, 241, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contactsNotesPanel, -2, -1, -2).addContainerGap()));
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(CalendarEntryContactTablePanel.class);
        resourceMap.injectComponents((Component)((Object)this));
    }
}

