/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEventEntry;
import com.openindex.openestate.tool.calendar.VirtualCalendarObject;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsEntryViewPanel;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import com.openindex.openestate.tool.utils.TabComponent;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.xml.bind.DatatypeConverter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.Comment;
import net.fortuna.ical4j.model.property.RRule;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

public class ContactsBirthdayCalendar
extends VirtualCalendarObject {
    private static final Logger LOGGER = Logger.getLogger(ContactsBirthdayCalendar.class);
    public static final String BIRTHDAY_GROUP_ID = "BIRTHDAY-GROUP-ID";
    public static final String BIRTHDAY_CONTACT_ID = "BIRTHDAY-CONTACT-ID";
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ContactsBirthdayCalendar.class);

    public CalendarEntry[] getEntries(String string) throws ImmoToolException {
        if (string != null && !"VEVENT".equals(string)) {
            return new CalendarEntry[0];
        }
        Collection collection = null;
        try {
            collection = ContactsPluginUtils.openPluginCollection((String)"");
            ArrayList<CalendarEventEntry> arrayList = new ArrayList<CalendarEventEntry>();
            String string2 = "declare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\ndeclare namespace openestate=\"http://www.openestate.org/1.0/\";\ndeclare namespace util=\"http://exist-db.org/xquery/util\";\nfor $x in collection('ImmoTool/OpenEstate-Contacts')/openestate:CompanyAdress\n";
            string2 = string2 + "let $id := util:document-name($x)\n";
            string2 = string2 + "let $group := util:collection-name($x)\n";
            string2 = string2 + "let $firstName := $x/@PersonFirstName\n";
            string2 = string2 + "let $lastName := $x/@PersonLastName\n";
            string2 = string2 + "let $status := $x/openestate:CustomValues/openestate:CustomValue[@Key='status']/openestate:String/text()\n";
            string2 = string2 + "let $dayOfBirth := $x/openestate:CustomValues/openestate:CustomValue[@Key='day_of_birth']/openestate:Date/text()\n";
            string2 = string2 + "where ($status!='inactive' and exists($dayOfBirth))\n";
            string2 = string2 + "return <row id=\"{$id}\" group=\"{$group}\" firstName=\"{$firstName}\" lastName=\"{$lastName}\" status=\"{$status}\" dayOfBirth=\"{$dayOfBirth}\" />";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string2);
            for (long i = 0L; i < resourceSet.getSize(); ++i) {
                XMLResource xMLResource = (XMLResource)resourceSet.getResource(i);
                Node node = xMLResource.getContentAsDOM();
                String string3 = node.getAttributes().getNamedItem("id").getNodeValue();
                String string4 = node.getAttributes().getNamedItem("group").getNodeValue();
                String string5 = node.getAttributes().getNamedItem("firstName").getNodeValue();
                String string6 = node.getAttributes().getNamedItem("lastName").getNodeValue();
                String string7 = this.resourceMap.getString("calendar.summary", new Object[]{(string5 + " " + string6).trim()});
                String string8 = node.getAttributes().getNamedItem("dayOfBirth").getNodeValue();
                if (string8 == null || string8.trim().length() == 0) {
                    LOGGER.warn((Object)"Can't find day of birth!");
                    continue;
                }
                try {
                    String[] stringArray;
                    CalendarEventEntry calendarEventEntry = new CalendarEventEntry();
                    calendarEventEntry.setSummary(string7);
                    calendarEventEntry.getProperties().add((Property)new Comment("VIRTUAL-CALENDAR:" + ((Object)((Object)this)).getClass().getName()));
                    if (string3 != null && string3.contains(".")) {
                        stringArray = string3.split("\\.");
                        calendarEventEntry.getProperties().add((Property)new Comment("BIRTHDAY-CONTACT-ID:" + stringArray[1]));
                    }
                    if (string4 != null && string4.contains("/")) {
                        stringArray = string4.split("/");
                        calendarEventEntry.getProperties().add((Property)new Comment("BIRTHDAY-GROUP-ID:" + stringArray[stringArray.length - 1]));
                    }
                    stringArray = Calendar.getInstance();
                    stringArray.setTime(DatatypeConverter.parseDate((String)string8).getTime());
                    stringArray.set(11, 0);
                    stringArray.set(12, 0);
                    stringArray.set(13, 0);
                    stringArray.set(14, 0);
                    calendarEventEntry.setBeginTime(stringArray.getTime());
                    stringArray.add(6, 1);
                    stringArray.add(14, -1);
                    calendarEventEntry.setEndTime(stringArray.getTime());
                    RRule rRule = new RRule();
                    rRule.getRecur().setFrequency("YEARLY");
                    rRule.getRecur().setCount(150);
                    calendarEventEntry.getProperties().add((Property)rRule);
                    arrayList.add(calendarEventEntry);
                    continue;
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)("Can't parse day of birth: " + string8));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
            return arrayList.toArray(new CalendarEntry[arrayList.size()]);
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("Can't load contact-birthdays: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public String getTitle() {
        return this.resourceMap.getString("calendar.title", new Object[0]);
    }

    public Action getViewAction(final CalendarEntry calendarEntry) {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Long l = Long.valueOf(calendarEntry.extractCommentParameter(ContactsBirthdayCalendar.BIRTHDAY_GROUP_ID));
                Long l2 = Long.valueOf(calendarEntry.extractCommentParameter(ContactsBirthdayCalendar.BIRTHDAY_CONTACT_ID));
                ContactsEntry contactsEntry = null;
                try {
                    contactsEntry = ContactsEntry.load((long)l, (long)l2);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Can't load contact-entry!");
                }
                if (contactsEntry == null) {
                    throw new NullPointerException("Unknown contact-entry!");
                }
                ContactsEntryViewPanel contactsEntryViewPanel = new ContactsEntryViewPanel();
                contactsEntryViewPanel.setContact(contactsEntry);
                contactsEntryViewPanel.executeFormTasks();
                ImmoToolUtils.showPanel((TabComponent)contactsEntryViewPanel);
            }
        };
        abstractAction.putValue("Name", this.resourceMap.getString("doViewContact.Action.text", new Object[0]));
        abstractAction.putValue("ShortDescription", this.resourceMap.getString("doViewContact.Action.shortDescription", new Object[0]));
        abstractAction.putValue("SmallIcon", this.resourceMap.getIcon("doViewContact.Action.smallIcon"));
        return abstractAction;
    }

    public boolean isUsable() {
        return ImmoToolApp.getApplication().getProject().getPlugin("OpenEstate-Contacts") != null;
    }
}

