/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons;

import com.openindex.openestate.impl.CustomValuesImpl;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.calendar.CalendarEntryRelation;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsGroup;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

public class ContactsEntryCalendar
extends CalendarEntryRelation {
    private static final Logger LOGGER = Logger.getLogger(ContactsEntryCalendar.class);
    public static final String VALUE_CALENDAR_ID = "calendar.id.";
    public static final String VALUE_CALENDAR_UID = "calendar.uid.";
    public static final String VALUE_CALENDAR_TEXT = "calendar.text.";
    private long relationContactEntryId;
    private long relationContactGroupId;

    public ContactsEntryCalendar() {
        this.relationContactGroupId = 0L;
        this.relationContactEntryId = 0L;
    }

    public ContactsEntryCalendar(long l, long l2, long l3, String string, String string2) {
        this.relationContactGroupId = l;
        this.relationContactEntryId = l2;
        this.setCalendarId(l3);
        this.setCalendarUid(string);
        this.setDescription(string2);
    }

    public static ContactsEntryCalendar[] getContactsEntryCalendars(ContactsEntry contactsEntry) {
        return ContactsEntryCalendar.getContactsEntryCalendars(contactsEntry.getGroupId(), contactsEntry.getId(), contactsEntry.getCompanyAdress().getCustomValues());
    }

    public static ContactsEntryCalendar[] getContactsEntryCalendars(long l, long l2) throws ImmoToolDbException {
        return ContactsEntryCalendar.getContactsEntryCalendars(ContactsEntry.load((long)l, (long)l2));
    }

    public static ContactsEntryCalendar[] getContactsEntryCalendars(long l, long l2, Collection collection) throws ImmoToolDbException {
        return ContactsEntryCalendar.getContactsEntryCalendars(ContactsEntry.load((long)l, (long)l2, (Collection)collection));
    }

    public static ContactsEntryCalendar[] getContactsEntryCalendars(long l, long l2, CustomValuesImpl customValuesImpl) {
        ArrayList<ContactsEntryCalendar> arrayList = new ArrayList<ContactsEntryCalendar>();
        for (String string : customValuesImpl.getValueMap().keySet()) {
            if (!string.startsWith(VALUE_CALENDAR_ID)) continue;
            String string2 = VALUE_CALENDAR_UID + string.substring(VALUE_CALENDAR_ID.length());
            String string3 = VALUE_CALENDAR_TEXT + string.substring(VALUE_CALENDAR_ID.length());
            Long l3 = customValuesImpl.getCustomValue(string).getInteger().longValue();
            String string4 = customValuesImpl.getCustomValue(string2).getString();
            String string5 = customValuesImpl.hasCustomValue(string3) ? (customValuesImpl.getCustomValue(string3).isText() ? customValuesImpl.getCustomValue(string3).getText() : customValuesImpl.getCustomValue(string3).getString()) : "";
            arrayList.add(new ContactsEntryCalendar(l, l2, l3, string4, string5));
        }
        return arrayList.toArray(new ContactsEntryCalendar[arrayList.size()]);
    }

    public long getContactEntryId() {
        return this.relationContactEntryId;
    }

    public long getContactGroupId() {
        return this.relationContactGroupId;
    }

    public ContactsEntry loadContactsEntry() throws ImmoToolDbException {
        return ContactsEntry.load((long)this.getContactGroupId(), (long)this.getContactEntryId());
    }

    public ContactsGroup loadContactsGroup() throws ImmoToolDbException {
        return ContactsGroup.load((long)this.getContactGroupId());
    }

    public static ContactsEntryCalendar[] loadEntriesForCalendar(String string) throws ImmoToolDbException {
        Collection collection = null;
        ArrayList<ContactsEntryCalendar> arrayList = new ArrayList<ContactsEntryCalendar>();
        try {
            collection = ContactsPluginUtils.openPluginCollection((String)"");
            String string2 = "declare namespace util=\"http://exist-db.org/xquery/util\";\ndeclare namespace openestate=\"http://www.openestate.org/1.0/\";\nfor $x in collection('ImmoTool/OpenEstate-Contacts')/openestate:CompanyAdress//openestate:CustomValues/openestate:CustomValue\nlet $pos:=substring($x/@Key, " + (VALUE_CALENDAR_UID.length() + 1) + ")\n" + "let $calIdVar:=concat('" + VALUE_CALENDAR_ID + "', $pos)\n" + "let $calId:=$x/../openestate:" + "CustomValue" + "[@" + "Key" + "=$calIdVar]/openestate:" + "Integer" + "/text()\n" + "let $txtVar:=concat('" + VALUE_CALENDAR_TEXT + "', $pos)\n" + "let $txt:=$x/../openestate:" + "CustomValue" + "[@" + "Key" + "=$txtVar]/*/text()\n" + "where (starts-with($x/@" + "Key" + ", '" + VALUE_CALENDAR_UID + "') and ($x/openestate:" + "String" + "/text()='" + StringEscapeUtils.escapeSql((String)string) + "') )\n" + "return <result path=\"{util:collection-name( $x )}\" file=\"{util:document-name( $x )}\" pos=\"{$pos}\" calId=\"{$calId}\">{$txt}</result>";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string2);
            for (long i = 0L; i < resourceSet.getSize(); ++i) {
                try {
                    XMLResource xMLResource = (XMLResource)resourceSet.getResource(i);
                    Node node = xMLResource.getContentAsDOM();
                    String string3 = node.getAttributes().getNamedItem("path").getNodeValue();
                    String string4 = node.getAttributes().getNamedItem("file").getNodeValue();
                    Long l = Long.valueOf(node.getAttributes().getNamedItem("calId").getNodeValue());
                    String string5 = node.getFirstChild() != null ? node.getFirstChild().getNodeValue() : "";
                    string5 = string5.replaceAll("<br/>", SystemUtils.LINE_SEPARATOR);
                    String[] stringArray = string3.split("/");
                    String[] stringArray2 = string4.split("\\.");
                    arrayList.add(new ContactsEntryCalendar(Long.valueOf(stringArray[stringArray.length - 1]), Long.valueOf(stringArray2[1]), l, string, string5));
                    continue;
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not load ContactsEntryCalendar!");
                    LOGGER.warn((Object)("> for uid " + string));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
        return arrayList.toArray(new ContactsEntryCalendar[arrayList.size()]);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ContactsEntryCalendar[] loadEntriesForContact(long l, long l2) throws ImmoToolDbException {
        ContactsEntryCalendar[] contactsEntryCalendarArray;
        Collection collection = null;
        ArrayList<ContactsEntryCalendar> arrayList = new ArrayList<ContactsEntryCalendar>();
        try {
            String string = "contact." + l2 + ".xml";
            String string2 = "declare namespace util=\"http://exist-db.org/xquery/util\";\ndeclare namespace openestate=\"http://www.openestate.org/1.0/\";\nfor $x in document('ImmoTool/OpenEstate-Contacts/" + l + "/" + string + "')/openestate:" + "CompanyAdress" + "/openestate:" + "CustomValues" + "/openestate:" + "CustomValue" + "\n" + "  let $uid:=$x/openestate:" + "String" + "/text()\n" + "  let $pos:=substring($x/@" + "Key" + ", " + (VALUE_CALENDAR_UID.length() + 1) + ")\n" + "  let $calIdVar:=concat('" + VALUE_CALENDAR_ID + "', $pos)\n" + "  let $calId:=$x/../openestate:" + "CustomValue" + "[@" + "Key" + "=$calIdVar]/openestate:" + "Integer" + "/text()\n" + "  let $txtVar:=concat('" + VALUE_CALENDAR_TEXT + "', $pos)\n" + "  let $txt:=$x/../openestate:" + "CustomValue" + "[@" + "Key" + "=$txtVar]/*/text()\n" + "  where (starts-with($x/@" + "Key" + ", '" + VALUE_CALENDAR_UID + "'))\n" + "  return <result pos=\"{$pos}\" calId=\"{$calId}\" calUid=\"{$uid}\">{$txt}</result>";
            collection = ContactsPluginUtils.openPluginCollection((String)"");
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string2);
            for (long i = 0L; i < resourceSet.getSize(); ++i) {
                try {
                    XMLResource xMLResource = (XMLResource)resourceSet.getResource(i);
                    Node node = xMLResource.getContentAsDOM();
                    Long l3 = Long.valueOf(node.getAttributes().getNamedItem("calId").getNodeValue());
                    String string3 = node.getAttributes().getNamedItem("calUid").getNodeValue();
                    String string4 = node.getFirstChild() != null ? node.getFirstChild().getNodeValue() : "";
                    string4 = string4.replaceAll("<br/>", SystemUtils.LINE_SEPARATOR);
                    arrayList.add(new ContactsEntryCalendar(l, l2, l3, string3, string4));
                    continue;
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not load ContactsEntryCalendar!");
                    LOGGER.warn((Object)("> for groupId " + l));
                    LOGGER.warn((Object)("> for contactId " + l2));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
            contactsEntryCalendarArray = arrayList.toArray(new ContactsEntryCalendar[arrayList.size()]);
        }
        catch (ImmoToolDbException immoToolDbException) {
            try {
                throw immoToolDbException;
                catch (Exception exception) {
                    throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                ImmoToolDbUtils.close(collection);
                throw throwable;
            }
        }
        ImmoToolDbUtils.close((Collection)collection);
        return contactsEntryCalendarArray;
    }

    public static void setContactsEntryCalendars(ContactsEntry contactsEntry, ContactsEntryCalendar[] contactsEntryCalendarArray) {
        ContactsEntryCalendar.setContactsEntryCalendars(contactsEntry.getCompanyAdress().getCustomValues(), contactsEntryCalendarArray);
    }

    public static void setContactsEntryCalendars(CustomValuesImpl customValuesImpl, ContactsEntryCalendar[] contactsEntryCalendarArray) {
        int n = customValuesImpl.getValueMap().size();
        for (String string : customValuesImpl.getValueMap().keySet().toArray(new String[n])) {
            String string2;
            if (!string.startsWith(VALUE_CALENDAR_ID)) continue;
            customValuesImpl.getValueMap().remove(string);
            String string3 = VALUE_CALENDAR_UID + string.substring(VALUE_CALENDAR_ID.length());
            if (customValuesImpl.hasCustomValue(string3)) {
                customValuesImpl.getValueMap().remove(string3);
            }
            if (!customValuesImpl.hasCustomValue(string2 = VALUE_CALENDAR_TEXT + string.substring(VALUE_CALENDAR_ID.length()))) continue;
            customValuesImpl.getValueMap().remove(string2);
        }
        for (int i = 0; i < contactsEntryCalendarArray.length; ++i) {
            String string;
            String string4 = VALUE_CALENDAR_ID + i;
            customValuesImpl.putCustomValue(string4, (Object)BigInteger.valueOf(contactsEntryCalendarArray[i].getCalendarId()), 4);
            String string5 = VALUE_CALENDAR_UID + i;
            if (contactsEntryCalendarArray[i].getCalendarUid().trim().length() > 0) {
                customValuesImpl.putCustomValue(string5, (Object)contactsEntryCalendarArray[i].getCalendarUid().trim(), 5);
            }
            string = VALUE_CALENDAR_TEXT + i;
            if (contactsEntryCalendarArray[i].getDescription().trim().length() <= 0) continue;
            customValuesImpl.putCustomValue(string, (Object)contactsEntryCalendarArray[i].getDescription().trim(), 6);
        }
    }

    public void setContactEntryId(long l) {
        this.relationContactEntryId = l;
    }

    public void setContactGroupId(long l) {
        this.relationContactGroupId = l;
    }
}

