/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarJournalEntry;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.CalendarSource;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsGroup;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import com.openindex.openestate.tool.contacts.addons.ContactsEntryCalendar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.ArrayList;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.xmldb.api.base.Collection;

public class ContactsEntryCalendarDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(ContactsEntryCalendarDialog.class);
    private static final DateFormat DATEFORMAT_SHORT = DateFormat.getDateInstance(3);
    public static final int SELECT_ALL = 0;
    public static final int SELECT_CALENDAR = 1;
    public static final int SELECT_CONTACT = 2;
    private int selection = 0;
    public static final int UNDEFINED = 0;
    public static final int CANCELLED = 1;
    public static final int APPROVED = 2;
    private int status = 0;
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JXPanel contentPane;
    private RTextArea notesField;
    private JButton closeButton;
    private JButton submitButton;
    private JComboBox contactGroupField = null;
    private JXBusyLabel contactGroupBusyField = null;
    private JComboBox contactEntryField = null;
    private JXBusyLabel contactEntryBusyField = null;
    private JComboBox calendarGroupField = null;
    private JXBusyLabel calendarGroupBusyField = null;
    private JComboBox calendarEntryField = null;
    private JXBusyLabel calendarEntryBusyField = null;
    private Long contactEntryIdOnLoad = null;
    private String calendarEntryUIdOnLoad = null;
    private Task calendarGroupTask = null;
    private Task calendarEntryTask = null;
    private Task contactGroupTask = null;
    private Task contactEntryTask = null;
    private Collection contactCollection = null;
    private Collection calendarCollection = null;

    public ContactsEntryCalendarDialog(int n, Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.build(n);
        this.setLocationRelativeTo(dialog);
    }

    public ContactsEntryCalendarDialog(int n, Frame frame, boolean bl) {
        super(frame, bl);
        this.build(n);
        this.setLocationRelativeTo(frame);
    }

    private void build(int n) {
        this.setTitle("Kalendereintrag zuordnen");
        this.actionMap = ImmoToolUtils.getActionMap(ContactsEntryCalendarDialog.class, (Object)this);
        this.resourceMap = ImmoToolUtils.getResourceMap(ContactsEntryCalendarDialog.class);
        this.contentPane = new JXPanel();
        this.contentPane.setOpaque(true);
        this.setContentPane((Container)this.contentPane);
        this.selection = n;
        this.buildForm();
        this.setDefaultCloseOperation(2);
        this.resourceMap.injectComponents((Component)this);
        if (this.calendarGroupField != null) {
            this.calendarGroupField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ContactsEntryCalendarDialog.this.calendarGroupField.getSelectedIndex() < 0) {
                        return;
                    }
                    String string = ContactsEntryCalendarDialog.this.calendarEntryUIdOnLoad != null ? ContactsEntryCalendarDialog.this.calendarEntryUIdOnLoad : null;
                    ImmoToolUtils.executeTask((Task)ContactsEntryCalendarDialog.this.reloadCalendarEntries(string));
                }
            });
        }
        if (this.contactGroupField != null && this.contactEntryField != null) {
            this.contactGroupField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ContactsEntryCalendarDialog.this.contactGroupField.getSelectedIndex() < 0) {
                        return;
                    }
                    long l = ContactsEntryCalendarDialog.this.contactEntryIdOnLoad != null ? ContactsEntryCalendarDialog.this.contactEntryIdOnLoad : 0L;
                    ImmoToolUtils.executeTask((Task)ContactsEntryCalendarDialog.this.reloadContactEntries(l));
                }
            });
            final String string = this.contactEntryField.getToolTipText();
            this.contactEntryField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ContactsEntryCalendarDialog.this.contactEntryField.getSelectedIndex() <= 0) {
                        ContactsEntryCalendarDialog.this.contactEntryField.setToolTipText(string);
                    } else {
                        ContactsEntryCalendarDialog.this.contactEntryField.setToolTipText(((ContactsEntry.Row)ContactsEntryCalendarDialog.this.contactEntryField.getSelectedItem()).writeToolTip());
                    }
                }
            });
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.closeButton.setOpaque(false);
            this.submitButton.setOpaque(false);
        }
        this.setSize(500, 400);
        ImmoToolUtils.configureDialog((JDialog)this, (JXPanel)this.contentPane);
    }

    private void buildForm() {
        this.notesField = new RTextArea();
        this.notesField.setName("estateTextField");
        this.notesField.setLineWrap(true);
        this.notesField.setWrapStyleWord(true);
        JPanel jPanel = null;
        JPanel jPanel2 = null;
        if (this.selection == 0 || this.selection == 1) {
            this.calendarGroupField = new JComboBox();
            this.calendarGroupField.setName("calendarGroupField");
            this.calendarGroupField.setRenderer(new CalendarSourceRenderer());
            this.calendarGroupBusyField = new JXBusyLabel();
            this.calendarGroupBusyField.setName("calendarGroupBusyField");
            this.calendarGroupBusyField.setOpaque(false);
            this.calendarGroupBusyField.setVisible(false);
            jPanel = new JPanel(new BorderLayout());
            jPanel.setOpaque(false);
            jPanel.add((Component)this.calendarGroupField, "North");
            jPanel.add((Component)this.calendarGroupBusyField, "South");
            this.calendarEntryField = new JComboBox();
            this.calendarEntryField.setName("calendarEntryField");
            this.calendarEntryField.setRenderer(new CalendarEntryRenderer());
            this.calendarEntryBusyField = new JXBusyLabel();
            this.calendarEntryBusyField.setName("calendarEntryBusyField");
            this.calendarEntryBusyField.setOpaque(false);
            this.calendarEntryBusyField.setVisible(false);
            jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setOpaque(false);
            jPanel2.add((Component)this.calendarEntryField, "North");
            jPanel2.add((Component)this.calendarEntryBusyField, "South");
            AutoCompleteDecorator.decorate((JComboBox)this.calendarEntryField, (ObjectToStringConverter)new ObjectToStringConverter(){

                public String getPreferredStringForItem(Object object) {
                    if (object instanceof CalendarEntry) {
                        CalendarEntry calendarEntry = (CalendarEntry)object;
                        String string = calendarEntry.getBegin() != null ? DATEFORMAT_SHORT.format(calendarEntry.getBegin()) + " | " + calendarEntry.getSummaryString() : calendarEntry.getSummaryString();
                        return string.trim();
                    }
                    return "-";
                }

                public String[] getPossibleStringsForItem(Object object) {
                    if (object instanceof CalendarEntry) {
                        CalendarEntry calendarEntry = (CalendarEntry)object;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(this.getPreferredStringForItem(object));
                        arrayList.add(calendarEntry.getSummaryString());
                        return arrayList.toArray(new String[arrayList.size()]);
                    }
                    return super.getPossibleStringsForItem(object);
                }
            });
        }
        JPanel jPanel3 = null;
        JPanel jPanel4 = null;
        if (this.selection == 0 || this.selection == 2) {
            this.contactGroupField = new JComboBox();
            this.contactGroupField.setName("contactGroupField");
            this.contactGroupField.setRenderer(new ContactGroupRenderer());
            this.contactGroupBusyField = new JXBusyLabel();
            this.contactGroupBusyField.setName("contactGroupBusyField");
            this.contactGroupBusyField.setOpaque(false);
            this.contactGroupBusyField.setVisible(false);
            jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setOpaque(false);
            jPanel3.add((Component)this.contactGroupField, "North");
            jPanel3.add((Component)this.contactGroupBusyField, "South");
            this.contactEntryField = new JComboBox();
            this.contactEntryField.setName("contactEntryField");
            this.contactEntryField.setRenderer(new ContactEntryRenderer());
            this.contactEntryBusyField = new JXBusyLabel();
            this.contactEntryBusyField.setName("contactEntryBusyField");
            this.contactEntryBusyField.setOpaque(false);
            this.contactEntryBusyField.setVisible(false);
            jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setOpaque(false);
            jPanel4.add((Component)this.contactEntryField, "North");
            jPanel4.add((Component)this.contactEntryBusyField, "South");
            AutoCompleteDecorator.decorate((JComboBox)this.contactEntryField, (ObjectToStringConverter)new ObjectToStringConverter(){

                public String getPreferredStringForItem(Object object) {
                    if (object instanceof ContactsEntry.Row) {
                        String string;
                        ContactsEntry.Row row = (ContactsEntry.Row)object;
                        String string2 = "";
                        String string3 = row.writePerson();
                        if (string3 != null && string3.trim().length() > 0) {
                            if (string2.length() > 0) {
                                string2 = string2 + " / ";
                            }
                            string2 = string2 + string3.trim();
                        }
                        if ((string = row.company) != null && string.trim().length() > 0) {
                            if (string2.length() > 0) {
                                string2 = string2 + " / ";
                            }
                            string2 = string2 + string.trim();
                        }
                        return "#" + row.id + " | " + string2;
                    }
                    return "-";
                }

                public String[] getPossibleStringsForItem(Object object) {
                    if (object instanceof ContactsEntry.Row) {
                        ContactsEntry.Row row = (ContactsEntry.Row)object;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(this.getPreferredStringForItem(object));
                        arrayList.add("#" + row.id);
                        if (row.firstName != null && row.firstName.trim().length() > 0) {
                            arrayList.add(row.firstName);
                        }
                        if (row.lastName != null && row.lastName.trim().length() > 0) {
                            arrayList.add(row.lastName);
                        }
                        if (row.company != null && row.company.trim().length() > 0) {
                            arrayList.add(row.company);
                        }
                        return arrayList.toArray(new String[arrayList.size()]);
                    }
                    return super.getPossibleStringsForItem(object);
                }
            });
        }
        this.closeButton = new JButton(this.actionMap.get("doClose"));
        this.closeButton.setName("closeButton");
        this.submitButton = new JButton(this.actionMap.get("doSubmit"));
        this.submitButton.setName("submitButton");
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 20dlu:grow");
        defaultFormBuilder.opaque(false);
        if (this.selection == 0 || this.selection == 2) {
            defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.selectContact", new Object[0])), 3);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.resourceMap.getString("label.contactGroupField", new Object[0]), (Component)jPanel3);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.resourceMap.getString("label.contactEntryField", new Object[0]), jPanel4);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append((Component)new JLabel(" "), 3);
            defaultFormBuilder.nextLine();
        }
        if (this.selection == 0 || this.selection == 1) {
            defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.selectCalendar", new Object[0])), 3);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.resourceMap.getString("label.calendarGroupField", new Object[0]), (Component)jPanel);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.resourceMap.getString("label.calendarEntryField", new Object[0]), jPanel2);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append((Component)new JLabel(" "), 3);
            defaultFormBuilder.nextLine();
        }
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.setNotes", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        this.contentPane.setLayout((LayoutManager)new BorderLayout(5, 5));
        this.contentPane.setBorder(Borders.DIALOG);
        this.contentPane.add((Component)defaultFormBuilder.getPanel(), (Object)"North");
        JScrollPane jScrollPane = new JScrollPane((Component)this.notesField);
        jScrollPane.setOpaque(false);
        this.contentPane.add((Component)jScrollPane, (Object)"Center");
        JPanel jPanel5 = ImmoToolUtils.buildButtonBar((JButton[])new JButton[]{this.submitButton, this.closeButton});
        jPanel5.setOpaque(false);
        this.contentPane.add((Component)jPanel5, (Object)"South");
        this.contentPane.revalidate();
        this.contentPane.repaint();
    }

    @Action
    public void doClose() {
        this.status = 1;
        this.setVisible(false);
    }

    @Action
    public void doSelectEstate() {
    }

    @Action
    public void doSubmit() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.calendarGroupField != null && this.calendarEntryField != null && (this.calendarGroupField.getSelectedIndex() <= 0 || this.calendarEntryField.getSelectedIndex() <= 0)) {
            arrayList.add(this.resourceMap.getString("error.noCalendarEntrySelected", new Object[0]));
        }
        if (this.contactGroupField != null && this.contactEntryField != null && (this.contactGroupField.getSelectedIndex() <= 0 || this.contactEntryField.getSelectedIndex() <= 0)) {
            arrayList.add(this.resourceMap.getString("error.noContactEntrySelected", new Object[0]));
        }
        if (!arrayList.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]), arrayList);
            return;
        }
        this.status = 2;
        this.setVisible(false);
    }

    public CalendarEntry getSelectedCalendarEntry() {
        if (this.calendarEntryField == null) {
            return null;
        }
        Object object = this.calendarEntryField.getSelectedItem();
        return object instanceof CalendarEntry ? (CalendarEntry)object : null;
    }

    public CalendarSource getSelectedCalendarSource() {
        if (this.calendarGroupField == null) {
            return null;
        }
        Object object = this.calendarGroupField.getSelectedItem();
        return object instanceof CalendarSource ? (CalendarSource)object : null;
    }

    public ContactsEntry.Row getSelectedContactsEntry() {
        if (this.contactEntryField == null) {
            return null;
        }
        Object object = this.contactEntryField.getSelectedItem();
        return object instanceof ContactsEntry.Row ? (ContactsEntry.Row)object : null;
    }

    public ContactsGroup getSelectedContactsGroup() {
        if (this.contactGroupField == null) {
            return null;
        }
        Object object = this.contactGroupField.getSelectedItem();
        return object instanceof ContactsGroup ? (ContactsGroup)object : null;
    }

    public int getStatus() {
        return this.status;
    }

    public void load(ContactsEntryCalendar contactsEntryCalendar) throws ImmoToolException {
        this.notesField.setText(contactsEntryCalendar != null ? contactsEntryCalendar.getDescription().trim() : "");
    }

    public void loadCalendar(CalendarEntry calendarEntry) throws ImmoToolException {
        if (calendarEntry != null) {
            this.loadCalendar(calendarEntry.getCalendarId(), calendarEntry.getUId() != null ? calendarEntry.getUId().getValue() : null);
        } else {
            this.loadCalendar(0L, null);
        }
    }

    public void loadCalendar(long l, String string) throws ImmoToolException {
        if (this.calendarGroupField == null || this.calendarEntryField == null) {
            return;
        }
        this.calendarEntryUIdOnLoad = string;
        this.calendarGroupField.setSelectedIndex(-1);
        ImmoToolUtils.executeTask((Task)this.reloadCalendarGroups(l));
    }

    private DefaultComboBoxModel loadCalendarEntryModel(Collection collection) throws ImmoToolException {
        CalendarSource calendarSource = this.getSelectedCalendarSource();
        if (calendarSource == null) {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            defaultComboBoxModel.addElement("[ " + this.resourceMap.getString("label.calendarEntryField.selectGroup", new Object[0]) + " ]");
            return defaultComboBoxModel;
        }
        try {
            DefaultComboBoxModel<CalendarEntry> defaultComboBoxModel = new DefaultComboBoxModel<CalendarEntry>();
            defaultComboBoxModel.addElement(null);
            CalendarObject calendarObject = CalendarObject.load((long)calendarSource.getCalendarId());
            for (CalendarEntry calendarEntry : calendarObject.getEntries()) {
                if (calendarEntry == null || calendarEntry instanceof CalendarJournalEntry) continue;
                defaultComboBoxModel.addElement(calendarEntry);
            }
            return defaultComboBoxModel;
        }
        catch (Exception exception) {
            throw new ImmoToolException("Can't load calendar entries!", (Throwable)exception);
        }
    }

    private DefaultComboBoxModel loadCalendarGroupModel(Collection collection) throws ImmoToolException {
        try {
            DefaultComboBoxModel<CalendarSource> defaultComboBoxModel = new DefaultComboBoxModel<CalendarSource>();
            defaultComboBoxModel.addElement(null);
            for (CalendarSource calendarSource : CalendarSource.loadSources((Collection)collection)) {
                defaultComboBoxModel.addElement(calendarSource);
            }
            return defaultComboBoxModel;
        }
        catch (Exception exception) {
            throw new ImmoToolException("Can't load calendar sources!", (Throwable)exception);
        }
    }

    public void loadContact(ContactsEntry contactsEntry) throws ImmoToolException {
        if (contactsEntry != null) {
            this.loadContact(contactsEntry.getGroupId(), contactsEntry.getId());
        } else {
            this.loadContact(0L, 0L);
        }
    }

    public void loadContact(long l, long l2) throws ImmoToolException {
        if (this.contactGroupField == null || this.contactEntryField == null) {
            return;
        }
        this.contactEntryIdOnLoad = l2;
        this.contactGroupField.setSelectedIndex(-1);
        ImmoToolUtils.executeTask((Task)this.reloadContactGroups(l));
    }

    private DefaultComboBoxModel loadContactEntryModel(Collection collection) throws ImmoToolException {
        ContactsGroup contactsGroup = this.getSelectedContactsGroup();
        if (contactsGroup == null) {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            defaultComboBoxModel.addElement(" [ " + this.resourceMap.getString("label.contactEntryField.selectGroup", new Object[0]) + " ] ");
            return defaultComboBoxModel;
        }
        try {
            DefaultComboBoxModel<ContactsEntry.Row> defaultComboBoxModel = new DefaultComboBoxModel<ContactsEntry.Row>();
            defaultComboBoxModel.addElement(null);
            ContactsEntry.Row[] rowArray = ContactsEntry.loadRows(null, (Long[])new Long[]{contactsGroup.getId()}, null, null, (Collection)collection);
            if (rowArray != null) {
                for (ContactsEntry.Row row : rowArray) {
                    defaultComboBoxModel.addElement(row);
                }
            }
            return defaultComboBoxModel;
        }
        catch (Exception exception) {
            throw new ImmoToolException("Can't load contact entries!", (Throwable)exception);
        }
    }

    private DefaultComboBoxModel loadContactGroupModel(Collection collection) throws ImmoToolException {
        try {
            DefaultComboBoxModel<ContactsGroup> defaultComboBoxModel = new DefaultComboBoxModel<ContactsGroup>();
            defaultComboBoxModel.addElement(null);
            for (ContactsGroup contactsGroup : ContactsGroup.loadGroups((Collection)collection)) {
                defaultComboBoxModel.addElement(contactsGroup);
            }
            return defaultComboBoxModel;
        }
        catch (Exception exception) {
            throw new ImmoToolException("Can't load contact groups!", (Throwable)exception);
        }
    }

    private Task reloadCalendarEntries(final String string) {
        if (this.calendarEntryTask != null) {
            LOGGER.info((Object)"cancel running entry-task...");
            this.calendarEntryTask.cancel(true);
        }
        this.calendarEntryField.setEnabled(false);
        this.calendarEntryField.setVisible(false);
        this.calendarEntryBusyField.setVisible(true);
        this.calendarEntryBusyField.setBusy(true);
        this.calendarEntryBusyField.setText(this.resourceMap.getString("message.doSearchEntries", new Object[0]));
        this.calendarEntryTask = new ImmoToolTask<DefaultComboBoxModel>(){

            protected DefaultComboBoxModel executeTask() throws Exception {
                if (ContactsEntryCalendarDialog.this.calendarCollection == null) {
                    ContactsEntryCalendarDialog.this.calendarCollection = CalendarPluginUtils.openPluginCollection((String)"");
                }
                DefaultComboBoxModel defaultComboBoxModel = ContactsEntryCalendarDialog.this.loadCalendarEntryModel(ContactsEntryCalendarDialog.this.calendarCollection);
                ContactsEntryCalendarDialog.this.calendarEntryBusyField.setText(ContactsEntryCalendarDialog.this.resourceMap.getString("message.doRefreshBox", new Object[0]));
                ContactsEntryCalendarDialog.this.calendarEntryField.setModel(defaultComboBoxModel);
                return defaultComboBoxModel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryCalendarDialog.this.resourceMap.getString("error.cantLoadCalendarEntries", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsEntryCalendarDialog.this.calendarEntryField.setEnabled(true);
                ContactsEntryCalendarDialog.this.calendarEntryField.setVisible(true);
                ContactsEntryCalendarDialog.this.calendarEntryBusyField.setVisible(false);
                ContactsEntryCalendarDialog.this.calendarEntryBusyField.setBusy(false);
                ContactsEntryCalendarDialog.this.calendarEntryTask = null;
                if (ContactsEntryCalendarDialog.this.calendarEntryUIdOnLoad != null) {
                    ContactsEntryCalendarDialog.this.calendarEntryUIdOnLoad = null;
                }
                if (ContactsEntryCalendarDialog.this.calendarCollection != null && ContactsEntryCalendarDialog.this.calendarGroupTask == null) {
                    ImmoToolDbUtils.close((Collection)ContactsEntryCalendarDialog.this.calendarCollection);
                    ContactsEntryCalendarDialog.this.calendarCollection = null;
                }
            }

            protected void succeeded(DefaultComboBoxModel defaultComboBoxModel) {
                super.succeeded((Object)defaultComboBoxModel);
                ContactsEntryCalendarDialog.this.calendarEntryField.setSelectedIndex(-1);
                if (string != null) {
                    for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                        CalendarEntry calendarEntry;
                        Object e = defaultComboBoxModel.getElementAt(i);
                        if (!(e instanceof CalendarEntry) || !string.equals((calendarEntry = (CalendarEntry)e).getUId().getValue())) continue;
                        ContactsEntryCalendarDialog.this.calendarEntryField.setSelectedIndex(i);
                        break;
                    }
                }
            }
        };
        return this.calendarEntryTask;
    }

    private Task reloadCalendarGroups(final long l) {
        if (this.calendarGroupTask != null) {
            LOGGER.info((Object)"cancel running group-task...");
            this.calendarGroupTask.cancel(true);
        }
        this.calendarGroupField.setEnabled(false);
        this.calendarGroupField.setVisible(false);
        this.calendarGroupBusyField.setVisible(true);
        this.calendarGroupBusyField.setBusy(true);
        this.calendarGroupBusyField.setText(this.resourceMap.getString("message.doSearchEntries", new Object[0]));
        this.calendarGroupTask = new ImmoToolTask<DefaultComboBoxModel>(){

            protected DefaultComboBoxModel executeTask() throws Exception {
                if (ContactsEntryCalendarDialog.this.calendarCollection == null) {
                    ContactsEntryCalendarDialog.this.calendarCollection = CalendarPluginUtils.openPluginCollection((String)"");
                }
                DefaultComboBoxModel defaultComboBoxModel = ContactsEntryCalendarDialog.this.loadCalendarGroupModel(ContactsEntryCalendarDialog.this.calendarCollection);
                ContactsEntryCalendarDialog.this.calendarGroupBusyField.setText(ContactsEntryCalendarDialog.this.resourceMap.getString("message.doRefreshBox", new Object[0]));
                ContactsEntryCalendarDialog.this.calendarGroupField.setModel(defaultComboBoxModel);
                return defaultComboBoxModel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryCalendarDialog.this.resourceMap.getString("error.cantLoadCalendarGroups", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsEntryCalendarDialog.this.calendarGroupField.setEnabled(true);
                ContactsEntryCalendarDialog.this.calendarGroupField.setVisible(true);
                ContactsEntryCalendarDialog.this.calendarGroupBusyField.setVisible(false);
                ContactsEntryCalendarDialog.this.calendarGroupBusyField.setBusy(false);
                ContactsEntryCalendarDialog.this.calendarGroupTask = null;
                if (ContactsEntryCalendarDialog.this.calendarCollection != null && ContactsEntryCalendarDialog.this.calendarEntryTask == null) {
                    ImmoToolDbUtils.close((Collection)ContactsEntryCalendarDialog.this.calendarCollection);
                    ContactsEntryCalendarDialog.this.calendarCollection = null;
                }
            }

            protected void succeeded(DefaultComboBoxModel defaultComboBoxModel) {
                super.succeeded((Object)defaultComboBoxModel);
                if (l == 0L) {
                    ContactsEntryCalendarDialog.this.calendarGroupField.setSelectedIndex(0);
                } else if (l > 0L) {
                    ContactsEntryCalendarDialog.this.calendarGroupField.setSelectedIndex(-1);
                    for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                        CalendarSource calendarSource;
                        Object e = defaultComboBoxModel.getElementAt(i);
                        if (!(e instanceof CalendarSource) || (calendarSource = (CalendarSource)e).getCalendarId() != l) continue;
                        ContactsEntryCalendarDialog.this.calendarGroupField.setSelectedIndex(i);
                        break;
                    }
                }
            }
        };
        return this.calendarGroupTask;
    }

    private Task reloadContactEntries(final long l) {
        if (this.contactEntryTask != null) {
            LOGGER.info((Object)"cancel running entry-task...");
            this.contactEntryTask.cancel(true);
        }
        this.contactEntryField.setEnabled(false);
        this.contactEntryField.setVisible(false);
        this.contactEntryBusyField.setVisible(true);
        this.contactEntryBusyField.setBusy(true);
        this.contactEntryBusyField.setText(this.resourceMap.getString("message.doSearchEntries", new Object[0]));
        this.contactEntryTask = new ImmoToolTask<DefaultComboBoxModel>(){

            protected DefaultComboBoxModel executeTask() throws Exception {
                if (ContactsEntryCalendarDialog.this.contactCollection == null) {
                    ContactsEntryCalendarDialog.this.contactCollection = ContactsPluginUtils.openPluginCollection((String)"");
                }
                DefaultComboBoxModel defaultComboBoxModel = ContactsEntryCalendarDialog.this.loadContactEntryModel(ContactsEntryCalendarDialog.this.contactCollection);
                ContactsEntryCalendarDialog.this.contactEntryBusyField.setText(ContactsEntryCalendarDialog.this.resourceMap.getString("message.doRefreshBox", new Object[0]));
                ContactsEntryCalendarDialog.this.contactEntryField.setModel(defaultComboBoxModel);
                return defaultComboBoxModel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryCalendarDialog.this.resourceMap.getString("error.cantLoadContactEntries", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsEntryCalendarDialog.this.contactEntryField.setEnabled(true);
                ContactsEntryCalendarDialog.this.contactEntryField.setVisible(true);
                ContactsEntryCalendarDialog.this.contactEntryBusyField.setVisible(false);
                ContactsEntryCalendarDialog.this.contactEntryBusyField.setBusy(false);
                ContactsEntryCalendarDialog.this.contactEntryTask = null;
                if (ContactsEntryCalendarDialog.this.contactEntryIdOnLoad != null) {
                    ContactsEntryCalendarDialog.this.contactEntryIdOnLoad = null;
                }
                if (ContactsEntryCalendarDialog.this.contactCollection != null && ContactsEntryCalendarDialog.this.contactGroupTask == null) {
                    ImmoToolDbUtils.close((Collection)ContactsEntryCalendarDialog.this.contactCollection);
                    ContactsEntryCalendarDialog.this.contactCollection = null;
                }
            }

            protected void succeeded(DefaultComboBoxModel defaultComboBoxModel) {
                super.succeeded((Object)defaultComboBoxModel);
                ContactsEntryCalendarDialog.this.contactEntryField.setSelectedIndex(-1);
                if (l > 0L) {
                    for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                        Object e = defaultComboBoxModel.getElementAt(i);
                        if (!(e instanceof ContactsEntry.Row)) continue;
                        ContactsEntry.Row row = (ContactsEntry.Row)e;
                        if (row.id != l) continue;
                        ContactsEntryCalendarDialog.this.contactEntryField.setSelectedIndex(i);
                        break;
                    }
                }
            }
        };
        return this.contactEntryTask;
    }

    private Task reloadContactGroups(final long l) {
        if (this.contactGroupTask != null) {
            LOGGER.info((Object)"cancel running group-task...");
            this.contactGroupTask.cancel(true);
        }
        this.contactGroupField.setEnabled(false);
        this.contactGroupField.setVisible(false);
        this.contactGroupBusyField.setVisible(true);
        this.contactGroupBusyField.setBusy(true);
        this.contactGroupBusyField.setText(this.resourceMap.getString("message.doSearchEntries", new Object[0]));
        this.contactGroupTask = new ImmoToolTask<DefaultComboBoxModel>(){

            protected DefaultComboBoxModel executeTask() throws Exception {
                if (ContactsEntryCalendarDialog.this.contactCollection == null) {
                    ContactsEntryCalendarDialog.this.contactCollection = ContactsPluginUtils.openPluginCollection((String)"");
                }
                DefaultComboBoxModel defaultComboBoxModel = ContactsEntryCalendarDialog.this.loadContactGroupModel(ContactsEntryCalendarDialog.this.contactCollection);
                ContactsEntryCalendarDialog.this.contactGroupBusyField.setText(ContactsEntryCalendarDialog.this.resourceMap.getString("message.doRefreshBox", new Object[0]));
                ContactsEntryCalendarDialog.this.contactGroupField.setModel(defaultComboBoxModel);
                return defaultComboBoxModel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryCalendarDialog.this.resourceMap.getString("error.cantLoadContactGroups", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsEntryCalendarDialog.this.contactGroupField.setEnabled(true);
                ContactsEntryCalendarDialog.this.contactGroupField.setVisible(true);
                ContactsEntryCalendarDialog.this.contactGroupBusyField.setVisible(false);
                ContactsEntryCalendarDialog.this.contactGroupBusyField.setBusy(false);
                ContactsEntryCalendarDialog.this.contactGroupTask = null;
                if (ContactsEntryCalendarDialog.this.contactCollection != null && ContactsEntryCalendarDialog.this.contactEntryTask == null) {
                    ImmoToolDbUtils.close((Collection)ContactsEntryCalendarDialog.this.contactCollection);
                    ContactsEntryCalendarDialog.this.contactCollection = null;
                }
            }

            protected void succeeded(DefaultComboBoxModel defaultComboBoxModel) {
                super.succeeded((Object)defaultComboBoxModel);
                if (l == 0L) {
                    ContactsEntryCalendarDialog.this.contactGroupField.setSelectedIndex(0);
                } else if (l > 0L) {
                    ContactsEntryCalendarDialog.this.contactGroupField.setSelectedIndex(-1);
                    for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                        ContactsGroup contactsGroup;
                        Object e = defaultComboBoxModel.getElementAt(i);
                        if (!(e instanceof ContactsGroup) || (contactsGroup = (ContactsGroup)e).getId() != l) continue;
                        ContactsEntryCalendarDialog.this.contactGroupField.setSelectedIndex(i);
                        break;
                    }
                }
            }
        };
        return this.contactGroupTask;
    }

    public void save(ContactsEntryCalendar contactsEntryCalendar) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.contactGroupField != null && this.contactGroupField.getSelectedIndex() <= 0) {
            arrayList.add(this.resourceMap.getString("error.noContactGroupSelected", new Object[0]));
        }
        if (this.contactEntryField != null && this.contactEntryField.getSelectedIndex() <= 0) {
            arrayList.add(this.resourceMap.getString("error.noContactEntrySelected", new Object[0]));
        }
        if (this.calendarGroupField != null && this.calendarGroupField.getSelectedIndex() <= 0) {
            arrayList.add(this.resourceMap.getString("error.noCalendarGroupSelected", new Object[0]));
        }
        if (this.calendarEntryField != null && this.calendarEntryField.getSelectedIndex() <= 0) {
            arrayList.add(this.resourceMap.getString("error.noCalendarEntrySelected", new Object[0]));
        }
        if (!arrayList.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]), arrayList);
            return;
        }
        contactsEntryCalendar.setDescription(ImmoToolUtils.replaceTags((String)this.notesField.getText()).trim());
        if (this.calendarGroupField != null) {
            contactsEntryCalendar.setCalendarId(this.getSelectedCalendarSource().getCalendarId());
        }
        if (this.calendarEntryField != null) {
            contactsEntryCalendar.setCalendarUid(this.getSelectedCalendarEntry().getUId().getValue());
        }
        if (this.contactGroupField != null) {
            contactsEntryCalendar.setContactGroupId(this.getSelectedContactsGroup().getId());
        }
        if (this.contactEntryField != null) {
            contactsEntryCalendar.setContactEntryId(this.getSelectedContactsEntry().id);
        }
    }

    private final class ContactGroupRenderer
    extends JLabel
    implements ListCellRenderer {
        public ContactGroupRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof ContactsGroup) {
                ContactsGroup contactsGroup = (ContactsGroup)object;
                this.setText(contactsGroup.getName());
            } else if (object instanceof String) {
                this.setText((String)object);
            } else {
                this.setText(n <= 0 ? "[ " + ContactsEntryCalendarDialog.this.resourceMap.getString("label.contactGroupField.select", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }

    private final class ContactEntryRenderer
    extends JLabel
    implements ListCellRenderer {
        private ContactEntryRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof ContactsEntry.Row) {
                ContactsPluginUtils.prepareListCellRenderer((JLabel)this, (JList)jList, (ContactsEntry.Row)((ContactsEntry.Row)object), (int)n, (boolean)bl, (boolean)bl2);
            } else if (object instanceof String) {
                this.setText((String)object);
            } else {
                this.setText(n <= 0 ? "[ " + ContactsEntryCalendarDialog.this.resourceMap.getString("label.calendarEntryField.select", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }

    private final class CalendarSourceRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarSourceRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof CalendarSource) {
                CalendarSource calendarSource = (CalendarSource)object;
                this.setText("#" + calendarSource.getCalendarId() + " | " + calendarSource.getName());
            } else if (object instanceof String) {
                this.setText((String)object);
            } else {
                this.setText(n <= 0 ? "[ " + ContactsEntryCalendarDialog.this.resourceMap.getString("label.calendarGroupField.select", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }

    private final class CalendarEntryRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarEntryRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof CalendarEntry) {
                CalendarEntry calendarEntry = (CalendarEntry)object;
                if (calendarEntry.getBegin() != null) {
                    this.setText(DATEFORMAT_SHORT.format(calendarEntry.getBegin()) + " | " + calendarEntry.getSummaryString());
                } else {
                    this.setText("- | " + calendarEntry.getSummaryString());
                }
            } else if (object instanceof String) {
                this.setText((String)object);
            } else {
                this.setText(n <= 0 ? "[ " + ContactsEntryCalendarDialog.this.resourceMap.getString("label.calendarEntryField.select", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }
}

