/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEntryTableModel;
import com.openindex.openestate.tool.calendar.CalendarEntryViewTask;
import com.openindex.openestate.tool.calendar.CalendarSource;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsEntryViewAddonPanel;
import com.openindex.openestate.tool.contacts.addons.ContactsEntryCalendar;
import com.openindex.openestate.tool.contacts.addons.ContactsEntryCalendarDialog;
import com.openindex.openestate.tool.utils.QuickTableExport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;

public class ContactsEntryCalendarTablePanel
extends ContactsEntryViewAddonPanel {
    private static final Logger LOGGER = Logger.getLogger(ContactsEntryCalendarTablePanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JPopupMenu actionsMenu;
    private TableModel resultTableModel;
    private List<ContactsEntryCalendar> selectedEntryCalendars;
    private ContactsEntry selectedContactsEntry = null;
    private boolean isModified = false;
    private JButton actionButton;
    private JButton addButton;
    private JButton calendarNotesButton;
    private JTextArea calendarNotesField;
    private JPanel calendarNotesPanel;
    private JScrollPane calendarNotesScroller;
    private JXTitledSeparator calendarNotesTitleLabel;
    private JButton refreshButton;
    private JXTable resultTable;
    private JScrollPane resultTableScroller;
    private JXTitledSeparator titleLabel;

    public ContactsEntryCalendarTablePanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(ContactsEntryCalendarTablePanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(ContactsEntryCalendarTablePanel.class);
        this.selectedEntryCalendars = new ArrayList<ContactsEntryCalendar>();
        this.initComponents();
        this.actionsMenu = new JPopupMenu();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doViewEntry")));
        this.actionsMenu.addSeparator();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doView")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doRemove")));
        this.resultTableModel = new TableModel();
        this.resultTable.setModel((javax.swing.table.TableModel)((Object)this.resultTableModel));
        this.resultTable.setSortable(true);
        this.resultTable.getSelectionModel().setSelectionMode(0);
        this.resultTable.getColumn(1).setCellRenderer((TableCellRenderer)new CalendarEntryTableModel.CalendarDateRenderer());
        this.resultTable.getColumn(2).setCellRenderer((TableCellRenderer)new CalendarEntryTableModel.CalendarDateRenderer());
        this.resultTable.getColumnModel().removeColumn(this.resultTable.getColumn(0));
        this.resultTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    ContactsEntryCalendarTablePanel.this.doView();
                } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    int n = ContactsEntryCalendarTablePanel.this.resultTable.rowAtPoint(mouseEvent.getPoint());
                    if (n >= 0 && n != ContactsEntryCalendarTablePanel.this.resultTable.getSelectedRow() && n >= 0) {
                        ContactsEntryCalendarTablePanel.this.resultTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    if (n < 0) {
                        n = ContactsEntryCalendarTablePanel.this.resultTable.getSelectedRow();
                    }
                    if (n < 0) {
                        return;
                    }
                    ContactsEntryCalendarTablePanel.this.showActions((JComponent)ContactsEntryCalendarTablePanel.this.resultTable, ((ContactsEntryCalendarTablePanel)ContactsEntryCalendarTablePanel.this).resultTable.getMousePosition().x, ((ContactsEntryCalendarTablePanel)ContactsEntryCalendarTablePanel.this).resultTable.getMousePosition().y);
                }
            }
        });
        this.resultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ContactsEntryCalendarTablePanel.this.actionButton.setEnabled(ContactsEntryCalendarTablePanel.this.resultTable.getSelectedRowCount() > 0);
                if (ContactsEntryCalendarTablePanel.this.resultTable.getSelectedRowCount() < 1) {
                    ContactsEntryCalendarTablePanel.this.calendarNotesField.setText("");
                    ContactsEntryCalendarTablePanel.this.calendarNotesPanel.setVisible(false);
                } else {
                    int n = ContactsEntryCalendarTablePanel.this.resultTable.convertRowIndexToModel(ContactsEntryCalendarTablePanel.this.resultTable.getSelectedRow());
                    String string = ContactsEntryCalendarTablePanel.this.resultTableModel.getDescription(n);
                    ContactsEntryCalendarTablePanel.this.calendarNotesField.setText(string != null ? string.trim() : "");
                    ContactsEntryCalendarTablePanel.this.calendarNotesField.setCaretPosition(0);
                    ContactsEntryCalendarTablePanel.this.calendarNotesPanel.setVisible(true);
                }
            }
        });
        this.resultTable.setColumnControl((JComponent)QuickTableExport.createColumnControl((JXTable)this.resultTable));
        ImmoToolUtils.configureTable((JXTable)this.resultTable);
        this.resourceMap.injectComponents((Component)((Object)this));
        this.actionButton.setEnabled(false);
        this.calendarNotesPanel.setVisible(false);
    }

    @Action
    public void doAction() {
        this.showActions(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doAdd() {
        ContactsEntryCalendarDialog contactsEntryCalendarDialog = null;
        try {
            contactsEntryCalendarDialog = new ContactsEntryCalendarDialog(1, ImmoToolApp.getApplication().getMainFrame(), true);
            contactsEntryCalendarDialog.load(null);
            contactsEntryCalendarDialog.loadCalendar(null);
            contactsEntryCalendarDialog.setVisible(true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant create dialog!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantCreateDialog", new Object[0]), (Throwable)exception);
            return;
        }
        try {
            if (contactsEntryCalendarDialog.getStatus() != 2) {
                return;
            }
            ContactsEntryCalendar contactsEntryCalendar = new ContactsEntryCalendar();
            contactsEntryCalendarDialog.save(contactsEntryCalendar);
            if (this.getRowForCalendar(contactsEntryCalendar.getCalendarId(), contactsEntryCalendar.getCalendarUid()) > -1) {
                LOGGER.error((Object)"calendar is already mapped!");
                LOGGER.error((Object)("> cal #" + contactsEntryCalendar.getCalendarId()));
                LOGGER.error((Object)("> uid: " + contactsEntryCalendar.getCalendarUid()));
                ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.calendarIsAlreadyMapped", new Object[0]));
                return;
            }
            CalendarSource calendarSource = contactsEntryCalendarDialog.getSelectedCalendarSource();
            String string = calendarSource != null ? calendarSource.getName() : null;
            this.resultTableModel.addCalendarEntry(contactsEntryCalendarDialog.getSelectedCalendarEntry(), string, contactsEntryCalendar.getDescription());
            this.selectedEntryCalendars.add(contactsEntryCalendar);
            this.isModified = true;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant put calendar!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantPutCalendar", new Object[0]), (Throwable)exception);
            return;
        }
    }

    public Task doLoadInBackground() {
        return this.doRefresh();
    }

    @Action
    public Task doRefresh() {
        this.resultTableModel.clear();
        this.selectedEntryCalendars.clear();
        this.resultTable.setEnabled(false);
        this.addButton.setEnabled(false);
        this.actionButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        return new ImmoToolTask<Long>(){

            protected Long executeTask() throws Exception {
                if (ContactsEntryCalendarTablePanel.this.selectedContactsEntry == null) {
                    return 0L;
                }
                HashMap<Long, CalendarSource> hashMap = new HashMap<Long, CalendarSource>();
                Object[] objectArray = CalendarSource.loadSources();
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    CalendarSource calendarSource = objectArray[i];
                    hashMap.put(calendarSource.getCalendarId(), calendarSource);
                }
                for (CalendarSource calendarSource : objectArray = ContactsEntryCalendar.loadEntriesForContact(ContactsEntryCalendarTablePanel.this.selectedContactsEntry.getGroupId(), ContactsEntryCalendarTablePanel.this.selectedContactsEntry.getId())) {
                    CalendarEntry calendarEntry = calendarSource.loadCalendarEntry();
                    if (calendarEntry == null) {
                        LOGGER.warn((Object)("entry not found, " + calendarSource.getCalendarUid()));
                        continue;
                    }
                    ContactsEntryCalendarTablePanel.this.selectedEntryCalendars.add(calendarSource);
                    ContactsEntryCalendarTablePanel.this.resultTableModel.addCalendarEntry(calendarEntry, ((CalendarSource)hashMap.get(calendarEntry.getCalendarId())).getName(), calendarSource.getDescription());
                }
                return objectArray.length;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)ContactsEntryCalendarTablePanel.this.resourceMap.getString("error.cantRefresh", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                ContactsEntryCalendarTablePanel.this.resultTable.setEnabled(true);
                ContactsEntryCalendarTablePanel.this.addButton.setEnabled(true);
                ContactsEntryCalendarTablePanel.this.refreshButton.setEnabled(true);
            }

            protected void succeeded(Long l) {
                super.succeeded((Object)l);
                if (l == null) {
                    return;
                }
                ContactsEntryCalendarTablePanel.this.titleLabel.setTitle(ContactsEntryCalendarTablePanel.this.resourceMap.getString("titleLabel.title", new Object[0]) + " / " + ContactsEntryCalendarTablePanel.this.resourceMap.getString("message.resultCount", new Object[]{NumberFormat.getIntegerInstance().format(ContactsEntryCalendarTablePanel.this.resultTable.getRowCount())}));
                ContactsEntryCalendarTablePanel.this.resultTable.packAll();
                ContactsEntryCalendarTablePanel.this.isModified = false;
            }
        };
    }

    @Action
    public void doRemove() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.resultTable.getSelectedRow();
        int n2 = this.resultTable.convertRowIndexToModel(n);
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteCalendarEntry", new Object[0]));
        if (!bl) {
            return;
        }
        CalendarEntry calendarEntry = this.resultTableModel.getEntry(n2);
        long l = calendarEntry.getCalendarId();
        String string = calendarEntry.getUId() != null ? calendarEntry.getUId().getValue() : null;
        for (ContactsEntryCalendar contactsEntryCalendar : this.selectedEntryCalendars) {
            if (contactsEntryCalendar.getCalendarId() != l || !contactsEntryCalendar.getCalendarUid().equals(string)) continue;
            this.selectedEntryCalendars.remove((Object)contactsEntryCalendar);
            break;
        }
        this.resultTableModel.removeRow(n2);
        this.isModified = true;
    }

    @Action
    public void doSaveNotes() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.resultTable.getSelectedRow();
        int n2 = this.resultTable.convertRowIndexToModel(n);
        CalendarEntry calendarEntry = this.resultTableModel.getEntry(n2);
        long l = calendarEntry.getCalendarId();
        String string = calendarEntry.getUId() != null ? calendarEntry.getUId().getValue() : null;
        for (ContactsEntryCalendar contactsEntryCalendar : this.selectedEntryCalendars) {
            if (contactsEntryCalendar.getCalendarId() != l || !contactsEntryCalendar.getCalendarUid().equals(string)) continue;
            String string2 = this.calendarNotesField.getText().trim();
            contactsEntryCalendar.setDescription(string2);
            this.resultTableModel.setDescriptionAt(n2, string2);
            this.isModified = true;
            break;
        }
    }

    @Action
    public void doView() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.resultTable.getSelectedRow();
        int n2 = this.resultTable.convertRowIndexToModel(n);
        ContactsEntryCalendar contactsEntryCalendar = null;
        CalendarEntry calendarEntry = this.resultTableModel.getEntry(n2);
        long l = calendarEntry.getCalendarId();
        String string = calendarEntry.getUId() != null ? calendarEntry.getUId().getValue() : null;
        for (ContactsEntryCalendar contactsEntryCalendar2 : this.selectedEntryCalendars) {
            if (contactsEntryCalendar2.getCalendarId() != l || !contactsEntryCalendar2.getCalendarUid().equals(string)) continue;
            contactsEntryCalendar = contactsEntryCalendar2;
            break;
        }
        if (contactsEntryCalendar == null) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.noCalendarEntryFound", new Object[0]));
            return;
        }
        Object object = null;
        try {
            object = new ContactsEntryCalendarDialog(1, ImmoToolApp.getApplication().getMainFrame(), true);
            ((ContactsEntryCalendarDialog)object).load(contactsEntryCalendar);
            ((ContactsEntryCalendarDialog)object).loadCalendar(calendarEntry);
            ((Dialog)object).setVisible(true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't create dialog!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantCreateDialog", new Object[0]), (Throwable)exception);
            return;
        }
        if (((ContactsEntryCalendarDialog)object).getStatus() != 2) {
            return;
        }
        try {
            int n3;
            ((ContactsEntryCalendarDialog)object).save(contactsEntryCalendar);
            int n4 = this.getRowForCalendar(contactsEntryCalendar.getCalendarId(), contactsEntryCalendar.getCalendarUid());
            int n5 = n3 = n4 > -1 ? this.resultTable.convertRowIndexToModel(n4) : -1;
            if (n3 > -1 && n3 != n2) {
                LOGGER.error((Object)"Calendar entry is already mapped!");
                LOGGER.error((Object)("> cal #" + contactsEntryCalendar.getCalendarId()));
                LOGGER.error((Object)("> uid: " + contactsEntryCalendar.getCalendarUid()));
                ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.calendarIsAlreadyMapped", new Object[0]));
                return;
            }
            CalendarSource calendarSource = ((ContactsEntryCalendarDialog)object).getSelectedCalendarSource();
            String string2 = calendarSource != null ? calendarSource.getName() : null;
            this.resultTableModel.setCalendarEntry(n2, ((ContactsEntryCalendarDialog)object).getSelectedCalendarEntry(), string2, contactsEntryCalendar.getDescription());
            this.isModified = true;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't put calendar entry!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantPutCalendar", new Object[0]), (Throwable)exception);
            return;
        }
    }

    @Action
    public Task doViewEntry() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return null;
        }
        int n = this.resultTable.getSelectedRow();
        int n2 = this.resultTable.convertRowIndexToModel(n);
        CalendarEntry calendarEntry = this.resultTableModel.getEntry(n2);
        return new CalendarEntryViewTask(calendarEntry);
    }

    private int getRowForCalendar(long l, String string) {
        for (int i = 0; i < this.resultTable.getRowCount(); ++i) {
            if (!string.equals(this.resultTableModel.getEntryUId(i)) || l != this.resultTableModel.getEntryCalId(i)) continue;
            return i;
        }
        return -1;
    }

    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    public boolean isFormEnabled() {
        return true;
    }

    public boolean isFormModified() {
        return this.isModified;
    }

    public boolean isFormUsable() {
        return ImmoToolApp.getApplication().getProject().getPlugin("OpenEstate-Contacts") != null;
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    public void load(ContactsEntry contactsEntry) throws ImmoToolException {
        this.selectedContactsEntry = contactsEntry;
        this.isModified = false;
    }

    public void save(ContactsEntry contactsEntry) throws ImmoToolException {
        int n = this.selectedEntryCalendars.size();
        ContactsEntryCalendar[] contactsEntryCalendarArray = this.selectedEntryCalendars.toArray(new ContactsEntryCalendar[n]);
        ContactsEntryCalendar.setContactsEntryCalendars(contactsEntry, contactsEntryCalendarArray);
    }

    public void saveFinished(ContactsEntry contactsEntry) throws ImmoToolException {
    }

    private void showActions(JComponent jComponent, int n, int n2) {
        if (this.resultTable.getSelectedRow() >= 0) {
            this.actionsMenu.show(jComponent, n, n2);
        }
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.refreshButton = new JButton();
        this.addButton = new JButton();
        this.actionButton = new JButton();
        this.resultTableScroller = new JScrollPane();
        this.resultTable = new JXTable();
        this.calendarNotesPanel = new JPanel();
        this.calendarNotesTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.calendarNotesButton = new JButton();
        this.calendarNotesScroller = new JScrollPane();
        this.calendarNotesField = new RTextArea();
        this.titleLabel.setName("titleLabel");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(ContactsEntryCalendarTablePanel.class, (Object)this);
        this.refreshButton.setAction(applicationActionMap.get("doRefresh"));
        this.refreshButton.setName("refreshButton");
        this.addButton.setAction(applicationActionMap.get("doAdd"));
        this.addButton.setName("addButton");
        this.actionButton.setAction(applicationActionMap.get("doAction"));
        this.actionButton.setName("actionButton");
        this.resultTableScroller.setName("resultTableScroller");
        this.resultTable.setColumnControlVisible(true);
        this.resultTable.setName("resultTable");
        this.resultTableScroller.setViewportView((Component)this.resultTable);
        this.calendarNotesPanel.setName("calendarNotesPanel");
        this.calendarNotesTitleLabel.setName("calendarNotesTitleLabel");
        this.calendarNotesButton.setAction(applicationActionMap.get("doSaveNotes"));
        this.calendarNotesButton.setName("calendarNotesButton");
        this.calendarNotesScroller.setName("calendarNotesScroller");
        this.calendarNotesField.setColumns(20);
        this.calendarNotesField.setLineWrap(true);
        this.calendarNotesField.setRows(5);
        this.calendarNotesField.setWrapStyleWord(true);
        this.calendarNotesField.setName("calendarNotesField");
        this.calendarNotesScroller.setViewportView(this.calendarNotesField);
        GroupLayout groupLayout = new GroupLayout(this.calendarNotesPanel);
        this.calendarNotesPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent((Component)this.calendarNotesTitleLabel, -1, 529, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.calendarNotesButton)).addComponent(this.calendarNotesScroller, GroupLayout.Alignment.TRAILING, -1, 590, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.calendarNotesButton).addComponent((Component)this.calendarNotesTitleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.calendarNotesScroller, -2, -1, -2)));
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resultTableScroller, GroupLayout.Alignment.TRAILING, -1, 590, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 401, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton)).addComponent(this.calendarNotesPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.actionButton).addComponent(this.addButton).addComponent(this.refreshButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultTableScroller, -1, 247, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.calendarNotesPanel, -2, -1, -2).addContainerGap()));
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ContactsEntryCalendarTablePanel.class);
        resourceMap.injectComponents((Component)((Object)this));
    }

    private final class TableModel
    extends CalendarEntryTableModel {
        private int descriptionCol = this.getColumnCount();

        public TableModel() {
            this.setColumnCount(this.descriptionCol + 1);
        }

        public void addCalendarEntry(CalendarEntry calendarEntry, String string) {
            this.addCalendarEntry(calendarEntry, string, "");
        }

        public void addCalendarEntry(CalendarEntry calendarEntry, String string, String string2) {
            super.addCalendarEntry(calendarEntry, string);
            this.setDescriptionAt(this.getRowCount() - 1, string2);
        }

        public Class getColumnClass(int n) {
            if (n == this.descriptionCol) {
                return String.class;
            }
            return super.getColumnClass(n);
        }

        public String getColumnName(int n) {
            if (n == this.descriptionCol) {
                return ContactsEntryCalendarTablePanel.this.resourceMap.getString("col.notes", new Object[0]);
            }
            return super.getColumnName(n);
        }

        public String getDescription(int n) {
            return (String)this.getValueAt(n, this.descriptionCol);
        }

        public int getDescriptionCol() {
            return this.descriptionCol;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setCalendarEntry(int n, CalendarEntry calendarEntry, String string) {
            this.setCalendarEntry(n, calendarEntry, string, "");
        }

        public void setCalendarEntry(int n, CalendarEntry calendarEntry, String string, String string2) {
            super.setCalendarEntry(n, calendarEntry, string);
            this.setDescriptionAt(n, string2);
        }

        public void setDescriptionAt(int n, String string) {
            this.setValueAt(string, n, this.descriptionCol);
        }
    }
}

