/*
 * Decompiled with CFR 0.152.
 */
package org.skife.csv;

import java.util.Iterator;

class FieldStreamGenerator
implements Iterator {
    private final CharSequence line;
    private final char[] quotes;
    private final char seperator;
    private final boolean trim;
    private final char escape;
    private int location = 0;
    private char quoteChar = '\u0000';
    private boolean inQuote = false;
    private boolean escapeNext = false;

    FieldStreamGenerator(CharSequence line, char[] quotes, char escape, char seperator, boolean trim) {
        this.line = line;
        this.quotes = quotes;
        this.seperator = seperator;
        this.trim = trim;
        this.escape = escape;
    }

    public boolean hasNext() {
        return this.location < this.line.length();
    }

    public Object next() {
        StringBuffer buffer = new StringBuffer();
        while (this.location < this.line.length() && (this.line.charAt(this.location) != this.seperator || this.inQuote || this.escapeNext)) {
            char c = this.line.charAt(this.location);
            if (this.escapeNext) {
                buffer.append(c);
                this.escapeNext = false;
            } else if (c == this.escape) {
                this.escapeNext = true;
            } else if (this.inQuote) {
                if (c == this.quoteChar) {
                    this.inQuote = false;
                } else {
                    buffer.append(c);
                }
            } else if (this.isQuoteChar(c)) {
                this.inQuote = true;
                this.quoteChar = c;
            } else {
                buffer.append(c);
            }
            ++this.location;
        }
        ++this.location;
        return this.trim ? buffer.toString().trim() : buffer.toString();
    }

    private boolean isQuoteChar(char c) {
        for (int i = 0; i < this.quotes.length; ++i) {
            char quote = this.quotes[i];
            if (c != quote) continue;
            return true;
        }
        return false;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

