/*
 * Decompiled with CFR 0.152.
 */
package org.skife.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.skife.csv.CSVReader;
import org.skife.csv.LineSplitter;
import org.skife.csv.ReaderCallback;

public class SimpleReader
implements CSVReader {
    private LineSplitter splitter = new LineSplitter();
    private String commentToken = null;

    public void parse(String raw, ReaderCallback callback) {
        StringReader reader = new StringReader(raw);
        try {
            this.parse(reader, callback);
        }
        catch (IOException e) {
            throw new RuntimeException("Somehow got an IOException reading from a String!", e);
        }
    }

    public List parse(String raw) {
        StringReader reader = new StringReader(raw);
        try {
            return this.parse(reader);
        }
        catch (IOException e) {
            throw new RuntimeException("Somehow got an IOException reading from a String!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List parse(File in) throws IOException {
        FileInputStream file = new FileInputStream(in);
        try {
            List list = this.parse(file);
            return list;
        }
        finally {
            file.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(File in, ReaderCallback callback) throws IOException {
        FileInputStream file = new FileInputStream(in);
        try {
            this.parse(file, callback);
        }
        finally {
            file.close();
        }
    }

    public List parse(Reader in) throws IOException {
        final ArrayList list = new ArrayList();
        this.parse(in, new ReaderCallback(){

            public void onRow(String[] fields) {
                list.add(fields);
            }
        });
        return list;
    }

    public List parse(InputStream in) throws IOException {
        return this.parse(new InputStreamReader(in));
    }

    public void parse(InputStream in, ReaderCallback callback) throws IOException {
        this.parse(new InputStreamReader(in), callback);
    }

    public void parse(Reader in, ReaderCallback callback) throws IOException {
        BufferedReader reader = new BufferedReader(in);
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (this.commentToken != null && line.startsWith(this.commentToken)) continue;
            callback.onRow(this.splitter.split(line));
        }
    }

    public void setEscapeCharacter(char escape) {
        this.splitter.setEscapeCharacter(escape);
    }

    public void setSeperator(char seperator) {
        this.splitter.setSeperator(seperator);
    }

    public void setQuoteCharacters(char[] quotes) {
        this.splitter.setQuoteCharacters(quotes);
    }

    public void setTrim(boolean b) {
        this.splitter.setTrim(b);
    }

    public void setLineCommentIndicator(String token) {
        this.commentToken = token;
    }
}

