/*
 * Decompiled with CFR 0.152.
 */
package org.skife.csv;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.skife.csv.CSVWriter;
import org.skife.csv.Defaults;
import org.skife.csv.FieldMunger;
import org.skife.csv.WriterCallback;

public class SimpleWriter
implements CSVWriter {
    private char[] newline = Defaults.LINE_SEPERATOR;
    private final Writer out;
    private boolean autoFlush = false;
    private final FieldMunger munger = new FieldMunger();

    public SimpleWriter(Writer out) {
        this.out = out;
    }

    public void append(Object[] fields) throws IOException {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < fields.length; ++i) {
            CharSequence field = this.munger.munge(String.valueOf(fields[i]));
            buffer.append((Object)field);
            if (i >= fields.length - 1) continue;
            buffer.append(this.munger.getSeperator());
        }
        buffer.append(this.newline);
        this.out.write(buffer.toString());
        if (this.autoFlush) {
            this.out.flush();
        }
    }

    public void rawLine(String line) throws IOException {
        this.out.write(line);
        this.out.write(this.newline);
        if (this.autoFlush) {
            this.out.flush();
        }
    }

    public void setSeperator(char seperator) {
        this.munger.setSeperator(seperator);
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public void setNewLine(char c) {
        this.newline = new char[]{c};
    }

    public void setNewLine(char[] c) {
        this.newline = c;
    }

    public void setNewLine(String newline) {
        this.newline = newline.toCharArray();
    }

    public void setQuoteCharacters(char[] quotes) {
        this.munger.setQuotes(quotes);
    }

    public static void write(File file, WriterCallback callback) {
        SimpleWriter.withCallback(file, callback, false);
    }

    public static void append(File file, WriterCallback callback) {
        SimpleWriter.withCallback(file, callback, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void withCallback(File file, WriterCallback callback, boolean append) {
        Writer out = null;
        try {
            try {
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, append)));
                SimpleWriter writer = new SimpleWriter(out);
                callback.withWriter(writer);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception thrown from callback", e);
            }
            Object var6_6 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (out == null) throw throwable;
            try {
                out.flush();
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {}
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        out.flush();
        out.close();
    }
}

