/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.impl.OpenEstateTranslator;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolLanguagePack;
import com.openindex.openestate.tool.ImmoToolPlugin;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.engine.PlugEngine;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class ImmoToolAboutDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolAboutDialog.class);
    private JXHyperlink appDevLinkLabel;
    private JXHyperlink appProjectLinkLabel;
    private JXTitledSeparator appTitleLabel;
    private JXEditorPane authorsField;
    private JScrollPane authorsScrollPane;
    private JXPanel bgPanel;
    private JButton closeButton;
    private JXEditorPane librariesField;
    private JScrollPane librariesScrollPane;
    private JXEditorPane licenseField;
    private JScrollPane licenseScrollPane;
    private JTabbedPane mainTabbedPane;
    private JXEditorPane modulesField;
    private JScrollPane modulesScrollPane;
    private JXEditorPane partnerField;
    private JScrollPane partnerScrollPane;
    private JXEditorPane systemField;
    private JScrollPane systemScrollPane;

    public ImmoToolAboutDialog(Frame frame, boolean bl) throws IOException {
        super(frame, bl);
        this.build();
        this.setLocationRelativeTo(frame);
    }

    private void build() {
        this.initComponents();
        this.getRootPane().setDefaultButton(this.closeButton);
        this.authorsField.setText(ImmoToolAboutDialog.buildAuthorsPage());
        this.authorsField.setCaretPosition(0);
        this.librariesField.setText(ImmoToolAboutDialog.buildLibrariesPage());
        this.librariesField.setCaretPosition(0);
        this.licenseField.setText(ImmoToolAboutDialog.buildLicensePage());
        this.licenseField.setCaretPosition(0);
        this.modulesField.setText(ImmoToolAboutDialog.buildModulesPage());
        this.modulesField.setCaretPosition(0);
        this.systemField.setText(ImmoToolAboutDialog.buildSystemPage());
        this.systemField.setCaretPosition(0);
        this.partnerField.setText(ImmoToolAboutDialog.buildPartnersPage());
        this.partnerField.setCaretPosition(0);
        HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType())) {
                    ImmoToolUtils.openURL(hyperlinkEvent.getURL());
                }
            }
        };
        this.authorsField.addHyperlinkListener(hyperlinkListener);
        this.librariesField.addHyperlinkListener(hyperlinkListener);
        this.licenseField.addHyperlinkListener(hyperlinkListener);
        this.modulesField.addHyperlinkListener(hyperlinkListener);
        this.systemField.addHyperlinkListener(hyperlinkListener);
        this.partnerField.addHyperlinkListener(hyperlinkListener);
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.closeButton.setOpaque(false);
            this.mainTabbedPane.setOpaque(true);
            this.mainTabbedPane.setBorder(BorderFactory.createRaisedBevelBorder());
        }
        ImmoToolUtils.configureDialog(this, this.bgPanel);
    }

    @Action
    public void closeAboutBox() {
        this.dispose();
    }

    /*
     * WARNING - void declaration
     */
    public static String buildAuthorsPage() {
        ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ImmoToolAboutDialog.class);
        try {
            Object object;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            HashMap<String, URL> hashMap = new HashMap<String, URL>();
            for (ImmoToolLanguagePack object52 : ImmoToolLanguagePack.listAvailableLanguagePacks(true).values()) {
                String string = object52.getAuthor();
                if (!treeMap.containsKey(string)) {
                    treeMap.put(string, object52.getLocale().getDisplayLanguage());
                    try {
                        hashMap.put(string, new URL(object52.getWebsite()));
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"invalid translator-website!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                    continue;
                }
                treeMap.put(string, (String)treeMap.get(string) + ", " + object52.getLocale().getDisplayLanguage());
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry : treeMap.entrySet()) {
                object = "-";
                if (hashMap.containsKey(entry.getKey())) {
                    void var8_19;
                    URL uRL = (URL)hashMap.get(entry.getKey());
                    String string = uRL.getHost();
                    if (uRL.getPath().length() > 1) {
                        String string2 = string + uRL.getPath();
                    }
                    object = "<a href=\"" + uRL.toString() + "\">" + (String)var8_19 + "</a>";
                }
                stringBuilder.append("<li>").append((String)entry.getKey()).append(" (").append((String)entry.getValue()).append(")").append("<br>&raquo; ").append((String)object).append("</li>");
            }
            TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
            HashMap<String, URL> hashMap2 = new HashMap<String, URL>();
            for (OpenEstateTranslator openEstateTranslator : OpenEstateUtils.loadTranslatorsByLanguage().values()) {
                String string = openEstateTranslator.getName();
                if (!treeMap2.containsKey(string)) {
                    treeMap2.put(string, openEstateTranslator.getLocale().getDisplayLanguage());
                    try {
                        hashMap2.put(string, new URL(openEstateTranslator.getWebsite()));
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"invalid translator-website!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                    continue;
                }
                treeMap2.put(string, (String)treeMap2.get(string) + ", " + openEstateTranslator.getLocale().getDisplayLanguage());
            }
            object = new StringBuilder();
            for (Map.Entry entry : treeMap2.entrySet()) {
                String string = "-";
                if (hashMap2.containsKey(entry.getKey())) {
                    URL uRL = (URL)hashMap2.get(entry.getKey());
                    String string3 = uRL.getHost();
                    if (uRL.getPath().length() > 1) {
                        string3 = string3 + uRL.getPath();
                    }
                    string = "<a href=\"" + uRL.toString() + "\">" + string3 + "</a>";
                }
                ((StringBuilder)object).append("<li>").append((String)entry.getKey()).append(" (").append((String)entry.getValue()).append(")").append("<br>&raquo; ").append(string).append("</li>");
            }
            String string = ImmoToolAboutDialog.replaceVars(ImmoToolUtils.readApplicationResource(resourceMap.getString("about.authors", new Object[0])), ImmoToolAboutDialog.getHtmlVar("about.authors.title", resourceMap));
            return string.replaceAll("%DEVELOPER%", ImmoToolAboutDialog.getHtmlVar("about.authors.developers", resourceMap)).replaceAll("%DEVELOPER_TXT%", ImmoToolAboutDialog.getHtmlVar("about.authors.developers.text", resourceMap)).replaceAll("%LOGO%", ImmoToolAboutDialog.getHtmlVar("about.authors.logo", resourceMap)).replaceAll("%LOGO_TXT%", ImmoToolAboutDialog.getHtmlVar("about.authors.logo.text", resourceMap)).replaceAll("%ICONS%", ImmoToolAboutDialog.getHtmlVar("about.authors.icons", resourceMap)).replaceAll("%ICONS_TXT%", ImmoToolAboutDialog.getHtmlVar("about.authors.icons.text", resourceMap)).replaceAll("%I18N%", ImmoToolAboutDialog.getHtmlVar("about.authors.translators", resourceMap)).replaceAll("%I18N_IMMOTOOL%", ImmoToolAboutDialog.getHtmlVar("about.authors.translators.immotool", resourceMap)).replaceAll("%I18N_IMMOTOOL_TXT%", ImmoToolAboutDialog.getHtmlVar("about.authors.translators.immotool.text", resourceMap)).replaceAll("%I18N_IMMOTOOL_LIST%", stringBuilder.toString()).replaceAll("%I18N_OPENESTATE%", ImmoToolAboutDialog.getHtmlVar("about.authors.translators.openestate", resourceMap)).replaceAll("%I18N_OPENESTATE_TXT%", ImmoToolAboutDialog.getHtmlVar("about.authors.translators.openestate.text", resourceMap)).replaceAll("%I18N_OPENESTATE_LIST%", ((StringBuilder)object).toString());
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return "<html><h1>ERROR</h1>" + ImmoToolUtils.writeException(exception).replaceAll("\\n", "<br>") + "</html>";
        }
    }

    public static String buildLibrariesPage() {
        ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ImmoToolAboutDialog.class);
        try {
            String string = ImmoToolAboutDialog.replaceVars(ImmoToolUtils.readApplicationResource(resourceMap.getString("about.libraries", new Object[0])), ImmoToolAboutDialog.getHtmlVar("about.libraries.title", resourceMap));
            return string.replaceAll("%DEPENDENCIES%", ImmoToolAboutDialog.getHtmlVar("about.libraries.dependencies", resourceMap)).replaceAll("%DEPENDENCIES_LICENSE%", ImmoToolAboutDialog.getHtmlVar("about.libraries.dependencies.license", resourceMap)).replaceAll("%UTILITIES%", ImmoToolAboutDialog.getHtmlVar("about.libraries.utilities", resourceMap)).replaceAll("%REMARKS%", ImmoToolAboutDialog.getHtmlVar("about.libraries.remarks", resourceMap)).replaceAll("%REMARKS_TEXT%", ImmoToolAboutDialog.getHtmlVar("about.libraries.remarks.text", resourceMap));
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return "<html><h1>ERROR</h1>" + ImmoToolUtils.writeException(exception).replaceAll("\\n", "<br>") + "</html>";
        }
    }

    public static String buildLicensePage() {
        ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ImmoToolAboutDialog.class);
        try {
            String string = ImmoToolAboutDialog.replaceVars(ImmoToolUtils.readApplicationResource(resourceMap.getString("about.license", new Object[0])), ImmoToolAboutDialog.getHtmlVar("about.license.title", resourceMap));
            return string.replaceAll("%NOTES%", ImmoToolAboutDialog.getHtmlVar("about.license.notes", resourceMap)).replaceAll("%NOTES_TEXT%", ImmoToolAboutDialog.getHtmlVar("about.license.notes.text", resourceMap));
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return "<html><h1>ERROR</h1>" + ImmoToolUtils.writeException(exception).replaceAll("\\n", "<br>") + "</html>";
        }
    }

    public static String buildModulesPage() {
        ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ImmoToolAboutDialog.class);
        try {
            StringBuilder stringBuilder = new StringBuilder();
            PlugEngine plugEngine = PlugEngine.getInstance();
            int n = 0;
            for (String string : ImmoToolUtils.getPluginNames()) {
                ImmoToolPlugin immoToolPlugin = ImmoToolUtils.getPlugin(string);
                String string2 = ++n % 2 == 0 ? "bg2" : "bg1";
                stringBuilder.append("<div class=\"").append(string2).append("\" style=\"padding:5px;\">");
                stringBuilder.append("<h3 style=\"margin:0\">").append(immoToolPlugin.getTitle()).append(" v").append(immoToolPlugin.getVersion()).append("</h3>");
                stringBuilder.append("<ul style=\"margin:0;margin-left:30px;margin-top:5px;\">");
                stringBuilder.append("<li>").append(immoToolPlugin.getDescription()).append("</li>");
                stringBuilder.append("<li>").append(ImmoToolAboutDialog.getHtmlVar("about.modules.license", resourceMap)).append(": ").append(immoToolPlugin.getLicense()).append("</li>");
                stringBuilder.append("<li>").append(ImmoToolAboutDialog.getHtmlVar("about.modules.author", resourceMap)).append(": ").append(immoToolPlugin.getAuthor()).append(" &raquo; <a href=\"").append(immoToolPlugin.getWebsite()).append("\">").append(immoToolPlugin.getWebsite()).append("</a></li>");
                if (plugEngine.isEnabled(immoToolPlugin)) {
                    stringBuilder.append("<li>").append("<b>").append(ImmoToolAboutDialog.getHtmlVar("about.modules.isEnabled", resourceMap)).append("</b></li>");
                } else {
                    stringBuilder.append("<li>").append("<b>").append(ImmoToolAboutDialog.getHtmlVar("about.modules.isDisabled", resourceMap)).append("</b></li>");
                }
                stringBuilder.append("</ul>");
                stringBuilder.append("</div>");
            }
            String string = ImmoToolUtils.readApplicationResource(resourceMap.getString("about.modules", new Object[0]));
            return ImmoToolAboutDialog.replaceVars(string, ImmoToolAboutDialog.getHtmlVar("about.modules.title", resourceMap)).replaceAll("%MODULES%", stringBuilder.toString());
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return "<html><h1>ERROR</h1>" + ImmoToolUtils.writeException(exception).replaceAll("\\n", "<br>") + "</html>";
        }
    }

    public static String buildPartnersPage() {
        ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ImmoToolAboutDialog.class);
        try {
            String string = ImmoToolAboutDialog.replaceVars(ImmoToolUtils.readApplicationResource(resourceMap.getString("about.partners", new Object[0])), ImmoToolAboutDialog.getHtmlVar("about.partners.title", resourceMap));
            return string.replaceAll("%YOU%", ImmoToolAboutDialog.getHtmlVar("about.partners.you", resourceMap)).replaceAll("%YOU_TEXT%", ImmoToolAboutDialog.getHtmlVar("about.partners.you.text", resourceMap));
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return "<html><h1>ERROR</h1>" + ImmoToolUtils.writeException(exception).replaceAll("\\n", "<br>") + "</html>";
        }
    }

    public static String buildSystemPage() {
        ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ImmoToolAboutDialog.class);
        try {
            TreeSet<String> treeSet = new TreeSet<String>();
            Object object = System.getProperties().propertyNames();
            while (object.hasMoreElements()) {
                treeSet.add((String)object.nextElement());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("<h3>").append(ImmoToolAboutDialog.getHtmlVar("about.system.environment", resourceMap)).append("</h3>");
            ((StringBuilder)object).append("<ul>");
            for (String string : treeSet) {
                String string2 = System.getProperty(string, "");
                if (string.toLowerCase().contains("path") && string2.contains(SystemUtils.PATH_SEPARATOR)) {
                    string2 = string2.replaceAll(Pattern.quote(SystemUtils.PATH_SEPARATOR), SystemUtils.PATH_SEPARATOR + " ");
                }
                ((StringBuilder)object).append("<li>").append("<b>").append(string).append("</b><br>").append(StringEscapeUtils.escapeHtml((String)string2.trim())).append("</li>");
            }
            ((StringBuilder)object).append("</ul>");
            String string = ImmoToolUtils.readApplicationResource(resourceMap.getString("about.system", new Object[0]));
            return ImmoToolAboutDialog.replaceVars(string, ImmoToolAboutDialog.getHtmlVar("about.system.title", resourceMap)).replace("%SYSTEM%", ((StringBuilder)object).toString());
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return "<html><h1>ERROR</h1>" + ImmoToolUtils.writeException(exception).replaceAll("\\n", "<br>") + "</html>";
        }
    }

    private static String getHtmlVar(String string, ResourceMap resourceMap) {
        return StringEscapeUtils.escapeHtml((String)resourceMap.getString(string, new Object[0]));
    }

    private static String replaceVars(String string, String string2) {
        try {
            String string3 = ImmoToolApp.getApplicationJar().getAbsolutePath();
            if (!SystemUtils.FILE_SEPARATOR.equals("/")) {
                string3 = "/" + string3.replaceAll(Pattern.quote(SystemUtils.FILE_SEPARATOR), "/");
            }
            int n = 0;
            while (string.contains("%BG%")) {
                String string4 = "bg" + (n % 2 + 1);
                string = StringUtils.replaceOnce((String)string, (String)"%BG%", (String)string4);
                ++n;
            }
            return string.replaceAll("%TITLE%", string2 != null ? string2 : "").replaceAll("%OpenEstate-Tool.jar%", string3);
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return "<html><h1>ERROR</h1>" + ImmoToolUtils.writeException(exception).replaceAll("\\n", "<br>") + "</html>";
        }
    }

    private void initComponents() {
        this.bgPanel = new JXPanel();
        this.appTitleLabel = ImmoToolUtils.createHead1Separator("");
        JLabel jLabel = new JLabel();
        this.appProjectLinkLabel = new JXHyperlink();
        this.appDevLinkLabel = new JXHyperlink();
        this.mainTabbedPane = new JTabbedPane();
        this.authorsScrollPane = new JScrollPane();
        this.authorsField = new JXEditorPane();
        this.licenseScrollPane = new JScrollPane();
        this.licenseField = new JXEditorPane();
        this.librariesScrollPane = new JScrollPane();
        this.librariesField = new JXEditorPane();
        this.modulesScrollPane = new JScrollPane();
        this.modulesField = new JXEditorPane();
        this.systemScrollPane = new JScrollPane();
        this.systemField = new JXEditorPane();
        this.partnerScrollPane = new JScrollPane();
        this.partnerField = new JXEditorPane();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ImmoToolAboutDialog.class);
        this.setTitle(resourceMap.getString("title", new Object[0]));
        this.setModal(true);
        this.setName("aboutBox");
        this.bgPanel.setName("bgPanel");
        this.appTitleLabel.setFont(this.appTitleLabel.getFont().deriveFont(20.0f));
        this.appTitleLabel.setIcon(resourceMap.getIcon("appTitleLabel.icon"));
        this.appTitleLabel.setName("appTitleLabel");
        this.appTitleLabel.setTitle(ImmoToolApp.getApplicationTitle() + " " + ImmoToolApp.getApplicationVersion());
        jLabel.setIcon(resourceMap.getIcon("appLogoLabel.icon"));
        jLabel.setName("appLogoLabel");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(ImmoToolAboutDialog.class, (Object)this);
        this.appProjectLinkLabel.setAction(applicationActionMap.get("openProjectWebsite"));
        this.appProjectLinkLabel.setText("http://openestate.org/");
        this.appProjectLinkLabel.setName("appProjectLinkLabel");
        this.appDevLinkLabel.setAction(applicationActionMap.get("openCustomerWebsite"));
        this.appDevLinkLabel.setText("http://dev.openestate.org/");
        this.appDevLinkLabel.setName("appDevLinkLabel");
        this.mainTabbedPane.setName("mainTabbedPane");
        this.authorsScrollPane.setName("authorsScrollPane");
        this.authorsField.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.authorsField.setContentType("text/html");
        this.authorsField.setEditable(false);
        this.authorsField.setName("authorsField");
        this.authorsScrollPane.setViewportView((Component)this.authorsField);
        this.mainTabbedPane.addTab(resourceMap.getString("authorsScrollPane.TabConstraints.tabTitle", new Object[0]), this.authorsScrollPane);
        this.licenseScrollPane.setName("licenseScrollPane");
        this.licenseField.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.licenseField.setContentType("text/html");
        this.licenseField.setEditable(false);
        this.licenseField.setName("licenseField");
        this.licenseScrollPane.setViewportView((Component)this.licenseField);
        this.mainTabbedPane.addTab(resourceMap.getString("licenseScrollPane.TabConstraints.tabTitle", new Object[0]), this.licenseScrollPane);
        this.librariesScrollPane.setName("librariesScrollPane");
        this.librariesField.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.librariesField.setContentType("text/html");
        this.librariesField.setEditable(false);
        this.librariesField.setName("librariesField");
        this.librariesScrollPane.setViewportView((Component)this.librariesField);
        this.mainTabbedPane.addTab(resourceMap.getString("librariesScrollPane.TabConstraints.tabTitle", new Object[0]), this.librariesScrollPane);
        this.modulesScrollPane.setName("modulesScrollPane");
        this.modulesField.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.modulesField.setContentType("text/html");
        this.modulesField.setEditable(false);
        this.modulesField.setName("modulesField");
        this.modulesScrollPane.setViewportView((Component)this.modulesField);
        this.mainTabbedPane.addTab(resourceMap.getString("modulesScrollPane.TabConstraints.tabTitle", new Object[0]), this.modulesScrollPane);
        this.systemScrollPane.setName("systemScrollPane");
        this.systemField.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.systemField.setContentType("text/html");
        this.systemField.setEditable(false);
        this.systemField.setName("systemField");
        this.systemScrollPane.setViewportView((Component)this.systemField);
        this.mainTabbedPane.addTab(resourceMap.getString("systemScrollPane.TabConstraints.tabTitle", new Object[0]), this.systemScrollPane);
        this.partnerScrollPane.setName("partnerScrollPane");
        this.partnerField.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.partnerField.setContentType("text/html");
        this.partnerField.setEditable(false);
        this.partnerField.setName("partnerField");
        this.partnerScrollPane.setViewportView((Component)this.partnerField);
        this.mainTabbedPane.addTab(resourceMap.getString("partnerScrollPane.TabConstraints.tabTitle", new Object[0]), this.partnerScrollPane);
        this.closeButton.setAction(applicationActionMap.get("closeAboutBox"));
        this.closeButton.setName("closeButton");
        GroupLayout groupLayout = new GroupLayout((Container)this.bgPanel);
        this.bgPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.mainTabbedPane, GroupLayout.Alignment.LEADING, -1, 744, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.appDevLinkLabel, -2, -1, -2).addComponent((Component)this.appProjectLinkLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 575, Short.MAX_VALUE).addComponent(this.closeButton)).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.appTitleLabel, -1, 580, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel).addComponent((Component)this.appTitleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mainTabbedPane, -1, 437, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.appProjectLinkLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.appDevLinkLabel, -2, -1, -2)).addComponent(this.closeButton)).addContainerGap()));
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.bgPanel, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.bgPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }
}

