/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.windows.WindowsLookAndFeel;
import com.openindex.openestate.tool.ImmoToolAboutDialog;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolLanguageDialog;
import com.openindex.openestate.tool.ImmoToolLanguagePack;
import com.openindex.openestate.tool.ImmoToolLicenseReminderDialog;
import com.openindex.openestate.tool.ImmoToolPlugin;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolProjectCloseTask;
import com.openindex.openestate.tool.ImmoToolProjectOpenTask;
import com.openindex.openestate.tool.ImmoToolSetupDialog;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUpdateTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.ImmoToolView;
import com.openindex.openestate.tool.ImmoToolWizardDialog;
import com.openindex.openestate.tool.utils.HashGenerator;
import com.openindex.openestate.tool.utils.SSLUtils;
import com.openindex.openestate.tool.utils.SyndicationFeed;
import com.openindex.openestate.tool.utils.TabComponent;
import com.openindex.openestate.tool.utils.engine.PlugEngine;
import com.openindex.openestate.tool.utils.engine.Pluggable;
import eu.medsea.mimeutil.MimeUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.help.HelpSet;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.roydesign.mac.MRJAdapter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.View;
import org.jdesktop.application.session.WindowState;

public class ImmoToolApp
extends SingleFrameApplication {
    public static final String APP_LOG_DIR = new File("logs").getPath();
    public static final String APP_PROJECT_DIR = new File("projects").getPath();
    public static final String APP_RES_PATH = "/com/openindex/openestate/tool/resources/";
    public static final String APP_PROPERTIES = "ImmoTool.properties";
    private static final String APP_PROPERTY_AUTOUPDATE_ADDONS = "AutoUpdate.Addons";
    private static final String APP_PROPERTY_AUTOUPDATE_PROGRAM = "AutoUpdate.Program";
    private static final String APP_PROPERTY_AUTOUPDATE_STAMP = "AutoUpdate.Stamp";
    private static final String APP_PROPERTY_LICENSE_KEY = "License.Key";
    private static final String APP_PROPERTY_LICENSE_HASH = "License.Hash";
    private static final String APP_PROPERTY_LICENSE_REMINDER = "License.Reminder";
    private static final String APP_PROPERTY_PROXY_HTTP_HOST = "Proxy.HTTP.Host";
    private static final String APP_PROPERTY_PROXY_HTTP_PORT = "Proxy.HTTP.Port";
    private static final String APP_PROPERTY_PROXY_FTP_HOST = "Proxy.FTP.Host";
    private static final String APP_PROPERTY_PROXY_FTP_PORT = "Proxy.FTP.Port";
    private static final String APP_PROPERTY_FTP_ACTIVE_HOST = "FTP.ActiveHost";
    private static final String APP_PROPERTY_FTP_ACTIVE_PORTRANGE = "FTP.ActivePortRange";
    private static final String APP_PROPERTY_EXEC_PDF_READER = "Exec.PdfReader";
    private static final String APP_PROPERTY_EXEC_WEB_BROWSER = "Exec.WebBrowser";
    private static SyndicationFeed APP_NEWS = null;
    private static final String APP_NEWS_URL = "http://de.openestate.org/category/immotool/feed/";
    public static final String PROJECT_WEBSITE = "http://openestate.org/";
    public static final String CUSTOMER_WEBSITE = "http://dev.openestate.org/";
    public static final String MEDIA_WEBSITE = "http://media.openestate.org/";
    public static final String USER_PROPERTIES = "user.properties";
    public static final String USER_LAST_STARTUP = "lastStartup";
    public static final String USER_LAST_PROJECT = "lastProject";
    public static final String USER_RECENT_PROJECTS = "recentProject";
    public static final String USER_LANGUAGE_CODE = "languageCode";
    private static final Logger LOGGER = Logger.getLogger(ImmoToolApp.class);
    private static String appTitle;
    private static String appVersion;
    private static int appApiVersion;
    private static boolean appDisableUpdate;
    private static boolean appDefaultLookAndFeel;
    private static boolean appStartWithoutProject;
    private static String appStartWithProject;
    private static Properties appProperties;
    private ImmoToolView appFrameView = null;
    private ResourceMap appResourceMap = null;
    private ImmoToolProject appProject = null;
    private ImmoToolDb appDatabase = null;
    private File appUserDir = null;
    private Properties appUserProperties = null;
    private HelpSet appHelpSet = null;
    private boolean appExitForced = false;

    protected ImmoToolApp() {
    }

    protected void configureWindow(Window window) {
    }

    public void forceExit() {
        this.appExitForced = true;
        this.exit();
    }

    public static ImmoToolApp getApplication() {
        return (ImmoToolApp)Application.getInstance(ImmoToolApp.class);
    }

    public static int getApplicationApiVersion() {
        return appApiVersion;
    }

    public static SyndicationFeed getApplicationFeed() {
        return APP_NEWS;
    }

    public static long getApplicationAutoUpdateStamp() {
        try {
            return Long.valueOf(appProperties.getProperty(APP_PROPERTY_AUTOUPDATE_STAMP, "0"));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"invalid auto-update-stamp!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            appProperties.setProperty(APP_PROPERTY_AUTOUPDATE_STAMP, "0");
            return 0L;
        }
    }

    public static String getApplicationFtpActiveHost() {
        String string = appProperties.getProperty(APP_PROPERTY_FTP_ACTIVE_HOST, "");
        return string != null && string.trim().length() > 0 ? string : null;
    }

    public static String getApplicationFtpActivePortRange() {
        String string = appProperties.getProperty(APP_PROPERTY_FTP_ACTIVE_PORTRANGE, "");
        return string != null && string.trim().length() > 0 ? string : "6000-7000";
    }

    public static String getApplicationFtpProxyHost() {
        String string = appProperties.getProperty(APP_PROPERTY_PROXY_FTP_HOST, "");
        return string != null && string.trim().length() > 0 ? string : null;
    }

    public static Integer getApplicationFtpProxyPort() {
        String string = appProperties.getProperty(APP_PROPERTY_PROXY_FTP_PORT, "");
        try {
            return string != null && string.trim().length() > 0 ? Integer.valueOf(string) : null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"invalid ftp-proxy-port!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public static String getApplicationHttpProxyHost() {
        String string = appProperties.getProperty(APP_PROPERTY_PROXY_HTTP_HOST, "");
        return string != null && string.trim().length() > 0 ? string : null;
    }

    public static Integer getApplicationHttpProxyPort() {
        String string = appProperties.getProperty(APP_PROPERTY_PROXY_HTTP_PORT, "");
        try {
            return string != null && string.trim().length() > 0 ? Integer.valueOf(string) : null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"invalid http-proxy-port!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public static String getApplicationLicenseKey() {
        String string = appProperties.getProperty(APP_PROPERTY_LICENSE_KEY, "");
        if (string.trim().length() == 0) {
            return "";
        }
        try {
            String string2 = HashGenerator.messageDigestAsString(string, "SHA");
            if (!string2.equals(appProperties.getProperty(APP_PROPERTY_LICENSE_HASH, ""))) {
                throw new Exception("invalid license-hash!");
            }
            return string;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"invalid license!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            appProperties.setProperty(APP_PROPERTY_LICENSE_KEY, "");
            appProperties.setProperty(APP_PROPERTY_LICENSE_HASH, "");
            return "";
        }
    }

    public static long getApplicationLicenseRemindStamp() {
        try {
            return Long.valueOf(appProperties.getProperty(APP_PROPERTY_LICENSE_REMINDER, "0"));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"invalid license-remind-stamp!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            appProperties.setProperty(APP_PROPERTY_LICENSE_REMINDER, "0");
            return 0L;
        }
    }

    @Deprecated
    public static String getApplicationName() {
        return ImmoToolApp.getApplicationTitle();
    }

    public static String getApplicationPathToPdfReader() {
        String string = appProperties.getProperty(APP_PROPERTY_EXEC_PDF_READER, "").trim();
        return string.length() > 0 ? string : null;
    }

    public static String getApplicationPathToWebBrowser() {
        String string = appProperties.getProperty(APP_PROPERTY_EXEC_WEB_BROWSER, "").trim();
        return string.length() > 0 ? string : null;
    }

    public static Properties getApplicationProperties() {
        return appProperties;
    }

    public ResourceMap getApplicationResources() {
        return this.appResourceMap;
    }

    public static File getApplicationJar() {
        return ImmoToolApp.isApplicationStartedFromMacApp() ? ImmoToolApp.getApplicationJarForMacApp() : new File("OpenEstate-Tool.jar");
    }

    public static File getApplicationJarForMacApp() {
        return new File("ImmoTool.app" + File.separator + "Contents" + File.separator + "Resources" + File.separator + "Java" + File.separator + "OpenEstate-Tool.jar");
    }

    public static String getApplicationTitle() {
        return appTitle;
    }

    public static String getApplicationVersion() {
        return appVersion;
    }

    public ImmoToolDb getDatabase() {
        return this.appDatabase;
    }

    public ImmoToolView getFrameView() {
        return this.appFrameView;
    }

    public HelpSet getHelpSet() {
        return this.appHelpSet;
    }

    public ImmoToolProject getProject() {
        return this.appProject;
    }

    public Properties getUserProperties() {
        return this.appUserProperties;
    }

    public static boolean isApplicationAutoUpdateAddons() {
        return appProperties.getProperty(APP_PROPERTY_AUTOUPDATE_ADDONS, "1").equals("1");
    }

    public static boolean isApplicationBetaVersion() {
        return appVersion == null || appVersion.toLowerCase().contains("beta");
    }

    public static boolean isApplicationAutoUpdateProgram() {
        return appProperties.getProperty(APP_PROPERTY_AUTOUPDATE_PROGRAM, "1").equals("1");
    }

    public static boolean isApplicationStartedFromMacApp() {
        return SystemUtils.IS_OS_MAC_OSX && ImmoToolApp.getApplicationJarForMacApp().isFile();
    }

    public static boolean isApplicationUpdateDisabled() {
        return appDisableUpdate;
    }

    public void loadHelpSet() {
        LOGGER.info((Object)"init help-system...");
        this.appHelpSet = new HelpSet();
        try {
            URL uRL = ((Object)((Object)this)).getClass().getResource("/com/openindex/openestate/tool/resources/help/help.hs");
            this.appHelpSet = new HelpSet(null, uRL);
            for (String string : ImmoToolUtils.getPluginNames()) {
                try {
                    HelpSet helpSet = ImmoToolUtils.getPlugin(string).createHelpSet();
                    if (helpSet == null) continue;
                    LOGGER.info((Object)("> add " + string));
                    this.appHelpSet.add(helpSet);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not load plugin-helpset!");
                    LOGGER.warn((Object)exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load HelpSet!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    public void loadProject(ImmoToolProject immoToolProject, ImmoToolTask.Callback callback) throws ImmoToolException {
        ImmoToolDb immoToolDb = ImmoToolDb.createInstance(immoToolProject);
        immoToolDb.configure(immoToolProject);
        this.loadProject(immoToolProject, immoToolDb, callback);
    }

    public void loadProject(ImmoToolProject immoToolProject, ImmoToolDb immoToolDb, ImmoToolTask.Callback callback) throws ImmoToolException {
        try {
            this.appProject = immoToolProject;
            this.appDatabase = immoToolDb;
            for (Pluggable pluggable : PlugEngine.getInstance().getAllPluggables()) {
                boolean bl = this.appProject.getPlugin(pluggable.getName()) != null;
                PlugEngine.getInstance().setEnabled(pluggable, bl);
                if (!bl) continue;
                PlugEngine.getInstance().startPluggable(pluggable);
                ((ImmoToolPlugin)pluggable).load();
            }
            if (!this.appDatabase.isOpen()) {
                this.appDatabase.open();
                this.appDatabase.init(immoToolProject, callback);
            }
            this.appUserProperties.setProperty(USER_LAST_PROJECT, this.appProject.getDirectory().getAbsolutePath());
            try {
                Pluggable pluggable;
                HttpClient httpClient = ImmoToolUtils.createHttpClient();
                ImmoToolApp.setApplicationFeed(new SyndicationFeed(this.appResourceMap.getString("newsFeed.title", new Object[0]), new URL(APP_NEWS_URL)));
                pluggable = APP_NEWS.loadSyndFeedExternal(httpClient, true);
                if (pluggable == null) {
                    throw new Exception("Can't load syndication-feed: " + APP_NEWS.getUrl().toString());
                }
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Can't load immotool-news-feed!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            if (this.appFrameView != null) {
                this.appFrameView.loadProject(this.appProject);
            }
        }
        catch (Exception exception) {
            this.appProject = null;
            this.appDatabase = null;
            if (exception instanceof ImmoToolException) {
                throw (ImmoToolException)exception;
            }
            throw new ImmoToolDbException(exception.getLocalizedMessage(), exception);
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        CommandLine commandLine = null;
        Options options = new Options();
        options.addOption("help", false, "print this message and exit the application");
        options.addOption("noUpdate", false, "disable application updates");
        options.addOption("defaultLookAndFeel", false, "use the system default look & feel");
        options.addOption("noProject", false, "start the application without opening a project");
        options.addOption("project", true, "start the application with the specified project");
        try {
            object = new GnuParser();
            commandLine = object.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            System.out.println("Can't parse the command line!");
            System.out.println("> Reason: " + parseException.getLocalizedMessage());
            ImmoToolApp.printUsage(options);
            System.exit(1);
        }
        if (commandLine.hasOption("help")) {
            ImmoToolApp.printUsage(options);
            System.exit(0);
        }
        DOMConfigurator.configure((URL)ImmoToolApp.class.getResource("/com/openindex/openestate/tool/resources/log4j.xml"));
        object = new File(APP_LOG_DIR);
        if (!((File)object).exists() && !((File)object).mkdirs()) {
            LOGGER.error((Object)"Can't create log directory!");
            LOGGER.error((Object)("> " + ((File)object).getPath()));
            System.exit(1);
        } else if (!((File)object).isDirectory()) {
            LOGGER.error((Object)"The log directory is invalid!");
            LOGGER.error((Object)("> " + ((File)object).getPath()));
            System.exit(1);
        } else if (!((File)object).canWrite()) {
            LOGGER.error((Object)"The log directory is not writable!");
            LOGGER.error((Object)("> " + ((File)object).getPath()));
            System.exit(1);
        }
        try {
            System.setErr(new PrintStream(new OutputStream(){
                private StringBuilder _output = new StringBuilder();
                private static final int CR = 13;
                private static final int LF = 10;

                @Override
                public void write(int n) throws IOException {
                    if (n != 13 && n != 10) {
                        this._output.append((char)n);
                    } else if (n == 10) {
                        LOGGER.fatal((Object)this._output.toString());
                        this._output.delete(0, this._output.length());
                    }
                }
            }));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't initialize error logging!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        Locale locale = Locale.getDefault();
        TimeZone timeZone = TimeZone.getDefault();
        Charset charset = Charset.defaultCharset();
        LOGGER.info((Object)"----------------------------------------------------------");
        LOGGER.info((Object)"System information");
        LOGGER.info((Object)"----------------------------------------------------------");
        LOGGER.info((Object)("> java     : " + SystemUtils.JAVA_VERSION + " (" + SystemUtils.JAVA_RUNTIME_NAME + ")"));
        LOGGER.info((Object)("> system   : " + SystemUtils.OS_NAME + " " + SystemUtils.OS_VERSION + " (" + SystemUtils.OS_ARCH + ")"));
        LOGGER.info((Object)("> user     : " + SystemUtils.USER_NAME));
        LOGGER.info((Object)("> user dir : " + SystemUtils.USER_HOME));
        LOGGER.info((Object)("> base dir : " + SystemUtils.USER_DIR));
        LOGGER.info((Object)("> language : " + locale.getDisplayName() + " (" + locale.toString() + ")"));
        LOGGER.info((Object)("> timezone : " + timeZone.getDisplayName() + " (" + timeZone.getID() + ")"));
        LOGGER.info((Object)("> charset  : " + charset.name()));
        LOGGER.info((Object)"----------------------------------------------------------");
        Locale.setDefault(Locale.GERMAN);
        appDisableUpdate = commandLine.hasOption("noUpdate");
        appDefaultLookAndFeel = commandLine.hasOption("defaultLookAndFeel");
        appStartWithProject = null;
        appStartWithoutProject = commandLine.hasOption("noProject");
        if (!appStartWithoutProject && commandLine.hasOption("project")) {
            File file = new File(commandLine.getOptionValue("project"));
            if (!ImmoToolProject.isValidProjectDirectory(file)) {
                appStartWithProject = null;
                appStartWithoutProject = true;
                LOGGER.warn((Object)"The requested project is invalid!");
                LOGGER.warn((Object)("> Path: " + file.getAbsolutePath()));
                LOGGER.warn((Object)"> Starting the application without a project.");
            } else {
                appStartWithProject = file.getAbsolutePath();
            }
        }
        CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.validation.relaxed", (boolean)true);
        System.setProperty("net.fortuna.ical4j.timezone.date.floating", "true");
        MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.MagicMimeMimeDetector");
        if (SystemUtils.IS_OS_WINDOWS) {
            MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.WindowsRegistryMimeDetector");
        }
        MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.ExtensionMimeDetector");
        if (SystemUtils.IS_OS_MAC_OSX) {
            MRJAdapter.addAboutListener((ActionListener)new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ImmoToolAboutDialog immoToolAboutDialog = new ImmoToolAboutDialog((Frame)(ImmoToolApp.getApplication() != null ? ImmoToolApp.getApplication().getMainFrame() : null), true);
                        immoToolAboutDialog.setVisible(true);
                    }
                    catch (Exception exception) {
                        LOGGER.error((Object)"could not load about-box!");
                        LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                }
            });
            MRJAdapter.addPreferencesListener((ActionListener)new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        new ImmoToolTask<ImmoToolSetupDialog>(){

                            @Override
                            protected ImmoToolSetupDialog executeTask() throws Exception {
                                return new ImmoToolSetupDialog();
                            }

                            @Override
                            protected void succeeded(ImmoToolSetupDialog immoToolSetupDialog) {
                                super.succeeded(immoToolSetupDialog);
                                immoToolSetupDialog.setVisible(true);
                                if (immoToolSetupDialog.getStatus() == 2 && ImmoToolApp.getApplication() != null) {
                                    ImmoToolApp.getApplication().saveSettings();
                                }
                            }
                        }.execute();
                    }
                    catch (Exception exception) {
                        LOGGER.error((Object)"could not show preferences-dialog!");
                        LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                }
            });
            MRJAdapter.addQuitApplicationListener((ActionListener)new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ImmoToolApp immoToolApp = ImmoToolApp.getApplication();
                    if (immoToolApp != null) {
                        immoToolApp.forceExit();
                        return;
                    }
                }
            });
        }
        try {
            if (!appDefaultLookAndFeel && SystemUtils.IS_OS_WINDOWS) {
                UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
            } else if (!appDefaultLookAndFeel && SystemUtils.IS_OS_MAC_OSX) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                System.setProperty("apple.laf.useScreenMenuBar", "true");
            } else {
                UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
                ToolTipManager.sharedInstance().setInitialDelay(500);
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load look & feel!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        try {
            SSLUtils.trustAllHttpsCertificates();
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load SSL trustmanager!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        ImmoToolApp.launch(ImmoToolApp.class, (String[])stringArray);
    }

    @Action
    public void openCustomerWebsite() {
        ImmoToolUtils.openURL(CUSTOMER_WEBSITE);
    }

    @Action
    public void openProjectWebsite() {
        ImmoToolUtils.openURL(PROJECT_WEBSITE);
    }

    private static void printUsage(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("ImmoTool.exe / ImmoTool.bat / ImmoTool.sh", "------------------------------------------------------------------------" + SystemUtils.LINE_SEPARATOR + "This application launches OpenEstate-ImmoTool." + SystemUtils.LINE_SEPARATOR + "Use the following arguments to change the programs default behaviour." + SystemUtils.LINE_SEPARATOR + "------------------------------------------------------------------------", options, "------------------------------------------------------------------------" + SystemUtils.LINE_SEPARATOR + "\u00a92009-2010 OpenEstate.org" + SystemUtils.LINE_SEPARATOR + "This application was developed as a part of the OpenEstate-Project." + SystemUtils.LINE_SEPARATOR + "Check our website for further information: http://openestate.org" + SystemUtils.LINE_SEPARATOR + "------------------------------------------------------------------------");
    }

    @Deprecated
    public boolean removePanel(String string) {
        return ImmoToolUtils.removePanel(string);
    }

    @Deprecated
    public boolean removePanel(String string, boolean bl) {
        return ImmoToolUtils.removePanel(string, bl);
    }

    public void saveSettings() {
        try {
            this.saveAppSettings();
            this.saveUserSettings();
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't save settings!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAppSettings() throws IOException {
        if (appProperties == null) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(APP_PROPERTIES);
            appProperties.store(fileOutputStream, "application-properties");
            fileOutputStream.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserSettings() throws IOException {
        if (this.appUserProperties == null || this.appUserDir == null) {
            return;
        }
        if (!this.appUserDir.exists() && !this.appUserDir.mkdirs()) {
            throw new IOException("Can't create user storage directory: " + this.appUserDir.getAbsolutePath());
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.appUserDir.getAbsolutePath() + File.separator + USER_PROPERTIES);
            this.appUserProperties.store(fileOutputStream, "user-properties");
            fileOutputStream.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    @Deprecated
    public boolean selectPanel(String string) {
        return ImmoToolUtils.selectPanel(string);
    }

    public static void setApplicationAutoUpdateAddons(boolean bl) {
        appProperties.setProperty(APP_PROPERTY_AUTOUPDATE_ADDONS, bl ? "1" : "0");
    }

    public static void setApplicationAutoUpdateProgram(boolean bl) {
        appProperties.setProperty(APP_PROPERTY_AUTOUPDATE_PROGRAM, bl ? "1" : "0");
    }

    public static void setApplicationAutoUpdateStamp(Date date) {
        ImmoToolApp.setApplicationAutoUpdateStamp(date != null ? date.getTime() : -1L);
    }

    public static void setApplicationAutoUpdateStamp(long l) {
        appProperties.setProperty(APP_PROPERTY_AUTOUPDATE_STAMP, l > 0L ? String.valueOf(l) : "0");
    }

    public static void setApplicationLicenseKey(String string) throws NoSuchAlgorithmException, IOException {
        String string2 = StringUtils.isEmpty((String)string) ? "" : HashGenerator.messageDigestAsString(string.trim(), "SHA");
        appProperties.setProperty(APP_PROPERTY_LICENSE_KEY, string != null ? string.trim() : "");
        appProperties.setProperty(APP_PROPERTY_LICENSE_HASH, string2 != null ? string2 : "");
    }

    public static void setApplicationLicenseRemindStamp(Date date) {
        ImmoToolApp.setApplicationLicenseRemindStamp(date != null ? date.getTime() : -1L);
    }

    public static void setApplicationLicenseRemindStamp(long l) {
        appProperties.setProperty(APP_PROPERTY_LICENSE_REMINDER, l > -2L ? String.valueOf(l) : "0");
    }

    public static void setApplicationFtpActive(String string, String string2) {
        appProperties.setProperty(APP_PROPERTY_FTP_ACTIVE_HOST, string != null ? string : "");
        appProperties.setProperty(APP_PROPERTY_FTP_ACTIVE_PORTRANGE, string2 != null ? string2 : "");
        if (string != null && string.trim().length() > 0) {
            System.setProperty("ftp4j.activeDataTransfer.hostAddress", string);
        } else {
            System.getProperties().remove("ftp4j.activeDataTransfer.hostAddress");
        }
        if (string2 != null && string2.trim().length() > 0) {
            System.setProperty("ftp4j.activeDataTransfer.portRange", string2);
        } else {
            System.getProperties().remove("ftp4j.activeDataTransfer.portRange");
        }
    }

    public static void setApplicationFtpProxy(String string, Integer n) {
        if (string == null || n == null || n <= 0) {
            appProperties.setProperty(APP_PROPERTY_PROXY_FTP_HOST, "");
            appProperties.setProperty(APP_PROPERTY_PROXY_FTP_PORT, "");
            System.getProperties().setProperty("ftp.proxySet", "false");
            if (System.getProperties().containsKey("ftp.proxyHost")) {
                System.getProperties().remove("ftp.proxyHost");
            }
            if (System.getProperties().containsKey("ftp.proxyPort")) {
                System.getProperties().remove("ftp.proxyPort");
            }
            if (System.getProperties().containsKey("socksProxyHost")) {
                System.getProperties().remove("socksProxyHost");
            }
            if (System.getProperties().containsKey("socksProxyPort")) {
                System.getProperties().remove("socksProxyPort");
            }
        } else {
            appProperties.setProperty(APP_PROPERTY_PROXY_FTP_HOST, string);
            appProperties.setProperty(APP_PROPERTY_PROXY_FTP_PORT, n.toString());
            System.getProperties().setProperty("ftp.proxySet", "true");
            System.getProperties().setProperty("ftp.proxyHost", string);
            System.getProperties().setProperty("ftp.proxyPort", n.toString());
            System.getProperties().setProperty("socksProxyHost", string);
            System.getProperties().setProperty("socksProxyPort", n.toString());
        }
    }

    public static void setApplicationHttpProxy(String string, Integer n) {
        if (string == null || n == null || n <= 0) {
            appProperties.setProperty(APP_PROPERTY_PROXY_HTTP_HOST, "");
            appProperties.setProperty(APP_PROPERTY_PROXY_HTTP_PORT, "");
            System.getProperties().setProperty("http.proxySet", "false");
            if (System.getProperties().containsKey("http.proxyHost")) {
                System.getProperties().remove("http.proxyHost");
            }
            if (System.getProperties().containsKey("http.proxyPort")) {
                System.getProperties().remove("http.proxyPort");
            }
        } else {
            appProperties.setProperty(APP_PROPERTY_PROXY_HTTP_HOST, string);
            appProperties.setProperty(APP_PROPERTY_PROXY_HTTP_PORT, n.toString());
            System.getProperties().setProperty("http.proxySet", "true");
            System.getProperties().setProperty("http.proxyHost", string);
            System.getProperties().setProperty("http.proxyPort", n.toString());
        }
    }

    public static synchronized void setApplicationFeed(SyndicationFeed syndicationFeed) {
        APP_NEWS = syndicationFeed;
    }

    public static void setApplicationPathToPdfReader(String string) {
        if (string == null) {
            if (appProperties.containsKey(APP_PROPERTY_EXEC_PDF_READER)) {
                appProperties.remove(APP_PROPERTY_EXEC_PDF_READER);
            }
        } else {
            appProperties.setProperty(APP_PROPERTY_EXEC_PDF_READER, string);
        }
    }

    public static void setApplicationPathToWebBrowser(String string) {
        if (string == null) {
            if (appProperties.containsKey(APP_PROPERTY_EXEC_WEB_BROWSER)) {
                appProperties.remove(APP_PROPERTY_EXEC_WEB_BROWSER);
            }
        } else {
            appProperties.setProperty(APP_PROPERTY_EXEC_WEB_BROWSER, string);
        }
    }

    @Deprecated
    public void showPanel(TabComponent tabComponent) {
        ImmoToolUtils.showPanel(tabComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startup() {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        boolean bl;
        Calendar calendar;
        block54: {
            Application.ExitListener exitListener = new Application.ExitListener(){

                public boolean canExit(EventObject eventObject) {
                    if (ImmoToolApp.this.appExitForced) {
                        return true;
                    }
                    return ImmoToolUtils.showQuestionDialog(ImmoToolApp.this.appResourceMap.getString("question.quitProgram", new Object[0]), ImmoToolApp.this.getMainFrame());
                }

                public void willExit(EventObject eventObject) {
                    if (ImmoToolApp.this.appProject != null) {
                        ImmoToolTaskDialog.execute(new ImmoToolProjectCloseTask());
                    }
                    ImmoToolApp.this.saveSettings();
                }
            };
            this.addExitListener(exitListener);
            calendar = Calendar.getInstance();
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            bl = false;
            this.appResourceMap = this.getContext().getResourceMap(ImmoToolApp.class);
            appTitle = this.appResourceMap.getString("Application.title", new Object[0]);
            appVersion = this.appResourceMap.getString("Application.version", new Object[0]);
            appApiVersion = this.appResourceMap.getInteger("Application.apiVersion");
            LOGGER.info((Object)("Launching " + appTitle + " " + appVersion + " (API #" + appApiVersion + ")..."));
            LOGGER.info((Object)"----------------------------------------------------------");
            this.appUserDir = this.getContext().getLocalStorage().getDirectory();
            System.setProperty("http.agent", appTitle + "/" + appVersion);
            appProperties = new Properties();
            try {
                object7 = new File(APP_PROPERTIES);
                if (!((File)object7).exists() && !((File)object7).createNewFile()) {
                    LOGGER.warn((Object)"could not create application-properties!");
                }
                if (((File)object7).exists()) {
                    object6 = null;
                    try {
                        object6 = new FileInputStream((File)object7);
                        appProperties.load((InputStream)object6);
                    }
                    finally {
                        if (object6 != null) {
                            ((FileInputStream)object6).close();
                        }
                    }
                }
                ImmoToolApp.setApplicationFtpActive(ImmoToolApp.getApplicationFtpActiveHost(), ImmoToolApp.getApplicationFtpActivePortRange());
                ImmoToolApp.setApplicationFtpProxy(ImmoToolApp.getApplicationFtpProxyHost(), ImmoToolApp.getApplicationFtpProxyPort());
                ImmoToolApp.setApplicationHttpProxy(ImmoToolApp.getApplicationHttpProxyHost(), ImmoToolApp.getApplicationHttpProxyPort());
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Can't load application properties!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            this.appUserProperties = new Properties();
            try {
                object7 = new File(this.appUserDir.getAbsolutePath() + File.separator + USER_PROPERTIES);
                if (!((File)object7).isFile()) break block54;
                object6 = null;
                try {
                    object6 = new FileInputStream((File)object7);
                    this.appUserProperties.load((InputStream)object6);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Can't load user.properties!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)object6);
                }
            }
            catch (Exception exception) {
                LOGGER.error((Object)"could not load user.properties!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        try {
            PlugEngine.getInstance().setCurrentVersion(appApiVersion);
            object7 = new File("plugins.xml");
            if (!((File)object7).exists()) {
                LOGGER.info((Object)"install plugin-engine");
                object6 = new File("plugins");
                if (!((File)object6).isDirectory() && !((File)object6).mkdirs()) {
                    throw new Exception("could not create plugin-directory!");
                }
                object5 = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.toLowerCase().endsWith(".xml");
                    }
                };
                object4 = ImmoToolUtils.createHttpClient();
                for (File file : ((File)object6).listFiles((FilenameFilter)object5)) {
                    LOGGER.info((Object)("> automatic installation: " + file.getName()));
                    PlugEngine.getInstance().installOrUpdate((HttpClient)object4, file.toURI());
                }
            } else {
                LOGGER.info((Object)"init plugin-engine");
                PlugEngine.getInstance().init(new Object[0]);
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load plugin-engine!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            System.exit(1);
        }
        object7 = this.appUserProperties.getProperty(USER_LANGUAGE_CODE);
        object6 = null;
        if (!StringUtils.isEmpty((String)object7)) {
            object5 = ImmoToolLanguagePack.listAvailableLanguagePacks();
            object4 = object5.values().iterator();
            while (object4.hasNext()) {
                object3 = (ImmoToolLanguagePack)object4.next();
                if (!((String)object7).equals(((ImmoToolLanguagePack)object3).getLocale().toString())) continue;
                LOGGER.info((Object)("select language: " + ((ImmoToolLanguagePack)object3).getLocale().toString()));
                object6 = object3;
                ImmoToolUtils.setLocale(((ImmoToolLanguagePack)object3).getLocale());
                break;
            }
        }
        if (object6 == null) {
            LOGGER.info((Object)"no language selected");
            object5 = new ImmoToolLanguageDialog();
            ((Dialog)object5).setVisible(true);
            if (((ImmoToolLanguageDialog)object5).getStatus() == 2) {
                LOGGER.info((Object)("selected language: " + Locale.getDefault().toString()));
                bl = true;
                this.appUserProperties.setProperty(USER_LANGUAGE_CODE, Locale.getDefault().getLanguage());
            }
        }
        this.appResourceMap = this.getContext().getResourceMap(ImmoToolApp.class);
        appTitle = this.appResourceMap.getString("Application.title", new Object[0]);
        LOGGER.debug((Object)"init main-window");
        this.appFrameView = new ImmoToolView(this);
        object5 = this.getContext().getSessionStorage().getProperty((Component)this.appFrameView.getFrame());
        if (object5 != null && (object4 = object5.getSessionState((Component)this.appFrameView.getFrame())) instanceof WindowState) {
            object3 = (WindowState)object4;
            if (object3.getBounds().width < 100) {
                object3.getBounds().setSize(this.appFrameView.getFrame().getMinimumSize().width, object3.getBounds().height);
            }
            if (object3.getBounds().height < 100) {
                object3.getBounds().setSize(object3.getBounds().width, this.appFrameView.getFrame().getMinimumSize().height);
            }
        }
        this.loadHelpSet();
        object4 = ImmoToolApp.getApplicationLicenseKey();
        long l = ImmoToolApp.getApplicationLicenseRemindStamp();
        if ((object4 == null || ((String)object4).trim().length() == 0) && l > -1L && l <= System.currentTimeMillis()) {
            ImmoToolLicenseReminderDialog immoToolLicenseReminderDialog = new ImmoToolLicenseReminderDialog();
            immoToolLicenseReminderDialog.setVisible(true);
            int n = immoToolLicenseReminderDialog.getStatus();
            if (n == 3 || n == 2) {
                bl = true;
            }
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(Long.valueOf(this.appUserProperties.getProperty(USER_LAST_STARTUP, "0")));
        if (calendar2.before(calendar)) {
            try {
                URL uRL = new URL("http://dev.openestate.org/repository-update/ImmoTool-0.9/");
                object2 = ImmoToolUtils.createHttpClient();
                object = object2.execute((HttpUriRequest)new HttpGet(ImmoToolUtils.toIdnUrl(uRL).toURI()));
                if (object.getStatusLine().getStatusCode() == 200) {
                    this.appUserProperties.setProperty(USER_LAST_STARTUP, String.valueOf(System.currentTimeMillis()));
                }
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Can't log application startup!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        if (ImmoToolApp.isApplicationAutoUpdateProgram() && !ImmoToolApp.isApplicationBetaVersion() && !ImmoToolApp.isApplicationUpdateDisabled()) {
            Calendar calendar3 = Calendar.getInstance();
            calendar3.setTimeInMillis(ImmoToolApp.getApplicationAutoUpdateStamp());
            if (calendar3.before(calendar)) {
                LOGGER.info((Object)"check for updates");
                object2 = new ImmoToolUpdateTask(true, ImmoToolApp.isApplicationAutoUpdateAddons()){

                    @Override
                    protected void finished() {
                        super.finished();
                    }

                    @Override
                    protected void succeeded(Boolean bl) {
                        if (Boolean.TRUE.equals(bl)) {
                            LOGGER.info((Object)"> updates have been installed");
                            LOGGER.info((Object)"> shutdown application");
                        }
                        ImmoToolApp.setApplicationAutoUpdateStamp(System.currentTimeMillis());
                        super.succeeded(bl);
                    }
                };
                try {
                    object = new ImmoToolTaskDialog();
                    ((ImmoToolTaskDialog)object).addTask((ImmoToolTask)((Object)object2));
                    ((ImmoToolTaskDialog)object).execute();
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"update-error!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        }
        ImmoToolTask immoToolTask = null;
        if (!appStartWithoutProject) {
            String string = object2 = appStartWithProject != null ? appStartWithProject : this.appUserProperties.getProperty(USER_LAST_PROJECT);
            if (object2 != null) {
                boolean bl2 = false;
                serializable = new File((String)object2);
                if (!((File)serializable).isDirectory()) {
                    ImmoToolUtils.showMessageWarningDialog(this.appResourceMap.getString("warning.lastProjectNotFound", new Object[]{((File)serializable).getAbsolutePath()}));
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    try {
                        LOGGER.info((Object)"opening last used project");
                        LOGGER.info((Object)("> " + (String)object2));
                        immoToolTask = new ImmoToolProjectOpenTask((File)serializable);
                    }
                    catch (Exception exception) {
                        object2 = null;
                        LOGGER.error((Object)"could not open project!");
                        LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                        ImmoToolUtils.showMessageErrorDialog(this.appResourceMap.getString("error.cantOpenProject", new Object[0]), exception);
                    }
                }
            }
        }
        try {
            LOGGER.info((Object)"save user settings");
            this.saveUserSettings();
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't update user settings!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        boolean bl3 = false;
        while (!bl3) {
            boolean bl4 = false;
            if (immoToolTask == null) {
                bl4 = true;
                immoToolTask = this.startupWizard();
            }
            serializable = new ImmoToolTaskDialog(null, true);
            ((ImmoToolTaskDialog)serializable).addTask(immoToolTask);
            ((ImmoToolTaskDialog)serializable).execute();
            if (((ImmoToolTaskDialog)serializable).wasSuccessful()) {
                if (bl4) {
                    bl = true;
                }
                LOGGER.info((Object)"project opened successfully.");
                break;
            }
            boolean bl5 = ImmoToolUtils.showQuestionDialog(this.appResourceMap.getString("question.createNewProjectAfterError", new Object[0]));
            if (!bl5) {
                LOGGER.info((Object)"opening project was cancelled by user.");
                System.exit(0);
            }
            immoToolTask = null;
        }
        if (bl) {
            this.saveSettings();
        }
        this.show((View)this.appFrameView);
    }

    private ImmoToolTask startupWizard() {
        File file = new File(APP_PROJECT_DIR);
        if (!file.exists() && !file.mkdirs()) {
            LOGGER.error((Object)"could not create project-directory!");
            LOGGER.error((Object)("> " + file.getPath()));
            System.exit(1);
        }
        ImmoToolWizardDialog immoToolWizardDialog = new ImmoToolWizardDialog(null);
        immoToolWizardDialog.setVisible(true);
        ImmoToolTask immoToolTask = immoToolWizardDialog.getProjectTask();
        if (immoToolWizardDialog.getStatus() == 2 && immoToolTask != null) {
            return immoToolTask;
        }
        if (immoToolWizardDialog.getStatus() == 3 && immoToolTask != null) {
            return immoToolTask;
        }
        System.exit(0);
        return null;
    }

    public void unloadProject() {
        this.appFrameView.unloadProject();
        try {
            if (this.appDatabase != null) {
                this.appDatabase.close();
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not close database!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        try {
            if (this.appProject != null) {
                this.appProject.save();
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not save project!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.appProject = null;
        this.appDatabase = null;
    }

    static {
        appApiVersion = 0;
        appDisableUpdate = false;
        appDefaultLookAndFeel = false;
        appStartWithoutProject = false;
        appStartWithProject = null;
        appProperties = null;
    }
}

