/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolPluginException;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.exist.xmldb.CollectionManagementServiceImpl;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.IndexQueryService;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class ImmoToolDb {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolDb.class);
    public static final String DB_APP_PATH = "ImmoTool";
    public static final String DB_COLLECTION_TEMP = "/temp";
    public static final String DB_DEFAULT_CATALOG = "/com/openindex/openestate/tool/resources/db-catalog.xml";
    public static final String DB_DEFAULT_CONF = "/com/openindex/openestate/tool/resources/db-conf.xml";
    public static final String DB_RESOURCE_LOGO = "logo.png";
    public static final String DB_RESOURCE_RSS_FEEDS = "rss_feeds.xml";
    public static final String DB_RESOURCE_SEQUENCES = "sequences.xml";
    public static final String DB_RESOURCE_VERSIONS = "versions.xml";
    public static final String DB_URI = "xmldb:exist:///db";
    public static final String XQUERY_CLASSPATH_OPENESTATE = "declare namespace openestate=\"http://www.openestate.org/1.0/\";";
    public static final String XQUERY_CLASSPATH_UTIL = "declare namespace util=\"http://exist-db.org/xquery/util\";";
    public static final String XQUERY_CLASSPATH_XMLDB = "declare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";";
    private Database database = null;
    private File databaseDir;
    private Map<String, String> databaseSchemas;

    private ImmoToolDb(File file) {
        this.databaseDir = file;
        this.databaseSchemas = new HashMap<String, String>();
    }

    public void clearSchemas() {
        this.databaseSchemas.clear();
    }

    public void close() throws ImmoToolDbException {
        if (!this.isOpen()) {
            return;
        }
        Collection collection = null;
        try {
            collection = this.openRootCollection();
            DatabaseInstanceManager databaseInstanceManager = (DatabaseInstanceManager)collection.getService("DatabaseInstanceManager", "1.0");
            databaseInstanceManager.shutdown();
            DatabaseManager.deregisterDatabase((Database)this.database);
            this.database = null;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not close database-instance: " + exception.getLocalizedMessage(), exception);
        }
    }

    public void configure(ImmoToolProject immoToolProject) throws ImmoToolPluginException {
        this.clearSchemas();
        for (String string : immoToolProject.getPluginNames()) {
            immoToolProject.getPlugin(string).exportSchemas(this);
        }
    }

    public void copyCollection(String string, String string2, String string3) throws ImmoToolDbException, URISyntaxException {
        this.copyCollection(XmldbURI.xmldbUriFor((String)string), XmldbURI.create((String)string2), XmldbURI.create((String)string3));
    }

    public synchronized void copyCollection(XmldbURI xmldbURI, XmldbURI xmldbURI2, XmldbURI xmldbURI3) throws ImmoToolDbException {
        LocalCollection localCollection = null;
        try {
            localCollection = (LocalCollection)DatabaseManager.getCollection((String)DB_URI);
            CollectionManagementServiceImpl collectionManagementServiceImpl = (CollectionManagementServiceImpl)localCollection.getService("CollectionManagementService", "1.0");
            collectionManagementServiceImpl.copy(xmldbURI, xmldbURI2, xmldbURI3);
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not copy collection!" + exception.getLocalizedMessage(), exception);
        }
    }

    public Collection createAppCollection() throws ImmoToolDbException {
        return this.createCollection(DB_APP_PATH);
    }

    public Collection createCollection(String string) throws ImmoToolDbException {
        try {
            Collection collection = DatabaseManager.getCollection((String)DB_URI);
            CollectionManagementService collectionManagementService = (CollectionManagementService)collection.getService("CollectionManagementService", "1.0");
            return collectionManagementService.createCollection(string);
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not create collection 'xmldb:exist:///db/" + string + "': " + exception.getLocalizedMessage(), exception);
        }
    }

    public static ImmoToolDb createInstance(ImmoToolProject immoToolProject) throws ImmoToolDbException {
        return ImmoToolDb.createInstance(immoToolProject.getDirectory());
    }

    public static ImmoToolDb createInstance(File file) throws ImmoToolDbException {
        File file2;
        if (file == null) {
            throw new ImmoToolDbException("invalid db-directory!");
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new ImmoToolDbException("could not create db-directory: " + file.getAbsolutePath());
        }
        File file3 = new File(file.getAbsolutePath() + File.separator + "data");
        if (!file3.exists() && !file3.mkdirs()) {
            throw new ImmoToolDbException("could not create db-data-directory: " + file.getAbsolutePath());
        }
        File file4 = new File(file.getAbsolutePath() + File.separator + "journal");
        if (!file4.exists() && !file4.mkdirs()) {
            throw new ImmoToolDbException("could not create db-jourtnal-directory: " + file.getAbsolutePath());
        }
        File file5 = new File(file.getAbsolutePath() + File.separator + "schemas");
        if (!file5.exists() && !file5.mkdirs()) {
            throw new ImmoToolDbException("could not create schema-directory!");
        }
        File file6 = new File(file.getAbsolutePath() + File.separator + "db-conf.xml");
        if (!file6.exists()) {
            try {
                ImmoToolUtils.writeStreamToFile(ImmoToolDb.class.getResourceAsStream(DB_DEFAULT_CONF), file6);
            }
            catch (Exception exception) {
                throw new ImmoToolDbException("could not create db-conf.xml: " + exception.getLocalizedMessage(), exception);
            }
        }
        if (!(file2 = new File(file.getAbsolutePath() + File.separator + "db-catalog.xml")).exists()) {
            try {
                ImmoToolUtils.writeStreamToFile(ImmoToolProject.class.getResourceAsStream(DB_DEFAULT_CATALOG), file2);
            }
            catch (Exception exception) {
                throw new ImmoToolDbException("could not create db-catalog.xml: " + exception.getLocalizedMessage(), exception);
            }
        }
        return new ImmoToolDb(file);
    }

    public Long getCurrentSequence(String string) throws ImmoToolDbException {
        return this.getCurrentSequence(string, this.loadSequences());
    }

    private Long getCurrentSequence(String string, Properties properties) throws ImmoToolDbException {
        String string2 = properties.getProperty(string, "0");
        return Long.valueOf(string2);
    }

    public Database getDatabase() {
        return this.database;
    }

    public File getDataDir() {
        return new File(this.databaseDir.getAbsolutePath() + File.separator + "data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextSequence(String string) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = this.openAppCollection();
            Properties properties = this.loadSequences(collection);
            Long l = this.getCurrentSequence(string, properties);
            Long l2 = l + 1L;
            properties.setProperty(string, String.valueOf(l2));
            this.storeSequences(properties, collection);
            Long l3 = l2;
            return l3;
        }
        finally {
            ImmoToolDbUtils.close(collection);
        }
    }

    public File getSchemaDir() {
        return new File(this.databaseDir.getAbsolutePath() + File.separator + "schemas");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ImmoToolProject immoToolProject, ImmoToolTask.Callback callback) throws ImmoToolException {
        Collection collection = null;
        try {
            Object object;
            Object object2;
            collection = this.openAppCollection();
            if (collection == null) {
                collection = this.createAppCollection();
            }
            if (collection == null) {
                throw new ImmoToolDbException("app-collection not found!");
            }
            if (!ImmoToolDbUtils.hasResource(collection, DB_RESOURCE_SEQUENCES)) {
                this.storeSequences(new Properties());
            }
            if (!ImmoToolDbUtils.hasResource(collection, DB_RESOURCE_RSS_FEEDS)) {
                Properties properties = new Properties();
                object2 = null;
                try {
                    object2 = this.getClass().getResourceAsStream("/com/openindex/openestate/tool/resources/rss_feeds.properties");
                    properties.load((InputStream)object2);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not load default rss-feeds!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)object2);
                }
                this.storeRssFeeds(properties);
            }
            boolean bl = false;
            if (!ImmoToolDbUtils.hasResource(collection, DB_RESOURCE_VERSIONS)) {
                this.storeVersions(new Properties());
            }
            object2 = this.loadVersions();
            List<String> list = Arrays.asList(collection.listChildCollections());
            if (!list.contains(DB_COLLECTION_TEMP.substring(1)) && (object = this.createCollection("ImmoTool/temp")) == null) {
                throw new ImmoToolDbException("could not create temp-collection!");
            }
            object = ((Properties)object2).getProperty(DB_APP_PATH);
            String string = ImmoToolApp.getApplicationVersion();
            if (!string.equals(object)) {
                if (object != null) {
                    LOGGER.info((Object)"program-version has been changed!");
                    LOGGER.info((Object)("> old version: " + (String)object));
                    LOGGER.info((Object)("> new version: " + string));
                    ImmoToolUtils.updateProgram(immoToolProject, this, (String)object, string);
                }
                ((Properties)object2).setProperty(DB_APP_PATH, string);
                bl = true;
            }
            for (String string2 : immoToolProject.getPluginNames()) {
                object = ((Properties)object2).getProperty("Plugin." + string2);
                string = immoToolProject.getPlugin(string2).getVersion();
                if (string != null && !string.equals(object)) {
                    if (object != null) {
                        LOGGER.info((Object)"module-version has been changed!");
                        LOGGER.info((Object)("> " + string2));
                        LOGGER.info((Object)("> old version: " + (String)object));
                        LOGGER.info((Object)("> new version: " + string));
                        ImmoToolUtils.updateProgramPlugin(immoToolProject, immoToolProject.getPlugin(string2), this, (String)object, string);
                    }
                    ((Properties)object2).setProperty("Plugin." + string2, string);
                    bl = true;
                }
                immoToolProject.getPlugin(string2).initDatabase(this, immoToolProject, callback);
            }
            if (bl) {
                this.storeVersions((Properties)object2);
            }
        }
        catch (XMLDBException xMLDBException) {
            throw new ImmoToolDbException(xMLDBException.getLocalizedMessage(), xMLDBException);
        }
        finally {
            ImmoToolDbUtils.close(collection);
        }
    }

    public boolean isOpen() {
        return this.database != null;
    }

    public boolean isSchemaRegistered(String string) {
        return this.databaseSchemas.containsKey(string);
    }

    public Properties loadRssFeeds() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = this.openAppCollection();
            Properties properties = ImmoToolDbUtils.loadProperties(collection, DB_RESOURCE_RSS_FEEDS);
            return properties;
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not load syndication-feeds: " + exception.getLocalizedMessage(), exception);
        }
        finally {
            ImmoToolDbUtils.close(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadSequences() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = this.openAppCollection();
            Properties properties = this.loadSequences(collection);
            return properties;
        }
        finally {
            ImmoToolDbUtils.close(collection);
        }
    }

    public Properties loadSequences(Collection collection) throws ImmoToolDbException {
        try {
            return ImmoToolDbUtils.loadProperties(collection, DB_RESOURCE_SEQUENCES);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not load sequences: " + exception.getLocalizedMessage(), exception);
        }
    }

    public Properties loadVersions() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = this.openAppCollection();
            Properties properties = ImmoToolDbUtils.loadProperties(collection, DB_RESOURCE_VERSIONS);
            return properties;
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not load versions: " + exception.getLocalizedMessage(), exception);
        }
        finally {
            ImmoToolDbUtils.close(collection);
        }
    }

    public void moveCollection(String string, String string2, String string3) throws ImmoToolDbException, URISyntaxException {
        this.moveCollection(XmldbURI.xmldbUriFor((String)string), XmldbURI.xmldbUriFor((String)string2), XmldbURI.xmldbUriFor((String)string3));
    }

    public synchronized void moveCollection(XmldbURI xmldbURI, XmldbURI xmldbURI2, XmldbURI xmldbURI3) throws ImmoToolDbException {
        try {
            Collection collection = DatabaseManager.getCollection((String)DB_URI);
            CollectionManagementServiceImpl collectionManagementServiceImpl = (CollectionManagementServiceImpl)collection.getService("CollectionManagementService", "1.0");
            collectionManagementServiceImpl.move(xmldbURI, xmldbURI2, xmldbURI3);
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not move collection!" + exception.getLocalizedMessage(), exception);
        }
    }

    public void moveResource(String string, String string2, String string3) throws ImmoToolDbException, URISyntaxException {
        this.moveResource(XmldbURI.xmldbUriFor((String)string), XmldbURI.xmldbUriFor((String)string2), XmldbURI.xmldbUriFor((String)string3));
    }

    public synchronized void moveResource(XmldbURI xmldbURI, XmldbURI xmldbURI2, XmldbURI xmldbURI3) throws ImmoToolDbException {
        try {
            Collection collection = DatabaseManager.getCollection((String)DB_URI);
            CollectionManagementServiceImpl collectionManagementServiceImpl = (CollectionManagementServiceImpl)collection.getService("CollectionManagementService", "1.0");
            collectionManagementServiceImpl.moveResource(xmldbURI, xmldbURI2, xmldbURI3);
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not move resource!" + exception.getLocalizedMessage(), exception);
        }
    }

    public void open() throws ImmoToolDbException {
        try {
            this.writeDbCatalog();
            this.writeDbConfiguration();
            File file = new File(this.databaseDir.getAbsolutePath() + File.separator + "db-conf.xml");
            Class<?> clazz = Class.forName("org.exist.xmldb.DatabaseImpl");
            this.database = (Database)clazz.newInstance();
            this.database.setProperty("create-database", "true");
            this.database.setProperty("configuration", file.getPath());
            DatabaseManager.registerDatabase((Database)this.database);
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not open database: " + exception.getLocalizedMessage(), exception);
        }
    }

    public Collection openAppCollection() throws ImmoToolDbException {
        return this.openCollection(DB_APP_PATH);
    }

    public Collection openCollection(String string) throws ImmoToolDbException {
        try {
            return DatabaseManager.getCollection((String)("xmldb:exist:///db/" + string), (String)"admin", (String)"");
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not open collection 'xmldb:exist:///db/" + string + "': " + exception.getLocalizedMessage(), exception);
        }
    }

    public Collection openTempCollection() throws ImmoToolDbException {
        return this.openCollection("ImmoTool/temp");
    }

    public Collection openRootCollection() throws ImmoToolDbException {
        return this.openCollection("");
    }

    public void registerSchema(String string, String string2) {
        this.databaseSchemas.put(string, string2);
    }

    public synchronized void reindexCollection(String string) throws ImmoToolDbException {
        try {
            Collection collection = DatabaseManager.getCollection((String)DB_URI);
            IndexQueryService indexQueryService = (IndexQueryService)collection.getService("IndexQueryService", "1.0");
            indexQueryService.reindexCollection(XmldbURI.create((String)string));
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not remove collection 'xmldb:exist:///db/" + string + "': " + exception.getLocalizedMessage(), exception);
        }
    }

    public synchronized void removeCollection(String string) throws ImmoToolDbException {
        try {
            Collection collection = DatabaseManager.getCollection((String)DB_URI);
            CollectionManagementService collectionManagementService = (CollectionManagementService)collection.getService("CollectionManagementService", "1.0");
            collectionManagementService.removeCollection(string);
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not remove collection 'xmldb:exist:///db/" + string + "': " + exception.getLocalizedMessage(), exception);
        }
    }

    public synchronized void shutdownCollection(Collection collection) throws ImmoToolDbException {
        try {
            DatabaseInstanceManager databaseInstanceManager = (DatabaseInstanceManager)collection.getService("DatabaseInstanceManager", "1.0");
            databaseInstanceManager.shutdown();
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not shutdown connection!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()));
            throw new ImmoToolDbException("could not shutdown collection: " + exception.getLocalizedMessage(), exception);
        }
    }

    public void storeRssFeeds(Properties properties) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = this.openAppCollection();
            ImmoToolDbUtils.storeProperties(collection, properties, DB_RESOURCE_RSS_FEEDS);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not store syndication-feeds: " + exception.getLocalizedMessage(), exception);
        }
        finally {
            ImmoToolDbUtils.close(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSequences(Properties properties) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = this.openAppCollection();
            this.storeSequences(properties, collection);
        }
        finally {
            ImmoToolDbUtils.close(collection);
        }
    }

    public void storeSequences(Properties properties, Collection collection) throws ImmoToolDbException {
        try {
            ImmoToolDbUtils.storeProperties(collection, properties, DB_RESOURCE_SEQUENCES);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not store sequences: " + exception.getLocalizedMessage(), exception);
        }
    }

    public void storeVersions(Properties properties) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = this.openAppCollection();
            ImmoToolDbUtils.storeProperties(collection, properties, DB_RESOURCE_VERSIONS);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not store versions: " + exception.getLocalizedMessage(), exception);
        }
        finally {
            ImmoToolDbUtils.close(collection);
        }
    }

    public void writeDbCatalog() throws ImmoToolDbException {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            String string2;
            inputStream = this.getClass().getResourceAsStream(DB_DEFAULT_CATALOG);
            SAXReader sAXReader = new SAXReader();
            Document document = sAXReader.read(inputStream);
            for (String string2 : this.databaseSchemas.keySet()) {
                String string3 = this.databaseSchemas.get(string2);
                Element element = document.getRootElement().addElement("uri");
                element.addAttribute("name", string2);
                element.addAttribute("uri", string3);
            }
            fileOutputStream = new FileOutputStream(new File(this.databaseDir.getPath() + File.separator + "db-catalog.xml"));
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            outputFormat.setEncoding("UTF-8");
            string2 = new XMLWriter((OutputStream)fileOutputStream, outputFormat);
            string2.write(document);
            string2.close();
        }
        catch (Exception exception) {
            try {
                throw new ImmoToolDbException("could not write db-catalog: " + exception.getLocalizedMessage(), exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileOutputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public void writeDbConfiguration() throws ImmoToolDbException {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream(DB_DEFAULT_CONF);
            SAXReader sAXReader = new SAXReader();
            Document document = sAXReader.read(inputStream);
            fileOutputStream = new FileOutputStream(new File(this.databaseDir.getPath() + File.separator + "db-conf.xml"));
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            outputFormat.setEncoding("UTF-8");
            XMLWriter xMLWriter = new XMLWriter((OutputStream)fileOutputStream, outputFormat);
            xMLWriter.write(document);
            xMLWriter.close();
        }
        catch (Exception exception) {
            try {
                throw new ImmoToolDbException("could not write db-configuration: " + exception.getLocalizedMessage(), exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileOutputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
    }
}

