/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.exist.xmldb.EXistResource;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXImageView;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;

public class ImmoToolDbAdminDialog
extends JDialog {
    private static Logger LOGGER = Logger.getLogger(ImmoToolDbAdminDialog.class);
    private ResourceMap resourceMap;
    private static File lastSaveLocation = null;
    private String selectedCollection = null;
    private String selectedResource = null;
    private JXImageView collectionResourceImageView;
    private JXPanel bgPanel;
    private JSplitPane browserSplitter;
    private JButton closeButton;
    private JPanel collectionPanel;
    private JPanel collectionResourceActionPanel;
    private JButton collectionResourceDownloadButton;
    private JPanel collectionResourceImagePanel;
    private JPanel collectionResourcePanel;
    private JTabbedPane collectionResourceTabbedPane;
    private RSyntaxTextArea collectionResourceTextArea;
    private JScrollPane collectionResourceTextScroller;
    private JXTitledSeparator collectionResourceTitle;
    private JSplitPane collectionSplitter;
    private JXTable collectionTable;
    private JPanel collectionTablePanel;
    private JScrollPane collectionTableScroller;
    private JXTitledSeparator collectionTableTitle;
    private JTree collectionTree;
    private JScrollPane collectionTreeScroller;
    private JSplitPane consoleSplitter;
    private JTabbedPane mainTabbedPane;
    private JPanel queryInputPanel;
    private JScrollPane queryInputScroller;
    private RSyntaxTextArea queryInputTextArea;
    private JXTitledSeparator queryInputTitle;
    private JPanel queryOutputPanel;
    private JScrollPane queryOutputScroller;
    private RSyntaxTextArea queryOutputTextArea;
    private JXTitledSeparator queryOutputTitle;
    private JButton querySubmitButton;
    private JXTitledSeparator titleLabel;

    public ImmoToolDbAdminDialog() throws ImmoToolDbException {
        this((Frame)ImmoToolApp.getApplication().getFrameView().getFrame(), true);
    }

    public ImmoToolDbAdminDialog(Frame frame, boolean bl) throws ImmoToolDbException {
        super(frame, bl);
        this.build();
    }

    private void build() throws ImmoToolDbException {
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolDbAdminDialog.class);
        this.collectionResourceTextArea = new RSyntaxTextArea();
        this.collectionResourceTextScroller = new RTextScrollPane((Component)this.collectionResourceTextArea);
        this.queryInputTextArea = new RSyntaxTextArea();
        this.queryInputScroller = new RTextScrollPane((Component)this.queryInputTextArea);
        this.queryOutputTextArea = new RSyntaxTextArea();
        this.queryOutputScroller = new RTextScrollPane((Component)this.queryOutputTextArea);
        this.initComponents();
        this.loadCollections();
        this.collectionResourceImageView = new JXImageView();
        JScrollPane jScrollPane = new JScrollPane((Component)this.collectionResourceImageView);
        jScrollPane.setBorder(Borders.EMPTY);
        this.collectionResourceImagePanel.setLayout(new BorderLayout());
        this.collectionResourceImagePanel.add((Component)jScrollPane, "Center");
        this.collectionResourceTabbedPane.setEnabledAt(0, false);
        this.collectionResourceTabbedPane.setEnabledAt(1, false);
        this.collectionResourceTabbedPane.setEnabledAt(2, false);
        this.collectionTable.setEnabled(false);
        for (int i = 0; i < this.collectionTable.getColumnModel().getColumnCount(); ++i) {
            String string = this.collectionTable.getModel().getColumnName(i);
            String string2 = this.resourceMap.getString("tableColumn." + string, new Object[0]);
            if (string2 == null || string2.trim().length() <= 0) continue;
            this.collectionTable.getColumnModel().getColumn(i).setHeaderValue(string2.trim());
        }
        this.collectionResourceTextArea.setEnabled(false);
        this.collectionResourceTextArea.setSyntaxEditingStyle("text/xml");
        this.collectionTree.getSelectionModel().setSelectionMode(1);
        this.collectionTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (ImmoToolDbAdminDialog.this.collectionTree.isSelectionEmpty()) {
                    return;
                }
                CollectionNode collectionNode = (CollectionNode)ImmoToolDbAdminDialog.this.collectionTree.getSelectionPath().getLastPathComponent();
                ImmoToolDbAdminDialog.this.loadCollection(collectionNode.getName());
            }
        });
        ImmoToolUtils.configureTable(this.collectionTable);
        this.collectionTable.getSelectionModel().setSelectionMode(0);
        this.collectionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = ImmoToolDbAdminDialog.this.collectionTable.getSelectedRow();
                if (n < 0) {
                    return;
                }
                ImmoToolDbAdminDialog.this.loadResource(ImmoToolDbAdminDialog.this.selectedCollection, ImmoToolDbAdminDialog.this.collectionTable.getValueAt(n, 0).toString(), ImmoToolDbAdminDialog.this.collectionTable.getValueAt(n, 2).toString());
            }
        });
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.closeButton.setOpaque(false);
            this.mainTabbedPane.setOpaque(true);
            this.mainTabbedPane.setBorder(BorderFactory.createRaisedBevelBorder());
        }
        ImmoToolUtils.configureDialog(this, this.bgPanel);
    }

    @Action
    public void doClose() {
        this.setVisible(false);
    }

    @Action
    public Task doDownloadResource() {
        if (this.selectedCollection == null || this.selectedResource == null) {
            return null;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.resourceMap.getString("question.saveResourceLocation", new Object[0]));
        if (lastSaveLocation != null) {
            jFileChooser.setSelectedFile(new File(lastSaveLocation.getAbsolutePath() + File.separator + this.selectedResource));
        } else {
            jFileChooser.setSelectedFile(new File(this.selectedResource));
        }
        int n = jFileChooser.showSaveDialog(this);
        if (n != 0) {
            return null;
        }
        final File file = jFileChooser.getSelectedFile();
        ImmoToolDbAdminDialog.setLastSaveLocation(file.getParentFile());
        return new ImmoToolTask<File>(){

            @Override
            protected File executeTask() throws Exception {
                ImmoToolDb immoToolDb = ImmoToolApp.getApplication().getDatabase();
                Collection collection = immoToolDb.openCollection(ImmoToolDbAdminDialog.this.selectedCollection.substring(4));
                Resource resource = collection.getResource(ImmoToolDbAdminDialog.this.selectedResource);
                if ("XMLResource".equals(resource.getResourceType())) {
                    FileUtils.write((File)file, (CharSequence)((String)resource.getContent()));
                } else if ("BinaryResource".equals(resource.getResourceType())) {
                    ImmoToolUtils.writeStreamToFile(new ByteArrayInputStream((byte[])resource.getContent()), file);
                } else {
                    throw new IOException("unknown resource type!");
                }
                return file;
            }

            @Override
            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog(ImmoToolDbAdminDialog.this.resourceMap.getString("error.cantSaveResource", new Object[]{ImmoToolDbAdminDialog.this.selectedResource}), throwable);
            }

            @Override
            protected void succeeded(File file2) {
                super.succeeded(file2);
                ImmoToolUtils.showMessageInfoDialog(ImmoToolDbAdminDialog.this.resourceMap.getString("message.selectedResourceWasSaved", new Object[]{file2.getAbsolutePath()}));
            }
        };
    }

    @Action
    public Task doExecuteQuery() {
        return new ImmoToolTask<String>(){

            @Override
            protected String executeTask() throws Exception {
                String string = ImmoToolDbAdminDialog.this.queryInputTextArea.getText().trim();
                ImmoToolDb immoToolDb = ImmoToolApp.getApplication().getDatabase();
                Collection collection = immoToolDb.openRootCollection();
                ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery(collection, string);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(ImmoToolDbAdminDialog.this.resourceMap.getString("message.queryResultSize", new Object[]{resourceSet.getSize()})).append(SystemUtils.LINE_SEPARATOR);
                int n = 0;
                while ((long)n < resourceSet.getSize()) {
                    Resource resource = resourceSet.getResource((long)n);
                    stringBuilder.append("-----------------------------------------").append(SystemUtils.LINE_SEPARATOR).append("resource #").append(n + 1).append(SystemUtils.LINE_SEPARATOR).append("> id   : ").append(resource.getId()).append(SystemUtils.LINE_SEPARATOR).append("> type : ").append(resource.getResourceType()).append(SystemUtils.LINE_SEPARATOR);
                    if ("XMLResource".equals(resource.getResourceType())) {
                        stringBuilder.append((String)resource.getContent()).append(SystemUtils.LINE_SEPARATOR);
                    } else if ("BinaryResource".equals(resource.getResourceType())) {
                        stringBuilder.append("> ").append(((byte[])resource.getContent()).length / 1024).append("KB").append(SystemUtils.LINE_SEPARATOR);
                    }
                    stringBuilder.append("-----------------------------------------").append(SystemUtils.LINE_SEPARATOR);
                    ++n;
                }
                return stringBuilder.toString();
            }

            @Override
            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolDbAdminDialog.this.queryOutputTextArea.setText(ImmoToolDbAdminDialog.this.resourceMap.getString("error.cantExceuteQuery", new Object[0]) + SystemUtils.LINE_SEPARATOR + throwable.getLocalizedMessage());
            }

            @Override
            protected void succeeded(String string) {
                super.succeeded(string);
                ImmoToolDbAdminDialog.this.queryOutputTextArea.setText(string);
            }
        };
    }

    private void loadCollection(String string) {
        this.selectedCollection = string;
        this.collectionTable.getSelectionModel().clearSelection();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.collectionTable.getModel();
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(0);
        }
        try {
            ImmoToolDb immoToolDb = ImmoToolApp.getApplication().getDatabase();
            Collection collection = immoToolDb.openCollection(string.substring(4));
            if (collection == null) {
                throw new Exception(this.resourceMap.getString("error.cantLoadCollection", new Object[]{string}));
            }
            for (String string2 : collection.listResources()) {
                Resource resource = collection.getResource(string2);
                EXistResource eXistResource = (EXistResource)resource;
                defaultTableModel.addRow(new Object[]{resource.getId(), resource.getResourceType(), eXistResource.getMimeType(), eXistResource.getContentLength() / 1024 + " kB", eXistResource.getCreationTime(), eXistResource.getLastModificationTime()});
            }
            collection.close();
            this.collectionTable.packAll();
            this.collectionTable.setEnabled(true);
            this.collectionTableTitle.setTitle(string);
        }
        catch (Exception exception) {
            this.selectedCollection = null;
            this.collectionTable.setEnabled(false);
            LOGGER.error((Object)"could not load collection!");
            LOGGER.error((Object)("> " + string));
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantLoadCollection", new Object[]{string}), exception);
        }
    }

    private void loadCollections() throws ImmoToolDbException {
        try {
            ImmoToolDb immoToolDb = ImmoToolApp.getApplication().getDatabase();
            Collection collection = immoToolDb.openRootCollection();
            this.collectionTree.setModel(new DefaultTreeModel(new CollectionNode(collection)));
            collection.close();
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), exception);
        }
    }

    private void loadResource(String string, String string2, String string3) {
        if (this.selectedCollection == null) {
            return;
        }
        this.selectedResource = string2;
        try {
            ImmoToolDb immoToolDb = ImmoToolApp.getApplication().getDatabase();
            Collection collection = immoToolDb.openCollection(string.substring(4));
            if (collection == null) {
                throw new Exception(this.resourceMap.getString("error.cantLoadCollection", new Object[]{string}));
            }
            Resource resource = collection.getResource(string2);
            if ("XMLResource".equals(resource.getResourceType())) {
                this.collectionResourceTextArea.setText(resource.getContent().toString());
                this.collectionResourceTabbedPane.setSelectedIndex(0);
                this.collectionResourceTabbedPane.setEnabledAt(0, true);
                this.collectionResourceTabbedPane.setEnabledAt(1, false);
                this.collectionResourceTabbedPane.setEnabledAt(2, true);
            } else if ("BinaryResource".equals(resource.getResourceType())) {
                if (string3 != null && string3.toLowerCase().startsWith("image/")) {
                    try {
                        this.collectionResourceImageView.setImage((Image)ImageIO.read(new ByteArrayInputStream((byte[])resource.getContent())));
                        this.collectionResourceTabbedPane.setSelectedIndex(1);
                        this.collectionResourceTabbedPane.setEnabledAt(0, false);
                        this.collectionResourceTabbedPane.setEnabledAt(1, true);
                        this.collectionResourceTabbedPane.setEnabledAt(2, true);
                    }
                    catch (Exception exception) {
                        this.collectionResourceTabbedPane.setSelectedIndex(2);
                        this.collectionResourceTabbedPane.setEnabledAt(0, false);
                        this.collectionResourceTabbedPane.setEnabledAt(1, false);
                        this.collectionResourceTabbedPane.setEnabledAt(2, true);
                        ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantLoadImageResource", new Object[]{string2}), exception);
                    }
                } else {
                    this.collectionResourceTabbedPane.setSelectedIndex(2);
                    this.collectionResourceTabbedPane.setEnabledAt(0, false);
                    this.collectionResourceTabbedPane.setEnabledAt(1, false);
                    this.collectionResourceTabbedPane.setEnabledAt(2, true);
                }
                long l = ((byte[])resource.getContent()).length;
                NumberFormat numberFormat = NumberFormat.getIntegerInstance();
                this.collectionResourceTextArea.setText(this.resourceMap.getString("message.selectedResourceIsBinary", new Object[]{numberFormat.format(l / 1024L)}));
            } else {
                this.collectionResourceTextArea.setText(this.resourceMap.getString("error.selectedResourceHasInvalidContentType", new Object[]{resource.getResourceType()}));
                this.collectionResourceTabbedPane.setSelectedIndex(0);
                this.collectionResourceTabbedPane.setEnabledAt(0, false);
                this.collectionResourceTabbedPane.setEnabledAt(1, false);
                this.collectionResourceTabbedPane.setEnabledAt(2, true);
            }
            collection.close();
            this.collectionResourceTextArea.setCaretPosition(0);
            this.collectionResourceTextArea.setEnabled(true);
            this.collectionResourceTitle.setTitle(string + "/" + string2);
        }
        catch (Exception exception) {
            this.selectedResource = null;
            this.collectionResourceTextArea.setEnabled(false);
            LOGGER.error((Object)"could not load resource!");
            LOGGER.error((Object)("> " + string));
            LOGGER.error((Object)("> " + string2));
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantLoadResource", new Object[]{string2}), exception);
        }
    }

    private static synchronized void setLastSaveLocation(File file) {
        lastSaveLocation = file;
    }

    private void initComponents() {
        this.bgPanel = new JXPanel();
        this.closeButton = new JButton();
        this.titleLabel = ImmoToolUtils.createHead1Separator("");
        this.mainTabbedPane = new JTabbedPane();
        this.browserSplitter = new JSplitPane();
        this.collectionTreeScroller = new JScrollPane();
        this.collectionTree = new JTree();
        this.collectionPanel = new JPanel();
        this.collectionSplitter = new JSplitPane();
        this.collectionTablePanel = new JPanel();
        this.collectionTableTitle = ImmoToolUtils.createHead2Separator("");
        this.collectionTableScroller = new JScrollPane();
        this.collectionTable = new JXTable();
        this.collectionResourcePanel = new JPanel();
        this.collectionResourceTitle = ImmoToolUtils.createHead2Separator("");
        this.collectionResourceTabbedPane = new JTabbedPane();
        this.collectionResourceTextScroller = this.collectionResourceTextScroller;
        this.collectionResourceTextArea = this.collectionResourceTextArea;
        this.collectionResourceImagePanel = new JPanel();
        this.collectionResourceActionPanel = new JPanel();
        this.collectionResourceDownloadButton = new JButton();
        this.consoleSplitter = new JSplitPane();
        this.queryInputPanel = new JPanel();
        this.queryInputTitle = ImmoToolUtils.createHead2Separator("");
        this.queryInputScroller = this.queryInputScroller;
        this.queryInputTextArea = this.queryInputTextArea;
        this.querySubmitButton = new JButton();
        this.queryOutputPanel = new JPanel();
        this.queryOutputTitle = ImmoToolUtils.createHead2Separator("");
        this.queryOutputScroller = this.queryOutputScroller;
        this.queryOutputTextArea = this.queryOutputTextArea;
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ImmoToolDbAdminDialog.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.bgPanel.setName("bgPanel");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(ImmoToolDbAdminDialog.class, (Object)this);
        this.closeButton.setAction(applicationActionMap.get("doClose"));
        this.closeButton.setName("closeButton");
        this.titleLabel.setIcon(resourceMap.getIcon("titleLabel.icon"));
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle(this.getTitle());
        this.mainTabbedPane.setName("mainTabbedPane");
        this.browserSplitter.setBorder(null);
        this.browserSplitter.setDividerLocation(200);
        this.browserSplitter.setName("browserSplitter");
        this.collectionTreeScroller.setName("collectionTreeScroller");
        this.collectionTree.setName("collectionTree");
        this.collectionTree.setRootVisible(false);
        this.collectionTreeScroller.setViewportView(this.collectionTree);
        this.browserSplitter.setLeftComponent(this.collectionTreeScroller);
        this.collectionPanel.setName("collectionPanel");
        this.collectionSplitter.setBorder(null);
        this.collectionSplitter.setDividerLocation(100);
        this.collectionSplitter.setOrientation(0);
        this.collectionSplitter.setName("collectionSplitter");
        this.collectionTablePanel.setName("collectionTablePanel");
        this.collectionTableTitle.setName("collectionTableTitle");
        this.collectionTableTitle.setTitle(resourceMap.getString("message.noCollectionSelected", new Object[0]));
        this.collectionTableScroller.setName("collectionTableScroller");
        this.collectionTable.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"file", "resourceType", "mimeType", "size", "createdAt", "modifiedAt"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, Object.class, Object.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.collectionTable.setColumnControlVisible(true);
        this.collectionTable.setName("collectionTable");
        this.collectionTableScroller.setViewportView((Component)this.collectionTable);
        GroupLayout groupLayout = new GroupLayout(this.collectionTablePanel);
        this.collectionTablePanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.collectionTableTitle, -1, 571, Short.MAX_VALUE).addComponent(this.collectionTableScroller, -1, 571, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.collectionTableTitle, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.collectionTableScroller, -1, 67, Short.MAX_VALUE).addContainerGap()));
        this.collectionSplitter.setLeftComponent(this.collectionTablePanel);
        this.collectionResourcePanel.setName("collectionResourcePanel");
        this.collectionResourceTitle.setName("collectionResourceTitle");
        this.collectionResourceTitle.setTitle(resourceMap.getString("message.noResourceSelected", new Object[0]));
        this.collectionResourceTabbedPane.setName("collectionResourceTabbedPane");
        this.collectionResourceTextScroller.setName("collectionResourceTextScroller");
        this.collectionResourceTextArea.setColumns(20);
        this.collectionResourceTextArea.setEditable(false);
        this.collectionResourceTextArea.setRows(5);
        this.collectionResourceTextArea.setName("collectionResourceTextArea");
        this.collectionResourceTextScroller.setViewportView((Component)this.collectionResourceTextArea);
        this.collectionResourceTabbedPane.addTab(resourceMap.getString("collectionResourceTextScroller.TabConstraints.tabTitle", new Object[0]), this.collectionResourceTextScroller);
        this.collectionResourceImagePanel.setName("collectionResourceImagePanel");
        GroupLayout groupLayout2 = new GroupLayout(this.collectionResourceImagePanel);
        this.collectionResourceImagePanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 566, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 282, Short.MAX_VALUE));
        this.collectionResourceTabbedPane.addTab(resourceMap.getString("collectionResourceImagePanel.TabConstraints.tabTitle", new Object[0]), this.collectionResourceImagePanel);
        this.collectionResourceActionPanel.setName("collectionResourceActionPanel");
        this.collectionResourceDownloadButton.setAction(applicationActionMap.get("doDownloadResource"));
        this.collectionResourceDownloadButton.setName("collectionResourceDownloadButton");
        GroupLayout groupLayout3 = new GroupLayout(this.collectionResourceActionPanel);
        this.collectionResourceActionPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.collectionResourceDownloadButton).addContainerGap(499, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.collectionResourceDownloadButton).addContainerGap(245, Short.MAX_VALUE)));
        this.collectionResourceTabbedPane.addTab(resourceMap.getString("collectionResourceActionPanel.TabConstraints.tabTitle", new Object[0]), this.collectionResourceActionPanel);
        GroupLayout groupLayout4 = new GroupLayout(this.collectionResourcePanel);
        this.collectionResourcePanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.collectionResourceTitle, -1, 571, Short.MAX_VALUE).addComponent(this.collectionResourceTabbedPane, -1, 571, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent((Component)this.collectionResourceTitle, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.collectionResourceTabbedPane, -1, 309, Short.MAX_VALUE)));
        this.collectionSplitter.setRightComponent(this.collectionResourcePanel);
        GroupLayout groupLayout5 = new GroupLayout(this.collectionPanel);
        this.collectionPanel.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.collectionSplitter, -1, 571, Short.MAX_VALUE).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.collectionSplitter, -1, 452, Short.MAX_VALUE).addContainerGap()));
        this.browserSplitter.setRightComponent(this.collectionPanel);
        this.mainTabbedPane.addTab(resourceMap.getString("browserSplitter.TabConstraints.tabTitle", new Object[0]), this.browserSplitter);
        this.consoleSplitter.setDividerLocation(190);
        this.consoleSplitter.setOrientation(0);
        this.consoleSplitter.setName("consoleSplitter");
        this.queryInputPanel.setName("queryInputPanel");
        this.queryInputTitle.setName("queryInputTitle");
        this.queryInputTitle.setTitle(resourceMap.getString("queryInputTitle.title", new Object[0]));
        this.queryInputScroller.setName("queryInputScroller");
        this.queryInputTextArea.setColumns(20);
        this.queryInputTextArea.setRows(5);
        this.queryInputTextArea.setName("queryInputTextArea");
        this.queryInputScroller.setViewportView((Component)this.queryInputTextArea);
        this.querySubmitButton.setAction(applicationActionMap.get("doExecuteQuery"));
        this.querySubmitButton.setName("querySubmitButton");
        GroupLayout groupLayout6 = new GroupLayout(this.queryInputPanel);
        this.queryInputPanel.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout6.createSequentialGroup().addContainerGap().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.queryInputScroller, -1, 779, Short.MAX_VALUE).addGroup(groupLayout6.createSequentialGroup().addComponent((Component)this.queryInputTitle, -1, 712, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.querySubmitButton))).addContainerGap()));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.querySubmitButton).addComponent((Component)this.queryInputTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.queryInputScroller, -1, 134, Short.MAX_VALUE).addContainerGap()));
        this.consoleSplitter.setTopComponent(this.queryInputPanel);
        this.queryOutputPanel.setName("queryOutputPanel");
        this.queryOutputTitle.setName("queryOutputTitle");
        this.queryOutputTitle.setTitle(resourceMap.getString("queryOutputTitle.title", new Object[0]));
        this.queryOutputScroller.setName("queryOutputScroller");
        this.queryOutputTextArea.setColumns(20);
        this.queryOutputTextArea.setEditable(false);
        this.queryOutputTextArea.setRows(5);
        this.queryOutputTextArea.setName("queryOutputTextArea");
        this.queryOutputScroller.setViewportView((Component)this.queryOutputTextArea);
        GroupLayout groupLayout7 = new GroupLayout(this.queryOutputPanel);
        this.queryOutputPanel.setLayout(groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addContainerGap().addGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.queryOutputScroller, GroupLayout.Alignment.TRAILING, -1, 779, Short.MAX_VALUE).addComponent((Component)this.queryOutputTitle, GroupLayout.Alignment.TRAILING, -1, 779, Short.MAX_VALUE)).addContainerGap()));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addContainerGap().addComponent((Component)this.queryOutputTitle, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.queryOutputScroller, -1, 230, Short.MAX_VALUE).addContainerGap()));
        this.consoleSplitter.setRightComponent(this.queryOutputPanel);
        this.mainTabbedPane.addTab(resourceMap.getString("consoleSplitter.TabConstraints.tabTitle", new Object[0]), this.consoleSplitter);
        GroupLayout groupLayout8 = new GroupLayout((Container)this.bgPanel);
        this.bgPanel.setLayout((LayoutManager)groupLayout8);
        groupLayout8.setHorizontalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout8.createSequentialGroup().addContainerGap().addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.mainTabbedPane, GroupLayout.Alignment.LEADING, -1, 810, Short.MAX_VALUE).addGroup(groupLayout8.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 723, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.closeButton))).addContainerGap()));
        groupLayout8.setVerticalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout8.createSequentialGroup().addContainerGap().addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.closeButton).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainTabbedPane, -1, 503, Short.MAX_VALUE).addContainerGap()));
        GroupLayout groupLayout9 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout9);
        groupLayout9.setHorizontalGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.bgPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        groupLayout9.setVerticalGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.bgPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private static final class CollectionNode
    extends DefaultMutableTreeNode {
        private String name;

        private CollectionNode(Collection collection) throws XMLDBException {
            this.name = collection.getName();
            for (String string : collection.listChildCollections()) {
                this.add(new CollectionNode(collection.getChildCollection(string)));
            }
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            String[] stringArray = this.name.split("/");
            return stringArray[stringArray.length - 1];
        }
    }
}

