/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskException;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.exist.backup.Backup;
import org.exist.xmldb.XmldbURI;
import org.jdesktop.application.ResourceMap;

public class ImmoToolDbBackupTask
extends ImmoToolTask<File> {
    private static Logger LOGGER = Logger.getLogger(ImmoToolDbBackupTask.class);
    private ResourceMap resourceMap;
    private ImmoToolProject project;
    private File backupDir;
    private String backupUri;
    private boolean cleanupBackupDir;

    public ImmoToolDbBackupTask(ImmoToolProject immoToolProject, boolean bl) {
        this(immoToolProject, null, bl);
    }

    public ImmoToolDbBackupTask(ImmoToolProject immoToolProject, File file, boolean bl) {
        this(immoToolProject, file, null, bl);
    }

    public ImmoToolDbBackupTask(ImmoToolProject immoToolProject, File file, String string, boolean bl) {
        this.project = immoToolProject;
        this.backupDir = file == null ? immoToolProject.getBackupDirectory() : file;
        this.backupUri = string == null ? "xmldb:exist:///db/ImmoTool" : string;
        this.cleanupBackupDir = bl;
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolDbBackupTask.class);
        this.setTitle(this.resourceMap.getString("title", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected File executeTask() throws Exception {
        if (this.project == null) {
            throw new ImmoToolTaskException("no project found!");
        }
        File file = this.project.getTempDirectory();
        if (!file.exists() && !file.mkdirs()) {
            throw new Exception("can't create temp-directory!");
        }
        if (!this.backupDir.exists() && !this.backupDir.mkdirs()) {
            throw new Exception("can't create backup-directory!");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm");
        this.setMessage(this.resourceMap.getString("message.executeBackup", new Object[0]));
        Backup backup = new Backup("admin", "", file.getAbsolutePath(), XmldbURI.xmldbUriFor((String)this.backupUri));
        backup.backup(false, null);
        File file2 = null;
        ZipOutputStream zipOutputStream = null;
        try {
            this.setMessage(this.resourceMap.getString("message.createZipFile", new Object[0]));
            file2 = new File(this.backupDir.getPath() + File.separator + "db_" + simpleDateFormat.format(new Date()) + ".zip");
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            ImmoToolUtils.loadFileIntoZipStream(new File(file.getPath() + File.separator + "db"), zipOutputStream);
            zipOutputStream.flush();
            FileUtils.deleteQuietly((File)new File(file.getPath() + File.separator + "db"));
            this.project.setProperty("Backup.Time", String.valueOf(System.currentTimeMillis()));
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
        if (this.cleanupBackupDir && this.project.getBackupFileCount() > 0) {
            TreeMap<String, File> treeMap = new TreeMap<String, File>();
            for (File file3 : this.backupDir.listFiles()) {
                if (!file3.isFile() || !file3.getName().startsWith("db_")) continue;
                treeMap.put(file3.getName(), file3);
            }
            if (treeMap.size() > this.project.getBackupFileCount()) {
                while (treeMap.size() > this.project.getBackupFileCount()) {
                    String string = (String)treeMap.keySet().iterator().next();
                    File file4 = (File)treeMap.get(string);
                    this.setMessage(this.resourceMap.getString("message.removeOldBackup", new Object[]{file4.getAbsolutePath()}));
                    if (!file4.delete()) {
                        LOGGER.warn((Object)("Can't delete '" + file4.getAbsolutePath() + "'!"));
                    }
                    treeMap.remove(string);
                }
            }
        }
        return file2;
    }

    @Override
    protected void failed(Throwable throwable) {
        super.failed(throwable);
        this.setMessage(this.resourceMap.getString("error.cantSaveBackup", new Object[]{throwable.getLocalizedMessage()}));
    }
}

