/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbSnapshot;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.exist.backup.Restore;
import org.jdesktop.application.ResourceMap;
import org.xmldb.api.base.Collection;

public class ImmoToolDbRestoreTask
extends ImmoToolTask<Boolean> {
    private static Logger LOGGER = Logger.getLogger(ImmoToolDbRestoreTask.class);
    private ResourceMap resourceMap = null;
    private ImmoToolProject project = null;
    private File backupFile = null;
    private String backupUri = null;
    private boolean backupSnapshot = false;

    public ImmoToolDbRestoreTask(ImmoToolProject immoToolProject, File file, boolean bl) {
        this(immoToolProject, file, null, bl);
    }

    public ImmoToolDbRestoreTask(ImmoToolProject immoToolProject, File file, String string, boolean bl) {
        this.project = immoToolProject;
        this.backupFile = file;
        this.backupUri = string == null ? "xmldb:exist:///db/ImmoTool" : string;
        this.backupSnapshot = bl;
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolDbRestoreTask.class);
        this.setTitle(this.resourceMap.getString("title", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Boolean executeTask() throws Exception {
        Object object;
        block14: {
            if (this.project == null) {
                throw new Exception("no project found!");
            }
            Collection collection = null;
            File file = new File(this.project.getTempDirectory().getAbsolutePath() + File.separator + "db-restore");
            try {
                File file2;
                Object object2;
                ImmoToolDb immoToolDb = ImmoToolApp.getApplication().getDatabase();
                if (file.exists()) {
                    FileUtils.deleteQuietly((File)file);
                }
                if (!file.exists() && !file.mkdirs()) {
                    throw new Exception("can't create temp-directory!");
                }
                this.setMessage(this.resourceMap.getString("message.extractZipFile", new Object[0]));
                ZipFile zipFile = new ZipFile(this.backupFile);
                Object object3 = zipFile.entries();
                while (object3.hasMoreElements()) {
                    try {
                        object2 = object3.nextElement();
                        file2 = new File(file.getAbsolutePath() + File.separator + ((ZipEntry)object2).getName());
                        if (((ZipEntry)object2).isDirectory()) {
                            if (file2.mkdirs()) continue;
                            LOGGER.warn((Object)("could not create directory: " + file2.getAbsolutePath()));
                            continue;
                        }
                        if (!file2.getParentFile().exists() && !file2.getParentFile().mkdirs()) {
                            LOGGER.warn((Object)("could not create directory: " + file2.getParentFile().getAbsolutePath()));
                            continue;
                        }
                        object = zipFile.getInputStream((ZipEntry)object2);
                        if (object == null) {
                            LOGGER.warn((Object)("Can't read zip-entry: " + ((ZipEntry)object2).getName()));
                            continue;
                        }
                        ImmoToolUtils.writeStreamToFile((InputStream)object, file2);
                        ((InputStream)object).close();
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"Can't read zip-entry!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                }
                zipFile.close();
                object3 = null;
                if (this.backupSnapshot) {
                    object3 = new ImmoToolDbSnapshot(null);
                    this.setMessage(this.resourceMap.getString("message.removeLastSnapshot", new Object[0]));
                    ((ImmoToolDbSnapshot)object3).removeSnapshot(immoToolDb);
                    this.setMessage(this.resourceMap.getString("message.createTempSnapshot", new Object[0]));
                    ((ImmoToolDbSnapshot)object3).createSnapshot(immoToolDb);
                }
                this.setMessage(this.resourceMap.getString("message.restoreDatabase", new Object[0]));
                collection = immoToolDb.createCollection("ImmoTool");
                ImmoToolDbUtils.close(collection);
                object2 = new File(file.getAbsolutePath() + File.separator + "db" + File.separator + "ImmoTool" + File.separator + "__contents__.xml");
                file2 = new Restore("admin", "", null, (File)object2, this.backupUri);
                file2.restore(false, null);
                if (this.backupSnapshot) {
                    this.setMessage(this.resourceMap.getString("message.removeTempSnapshot", new Object[0]));
                    ((ImmoToolDbSnapshot)object3).removeSnapshot(immoToolDb);
                }
                object = Boolean.TRUE;
                if (collection == null) break block14;
            }
            catch (Throwable throwable) {
                if (collection != null) {
                    ImmoToolDbUtils.close(collection);
                }
                throw throwable;
            }
            ImmoToolDbUtils.close(collection);
        }
        return object;
    }

    @Override
    protected void failed(Throwable throwable) {
        super.failed(throwable);
        this.setMessage(this.resourceMap.getString("error.cantRestoreBackup", new Object[]{throwable.getLocalizedMessage()}));
    }
}

