/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.awt.Component;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class ImmoToolDbSnapshot {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolDbSnapshot.class);
    public static final String OLD = "ImmoTool_Old";
    private final Date stamp;

    public ImmoToolDbSnapshot(Date date) {
        this.stamp = date != null ? (Date)date.clone() : null;
    }

    public void createSnapshot() throws ImmoToolDbException {
        this.createSnapshot(ImmoToolApp.getApplication().getDatabase());
    }

    public void createSnapshot(ImmoToolDb immoToolDb) throws ImmoToolDbException {
        String string = this.getCollection();
        Collection collection = null;
        Collection collection2 = null;
        try {
            collection = immoToolDb.openAppCollection();
            collection2 = immoToolDb.openCollection(string);
            if (collection2 == null) {
                collection2 = immoToolDb.createCollection(string);
            }
            ImmoToolDbUtils.copyCollection(collection, collection2, immoToolDb);
        }
        catch (XMLDBException xMLDBException) {
            try {
                throw new ImmoToolDbException(xMLDBException.getLocalizedMessage(), xMLDBException);
            }
            catch (Throwable throwable) {
                ImmoToolDbUtils.close(collection);
                ImmoToolDbUtils.close(collection2);
                throw throwable;
            }
        }
        ImmoToolDbUtils.close(collection);
        ImmoToolDbUtils.close(collection2);
    }

    public String getCollection() {
        return this.getStamp() != null ? "ImmoTool_" + this.getStamp().getTime() : OLD;
    }

    public Date getStamp() {
        return this.stamp != null ? (Date)this.stamp.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImmoToolDbSnapshot[] loadSnapshots() throws ImmoToolDbException {
        ImmoToolDbSnapshot[] immoToolDbSnapshotArray;
        Collection collection = null;
        try {
            ImmoToolDb immoToolDb = ImmoToolApp.getApplication().getDatabase();
            collection = immoToolDb.openRootCollection();
            immoToolDbSnapshotArray = ImmoToolDbSnapshot.loadSnapshots(collection);
        }
        catch (Throwable throwable) {
            ImmoToolDbUtils.close(collection);
            throw throwable;
        }
        ImmoToolDbUtils.close(collection);
        return immoToolDbSnapshotArray;
    }

    public static ImmoToolDbSnapshot[] loadSnapshots(Collection collection) throws ImmoToolDbException {
        try {
            TreeMap<Long, ImmoToolDbSnapshot> treeMap = new TreeMap<Long, ImmoToolDbSnapshot>(new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((Comparable)object).compareTo(object2) * -1;
                }
            });
            for (String string : collection.listChildCollections()) {
                if (string == null || !string.startsWith("ImmoTool_")) continue;
                if (string.equalsIgnoreCase(OLD)) {
                    treeMap.put(0L, new ImmoToolDbSnapshot(null));
                    continue;
                }
                try {
                    Long l = Long.valueOf(string.substring("ImmoTool".length() + 1).trim());
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(l);
                    treeMap.put(l, new ImmoToolDbSnapshot(calendar.getTime()));
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)("invalid snapshot: " + string));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
            return treeMap.values().toArray(new ImmoToolDbSnapshot[treeMap.size()]);
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("Can't load snapshots: " + exception.getLocalizedMessage(), exception);
        }
    }

    public boolean removeSnapshot() throws ImmoToolDbException {
        return this.removeSnapshot(ImmoToolApp.getApplication().getDatabase());
    }

    public boolean removeSnapshot(ImmoToolDb immoToolDb) throws ImmoToolDbException {
        Collection collection = immoToolDb.openCollection(this.getCollection());
        if (collection == null) {
            return false;
        }
        ImmoToolDbUtils.close(collection);
        collection = null;
        immoToolDb.removeCollection(OLD);
        return true;
    }

    public void restoreSnapshot() throws ImmoToolDbException {
        this.restoreSnapshot(ImmoToolApp.getApplication().getDatabase());
    }

    public void restoreSnapshot(ImmoToolDb immoToolDb) throws ImmoToolDbException {
        String string = this.getCollection();
        Collection collection = null;
        Collection collection2 = null;
        try {
            collection = immoToolDb.openCollection(string);
            collection2 = immoToolDb.openAppCollection();
            if (collection2 == null) {
                collection2 = immoToolDb.createCollection("ImmoTool");
            }
            ImmoToolDbUtils.copyCollection(collection, collection2, immoToolDb);
        }
        catch (XMLDBException xMLDBException) {
            try {
                throw new ImmoToolDbException(xMLDBException.getLocalizedMessage(), xMLDBException);
            }
            catch (Throwable throwable) {
                ImmoToolDbUtils.close(collection);
                ImmoToolDbUtils.close(collection2);
                throw throwable;
            }
        }
        ImmoToolDbUtils.close(collection);
        ImmoToolDbUtils.close(collection2);
    }

    public static ImmoToolDbSnapshot selectSnapshot(Component component, String string) throws ImmoToolDbException {
        return ImmoToolDbSnapshot.selectSnapshot(component, ImmoToolDbSnapshot.loadSnapshots(), string);
    }

    public static ImmoToolDbSnapshot selectSnapshot(Component component, ImmoToolDbSnapshot[] immoToolDbSnapshotArray, String string) throws ImmoToolDbException {
        if (immoToolDbSnapshotArray == null || immoToolDbSnapshotArray.length == 0) {
            throw new ImmoToolDbException(ImmoToolUtils.getResourceMap(ImmoToolDbSnapshot.class).getString("error.noSnapshotsFound", new Object[0]));
        }
        return (ImmoToolDbSnapshot)JOptionPane.showInputDialog(component, string, ImmoToolUtils.getResourceMap(ImmoToolDbSnapshot.class).getString("title.selectSnapshot", new Object[0]), 3, null, immoToolDbSnapshotArray, null);
    }

    public String toString() {
        if (this.getStamp() == null) {
            return ImmoToolUtils.getResourceMap(ImmoToolDbSnapshot.class).getString("label.tempSnapshot", new Object[0]);
        }
        String string = ImmoToolUtils.getResourceMap(ImmoToolDbSnapshot.class).getString("format.snapshot", new Object[0]);
        return string != null ? new SimpleDateFormat(string).format(this.getStamp()) : DateFormat.getDateTimeInstance(3, 2).format(this.getStamp());
    }
}

