/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.XQueryService;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.CompiledExpression;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.BinaryResource;
import org.xmldb.api.modules.XMLResource;

public class ImmoToolDbUtils {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolDbUtils.class);
    private static final boolean LOG_XQUERIES = false;

    public static void close(Collection collection) {
        try {
            if (collection != null) {
                collection.close();
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not close collection!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyCollection(Collection collection, Collection collection2, ImmoToolDb immoToolDb) throws XMLDBException, ImmoToolDbException {
        if (collection == null) {
            return;
        }
        for (String string : collection.listResources()) {
            ImmoToolDbUtils.copyResource(string, collection, collection2);
        }
        for (String string : collection.listChildCollections()) {
            Collection collection3 = null;
            Collection collection4 = null;
            try {
                collection3 = collection.getChildCollection(string);
                collection4 = immoToolDb.openCollection(collection2.getName() + "/" + string);
                if (collection4 == null) {
                    collection4 = immoToolDb.createCollection(collection2.getName() + "/" + string);
                }
                ImmoToolDbUtils.copyCollection(collection3, collection4, immoToolDb);
            }
            catch (Throwable throwable) {
                ImmoToolDbUtils.close(collection3);
                ImmoToolDbUtils.close(collection4);
                throw throwable;
            }
            ImmoToolDbUtils.close(collection3);
            ImmoToolDbUtils.close(collection4);
        }
    }

    public static void copyResource(String string, Collection collection, Collection collection2) throws XMLDBException, ImmoToolDbException {
        if (collection == null) {
            LOGGER.warn((Object)"Unknown source-collection!");
            return;
        }
        if (collection2 == null) {
            LOGGER.warn((Object)"Unknown destination-collection!");
            return;
        }
        Resource resource = collection.getResource(string);
        if (resource == null) {
            LOGGER.warn((Object)("Can't read resource: " + string + " from " + collection.getName()));
            return;
        }
        try {
            if (resource instanceof BinaryResource) {
                BinaryResource binaryResource = (BinaryResource)collection2.getResource(string);
                if (binaryResource == null) {
                    binaryResource = ImmoToolDbUtils.createBinaryResource(collection2, string);
                }
                binaryResource.setContent(resource.getContent());
                ((EXistResource)binaryResource).setMimeType(((EXistResource)resource).getMimeType());
                collection2.storeResource((Resource)binaryResource);
            } else if (resource instanceof XMLResource) {
                XMLResource xMLResource = (XMLResource)collection2.getResource(string);
                if (xMLResource == null) {
                    xMLResource = ImmoToolDbUtils.createXmlResource(collection2, string);
                }
                xMLResource.setContent(resource.getContent());
                ((EXistResource)xMLResource).setMimeType(((EXistResource)resource).getMimeType());
                collection2.storeResource((Resource)xMLResource);
            } else {
                LOGGER.warn((Object)("Unknown resource-type of " + string + ": " + resource.getResourceType()));
            }
        }
        catch (XMLDBException xMLDBException) {
            LOGGER.warn((Object)("Can't copy resource: " + string));
            throw xMLDBException;
        }
    }

    public static BinaryResource createBinaryResource(Collection collection, String string) throws ImmoToolDbException {
        return (BinaryResource)ImmoToolDbUtils.createResource(collection, string, "BinaryResource");
    }

    public static Resource createResource(Collection collection, String string, String string2) throws ImmoToolDbException {
        if (collection == null) {
            throw new NullPointerException("Provided collection is empty!");
        }
        try {
            return collection.createResource(string, string2);
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not create resource (" + string + "): " + exception.getLocalizedMessage(), exception);
        }
    }

    public static XMLResource createXmlResource(Collection collection, String string) throws ImmoToolDbException {
        return (XMLResource)ImmoToolDbUtils.createResource(collection, string, "XMLResource");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceSet executeXQuery(Collection collection, Reader reader) throws ImmoToolDbException, IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(reader);
            StringWriter stringWriter = new StringWriter();
            while (bufferedReader.ready()) {
                stringWriter.write(bufferedReader.readLine());
            }
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery(collection, stringWriter.toString());
            return resourceSet;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public static ResourceSet executeXQuery(Collection collection, String string) throws ImmoToolDbException {
        try {
            if (!collection.isOpen()) {
                throw new ImmoToolDbException("db-collection is closed!");
            }
            XQueryService xQueryService = (XQueryService)collection.getService("XQueryService", "1.0");
            xQueryService.setProperty("encoding", "UTF-8");
            CompiledExpression compiledExpression = xQueryService.compile(string);
            return xQueryService.execute(compiledExpression);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't execute XQuery!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()));
            LOGGER.error((Object)("> query: " + string));
            throw new ImmoToolDbException("xquery-error: " + exception.getLocalizedMessage(), exception);
        }
    }

    public static boolean hasResource(Collection collection, String string) {
        if (collection == null) {
            throw new NullPointerException("empty collection!");
        }
        String string2 = null;
        try {
            string2 = collection.getName();
            if (!collection.isOpen()) {
                throw new Exception("collection is closed!");
            }
            for (String string3 : collection.listResources()) {
                if (!string3.equals(string)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't lookup resource!");
            LOGGER.warn((Object)("> collection : " + string2));
            LOGGER.warn((Object)("> resource   : " + string));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return false;
        }
    }

    public static BinaryResource loadBinaryResource(Collection collection, String string) throws ImmoToolDbException {
        try {
            return (BinaryResource)(ImmoToolDbUtils.hasResource(collection, string) ? collection.getResource(string) : null);
        }
        catch (XMLDBException xMLDBException) {
            throw new ImmoToolDbException("could not load xml-resource: " + xMLDBException.getLocalizedMessage(), xMLDBException);
        }
    }

    public static Properties loadProperties(Collection collection, String string) throws ImmoToolDbException {
        try {
            XMLResource xMLResource = ImmoToolDbUtils.loadXMLResource(collection, string);
            if (xMLResource == null) {
                throw new Exception(string + " not found!");
            }
            return ImmoToolDbUtils.loadProperties(xMLResource);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not load properties at " + string + ": " + exception.getLocalizedMessage(), exception);
        }
    }

    public static Properties loadProperties(XMLResource xMLResource) throws ImmoToolDbException {
        try {
            Properties properties = new Properties();
            String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + SystemUtils.LINE_SEPARATOR + "<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">" + SystemUtils.LINE_SEPARATOR + (String)xMLResource.getContent();
            try {
                properties.loadFromXML(new ByteArrayInputStream(string.getBytes("UTF-8")));
            }
            catch (Exception exception) {
                LOGGER.error((Object)"xml-property-error!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                if (exception instanceof ImmoToolDbException) {
                    throw (ImmoToolDbException)exception;
                }
                throw new ImmoToolDbException("xml-property-error: " + exception.getLocalizedMessage(), exception);
            }
            return properties;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not load properties: " + exception.getLocalizedMessage(), exception);
        }
    }

    public static ResourceSet loadResourceSet(Collection collection, String string) throws ImmoToolDbException {
        try {
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery(collection, string);
            return resourceSet;
        }
        catch (ImmoToolDbException immoToolDbException) {
            LOGGER.error((Object)"could not load resource-set!");
            LOGGER.error((Object)("> " + string));
            LOGGER.error((Object)("> " + immoToolDbException.getLocalizedMessage()));
            throw immoToolDbException;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load resource-set!");
            LOGGER.error((Object)("> " + string));
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()));
            throw new ImmoToolDbException("could not load resource-set: " + exception.getLocalizedMessage(), exception);
        }
    }

    public static XMLResource loadXMLResource(Collection collection, String string) throws ImmoToolDbException {
        try {
            return (XMLResource)(ImmoToolDbUtils.hasResource(collection, string) ? collection.getResource(string) : null);
        }
        catch (XMLDBException xMLDBException) {
            throw new ImmoToolDbException("could not load xml-resource: " + xMLDBException.getLocalizedMessage(), xMLDBException);
        }
    }

    public static XMLResource loadXMLResourceByXQuery(Collection collection, String string) throws ImmoToolDbException {
        try {
            ResourceSet resourceSet = ImmoToolDbUtils.loadResourceSet(collection, string);
            if (resourceSet == null) {
                throw new ImmoToolDbException("no resource-set found for '" + string + "'");
            }
            if (resourceSet.getSize() <= 0L) {
                return null;
            }
            return (XMLResource)resourceSet.getResource(0L);
        }
        catch (XMLDBException xMLDBException) {
            throw new ImmoToolDbException("could not load resource: " + xMLDBException.getLocalizedMessage(), xMLDBException);
        }
    }

    public static void removeResource(Collection collection, Resource resource) throws ImmoToolDbException {
        try {
            collection.removeResource(resource);
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not remove resource!", exception);
        }
    }

    public static void storeProperties(Collection collection, Properties properties, String string) throws ImmoToolDbException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            properties.storeToXML((OutputStream)byteArrayOutputStream, "last update " + new Date().toString(), "UTF-8");
            String string2 = Charset.forName("UTF-8").decode(ByteBuffer.wrap(byteArrayOutputStream.toByteArray())).toString();
            XMLResource xMLResource = null;
            xMLResource = !ImmoToolDbUtils.hasResource(collection, string) ? ImmoToolDbUtils.createXmlResource(collection, string) : ImmoToolDbUtils.loadXMLResource(collection, string);
            xMLResource.setContent((Object)string2);
            ImmoToolDbUtils.storeResource(collection, (Resource)xMLResource);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not store properties at " + string + ": " + exception.getLocalizedMessage(), exception);
        }
    }

    public static void storeResource(Collection collection, Resource resource) throws ImmoToolDbException {
        try {
            collection.storeResource(resource);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not store resource!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()));
            throw new ImmoToolDbException(exception.getLocalizedMessage(), exception);
        }
    }
}

