/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.ClipboardTextWriter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class ImmoToolErrorDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolErrorDialog.class);
    private static File lastSaveLocation = null;
    private String errorMessage = null;
    private ResourceMap resourceMap;
    private JButton closeButton;
    private JTextArea errorTextArea;
    private JScrollPane errorTextScroller;
    private JButton saveButton;
    private JPopupMenu saveMenu;
    private JMenuItem saveToClipboardItem;
    private JMenuItem saveToFileItem;
    private JXTitledSeparator titleLabel;

    public ImmoToolErrorDialog() {
        this((Frame)ImmoToolApp.getApplication().getMainFrame(), true);
    }

    public ImmoToolErrorDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.build();
        this.setLocationRelativeTo(frame);
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolErrorDialog.class);
        this.setContentPane((Container)new JXPanel());
        this.initComponents();
        ImmoToolUtils.configureDialog(this, (JXPanel)this.getContentPane());
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.closeButton.setOpaque(false);
            this.saveButton.setOpaque(false);
        }
    }

    @Action
    public void doClose() {
        this.setVisible(false);
    }

    @Action
    public void doSave() {
        this.saveMenu.show(this.saveButton, 0, this.saveButton.getSize().height);
    }

    @Action
    public void doSaveToClipboard() {
        ClipboardTextWriter.writeToClipboard(this.getErrorText());
        ImmoToolUtils.showMessageInfoDialog(this.resourceMap.getString("message.protocolSavedToClipboard", new Object[0]), this.resourceMap.getString("message.saveProtocol", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Action
    public void doSaveToFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.resourceMap.getString("message.saveProtocol", new Object[0]));
        String string = "error-" + System.currentTimeMillis() + ".log";
        if (lastSaveLocation != null) {
            jFileChooser.setSelectedFile(new File(lastSaveLocation.getAbsolutePath() + File.separator + string));
        } else {
            jFileChooser.setSelectedFile(new File(string));
        }
        int n = jFileChooser.showSaveDialog(this);
        if (n != 0) {
            return;
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            File file = jFileChooser.getSelectedFile();
            ImmoToolErrorDialog.setLastSaveLocation(file.getParentFile());
            outputStreamWriter = new FileWriter(file);
            outputStreamWriter.write(this.getErrorText());
            outputStreamWriter.flush();
            ImmoToolUtils.showMessageInfoDialog(this.resourceMap.getString("message.protocolSavedToFile", new Object[]{file.getAbsolutePath()}), this.resourceMap.getString("message.saveProtocol", new Object[0]));
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant save protocol!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantSaveProtocol", new Object[0]), exception);
        }
        finally {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"cant close file!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }

    private String getErrorText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.errorTextArea.getText());
        return stringBuilder.toString();
    }

    private static synchronized void setLastSaveLocation(File file) {
        lastSaveLocation = file;
    }

    public void showDialog(String string, Throwable throwable) {
        this.errorMessage = string != null ? string.trim() : "";
        String string2 = StringUtils.abbreviate((String)this.errorMessage, (int)75);
        this.titleLabel.setTitle(!StringUtils.isEmpty((String)string2) ? string2 : this.resourceMap.getString("titleLabel.title", new Object[0]));
        this.errorTextArea.setText("");
        this.errorTextArea.append("----------------------------" + SystemUtils.LINE_SEPARATOR);
        this.errorTextArea.append(" " + this.resourceMap.getString("label.protocol.error", new Object[]{this.errorMessage}) + SystemUtils.LINE_SEPARATOR);
        this.errorTextArea.append(" " + throwable.getLocalizedMessage() + SystemUtils.LINE_SEPARATOR);
        this.errorTextArea.append("----------------------------" + SystemUtils.LINE_SEPARATOR);
        this.errorTextArea.append(ImmoToolUtils.writeException(throwable));
        this.errorTextArea.append(SystemUtils.LINE_SEPARATOR);
        this.errorTextArea.append("----------------------------" + SystemUtils.LINE_SEPARATOR);
        this.errorTextArea.append(" " + this.resourceMap.getString("label.protocol.system", new Object[0]) + SystemUtils.LINE_SEPARATOR);
        this.errorTextArea.append("----------------------------" + SystemUtils.LINE_SEPARATOR);
        TreeSet<String> treeSet = new TreeSet<String>();
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            treeSet.add((String)enumeration.nextElement());
        }
        for (String string3 : treeSet) {
            String string4 = "";
            string4 = "line.separator".equals(string3) ? string4 + SystemUtils.LINE_SEPARATOR : (string3.contains("path") ? string4 + System.getProperty(string3).replaceAll(Pattern.quote(SystemUtils.PATH_SEPARATOR), SystemUtils.PATH_SEPARATOR + " ") + SystemUtils.LINE_SEPARATOR : string4 + System.getProperty(string3) + SystemUtils.LINE_SEPARATOR);
            this.errorTextArea.append("\t" + string3 + ": " + string4);
        }
        this.errorTextArea.setCaretPosition(0);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.saveMenu = new JPopupMenu();
        this.saveToFileItem = new JMenuItem();
        this.saveToClipboardItem = new JMenuItem();
        this.titleLabel = ImmoToolUtils.createHead1Separator("");
        this.errorTextScroller = new JScrollPane();
        this.errorTextArea = new RTextArea();
        this.saveButton = new JButton();
        this.closeButton = new JButton();
        this.saveMenu.setName("saveMenu");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(ImmoToolErrorDialog.class, (Object)this);
        this.saveToFileItem.setAction(applicationActionMap.get("doSaveToFile"));
        this.saveToFileItem.setName("saveToFileItem");
        this.saveMenu.add(this.saveToFileItem);
        this.saveToClipboardItem.setAction(applicationActionMap.get("doSaveToClipboard"));
        this.saveToClipboardItem.setName("saveToClipboardItem");
        this.saveMenu.add(this.saveToClipboardItem);
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ImmoToolErrorDialog.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.titleLabel.setIcon(resourceMap.getIcon("titleLabel.icon"));
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle(resourceMap.getString("titleLabel.title", new Object[0]));
        this.errorTextScroller.setName("errorTextScroller");
        this.errorTextArea.setColumns(20);
        this.errorTextArea.setEditable(false);
        this.errorTextArea.setRows(5);
        this.errorTextArea.setTabSize(4);
        this.errorTextArea.setName("errorTextArea");
        this.errorTextScroller.setViewportView(this.errorTextArea);
        this.saveButton.setAction(applicationActionMap.get("doSave"));
        this.saveButton.setName("saveButton");
        this.closeButton.setAction(applicationActionMap.get("doClose"));
        this.closeButton.setName("closeButton");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.errorTextScroller, GroupLayout.Alignment.LEADING, -1, 483, Short.MAX_VALUE).addComponent((Component)this.titleLabel, GroupLayout.Alignment.LEADING, -1, 483, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 333, Short.MAX_VALUE).addComponent(this.closeButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorTextScroller, -1, 310, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveButton).addComponent(this.closeButton)).addContainerGap()));
        this.pack();
    }
}

