/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolFrontpageHandler;
import com.openindex.openestate.tool.ImmoToolFrontpageWidget;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.Service;
import com.openindex.openestate.tool.utils.SyndicationEntryReaderWidget;
import com.openindex.openestate.tool.utils.SyndicationFeed;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;
import org.jdesktop.swingx.calendar.DateSelectionModel;

public class ImmoToolFrontpagePanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolFrontpagePanel.class);
    private static final DateFormat DATEFORMAT = DateFormat.getDateInstance(2);
    private ResourceMap resourceMap;
    private Map<String, ImmoToolFrontpageWidget> widgets;
    private JList newsContainer;
    private DefaultListModel newsContainerModel;
    private List<SyndEntry> newsContainerList;
    private JPopupMenu widgetMenu;
    private Map<String, WidgetMenuItem> widgetMenuItems;
    private JXMonthView calendarView;
    private JDesktopPane desktopPanel;
    private JPanel infoPanel;
    private JPanel newsPanel;
    private JXTitledSeparator newsTitle;
    private JButton refreshButton;
    private JButton sidebarButton;
    private JXTitledSeparator titleLabel;
    private JButton widgetButton;

    public ImmoToolFrontpagePanel() {
        this.build();
    }

    private void build() {
        Object object;
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolFrontpagePanel.class);
        this.initComponents();
        this.desktopPanel.setOpaque(true);
        this.desktopPanel.setBackground(this.getBackground());
        this.widgets = new HashMap<String, ImmoToolFrontpageWidget>();
        this.calendarView.setSelectionBackground(ImmoToolUtils.TABLE_HIGHLIGHT_COLOR);
        this.calendarView.setFlaggedDayForeground(Color.BLUE);
        this.calendarView.setSelectionMode(DateSelectionModel.SelectionMode.SINGLE_SELECTION);
        this.calendarView.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Date date;
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1 && (date = ImmoToolFrontpagePanel.this.calendarView.getSelectionDate()) != null) {
                    ImmoToolFrontpagePanel.this.selectFlaggedDate(date);
                }
            }
        });
        this.widgetMenu = new JPopupMenu();
        this.widgetMenu.setName("widgetMenu");
        this.widgetMenuItems = new HashMap<String, WidgetMenuItem>();
        try {
            object = Service.providers(ImmoToolFrontpageWidget.class, true);
            while (object.hasNext()) {
                ImmoToolFrontpageWidget immoToolFrontpageWidget = (ImmoToolFrontpageWidget)object.next();
                WidgetMenuItem widgetMenuItem = new WidgetMenuItem(this, immoToolFrontpageWidget);
                this.widgetMenu.add(widgetMenuItem);
                this.widgetMenuItems.put(immoToolFrontpageWidget.getTitle(), widgetMenuItem);
            }
            this.widgetMenu.addSeparator();
            this.widgetMenu.add(new JMenuItem(ImmoToolUtils.getAction(this, "doShowWidgetsTiled")));
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load frontpage-widgets!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.newsContainerList = new ArrayList<SyndEntry>();
        this.newsContainerModel = new DefaultListModel();
        this.newsContainer = new JList(this.newsContainerModel);
        this.newsContainer.setFixedCellWidth(this.calendarView.getPreferredSize().width);
        this.newsContainer.setFixedCellHeight(-1);
        this.newsContainer.setCellRenderer(new ListCellRenderer(){
            JLabel label = null;

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string;
                SyndEntry syndEntry = (SyndEntry)object;
                String string2 = string = syndEntry.getDescription() != null ? ImmoToolUtils.replaceTags(syndEntry.getDescription().getValue()) : "<i>" + ImmoToolFrontpagePanel.this.resourceMap.getString("message.feedEntryIsEmpty", new Object[0]) + "</i>";
                if (syndEntry.getPublishedDate() != null) {
                    string = DATEFORMAT.format(syndEntry.getPublishedDate()) + ": " + string;
                }
                if (string.length() > 75) {
                    string = string.substring(0, 75) + "...";
                }
                boolean bl3 = false;
                if (this.label == null) {
                    bl3 = true;
                    this.label = new JLabel();
                    this.label.setOpaque(true);
                    this.label.setVerticalAlignment(1);
                    this.label.setVerticalTextPosition(1);
                }
                this.label.setBackground(n % 2 == 0 ? ImmoToolUtils.TABLE_HIGHLIGHT_COLOR : Color.WHITE);
                this.label.setBackground(bl ? jList.getSelectionBackground() : this.label.getBackground());
                this.label.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
                String string3 = "#" + Integer.toHexString(this.label.getForeground().getRed()) + Integer.toHexString(this.label.getForeground().getGreen()) + Integer.toHexString(this.label.getForeground().getBlue());
                this.label.setText("<html><div style=\"padding:3px; font-family:sans-serif; color:" + string3 + "\">" + "<b>" + syndEntry.getTitle() + "</b>" + "<div style=\"white-space:normal;\">" + string + "</div>" + "</div></html>");
                if (bl3) {
                    this.label.setPreferredSize(new Dimension(50, this.label.getPreferredSize().height * 2));
                }
                return this.label;
            }
        });
        this.newsContainer.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ImmoToolFrontpagePanel.this.newsContainerModel.getSize() <= 0) {
                    return;
                }
                if (ImmoToolFrontpagePanel.this.newsContainer.isSelectionEmpty()) {
                    return;
                }
                ImmoToolTask<SyndicationEntryReaderWidget> immoToolTask = new ImmoToolTask<SyndicationEntryReaderWidget>(){

                    @Override
                    protected SyndicationEntryReaderWidget executeTask() throws Exception {
                        SyndicationFeed syndicationFeed = ImmoToolApp.getApplicationFeed();
                        SyndEntry syndEntry = (SyndEntry)ImmoToolFrontpagePanel.this.newsContainer.getSelectedValue();
                        String string = SyndicationEntryReaderWidget.getInstanceTitle(syndicationFeed.getTitle());
                        SyndicationEntryReaderWidget syndicationEntryReaderWidget = (SyndicationEntryReaderWidget)ImmoToolFrontpagePanel.this.getWidget(string);
                        if (syndicationEntryReaderWidget == null) {
                            syndicationEntryReaderWidget = new SyndicationEntryReaderWidget(syndicationFeed.getTitle());
                        }
                        syndicationEntryReaderWidget.setEntry(syndEntry);
                        syndicationEntryReaderWidget.reload();
                        return syndicationEntryReaderWidget;
                    }

                    @Override
                    protected void failed(Throwable throwable) {
                        super.failed(throwable);
                        ImmoToolUtils.showMessageErrorDialog(ImmoToolFrontpagePanel.this.resourceMap.getString("error.cantLoadNewsEntry", new Object[0]), throwable);
                    }

                    @Override
                    protected void succeeded(SyndicationEntryReaderWidget syndicationEntryReaderWidget) {
                        super.succeeded(syndicationEntryReaderWidget);
                        ImmoToolFrontpagePanel.this.showWidget(syndicationEntryReaderWidget);
                        ImmoToolFrontpagePanel.this.newsContainer.requestFocus();
                    }
                };
                ImmoToolUtils.executeTask(immoToolTask);
            }
        });
        object = new JScrollPane(this.newsContainer);
        ((JComponent)object).setBorder(Borders.EMPTY);
        this.newsPanel.setOpaque(false);
        this.newsPanel.setLayout(new BorderLayout());
        this.newsPanel.add((Component)object, "Center");
        this.writeProgramCalendar();
        this.writeProgramNews(ImmoToolApp.getApplicationFeed(), false);
        this.newsContainerModel.removeAllElements();
        for (SyndEntry syndEntry : this.newsContainerList) {
            this.newsContainerModel.addElement(syndEntry);
        }
    }

    @Action
    public Task doRefresh() {
        this.refreshButton.setEnabled(false);
        this.newsContainerModel.removeAllElements();
        return new ImmoToolTask<Boolean>(){

            @Override
            protected Boolean executeTask() throws Exception {
                ImmoToolFrontpagePanel.this.refresh();
                return true;
            }

            @Override
            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog(ImmoToolFrontpagePanel.this.resourceMap.getString("error.cantRefreshDesktop", new Object[0]), throwable);
            }

            @Override
            protected void finished() {
                super.finished();
                ImmoToolFrontpagePanel.this.refreshButton.setEnabled(true);
                for (SyndEntry syndEntry : ImmoToolFrontpagePanel.this.newsContainerList) {
                    ImmoToolFrontpagePanel.this.newsContainerModel.addElement(syndEntry);
                }
            }
        };
    }

    @Action
    public void doShowWidgetMenu() {
        this.widgetMenu.show(this.widgetButton, 0, this.widgetButton.getSize().height);
    }

    @Action
    public void doShowWidgetsTiled() {
        this.tile();
    }

    @Action
    public void doToggleSidebar() {
        this.infoPanel.setVisible(!this.infoPanel.isVisible());
    }

    public static String getInstanceTabTitle() {
        return ImmoToolUtils.getResourceMap(ImmoToolFrontpagePanel.class).getString("tabTitle", new Object[0]);
    }

    @Override
    public String getTabInfo() {
        return this.resourceMap.getString("tabInfo", new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return ImmoToolFrontpagePanel.getInstanceTabTitle();
    }

    public ImmoToolFrontpageWidget getWidget(String string) {
        return this.widgets.containsKey(string) ? this.widgets.get(string) : null;
    }

    public void hideWidget(ImmoToolFrontpageWidget immoToolFrontpageWidget) {
        immoToolFrontpageWidget.setVisible(false);
    }

    private void refresh() {
        this.writeProgramCalendar();
        this.writeProgramNews(ImmoToolApp.getApplicationFeed(), true);
        for (ImmoToolFrontpageWidget immoToolFrontpageWidget : this.widgets.values()) {
            immoToolFrontpageWidget.reload();
        }
    }

    @Override
    public void refreshTab() {
        ImmoToolUtils.executeTask(this.doRefresh());
    }

    private void selectFlaggedDate(Date date) {
        try {
            Iterator<Object> iterator = Service.providers(ImmoToolFrontpageHandler.class, true);
            while (iterator.hasNext()) {
                ImmoToolFrontpageHandler immoToolFrontpageHandler = (ImmoToolFrontpageHandler)iterator.next();
                immoToolFrontpageHandler.setFrontpagePanel(this);
                if (!immoToolFrontpageHandler.isUsable() || !immoToolFrontpageHandler.selectFlaggedDate(date)) continue;
                break;
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void showWidget(final ImmoToolFrontpageWidget immoToolFrontpageWidget) {
        final String string = immoToolFrontpageWidget.getTitle();
        immoToolFrontpageWidget.showWidget();
        if (!this.widgets.containsKey(string) || this.widgets.get(string).isClosed()) {
            int n = 0;
            for (ImmoToolFrontpageWidget immoToolFrontpageWidget2 : this.widgets.values()) {
                if (!immoToolFrontpageWidget2.isVisible()) continue;
                ++n;
            }
            int n2 = 30 * (n % 10);
            int n3 = 30 * (n % 10);
            int n4 = this.desktopPanel.getSize().width - n2 - 1;
            int n5 = this.desktopPanel.getSize().height / 2;
            immoToolFrontpageWidget.setBounds(n2, n3, n4, n5);
            immoToolFrontpageWidget.setDefaultCloseOperation(0);
            immoToolFrontpageWidget.addInternalFrameListener(new InternalFrameListener(){

                @Override
                public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                }

                @Override
                public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
                    if (ImmoToolFrontpagePanel.this.widgetMenuItems.containsKey(string)) {
                        ((WidgetMenuItem)ImmoToolFrontpagePanel.this.widgetMenuItems.get(string)).setSelected(true);
                    }
                }

                @Override
                public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                    immoToolFrontpageWidget.setVisible(false);
                    if (ImmoToolFrontpagePanel.this.widgetMenuItems.containsKey(string)) {
                        ((WidgetMenuItem)ImmoToolFrontpagePanel.this.widgetMenuItems.get(string)).setSelected(false);
                    }
                }

                @Override
                public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
                    if (ImmoToolFrontpagePanel.this.widgetMenuItems.containsKey(string)) {
                        ((WidgetMenuItem)ImmoToolFrontpagePanel.this.widgetMenuItems.get(string)).setSelected(false);
                    }
                }

                @Override
                public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
                    if (ImmoToolFrontpagePanel.this.widgetMenuItems.containsKey(string)) {
                        ((WidgetMenuItem)ImmoToolFrontpagePanel.this.widgetMenuItems.get(string)).setSelected(true);
                    }
                }

                @Override
                public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                }

                @Override
                public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
                }
            });
            ImmoToolUtils.executeTask(immoToolFrontpageWidget.doLoad());
            this.desktopPanel.add(immoToolFrontpageWidget);
            this.widgets.put(immoToolFrontpageWidget.getTitle(), immoToolFrontpageWidget);
        }
        try {
            if (immoToolFrontpageWidget.isIcon()) {
                immoToolFrontpageWidget.setIcon(false);
            }
            if (!immoToolFrontpageWidget.isVisible()) {
                immoToolFrontpageWidget.setVisible(true);
            }
            immoToolFrontpageWidget.moveToFront();
            immoToolFrontpageWidget.setSelected(true);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("problem while displaying widget: " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    private void tile() {
        JInternalFrame[] jInternalFrameArray = this.desktopPanel.getAllFrames();
        if (jInternalFrameArray.length == 0) {
            return;
        }
        this.tile(jInternalFrameArray, this.desktopPanel.getBounds());
    }

    private void tile(JInternalFrame[] jInternalFrameArray, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = (int)Math.sqrt(jInternalFrameArray.length);
        int n6 = jInternalFrameArray.length - n5 * ((n4 = (int)Math.ceil((double)jInternalFrameArray.length / (double)n5)) - 1);
        if (n6 == 0) {
            n3 = rectangle.height / --n4;
        } else {
            n3 = rectangle.height / n4;
            if (n6 < n5) {
                --n4;
                n2 = rectangle.width / n6;
                for (n = 0; n < n6; ++n) {
                    jInternalFrameArray[n5 * n4 + n].setBounds(n * n2, n4 * n3, n2, n3);
                }
            }
        }
        n2 = rectangle.width / n5;
        for (n = 0; n < n4; ++n) {
            for (int i = 0; i < n5; ++i) {
                jInternalFrameArray[i + n * n5].setBounds(i * n2, n * n3, n2, n3);
            }
        }
    }

    private void writeProgramCalendar() {
        this.calendarView.setFlaggedDates(new Date[0]);
        ArrayList<Date> arrayList = new ArrayList<Date>();
        try {
            Iterator<Object> iterator = Service.providers(ImmoToolFrontpageHandler.class, true);
            while (iterator.hasNext()) {
                ImmoToolFrontpageHandler immoToolFrontpageHandler = (ImmoToolFrontpageHandler)iterator.next();
                immoToolFrontpageHandler.setFrontpagePanel(this);
                if (!immoToolFrontpageHandler.isUsable()) continue;
                int n = this.calendarView.getCalendar().get(1);
                int n2 = this.calendarView.getCalendar().get(2);
                arrayList.addAll(immoToolFrontpageHandler.getFlaggedDates(n, n2));
            }
            if (!arrayList.isEmpty()) {
                this.calendarView.setFlaggedDates(arrayList.toArray(new Date[arrayList.size()]));
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load calendar!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    private void writeProgramNews(SyndicationFeed syndicationFeed, boolean bl) {
        try {
            SyndFeed syndFeed;
            this.newsContainerList.clear();
            SyndFeed syndFeed2 = syndFeed = !bl ? syndicationFeed.loadSyndFeed() : null;
            if (syndFeed == null) {
                try {
                    HttpClient httpClient = ImmoToolUtils.createHttpClient();
                    syndFeed = syndicationFeed.loadSyndFeedExternal(httpClient, true);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not load syndication-feed from external source!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
                }
            }
            if (syndFeed == null) {
                return;
            }
            this.newsContainerList.addAll(Arrays.asList(SyndicationFeed.getSyndFeedEntries(syndFeed)));
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load syndication-feed!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator("");
        this.refreshButton = new JButton();
        this.widgetButton = new JButton();
        this.sidebarButton = new JButton();
        this.desktopPanel = new JDesktopPane();
        this.infoPanel = new JXPanel();
        this.calendarView = new JXMonthView();
        this.newsTitle = ImmoToolUtils.createHead2Separator("");
        this.newsPanel = new JPanel();
        this.setName("Form");
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ImmoToolFrontpagePanel.class);
        this.titleLabel.setIcon(resourceMap.getIcon("titleLabel.icon"));
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle(resourceMap.getString("titleLabel.title", new Object[0]));
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(ImmoToolFrontpagePanel.class, (Object)this);
        this.refreshButton.setAction(applicationActionMap.get("doRefresh"));
        this.refreshButton.setName("refreshButton");
        this.widgetButton.setAction(applicationActionMap.get("doShowWidgetMenu"));
        this.widgetButton.setName("widgetButton");
        this.sidebarButton.setAction(applicationActionMap.get("doToggleSidebar"));
        this.sidebarButton.setName("sidebarButton");
        this.desktopPanel.setBorder(BorderFactory.createLineBorder(new Color(128, 128, 128)));
        this.desktopPanel.setName("desktopPanel");
        this.infoPanel.setBackground(Color.white);
        this.infoPanel.setBorder(BorderFactory.createLineBorder(new Color(128, 128, 128)));
        this.infoPanel.setName("infoPanel");
        this.calendarView.setBoxPaddingX(5);
        this.calendarView.setBoxPaddingY(3);
        this.calendarView.setName("calendarView");
        this.calendarView.setOpaque(false);
        this.calendarView.setShowingLeadingDays(true);
        this.calendarView.setShowingTrailingDays(true);
        this.calendarView.setTraversable(true);
        this.calendarView.setZoomable(true);
        this.newsTitle.setName("newsTitle");
        this.newsTitle.setTitle(resourceMap.getString("newsTitle.title", new Object[0]));
        this.newsPanel.setName("newsPanel");
        this.newsPanel.setOpaque(false);
        GroupLayout groupLayout = new GroupLayout(this.newsPanel);
        this.newsPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 231, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 262, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this.infoPanel);
        this.infoPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.newsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.newsTitle, GroupLayout.Alignment.TRAILING, -1, 231, Short.MAX_VALUE).addComponent((Component)this.calendarView, -1, 231, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.calendarView, -2, -1, -2).addGap(12, 12, 12).addComponent((Component)this.newsTitle, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newsPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        GroupLayout groupLayout3 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 567, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.widgetButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sidebarButton)).addGroup(groupLayout3.createSequentialGroup().addComponent(this.desktopPanel, -1, 547, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoPanel, -2, -1, -2))).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sidebarButton).addComponent(this.widgetButton).addComponent(this.refreshButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.desktopPanel, -1, 495, Short.MAX_VALUE).addComponent(this.infoPanel, -1, -1, Short.MAX_VALUE)).addGap(12, 12, 12)));
    }

    private static final class WidgetMenuItem
    extends JCheckBoxMenuItem {
        private ImmoToolFrontpagePanel frontpage;
        private ImmoToolFrontpageWidget widget;

        public WidgetMenuItem(ImmoToolFrontpagePanel immoToolFrontpagePanel, ImmoToolFrontpageWidget immoToolFrontpageWidget) {
            super(immoToolFrontpageWidget.getTitle());
            this.frontpage = immoToolFrontpagePanel;
            this.widget = immoToolFrontpageWidget;
            this.setOpaque(true);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (WidgetMenuItem.this.isSelected()) {
                        WidgetMenuItem.this.frontpage.showWidget(WidgetMenuItem.this.widget);
                    } else {
                        WidgetMenuItem.this.frontpage.hideWidget(WidgetMenuItem.this.widget);
                    }
                }
            });
        }

        public ImmoToolFrontpageWidget getWidget() {
            return this.widget;
        }
    }
}

