/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.engine.PlugEngine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.event.HelpHistoryModelEvent;
import javax.help.event.HelpHistoryModelListener;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class ImmoToolHelpDialog
extends JDialog {
    private static Logger LOGGER = Logger.getLogger(ImmoToolHelpDialog.class);
    private ResourceMap resourceMap;
    private ActionMap actionMap;
    private JHelp helpComponent;
    private final boolean externallyStarted;
    private JXPanel bgPanel;
    private JButton closeButton;
    private JXPanel helpPanel;
    private JButton historyBackButton;
    private JButton historyNextButton;
    private JXTitledSeparator titleLabel;

    public ImmoToolHelpDialog() {
        this((Frame)ImmoToolApp.getApplication().getMainFrame(), true);
    }

    public ImmoToolHelpDialog(Frame frame, boolean bl) {
        this(frame, bl, ImmoToolApp.getApplication().getHelpSet(), false);
    }

    private ImmoToolHelpDialog(Frame frame, boolean bl, HelpSet helpSet, boolean bl2) {
        super(frame, bl);
        this.externallyStarted = bl2;
        this.build(helpSet);
    }

    private void build(HelpSet helpSet) {
        if (this.externallyStarted) {
            ApplicationContext applicationContext = Application.getInstance().getContext();
            this.actionMap = applicationContext.getActionMap(ImmoToolHelpDialog.class, (Object)this);
            this.resourceMap = applicationContext.getResourceMap(ImmoToolHelpDialog.class);
        } else {
            this.actionMap = ImmoToolUtils.getActionMap(ImmoToolHelpDialog.class, this);
            this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolHelpDialog.class);
        }
        this.initComponents();
        this.resourceMap.injectComponents((Component)this);
        this.setSize(800, 600);
        this.setResizable(true);
        this.helpComponent = new JHelp(helpSet);
        this.helpComponent.setToolbarDisplayed(false);
        this.helpComponent.setOpaque(false);
        this.helpComponent.getHistoryModel().addHelpHistoryModelListener(new HelpHistoryModelListener(){

            public void historyChanged(HelpHistoryModelEvent helpHistoryModelEvent) {
                int n = ImmoToolHelpDialog.this.helpComponent.getHistoryModel().getIndex();
                int n2 = ImmoToolHelpDialog.this.helpComponent.getHistoryModel().getHistory().size();
                ImmoToolHelpDialog.this.historyBackButton.setEnabled(n > 0);
                ImmoToolHelpDialog.this.historyNextButton.setEnabled(n + 1 < n2);
            }
        });
        this.helpPanel.setOpaque(false);
        this.helpPanel.setLayout((LayoutManager)new BorderLayout());
        this.helpPanel.add((Component)this.helpComponent, (Object)"Center");
        this.helpPanel.revalidate();
        this.helpPanel.repaint();
        this.historyBackButton.setAction(this.actionMap.get(this.historyBackButton.getText()));
        this.historyNextButton.setAction(this.actionMap.get(this.historyNextButton.getText()));
        this.closeButton.setAction(this.actionMap.get(this.closeButton.getText()));
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.historyBackButton.setOpaque(false);
            this.historyNextButton.setOpaque(false);
            this.closeButton.setOpaque(false);
            this.helpPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        }
        ImmoToolUtils.configureDialog(this, this.bgPanel);
    }

    @Action
    public void doClose() {
        if (this.externallyStarted) {
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    @Action
    public void doHistoryBack() {
        this.helpComponent.getHistoryModel().goBack();
    }

    @Action
    public void doHistoryNext() {
        this.helpComponent.getHistoryModel().goForward();
    }

    @Action
    public void doIndex() {
        this.helpComponent.setCurrentID("app.index");
    }

    public JHelp getHelp() {
        return this.helpComponent;
    }

    public void setHelpId(String string) {
        this.helpComponent.setCurrentID(string);
    }

    private void initComponents() {
        this.bgPanel = new JXPanel();
        this.helpPanel = new JXPanel();
        this.titleLabel = ImmoToolUtils.createHead1Separator("");
        this.historyBackButton = new JButton();
        this.historyNextButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.bgPanel.setName("bgPanel");
        this.helpPanel.setName("helpPanel");
        this.helpPanel.setOpaque(false);
        GroupLayout groupLayout = new GroupLayout((Container)this.helpPanel);
        this.helpPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 596, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 405, Short.MAX_VALUE));
        this.titleLabel.setIcon((Icon)new ImageIcon(this.getClass().getResource("/com/openindex/openestate/tool/resources/icons/32x32/help.png")));
        this.titleLabel.setTitle("Anwenderhandbuch");
        this.historyBackButton.setText("doHistoryBack");
        this.historyBackButton.setName("historyBackButton");
        this.historyNextButton.setText("doHistoryNext");
        this.historyNextButton.setName("historyNextButton");
        this.closeButton.setText("doClose");
        this.closeButton.setName("closeButton");
        GroupLayout groupLayout2 = new GroupLayout((Container)this.bgPanel);
        this.bgPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.helpPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 210, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.historyBackButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.historyNextButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.closeButton).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.historyNextButton).addComponent(this.historyBackButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.helpPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.bgPanel, -1, -1, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.bgPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    public static void main(String[] stringArray) {
        URL uRL;
        System.setProperty("file.encoding", "UTF-8");
        System.setProperty("http.agent", ImmoToolApp.getApplicationTitle() + "/" + ImmoToolApp.getApplicationVersion());
        DOMConfigurator.configure((URL)ImmoToolApp.class.getResource("/com/openindex/openestate/tool/resources/log4j.xml"));
        LOGGER.info((Object)"init logging...");
        File file = new File(ImmoToolApp.APP_LOG_DIR);
        if (!file.exists() && !file.mkdirs()) {
            LOGGER.error((Object)"could not create log-directory!");
            LOGGER.error((Object)("> " + file.getPath()));
            System.exit(1);
        } else if (!file.isDirectory()) {
            LOGGER.error((Object)"log-directory is invalid!");
            LOGGER.error((Object)("> " + file.getPath()));
            System.exit(1);
        } else if (!file.canWrite()) {
            LOGGER.error((Object)"log-directory is not writable!");
            LOGGER.error((Object)("> " + file.getPath()));
            System.exit(1);
        }
        try {
            LOGGER.info((Object)"init plugins...");
            PlugEngine.getInstance().init(new Object[0]);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not init plugins!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        LOGGER.info((Object)"init help-system...");
        HelpSet helpSet = new HelpSet();
        try {
            uRL = ImmoToolHelpDialog.class.getResource("/com/openindex/openestate/tool/resources/help/help.hs");
            helpSet = new HelpSet(null, uRL);
            for (String string : ImmoToolUtils.getPluginNames()) {
                try {
                    HelpSet helpSet2 = ImmoToolUtils.getPlugin(string).createHelpSet();
                    if (helpSet2 == null) continue;
                    LOGGER.info((Object)("> add " + string));
                    helpSet.add(helpSet2);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not load plugin-helpset!");
                    LOGGER.warn((Object)exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load HelpSet!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        LOGGER.info((Object)"show help-dialog...");
        uRL = helpSet;
        SwingUtilities.invokeLater(new Runnable((HelpSet)uRL){
            final /* synthetic */ HelpSet val$myHelpSet;
            {
                this.val$myHelpSet = helpSet;
            }

            @Override
            public void run() {
                ImmoToolHelpDialog immoToolHelpDialog = new ImmoToolHelpDialog(null, true, this.val$myHelpSet, true);
                immoToolHelpDialog.setDefaultCloseOperation(2);
                immoToolHelpDialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                immoToolHelpDialog.setVisible(true);
            }
        });
    }
}

