/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolLanguagePack;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ImmoToolLanguageComboBox
extends JComboBox {
    public ImmoToolLanguageComboBox() {
        this.setRenderer(new Renderer());
        this.setModel(new Model());
        for (ImmoToolLanguagePack immoToolLanguagePack : ImmoToolLanguagePack.listAvailableLanguagePacks().values()) {
            ((Model)this.getModel()).addLanguagePack(immoToolLanguagePack);
        }
    }

    public ImmoToolLanguagePack getLanguagePackAt(int n) {
        return ((Model)this.getModel()).getLanguagePackAt(n);
    }

    public ImmoToolLanguagePack getSelectedLanguagePack() {
        return this.getSelectedIndex() >= 0 ? this.getLanguagePackAt(this.getSelectedIndex()) : null;
    }

    public static class Renderer
    extends JLabel
    implements ListCellRenderer {
        public Renderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof ImmoToolLanguagePack) {
                ImmoToolLanguagePack immoToolLanguagePack = (ImmoToolLanguagePack)object;
                this.setIcon(new ImageIcon(immoToolLanguagePack.getFlag()));
                this.setText(immoToolLanguagePack.getLocale().getDisplayLanguage(immoToolLanguagePack.getLocale()) + " / " + immoToolLanguagePack.getLocale().getDisplayLanguage());
            } else {
                this.setIcon(null);
                this.setText("???");
            }
            return this;
        }
    }

    public static class Model
    extends DefaultComboBoxModel {
        public void addLanguagePack(ImmoToolLanguagePack immoToolLanguagePack) {
            this.addElement(immoToolLanguagePack);
        }

        public ImmoToolLanguagePack getLanguagePackAt(int n) {
            return (ImmoToolLanguagePack)this.getElementAt(n);
        }
    }
}

