/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolLanguageComboBox;
import com.openindex.openestate.tool.ImmoToolLanguagePack;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class ImmoToolLanguageDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolLanguageDialog.class);
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_CANCELLED = 1;
    public static final int STATUS_APPROVED = 2;
    private int status = 0;
    private Locale initialLocale;
    private ResourceMap resourceMap;
    private JButton cancelButton;
    private JLabel infoLabel;
    private JComboBox languageBox;
    private JXTitledSeparator languageTitle;
    private JButton submitButton;
    private JXTitledSeparator titleLabel;

    public ImmoToolLanguageDialog() {
        this(ImmoToolApp.getApplication().getMainFrame());
    }

    public ImmoToolLanguageDialog(Frame frame) {
        super(frame, true);
        this.build();
    }

    private void build() {
        this.initialLocale = Locale.getDefault();
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolLanguageDialog.class);
        this.setContentPane((Container)new JXPanel());
        this.initComponents();
        ImmoToolLanguagePack immoToolLanguagePack = null;
        ImmoToolLanguagePack immoToolLanguagePack2 = null;
        for (int i = 0; i < this.languageBox.getItemCount(); ++i) {
            ImmoToolLanguagePack immoToolLanguagePack3 = ((ImmoToolLanguageComboBox)this.languageBox).getLanguagePackAt(i);
            if (immoToolLanguagePack2 == null && Locale.GERMAN.getLanguage().equalsIgnoreCase(immoToolLanguagePack3.getLocale().getLanguage())) {
                immoToolLanguagePack2 = immoToolLanguagePack3;
            }
            if (immoToolLanguagePack != null || !Locale.getDefault().getLanguage().equalsIgnoreCase(immoToolLanguagePack3.getLocale().getLanguage())) continue;
            immoToolLanguagePack = immoToolLanguagePack3;
        }
        if (immoToolLanguagePack != null) {
            this.languageBox.setSelectedItem(immoToolLanguagePack);
        } else if (immoToolLanguagePack2 != null) {
            this.languageBox.setSelectedItem(immoToolLanguagePack2);
        } else {
            this.languageBox.setSelectedIndex(-1);
        }
        this.languageBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImmoToolLanguageDialog.this.retranslate();
            }
        });
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.cancelButton.setOpaque(false);
            this.submitButton.setOpaque(false);
        }
        ImmoToolUtils.configureDialog(this, (JXPanel)this.getContentPane());
    }

    @Action
    public void doCancel() {
        ImmoToolUtils.setLocale(this.initialLocale);
        this.status = 1;
        this.setVisible(false);
    }

    @Action
    public void doSubmit() {
        this.status = 2;
        this.setVisible(false);
    }

    public int getStatus() {
        return this.status;
    }

    private void retranslate() {
        ImmoToolLanguagePack immoToolLanguagePack = ((ImmoToolLanguageComboBox)this.languageBox).getSelectedLanguagePack();
        if (immoToolLanguagePack == null) {
            LOGGER.warn((Object)"Can't change language-pack!");
            return;
        }
        LOGGER.debug((Object)("Change langauge pack: " + immoToolLanguagePack.getLocale()));
        ImmoToolUtils.setLocale(immoToolLanguagePack.getLocale());
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolLanguageDialog.class);
        this.resourceMap.injectComponents((Component)this);
        this.cancelButton.setText(this.resourceMap.getString("doCancel.Action.text", new Object[0]));
        this.cancelButton.setToolTipText(this.resourceMap.getString("doCancel.Action.shortDescription", new Object[0]));
        this.submitButton.setText(this.resourceMap.getString("doSubmit.Action.text", new Object[0]));
        this.submitButton.setToolTipText(this.resourceMap.getString("doSubmit.Action.shortDescription", new Object[0]));
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator("");
        this.infoLabel = new JLabel();
        this.languageTitle = ImmoToolUtils.createHead2Separator("");
        this.languageBox = new ImmoToolLanguageComboBox();
        this.cancelButton = new JButton();
        this.submitButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setName("Form");
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ImmoToolLanguageDialog.class);
        this.titleLabel.setIcon(resourceMap.getIcon("titleLabel.icon"));
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle(resourceMap.getString("titleLabel.title", new Object[0]));
        this.infoLabel.setText(resourceMap.getString("infoLabel.text", new Object[0]));
        this.infoLabel.setName("infoLabel");
        this.languageTitle.setName("languageTitle");
        this.languageTitle.setTitle(resourceMap.getString("languageTitle.title", new Object[0]));
        this.languageBox.setName("languageBox");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(ImmoToolLanguageDialog.class, (Object)this);
        this.cancelButton.setAction(applicationActionMap.get("doCancel"));
        this.cancelButton.setName("cancelButton");
        this.submitButton.setAction(applicationActionMap.get("doSubmit"));
        this.submitButton.setName("submitButton");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.infoLabel, GroupLayout.Alignment.TRAILING, -1, 395, Short.MAX_VALUE).addComponent((Component)this.titleLabel, GroupLayout.Alignment.TRAILING, -1, 395, Short.MAX_VALUE).addComponent((Component)this.languageTitle, -1, 395, Short.MAX_VALUE).addComponent(this.languageBox, 0, 395, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 245, Short.MAX_VALUE).addComponent(this.submitButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.languageTitle, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.languageBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 107, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.submitButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }
}

