/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolLanguagePack_de;
import com.openindex.openestate.tool.ImmoToolPlugin;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.engine.PlugEngine;
import com.openindex.openestate.tool.utils.engine.Pluggable;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public abstract class ImmoToolLanguagePack
extends ImmoToolPlugin {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolLanguagePack.class);
    private ResourceMap resourceMap = null;
    private Locale packLocale;
    private URI packUri;
    private String packFlagResource;
    private String packVersion;
    private String packAuthor;
    private String packWebsite;
    private BufferedImage packFlag = null;
    private BufferedImage packIcon = null;

    protected ImmoToolLanguagePack(Locale locale, String string, String string2, String string3, String string4, String string5) throws MalformedURLException, URISyntaxException {
        this(locale, new URL(string).toURI(), string2, string3, string4, string5);
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolLanguagePack.class);
    }

    protected ImmoToolLanguagePack(Locale locale, URI uRI, String string, String string2, String string3, String string4) {
        this.packLocale = locale;
        this.packUri = uRI;
        this.packFlagResource = string;
        this.packVersion = string2;
        this.packAuthor = string3;
        this.packWebsite = string4;
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getAuthor() {
        return this.packAuthor;
    }

    @Override
    public String getDescription() {
        return this.resourceMap.getString("label.description", new Object[]{this.packLocale.getDisplayLanguage()});
    }

    public BufferedImage getFlag() {
        if (this.packFlagResource == null || this.packFlagResource.trim().length() == 0) {
            return null;
        }
        if (this.packFlag != null) {
            return this.packFlag;
        }
        try {
            this.packFlag = ImageIO.read(this.getClass().getResourceAsStream(this.packFlagResource.trim()));
            return this.packFlag;
        }
        catch (Exception exception) {
            this.packFlag = null;
            LOGGER.error((Object)"could not load language-pack-icon!");
            LOGGER.error((Object)("> " + this.packFlagResource));
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    @Override
    public BufferedImage getIcon() {
        if (this.packFlagResource == null || this.packFlagResource.trim().length() == 0) {
            return null;
        }
        if (this.packIcon != null) {
            return this.packIcon;
        }
        try {
            BufferedImage bufferedImage = this.getFlag();
            if (bufferedImage == null) {
                return null;
            }
            BufferedImage bufferedImage2 = ImageIO.read(ImmoToolLanguagePack.class.getResource("/com/openindex/openestate/tool/resources/icons/32x32/ImmoTool.png"));
            if (bufferedImage2 == null) {
                return null;
            }
            this.packIcon = new BufferedImage(40, 40, 2);
            Graphics2D graphics2D = this.packIcon.createGraphics();
            graphics2D.drawImage(bufferedImage2, 4, 4, 32, 32, null);
            graphics2D.drawImage(bufferedImage, 22, 27, 16, 11, null);
            return this.packIcon;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load language-pack-icon!");
            LOGGER.error((Object)("> " + this.packFlagResource));
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    @Override
    public String getLicense() {
        return this.resourceMap.getString("default.license", new Object[0]);
    }

    public Locale getLocale() {
        return this.packLocale;
    }

    @Override
    public int getMinimalVersion() {
        return ImmoToolApp.getApplicationApiVersion();
    }

    @Override
    public String getName() {
        return "OpenEstate-i18n-" + this.packLocale.toString();
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("label.name", new Object[]{this.packLocale.getDisplayLanguage()});
    }

    @Override
    public URI getURI() {
        return this.packUri;
    }

    @Override
    public String getVersion() {
        return this.packVersion;
    }

    @Override
    public String getWebsite() {
        return this.packWebsite;
    }

    @Override
    public boolean hasOptions() {
        return false;
    }

    @Override
    public void init(Object ... objectArray) {
    }

    public static Map<String, ImmoToolLanguagePack> listAvailableLanguagePacks() {
        return ImmoToolLanguagePack.listAvailableLanguagePacks(ImmoToolApp.getApplication().getProject() == null);
    }

    public static Map<String, ImmoToolLanguagePack> listAvailableLanguagePacks(boolean bl) {
        TreeMap<String, ImmoToolLanguagePack> treeMap = new TreeMap<String, ImmoToolLanguagePack>();
        try {
            ImmoToolLanguagePack_de immoToolLanguagePack_de = new ImmoToolLanguagePack_de();
            treeMap.put(immoToolLanguagePack_de.getName(), immoToolLanguagePack_de);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load default language-pack!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        for (Pluggable pluggable : PlugEngine.getInstance().getAllPluggables()) {
            if (!bl && !PlugEngine.getInstance().isEnabled(pluggable) || !(pluggable instanceof ImmoToolLanguagePack)) continue;
            treeMap.put(pluggable.getName(), (ImmoToolLanguagePack)pluggable);
        }
        return treeMap;
    }

    @Override
    public void openOptions() {
    }
}

