/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolLicenseSetupDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.Calendar;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class ImmoToolLicenseReminderDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolLicenseReminderDialog.class);
    public static final int OPENED = 0;
    public static final int CANCELLED = 1;
    public static final int CANCELLED_AND_REMIND = 2;
    public static final int APPROVED = 3;
    private int status = 0;
    private ResourceMap resourceMap;
    private JButton cancelButton;
    private JXHyperlink customerWebsiteLink;
    private JButton helpButton;
    private JTextField licenseKeyField;
    private JXLabel reasonInfoLabel;
    private JXTitledSeparator reasonLabel;
    private JButton step1Button;
    private JXTitledSeparator step1Label;
    private JButton step2Button;
    private JXTitledSeparator step2Label;
    private JButton submitButton;
    private JXLabel titleInfoLabel;
    private JXTitledSeparator titleLabel;

    public ImmoToolLicenseReminderDialog() {
        this((Frame)ImmoToolApp.getApplication().getMainFrame(), true);
    }

    public ImmoToolLicenseReminderDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.build();
    }

    private void build() {
        this.setContentPane((Container)new JXPanel());
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolLicenseReminderDialog.class);
        this.initComponents();
        this.titleInfoLabel.setText(this.resourceMap.getString("titleInfoLabel.text", new Object[]{"http://dev.openestate.org/"}));
        this.reasonInfoLabel.setText(this.resourceMap.getString("reasonInfoLabel.text", new Object[]{"http://dev.openestate.org/"}));
        ImmoToolUtils.configureDialog(this, (JXPanel)this.getContentPane());
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.step1Button.setOpaque(false);
            this.step2Button.setOpaque(false);
            this.submitButton.setOpaque(false);
            this.cancelButton.setOpaque(false);
            this.helpButton.setOpaque(false);
        }
    }

    public int getStatus() {
        return this.status;
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator("");
        this.titleInfoLabel = new JXLabel();
        this.reasonLabel = ImmoToolUtils.createHead2Separator("");
        this.reasonInfoLabel = new JXLabel();
        this.step1Label = ImmoToolUtils.createHead2Separator("");
        this.step1Button = new JButton();
        this.step2Label = ImmoToolUtils.createHead2Separator("");
        this.step2Button = new JButton();
        this.licenseKeyField = new JTextField();
        this.customerWebsiteLink = new JXHyperlink();
        this.submitButton = new JButton();
        this.cancelButton = new JButton();
        this.helpButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ImmoToolLicenseReminderDialog.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.titleLabel.setIcon(resourceMap.getIcon("titleLabel.icon"));
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle(resourceMap.getString("titleLabel.title", new Object[0]));
        this.titleInfoLabel.setText(resourceMap.getString("titleInfoLabel.text", new Object[0]));
        this.titleInfoLabel.setLineWrap(true);
        this.titleInfoLabel.setName("titleInfoLabel");
        this.reasonLabel.setName("reasonLabel");
        this.reasonLabel.setTitle(resourceMap.getString("reasonLabel.title", new Object[0]));
        this.reasonInfoLabel.setText(resourceMap.getString("reasonInfoLabel.text", new Object[0]));
        this.reasonInfoLabel.setLineWrap(true);
        this.reasonInfoLabel.setName("reasonInfoLabel");
        this.step1Label.setName("step1Label");
        this.step1Label.setTitle(resourceMap.getString("step1Label.title", new Object[0]));
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(ImmoToolLicenseReminderDialog.class, (Object)this);
        this.step1Button.setAction(applicationActionMap.get("openCustomerWebsite"));
        this.step1Button.setIcon(resourceMap.getIcon("step1Button.icon"));
        this.step1Button.setText(resourceMap.getString("step1Button.text", new Object[0]));
        this.step1Button.setName("step1Button");
        this.step2Label.setName("step2Label");
        this.step2Label.setTitle(resourceMap.getString("step2Label.title", new Object[0]));
        this.step2Button.setAction(applicationActionMap.get("doSetupLicense"));
        this.step2Button.setName("step2Button");
        this.licenseKeyField.setEditable(false);
        this.licenseKeyField.setName("licenseKeyField");
        this.licenseKeyField.setOpaque(false);
        this.customerWebsiteLink.setAction(applicationActionMap.get("openCustomerWebsite"));
        this.customerWebsiteLink.setText("http://dev.openestate.org/");
        this.customerWebsiteLink.setName("customerWebsiteLink");
        this.submitButton.setAction(applicationActionMap.get("doSubmit"));
        this.submitButton.setName("submitButton");
        this.cancelButton.setAction(applicationActionMap.get("doCancel"));
        this.cancelButton.setName("cancelButton");
        this.helpButton.setAction(applicationActionMap.get("doHelp"));
        this.helpButton.setName("helpButton");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent((Component)this.titleInfoLabel, -1, 531, Short.MAX_VALUE)).addComponent((Component)this.titleLabel, -1, 543, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.customerWebsiteLink, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 212, Short.MAX_VALUE).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.reasonLabel, -1, 543, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(24, 24, 24).addComponent((Component)this.reasonInfoLabel, -1, 531, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.step1Button)).addComponent((Component)this.step1Label, -1, 543, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.step2Button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.licenseKeyField, -1, 450, Short.MAX_VALUE)).addComponent((Component)this.step2Label, -1, 543, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.titleInfoLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.reasonLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.reasonInfoLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.step1Label, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.step1Button).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.step2Label, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.step2Button).addComponent(this.licenseKeyField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 63, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.helpButton).addComponent(this.cancelButton).addComponent(this.submitButton)).addComponent((Component)this.customerWebsiteLink, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    @Action
    public void doSubmit() {
        String string = this.licenseKeyField.getText().trim();
        if (string.length() <= 0) {
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("message.licenseKeyIsEmpty", new Object[0]));
            return;
        }
        try {
            ImmoToolApp.setApplicationLicenseKey(string);
            ImmoToolApp.setApplicationLicenseRemindStamp(-1L);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not save license-key!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantSaveLicenseKey", new Object[0]), exception);
            return;
        }
        this.status = 3;
        this.setVisible(false);
    }

    @Action
    public void doCancel() {
        boolean bl = ImmoToolUtils.showQuestionDialog(this.resourceMap.getString("question.remindAboutMissingLicense", new Object[0]));
        if (bl) {
            this.status = 2;
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            calendar.add(3, 1);
            ImmoToolApp.setApplicationLicenseRemindStamp(calendar.getTime());
        } else {
            this.status = 1;
            ImmoToolApp.setApplicationLicenseRemindStamp(-1L);
        }
        this.setVisible(false);
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog("app.faq.license.key", true);
    }

    @Action
    public void doSetupLicense() {
        ImmoToolLicenseSetupDialog immoToolLicenseSetupDialog = new ImmoToolLicenseSetupDialog();
        immoToolLicenseSetupDialog.setVisible(true);
        if (immoToolLicenseSetupDialog.getStatus() != 2) {
            this.licenseKeyField.setText("");
            this.submitButton.setEnabled(false);
        } else {
            this.licenseKeyField.setText(immoToolLicenseSetupDialog.getLicenseKey().toLowerCase());
            this.submitButton.setEnabled(true);
        }
    }
}

