/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolLicenseTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.RegexFormatter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class ImmoToolLicenseSetupDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolLicenseSetupDialog.class);
    public static final int OPENED = 0;
    public static final int CANCELLED = 1;
    public static final int APPROVED = 2;
    private int status = 0;
    private ResourceMap resourceMap;
    private boolean validationPassed = false;
    private JXBusyLabel busyLabel;
    private JButton cancelButton;
    private JXHyperlink customerWebsiteLink;
    private JButton helpButton;
    private JXTitledSeparator keyLabel;
    private JButton licenseKeyCheckButton;
    private JFormattedTextField licenseKeyField;
    private JXLabel registerInfoLabel;
    private JXTitledSeparator registerLabel;
    private JButton submitButton;
    private JXLabel titleInfoLabel;
    private JXTitledSeparator titleLabel;

    public ImmoToolLicenseSetupDialog() {
        this((Frame)ImmoToolApp.getApplication().getMainFrame(), true);
    }

    public ImmoToolLicenseSetupDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.build();
        this.setLocationRelativeTo(frame);
    }

    private void build() {
        this.setContentPane((Container)new JXPanel());
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolLicenseSetupDialog.class);
        this.initComponents();
        this.busyLabel.setVisible(false);
        String string = ImmoToolApp.getApplicationLicenseKey();
        if (string == null || string.trim().length() == 0) {
            string = "XXXXX-XXXXX-XXXXX-XXXXX-XXXXX";
        }
        this.licenseKeyField.setValue(string);
        this.titleInfoLabel.setText(this.resourceMap.getString("titleInfoLabel.text", new Object[]{"http://dev.openestate.org/"}));
        this.registerInfoLabel.setText(this.resourceMap.getString("registerInfoLabel.text", new Object[]{"http://dev.openestate.org/"}));
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.licenseKeyCheckButton.setOpaque(false);
            this.submitButton.setOpaque(false);
            this.cancelButton.setOpaque(false);
            this.helpButton.setOpaque(false);
        }
        ImmoToolUtils.configureDialog(this, (JXPanel)this.getContentPane());
    }

    public String getLicenseKey() {
        try {
            this.licenseKeyField.commitEdit();
            if (!this.licenseKeyField.isEditValid()) {
                throw new Exception(this.resourceMap.getString("error.licenseKeyIsInvalidFormat", new Object[0]));
            }
            return this.licenseKeyField.getText();
        }
        catch (Exception exception) {
            LOGGER.error((Object)"invalid license-key!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()));
            return null;
        }
    }

    public int getStatus() {
        return this.status;
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator("");
        this.titleInfoLabel = new JXLabel();
        this.registerLabel = ImmoToolUtils.createHead2Separator("");
        this.registerInfoLabel = new JXLabel();
        this.keyLabel = ImmoToolUtils.createHead2Separator("");
        this.licenseKeyField = new JFormattedTextField(new RegexFormatter("\\w{5}\\-\\w{5}\\-\\w{5}\\-\\w{5}\\-\\w{5}"));
        this.licenseKeyCheckButton = new JButton();
        this.busyLabel = new JXBusyLabel();
        this.customerWebsiteLink = new JXHyperlink();
        this.submitButton = new JButton();
        this.cancelButton = new JButton();
        this.helpButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ImmoToolLicenseSetupDialog.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.titleLabel.setIcon(resourceMap.getIcon("titleLabel.icon"));
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle(resourceMap.getString("titleLabel.title", new Object[0]));
        this.titleInfoLabel.setText(resourceMap.getString("titleInfoLabel.text", new Object[0]));
        this.titleInfoLabel.setLineWrap(true);
        this.titleInfoLabel.setName("titleInfoLabel");
        this.registerLabel.setName("registerLabel");
        this.registerLabel.setTitle(resourceMap.getString("registerLabel.title", new Object[0]));
        this.registerInfoLabel.setText(resourceMap.getString("registerInfoLabel.text", new Object[0]));
        this.registerInfoLabel.setLineWrap(true);
        this.registerInfoLabel.setName("registerInfoLabel");
        this.keyLabel.setName("keyLabel");
        this.keyLabel.setTitle(resourceMap.getString("keyLabel.title", new Object[0]));
        this.licenseKeyField.setToolTipText(resourceMap.getString("licenseKeyField.toolTipText", new Object[0]));
        this.licenseKeyField.setName("licenseKeyField");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(ImmoToolLicenseSetupDialog.class, (Object)this);
        this.licenseKeyCheckButton.setAction(applicationActionMap.get("doCheckLicense"));
        this.licenseKeyCheckButton.setName("licenseKeyCheckButton");
        this.busyLabel.setHorizontalAlignment(4);
        this.busyLabel.setHorizontalTextPosition(2);
        this.busyLabel.setIconTextGap(10);
        this.busyLabel.setName("busyLabel");
        this.customerWebsiteLink.setAction(applicationActionMap.get("openCustomerWebsite"));
        this.customerWebsiteLink.setText("http://dev.openestate.org/");
        this.customerWebsiteLink.setName("customerWebsiteLink");
        this.submitButton.setAction(applicationActionMap.get("doSubmit"));
        this.submitButton.setName("submitButton");
        this.cancelButton.setAction(applicationActionMap.get("doCancel"));
        this.cancelButton.setName("cancelButton");
        this.helpButton.setAction(applicationActionMap.get("doHelp"));
        this.helpButton.setName("helpButton");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent((Component)this.titleInfoLabel, -1, 509, Short.MAX_VALUE)).addComponent((Component)this.titleLabel, -1, 521, Short.MAX_VALUE).addComponent((Component)this.registerLabel, GroupLayout.Alignment.TRAILING, -1, 521, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(24, 24, 24).addComponent((Component)this.registerInfoLabel, -1, 509, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.keyLabel, -1, 521, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.busyLabel, GroupLayout.Alignment.TRAILING, -1, 509, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.licenseKeyField, -1, 428, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.licenseKeyCheckButton)))))).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.customerWebsiteLink, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 190, Short.MAX_VALUE).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.titleInfoLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.registerLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.registerInfoLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.keyLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.licenseKeyField, -2, -1, -2).addComponent(this.licenseKeyCheckButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.busyLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 48, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.helpButton).addComponent(this.cancelButton).addComponent(this.submitButton)).addComponent((Component)this.customerWebsiteLink, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    @Action
    public void doSubmit() {
        try {
            Task task = this.doCheckLicense();
            task.addTaskListener(new TaskListener(){

                public void doInBackground(TaskEvent taskEvent) {
                }

                public void process(TaskEvent taskEvent) {
                }

                public void succeeded(TaskEvent taskEvent) {
                }

                public void failed(TaskEvent taskEvent) {
                }

                public void cancelled(TaskEvent taskEvent) {
                }

                public void interrupted(TaskEvent taskEvent) {
                }

                public void finished(TaskEvent taskEvent) {
                    if (ImmoToolLicenseSetupDialog.this.validationPassed) {
                        ImmoToolLicenseSetupDialog.this.status = 2;
                        ImmoToolLicenseSetupDialog.this.setVisible(false);
                    }
                }
            });
            ImmoToolUtils.executeTask(task);
        }
        catch (Exception exception) {
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.couldNotSaveLicenseKey", new Object[0]), exception);
        }
    }

    @Action
    public void doCancel() {
        this.status = 1;
        this.setVisible(false);
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog("app.license.openestate", true);
    }

    @Action
    public Task doCheckLicense() {
        try {
            this.licenseKeyField.commitEdit();
            if (!this.licenseKeyField.isEditValid()) {
                throw new Exception(this.resourceMap.getString("error.licenseKeyIsInvalidFormat", new Object[0]));
            }
        }
        catch (Exception exception) {
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.couldNotSaveLicenseKey", new Object[0]), exception);
            return null;
        }
        this.validationPassed = false;
        this.licenseKeyCheckButton.setEnabled(false);
        this.licenseKeyField.setEnabled(false);
        this.submitButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.helpButton.setEnabled(false);
        this.busyLabel.setVisible(true);
        this.busyLabel.setBusy(true);
        this.busyLabel.setText("<html>" + this.resourceMap.getString("message.checkingLicenseKey", new Object[0]) + "</html>");
        return new ImmoToolLicenseTask(this.licenseKeyField.getText()){

            @Override
            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolLicenseSetupDialog.this.busyLabel.setText("<html>" + ImmoToolLicenseSetupDialog.this.resourceMap.getString("error.couldNotCheckLicenseKey", new Object[0]) + "</html>");
                ImmoToolUtils.showMessageErrorDialog(ImmoToolLicenseSetupDialog.this.resourceMap.getString("error.couldNotCheckLicenseKey", new Object[0]), throwable);
            }

            @Override
            protected void finished() {
                super.finished();
                ImmoToolLicenseSetupDialog.this.licenseKeyField.setEnabled(true);
                ImmoToolLicenseSetupDialog.this.licenseKeyCheckButton.setEnabled(true);
                ImmoToolLicenseSetupDialog.this.submitButton.setEnabled(true);
                ImmoToolLicenseSetupDialog.this.cancelButton.setEnabled(true);
                ImmoToolLicenseSetupDialog.this.helpButton.setEnabled(true);
                ImmoToolLicenseSetupDialog.this.busyLabel.setBusy(false);
            }

            @Override
            protected void succeeded(Boolean bl) {
                super.succeeded(bl);
                if (bl.booleanValue()) {
                    ImmoToolLicenseSetupDialog.this.validationPassed = true;
                    ImmoToolLicenseSetupDialog.this.busyLabel.setText("<html><i>" + ImmoToolLicenseSetupDialog.this.resourceMap.getString("message.licenseKeyIsValid", new Object[0]) + "</i></html>");
                } else {
                    ImmoToolLicenseSetupDialog.this.validationPassed = false;
                    ImmoToolLicenseSetupDialog.this.busyLabel.setText("<html><i>" + ImmoToolLicenseSetupDialog.this.resourceMap.getString("message.licenseKeyIsInvalid", new Object[0]) + "</i></html>");
                }
            }
        };
    }
}

