/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolPluginException;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolSetupPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.JOptionFileChooser;
import com.openindex.openestate.tool.utils.engine.PlugEngine;
import com.openindex.openestate.tool.utils.engine.PlugEngineException;
import com.openindex.openestate.tool.utils.engine.Pluggable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.ActionMap;
import javax.swing.JMenu;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXTaskPane;

public abstract class ImmoToolPlugin
implements Pluggable {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolPlugin.class);
    public static final String RES_PLUGIN_APIVERSION = "Plugin.ApiVersion";
    public static final String RES_PLUGIN_AUTHOR = "Plugin.Author";
    public static final String RES_PLUGIN_DESCRIPTION = "Plugin.Description";
    public static final String RES_PLUGIN_LICENSE = "Plugin.License";
    public static final String RES_PLUGIN_TITLE = "Plugin.Title";
    public static final String RES_PLUGIN_VERSION = "Plugin.Version";
    public static final String RES_PLUGIN_WEBSITE = "Plugin.Website";
    private ActionMap pluginActionMap = null;
    private ResourceMap pluginResourceMap = null;

    public void clearResources() {
        this.pluginActionMap = null;
        this.pluginResourceMap = null;
    }

    public ImmoToolPluginException createException(String string) {
        return new ImmoToolPluginException("[" + this.getName() + "] " + string);
    }

    public ImmoToolPluginException createException(String string, Throwable throwable) {
        return new ImmoToolPluginException("[" + this.getName() + "] " + string, throwable);
    }

    public HelpSet createHelpSet() throws HelpSetException {
        return null;
    }

    public JMenu createMenu() {
        return null;
    }

    public List<ImmoToolSetupPanel> createSetupPanels() {
        return new ArrayList<ImmoToolSetupPanel>();
    }

    public JXTaskPane createTaskPane() {
        return null;
    }

    protected void exportSchema(ImmoToolDb immoToolDb, String string, InputStream inputStream) throws ImmoToolPluginException {
        File file = new File(immoToolDb.getSchemaDir().getAbsolutePath() + File.separator + this.getName());
        if (!file.exists() && !file.mkdirs()) {
            throw this.createException("could not create schema-dir: " + file.getAbsolutePath());
        }
        try {
            File file2 = new File(file.getPath() + File.separator + string);
            if (!file2.exists()) {
                ImmoToolUtils.writeStreamToFile(inputStream, file2);
            }
        }
        catch (Exception exception) {
            throw this.createException("could not save schema: " + exception.getLocalizedMessage(), exception);
        }
    }

    public void exportSchemas(ImmoToolDb immoToolDb) throws ImmoToolPluginException {
    }

    public ActionMap getActionMap() {
        if (this.pluginActionMap == null) {
            Application application = Application.getInstance(ImmoToolApp.class);
            this.pluginActionMap = new ApplicationActionMap(application.getContext(), this.getClass(), (Object)this, this.getResourceMap());
        }
        return this.pluginActionMap;
    }

    public String getAuthor() {
        return this.getResourceMap().getString(RES_PLUGIN_AUTHOR, new Object[0]);
    }

    @Override
    public String getDescription() {
        return this.getResourceMap().getString(RES_PLUGIN_DESCRIPTION, new Object[0]);
    }

    public Map<String, JOptionFileChooser.OptionField> getExportDatabaseSettings() {
        return null;
    }

    public String getLicense() {
        return this.getResourceMap().getString(RES_PLUGIN_LICENSE, new Object[0]);
    }

    @Override
    public int getMinimalVersion() {
        Integer n = this.getResourceMap().getInteger(RES_PLUGIN_APIVERSION);
        return n != null ? n : 0;
    }

    @Override
    public abstract String getName();

    public ResourceMap getResourceMap() {
        if (this.pluginResourceMap == null) {
            this.pluginResourceMap = ImmoToolUtils.getResourceMap(this.getClass());
        }
        return this.pluginResourceMap;
    }

    public String getTitle() {
        return this.getResourceMap().getString(RES_PLUGIN_TITLE, new Object[0]);
    }

    @Override
    public String getVersion() {
        return this.getResourceMap().getString(RES_PLUGIN_VERSION, new Object[0]);
    }

    public String getWebsite() {
        return this.getResourceMap().getString(RES_PLUGIN_WEBSITE, new Object[0]);
    }

    public void exportDatabase(File file, ImmoToolDb immoToolDb, ImmoToolProject immoToolProject, JOptionFileChooser jOptionFileChooser, ImmoToolTask.Callback callback) throws ImmoToolException {
    }

    public void initDatabase(ImmoToolDb immoToolDb, ImmoToolProject immoToolProject, ImmoToolTask.Callback callback) throws ImmoToolException {
    }

    public void installOrUpdate(HttpClient httpClient) throws PlugEngineException {
        PlugEngine.getInstance().installOrUpdate(httpClient, this.getURI());
    }

    public static Map<String, ImmoToolPlugin> listAvailablePlugins() {
        TreeMap<String, ImmoToolPlugin> treeMap = new TreeMap<String, ImmoToolPlugin>();
        for (Pluggable pluggable : PlugEngine.getInstance().getAllPluggables()) {
            if (pluggable instanceof ImmoToolPlugin) {
                treeMap.put(pluggable.getName(), (ImmoToolPlugin)pluggable);
                continue;
            }
            LOGGER.warn((Object)"invalid plugin-instance!");
            LOGGER.warn((Object)("> name: " + pluggable.getName()));
            LOGGER.warn((Object)("> class: " + pluggable.getClass().getName()));
        }
        return treeMap;
    }

    public void load() {
    }

    public void rebuildDatabase(ImmoToolDb immoToolDb, ImmoToolProject immoToolProject, ImmoToolTask.Callback callback) throws ImmoToolException {
    }

    public void save() {
    }

    public void uninstall() throws PlugEngineException {
        PlugEngine.getInstance().removePluggable(this);
    }

    public void update(ImmoToolProject immoToolProject, ImmoToolDb immoToolDb, String string, String string2) throws ImmoToolException {
    }
}

