/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.impl.CompanyAdressImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolPlugin;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.engine.PlugEngineException;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class ImmoToolProject {
    public static final String PROJECT_COMPANY_XML = "company.xml";
    public static final String PROJECT_PROPERTIES = "project.properties";
    public static final int BACKUP_NEVER = 0;
    public static final int BACKUP_EVERY_PROJECT_START = 1;
    public static final int BACKUP_EVERY_PROJECT_CLOSE = 2;
    public static final int BACKUP_EVERY_DAY = 3;
    public static final int BACKUP_EVERY_1_WEEK = 4;
    public static final int BACKUP_EVERY_2_WEEKS = 5;
    public static final int BACKUP_EVERY_MONTH = 6;
    public static final String KEY_BACKUP_DIR = "Backup.Dir";
    public static final String KEY_BACKUP_MODE = "Backup.Mode";
    public static final String KEY_BACKUP_TIME = "Backup.Time";
    public static final String KEY_BACKUP_FILECOUNT = "Backup.FileCount";
    public static final String KEY_PROJECT_BETA = "Project.Beta";
    public static final String KEY_PROJECT_NAME = "Project.Name";
    public static final String KEY_PLUGINS = "Plugins";
    private static final Logger LOGGER = Logger.getLogger(ImmoToolProject.class);
    private CompanyAdressImpl adress = new CompanyAdressImpl();
    private File directory = null;
    private Properties projectProperties = null;
    private Map<String, ImmoToolPlugin> projectPlugins = null;

    private ImmoToolProject(File file) {
        this.directory = file;
        this.projectProperties = new Properties();
        this.projectPlugins = new TreeMap<String, ImmoToolPlugin>();
    }

    public static ImmoToolProject create(File file, String string) throws IOException {
        if (file == null) {
            throw new IOException("invalid project-directory!");
        }
        if (file.exists()) {
            throw new IOException("project-directory already exists!");
        }
        if (!file.mkdirs()) {
            throw new IOException("could not create project-directory!");
        }
        File file2 = new File(file.getAbsolutePath() + File.separator + "backup");
        if (!file2.mkdirs()) {
            throw new IOException("could not create project-backup-directory!");
        }
        ImmoToolProject immoToolProject = new ImmoToolProject(file);
        immoToolProject.setProperty(KEY_PROJECT_NAME, string);
        immoToolProject.setProperty(KEY_BACKUP_DIR, file2.getAbsolutePath());
        immoToolProject.setProperty(KEY_BACKUP_MODE, String.valueOf(0));
        if (ImmoToolApp.isApplicationBetaVersion()) {
            immoToolProject.setProperty(KEY_PROJECT_BETA, "1");
        }
        return immoToolProject;
    }

    public CompanyAdressImpl getAdress() {
        return this.adress;
    }

    public File getBackupDirectory() {
        return new File(this.getProperty(KEY_BACKUP_DIR, new File(this.getDirectory().getAbsolutePath() + File.separator + "backup").getAbsolutePath()));
    }

    public int getBackupFileCount() {
        try {
            return Integer.valueOf(this.getProperty(KEY_BACKUP_FILECOUNT, String.valueOf(5)));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return 0;
        }
    }

    public int getBackupMode() {
        try {
            return Integer.valueOf(this.getProperty(KEY_BACKUP_MODE, String.valueOf(0)));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return 0;
        }
    }

    public long getBackupTime() {
        try {
            return Long.valueOf(this.getProperty(KEY_BACKUP_TIME, String.valueOf(0)));
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public String getName() {
        String string = this.getProperty(KEY_PROJECT_NAME, "");
        return string.trim().length() > 0 ? string.trim() : this.directory.getName();
    }

    public ImmoToolPlugin getPlugin(String string) {
        return this.projectPlugins.containsKey(string) ? this.projectPlugins.get(string) : null;
    }

    public Set<String> getPluginNames() {
        return this.projectPlugins.keySet();
    }

    public String getProperty(String string) {
        return this.getProperty(string, null);
    }

    public String getProperty(String string, String string2) {
        return this.getProperties().getProperty(string, string2);
    }

    public Boolean getPropertyAsBoolean(String string, Boolean bl) {
        return ImmoToolUtils.getPropertyAsBoolean(string, bl, this.getProperties());
    }

    public Color getPropertyAsColor(String string, Color color) {
        return ImmoToolUtils.getPropertyAsColor(string, color, this.getProperties());
    }

    public Date getPropertyAsDate(String string, Date date) {
        return ImmoToolUtils.getPropertyAsDate(string, date, this.getProperties());
    }

    public Float getPropertyAsFloat(String string, Float f) {
        return ImmoToolUtils.getPropertyAsFloat(string, f, this.getProperties());
    }

    public Integer getPropertyAsInteger(String string, Integer n) {
        return ImmoToolUtils.getPropertyAsInteger(string, n, this.getProperties());
    }

    public Long getPropertyAsLong(String string, Long l) {
        return ImmoToolUtils.getPropertyAsLong(string, l, this.getProperties());
    }

    public Properties getProperties() {
        return this.projectProperties;
    }

    public File getTempDirectory() {
        return new File(this.getDirectory() + File.separator + "temp");
    }

    public boolean isBetaProject() {
        return "1".equals(this.getProperty(KEY_PROJECT_BETA, "0").trim());
    }

    public static boolean isValidProjectDirectory(File file) {
        if (file == null) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        File file2 = new File(file.getAbsolutePath() + File.separator + PROJECT_PROPERTIES);
        if (!file2.isFile()) {
            return false;
        }
        file2 = new File(file.getAbsolutePath() + File.separator + PROJECT_COMPANY_XML);
        return file2.isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImmoToolProject open(File file) throws IOException, DocumentException, PlugEngineException, ImmoToolException {
        String string;
        String string2;
        if (file == null) {
            throw new IOException("invalid project-directory!");
        }
        if (!file.canWrite()) {
            throw new IOException("project-directory not writable!");
        }
        File file2 = new File(file.getAbsolutePath() + File.separator + PROJECT_PROPERTIES);
        if (file2 == null || !file2.isFile()) {
            throw new IOException("invalid project.properties!");
        }
        if (!file2.canRead()) {
            throw new IOException("project.properties not readable!");
        }
        if (!file2.canWrite()) {
            throw new IOException("project.propertiesnot writable!");
        }
        File file3 = new File(file.getAbsolutePath() + File.separator + "temp");
        if (!file3.exists() && !file3.mkdir()) {
            throw new IOException("could not create temp-dir!");
        }
        for (File object2 : file3.listFiles()) {
            FileUtils.deleteQuietly((File)object2);
        }
        ImmoToolProject immoToolProject = new ImmoToolProject(file);
        immoToolProject.projectPlugins.clear();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file2);
            immoToolProject.projectProperties.load(fileInputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        if (immoToolProject.isBetaProject() != ImmoToolApp.isApplicationBetaVersion()) {
            if (ImmoToolApp.isApplicationBetaVersion()) {
                throw new ImmoToolException("Can't open a stable project in a beta ImmoTool!");
            }
            throw new ImmoToolException("Can't open a beta project in a stable ImmoTool");
        }
        try {
            File file4 = new File(file.getAbsolutePath() + File.separator + PROJECT_COMPANY_XML);
            SAXReader sAXReader = new SAXReader();
            immoToolProject.getAdress().readFromXml(sAXReader.read(file4));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not load company.xml!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
            immoToolProject.setAdress(null);
        }
        int n = 1;
        while ((string2 = immoToolProject.projectProperties.getProperty(string = "Plugins." + n, "").trim()).length() != 0) {
            ImmoToolPlugin immoToolPlugin = ImmoToolUtils.getPlugin(string2);
            if (immoToolPlugin == null) {
                LOGGER.warn((Object)("unknown plugin: " + string2));
                break;
            }
            try {
                immoToolProject.projectPlugins.put(string2, immoToolPlugin);
            }
            catch (Exception exception) {
                LOGGER.error((Object)("could not register plugin: " + string2));
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            ++n;
        }
        return immoToolProject;
    }

    public void registerPlugin(ImmoToolPlugin immoToolPlugin) {
        if (this.projectPlugins.containsKey(immoToolPlugin.getName())) {
            LOGGER.warn((Object)("plugin '" + immoToolPlugin.getName() + "' is already registered!"));
            return;
        }
        this.projectPlugins.put(immoToolPlugin.getName(), immoToolPlugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException, DocumentException {
        for (String string : this.getProperties().keySet().toArray(new String[this.getProperties().size()])) {
            if (!string.startsWith("Plugins.")) continue;
            this.getProperties().remove(string);
        }
        int n = 0;
        for (ImmoToolPlugin immoToolPlugin : this.projectPlugins.values()) {
            this.setProperty("Plugins." + ++n, immoToolPlugin.getName());
            immoToolPlugin.save();
        }
        Object object = null;
        try {
            object = new FileOutputStream(new File(this.getDirectory().getAbsolutePath() + File.separator + PROJECT_PROPERTIES));
            this.projectProperties.store((OutputStream)object, "");
        }
        finally {
            if (object != null) {
                ((FileOutputStream)object).close();
            }
        }
        if (this.getAdress() != null) {
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new FileWriter(new File(this.getDirectory().getAbsolutePath() + File.separator + PROJECT_COMPANY_XML));
                OpenEstateUtils.serializeToXML(this.getAdress(), outputStreamWriter, true);
            }
            finally {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
        }
    }

    public void setAdress(CompanyAdressImpl companyAdressImpl) {
        this.adress = companyAdressImpl;
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            if (this.getProperties().containsKey(string)) {
                this.getProperties().remove(string);
            }
        } else {
            this.getProperties().setProperty(string, string2);
        }
    }

    public void setProperty(String string, Boolean bl) {
        this.setProperty(string, bl != null ? bl.toString() : null);
    }

    public void setProperty(String string, Color color) {
        if (color == null) {
            this.setProperty(string, (String)null);
        } else {
            this.setProperty(string, ImmoToolUtils.writeHexColor(color));
        }
    }

    public void setProperty(String string, Date date) {
        this.setProperty(string, date != null ? String.valueOf(date.getTime()) : null);
    }

    public void setProperty(String string, Number number) {
        this.setProperty(string, number != null ? number.toString() : null);
    }

    public void unregisterPlugin(ImmoToolPlugin immoToolPlugin) {
        this.unregisterPlugin(immoToolPlugin.getName());
    }

    public void unregisterPlugin(String string) {
        if (!this.projectPlugins.containsKey(string)) {
            LOGGER.warn((Object)("plugin '" + string + "' is not registered!"));
            return;
        }
        this.projectPlugins.remove(string);
    }
}

