/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.ImmoToolWizardDialog;
import java.io.File;
import org.jdesktop.application.ResourceMap;

public class ImmoToolProjectCreateTask
extends ImmoToolTask<Boolean> {
    private ImmoToolWizardDialog wizardDialog = null;
    private ResourceMap resourceMap = null;
    private String projectName = null;
    private File projectDir = null;

    public ImmoToolProjectCreateTask(String string, File file, ImmoToolWizardDialog immoToolWizardDialog) {
        this.projectName = string;
        this.projectDir = file;
        this.wizardDialog = immoToolWizardDialog;
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolProjectCreateTask.class);
        this.setTitle(this.resourceMap.getString("title", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Boolean executeTask() throws Exception {
        if (this.projectName == null) {
            throw new Exception(this.resourceMap.getString("error.invalidProjectName", new Object[0]));
        }
        if (this.projectDir == null) {
            throw new Exception(this.resourceMap.getString("error.invalidProjectDirectory", new Object[0]));
        }
        if (this.wizardDialog == null) {
            throw new Exception(this.resourceMap.getString("error.invalidProjectWizard", new Object[0]));
        }
        ImmoToolTask.Callback callback = this.createCallback();
        int n = 0;
        int n2 = 6;
        this.setProgress(n, 0, n2);
        try {
            this.setProgress(++n, 0, n2);
            this.setMessage(this.resourceMap.getString("message.doCreateProject", new Object[0]));
            ImmoToolProject immoToolProject = ImmoToolProject.create(this.projectDir, this.projectName);
            if (immoToolProject == null) {
                throw new Exception(this.resourceMap.getString("error.cantCreateProject", new Object[0]));
            }
            this.wizardDialog.loadProject(immoToolProject);
            this.setProgress(++n, 0, n2);
            this.setMessage(this.resourceMap.getString("message.doFirstProjectSave", new Object[0]));
            immoToolProject.save();
            this.setMessage(this.resourceMap.getString("message.doOpenProject", new Object[0]));
            immoToolProject = ImmoToolProject.open(this.projectDir);
            this.setProgress(++n, 0, n2);
            this.setMessage(this.resourceMap.getString("message.doInitDatabase", new Object[0]));
            ImmoToolDb immoToolDb = ImmoToolDb.createInstance(immoToolProject);
            immoToolDb.configure(immoToolProject);
            immoToolDb.open();
            immoToolDb.createAppCollection();
            immoToolDb.init(immoToolProject, callback);
            this.setProgress(++n, 0, n2);
            this.setMessage(this.resourceMap.getString("message.doInitProgram", new Object[0]));
            ImmoToolApp.getApplication().loadProject(immoToolProject, immoToolDb, callback);
            Boolean bl = true;
            return bl;
        }
        finally {
            this.setProgress(n2, 0, n2);
        }
    }

    @Override
    protected void failed(Throwable throwable) {
        super.failed(throwable);
        this.setMessage(this.resourceMap.getString("error.cantCreateProject", new Object[0]));
    }

    @Override
    protected void succeeded(Boolean bl) {
        super.succeeded(bl);
        this.setMessage(this.resourceMap.getString("message.projectCreated", new Object[0]));
    }
}

