/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbBackupTask;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.io.File;
import java.util.Calendar;
import org.jdesktop.application.ResourceMap;

public class ImmoToolProjectOpenTask
extends ImmoToolTask<Boolean> {
    private final ResourceMap resourceMap;
    private final File projectDir;

    public ImmoToolProjectOpenTask(File file) {
        this.projectDir = file;
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolProjectOpenTask.class);
        this.setTitle(this.resourceMap.getString("title", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Boolean executeTask() throws Exception {
        if (this.projectDir == null) {
            throw new Exception(this.resourceMap.getString("error.projectDirectoryIsEmpty", new Object[0]));
        }
        if (!this.projectDir.exists()) {
            throw new Exception(this.resourceMap.getString("error.projectDirectoryNotFound", new Object[0]));
        }
        if (!this.projectDir.isDirectory()) {
            throw new Exception(this.resourceMap.getString("error.projectDirectoryIsInvalid", new Object[0]));
        }
        if (!this.projectDir.canWrite()) {
            throw new Exception(this.resourceMap.getString("error.projectDirectoryIsNotWritable", new Object[0]));
        }
        ImmoToolTask.Callback callback = this.createCallback();
        int n = 0;
        int n2 = 3;
        this.setProgress(n, 0, n2);
        try {
            this.setProgress(++n, 0, n2);
            this.setMessage(this.resourceMap.getString("message.doOpenProject", new Object[0]));
            ImmoToolProject immoToolProject = ImmoToolProject.open(this.projectDir);
            if (immoToolProject == null) {
                throw new Exception(this.resourceMap.getString("error.cantOpenProject", new Object[0]));
            }
            this.setProgress(++n, 0, n2);
            this.setMessage(this.resourceMap.getString("message.doInitProgram", new Object[0]));
            ImmoToolApp.getApplication().loadProject(immoToolProject, callback);
            int n3 = immoToolProject.getBackupMode();
            if (n3 != 0 && n3 != 2) {
                boolean bl = false;
                if (n3 == 1) {
                    bl = true;
                } else {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(immoToolProject.getBackupTime());
                    switch (n3) {
                        case 3: {
                            calendar.add(6, 1);
                            break;
                        }
                        case 4: {
                            calendar.add(3, 1);
                            break;
                        }
                        case 5: {
                            calendar.add(3, 2);
                            break;
                        }
                        case 6: {
                            calendar.add(2, 1);
                            break;
                        }
                        default: {
                            calendar = null;
                        }
                    }
                    if (calendar != null) {
                        Calendar calendar2 = Calendar.getInstance();
                        calendar2.setTimeInMillis(System.currentTimeMillis());
                        if (calendar.before(calendar2)) {
                            bl = true;
                        }
                    }
                }
                if (bl) {
                    this.setMessage(this.resourceMap.getString("message.doAutomaticDatabaseBackup", new Object[0]));
                    ImmoToolUtils.executeTask(new ImmoToolDbBackupTask(immoToolProject, true));
                }
            }
            Boolean bl = true;
            return bl;
        }
        finally {
            this.setProgress(n2, 0, n2);
        }
    }

    @Override
    protected void failed(Throwable throwable) {
        super.failed(throwable);
        this.setMessage(this.resourceMap.getString("error.cantOpenProject", new Object[0]));
    }

    @Override
    protected void succeeded(Boolean bl) {
        super.succeeded(bl);
        this.setMessage(this.resourceMap.getString("message.projectOpened", new Object[0]));
    }
}

