/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.ClipboardTextWriter;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXTitledSeparator;

public class ImmoToolProtocolPanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolProtocolPanel.class);
    private static File lastSaveLocation = null;
    private ResourceMap resourceMap;
    private JButton closeButton;
    private JButton helpButton;
    private JXTitledSeparator protocolLabel;
    private JScrollPane protocolScroller;
    private RTextArea protocolTextArea;
    private JButton refreshButton;
    private JButton saveButton;
    private JPopupMenu saveMenu;
    private JMenuItem saveToClipboardItem;
    private JMenuItem saveToFileItem;
    private JComboBox selectProtocolBox;
    private JLabel selectProtocolLabel;
    private JXTitledSeparator titleLabel;

    public ImmoToolProtocolPanel() {
        this.build();
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolProtocolPanel.class);
        this.protocolTextArea = new RSyntaxTextArea();
        this.protocolScroller = new RTextScrollPane((Component)this.protocolTextArea);
        this.initComponents();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.protocolTextArea.setTabSize(4);
        this.protocolTextArea.setEditable(false);
        this.selectProtocolBox.setAction(ImmoToolUtils.getAction(this, "doSelectProtocol"));
        this.selectProtocolBox.setSelectedIndex(-1);
        this.loadProtocols();
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel(this.getTabTitle());
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog("app.protocols");
    }

    @Action
    public void doRefresh() {
        this.loadProtocols();
    }

    @Action
    public void doSave() {
        this.saveMenu.show(this.saveButton, 0, this.saveButton.getSize().height);
    }

    @Action
    public void doSaveToClipboard() {
        ClipboardTextWriter.writeToClipboard(this.protocolTextArea.getText());
        ImmoToolUtils.showMessageInfoDialog(this.resourceMap.getString("message.protocolSavedToClipboard", new Object[0]), this.resourceMap.getString("message.saveProtocol", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Action
    public void doSaveToFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.resourceMap.getString("message.saveProtocol", new Object[0]));
        String string = "protocol-" + System.currentTimeMillis() + ".log";
        if (lastSaveLocation != null) {
            jFileChooser.setSelectedFile(new File(lastSaveLocation.getAbsolutePath() + File.separator + string));
        } else {
            jFileChooser.setSelectedFile(new File(string));
        }
        int n = jFileChooser.showSaveDialog((Component)((Object)this));
        if (n != 0) {
            return;
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            File file = jFileChooser.getSelectedFile();
            ImmoToolProtocolPanel.setLastSaveLocation(file.getParentFile());
            outputStreamWriter = new FileWriter(file);
            outputStreamWriter.write(this.protocolTextArea.getText());
            outputStreamWriter.flush();
            ImmoToolUtils.showMessageInfoDialog(this.resourceMap.getString("message.protocolSavedToFile", new Object[]{file.getAbsolutePath()}), this.resourceMap.getString("message.saveProtocol", new Object[0]));
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant save protocol!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantSaveProtocol", new Object[0]), exception);
        }
        finally {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"cant close file!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }

    @Action
    public void doSelectProtocol() {
        try {
            if (this.selectProtocolBox.getSelectedIndex() < 0) {
                return;
            }
            this.loadFile(((LogFileItem)this.selectProtocolBox.getSelectedItem()).getFile());
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.error((Object)"cant open protocol!");
            LOGGER.error((Object)("> " + fileNotFoundException.getLocalizedMessage()), (Throwable)fileNotFoundException);
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantOpenProtocol", new Object[0]), fileNotFoundException);
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"cant read protocol!");
            LOGGER.error((Object)("> " + iOException.getLocalizedMessage()), (Throwable)iOException);
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantReadProtocol", new Object[0]), iOException);
        }
    }

    public static String getInstanceTabTitle() {
        return ImmoToolUtils.getResourceMap(ImmoToolProtocolPanel.class).getString("tabTitle", new Object[0]);
    }

    @Override
    public String getTabInfo() {
        return this.resourceMap.getString("tabInfo", new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return ImmoToolProtocolPanel.getInstanceTabTitle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(File file) throws FileNotFoundException, IOException {
        this.protocolTextArea.setText("");
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            int n = 0;
            char[] cArray = new char[1024];
            while ((n = fileReader.read(cArray, 0, cArray.length)) > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(cArray, 0, n);
                this.protocolTextArea.append(stringBuilder.toString());
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"cant close file!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }

    private void loadProtocols() {
        File[] fileArray = new File(ImmoToolApp.APP_LOG_DIR).listFiles();
        TreeMap<String, LogFileItem> treeMap = new TreeMap<String, LogFileItem>();
        for (File object : fileArray) {
            if (!object.getName().toLowerCase().endsWith(".log") && !object.getName().toLowerCase().contains(".log.")) continue;
            treeMap.put(object.getName(), new LogFileItem(object));
        }
        int n = this.selectProtocolBox.getSelectedIndex();
        int n2 = 0;
        DefaultComboBoxModel<LogFileItem> defaultComboBoxModel = new DefaultComboBoxModel<LogFileItem>();
        for (LogFileItem logFileItem : treeMap.values()) {
            if (logFileItem.getFile().getName().toLowerCase().equals("system.log")) {
                n2 = defaultComboBoxModel.getSize();
            }
            defaultComboBoxModel.addElement(logFileItem);
        }
        this.selectProtocolBox.setModel(defaultComboBoxModel);
        this.selectProtocolBox.setSelectedIndex(n < 0 ? n2 : n);
        try {
            LogFileItem logFileItem = (LogFileItem)this.selectProtocolBox.getSelectedItem();
            if (logFileItem != null) {
                this.loadFile(logFileItem.getFile());
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load protocol!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            this.protocolTextArea.setText("could not load protocol!" + SystemUtils.LINE_SEPARATOR + exception.getLocalizedMessage() + SystemUtils.LINE_SEPARATOR + ImmoToolUtils.writeException(exception));
        }
    }

    @Override
    public void refreshTab() {
        this.doRefresh();
    }

    private static synchronized void setLastSaveLocation(File file) {
        lastSaveLocation = file;
    }

    private void initComponents() {
        this.saveMenu = new JPopupMenu();
        this.saveToFileItem = new JMenuItem();
        this.saveToClipboardItem = new JMenuItem();
        this.titleLabel = ImmoToolUtils.createHead1Separator("");
        this.refreshButton = new JButton();
        this.saveButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.selectProtocolLabel = new JLabel();
        this.selectProtocolBox = new JComboBox();
        this.protocolLabel = ImmoToolUtils.createHead1Separator("");
        this.protocolScroller = this.protocolScroller;
        this.protocolTextArea = this.protocolTextArea;
        this.saveMenu.setName("saveMenu");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(ImmoToolProtocolPanel.class, (Object)this);
        this.saveToFileItem.setAction(applicationActionMap.get("doSaveToFile"));
        this.saveToFileItem.setName("saveToFileItem");
        this.saveMenu.add(this.saveToFileItem);
        this.saveToClipboardItem.setAction(applicationActionMap.get("doSaveToClipboard"));
        this.saveToClipboardItem.setName("saveToClipboardItem");
        this.saveMenu.add(this.saveToClipboardItem);
        this.setName("Form");
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ImmoToolProtocolPanel.class);
        this.titleLabel.setIcon(resourceMap.getIcon("titleLabel.icon"));
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle(resourceMap.getString("titleLabel.title", new Object[0]));
        this.refreshButton.setAction(applicationActionMap.get("doRefresh"));
        this.refreshButton.setName("refreshButton");
        this.saveButton.setAction(applicationActionMap.get("doSave"));
        this.saveButton.setName("saveButton");
        this.helpButton.setAction(applicationActionMap.get("doHelp"));
        this.helpButton.setName("helpButton");
        this.closeButton.setAction(applicationActionMap.get("doClose"));
        this.closeButton.setName("closeButton");
        this.selectProtocolLabel.setText(resourceMap.getString("selectProtocolLabel.text", new Object[0]));
        this.selectProtocolLabel.setName("selectProtocolLabel");
        this.selectProtocolBox.setName("selectProtocolBox");
        this.protocolLabel.setName("protocolLabel");
        this.protocolLabel.setTitle(resourceMap.getString("protocolLabel.title", new Object[0]));
        this.protocolScroller.setName("protocolScroller");
        this.protocolTextArea.setColumns(20);
        this.protocolTextArea.setEditable(false);
        this.protocolTextArea.setRows(5);
        this.protocolTextArea.setName("protocolTextArea");
        this.protocolScroller.setViewportView((Component)this.protocolTextArea);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.protocolScroller, GroupLayout.Alignment.LEADING, -1, 742, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 412, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addGroup(groupLayout.createSequentialGroup().addComponent(this.selectProtocolLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectProtocolBox, 0, 709, Short.MAX_VALUE)).addComponent((Component)this.protocolLabel, GroupLayout.Alignment.LEADING, -1, 742, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.saveButton).addComponent(this.refreshButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectProtocolLabel).addComponent(this.selectProtocolBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.protocolLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.protocolScroller, -1, 352, Short.MAX_VALUE).addContainerGap()));
    }

    private static class LogFileItem {
        private File item;

        public LogFileItem(File file) {
            this.item = file;
        }

        public File getFile() {
            return this.item;
        }

        public String toString() {
            return this.item.getName();
        }
    }
}

