/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolSetupPanel;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;

public class ImmoToolSetupDbPanel
extends ImmoToolSetupPanel {
    private final BackupType BACKUP_NEVER = new BackupType(0);
    private final BackupType BACKUP_EVERY_PROGRAM_START = new BackupType(1);
    private final BackupType BACKUP_EVERY_PROGRAM_CLOSE = new BackupType(2);
    private final BackupType BACKUP_EVERY_DAY = new BackupType(3);
    private final BackupType BACKUP_EVERY_1_WEEK = new BackupType(4);
    private final BackupType BACKUP_EVERY_2_WEEKS = new BackupType(5);
    private final BackupType BACKUP_EVERY_MONTH = new BackupType(6);
    private final ActionMap actionMap = ImmoToolUtils.getActionMap(ImmoToolSetupDbPanel.class, (Object)this);
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ImmoToolSetupDbPanel.class);
    private final ValidationHandler validationHandler = ImmoToolUtils.createValidationHandler();
    private JComboBox backupTypeBox;
    private JTextField backupDirField;
    private JSpinner backupFileCountField;
    private JButton backupDirButton;

    public ImmoToolSetupDbPanel() {
        this.buildForm();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.backupTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ImmoToolSetupDbPanel.this.backupTypeBox.getSelectedIndex();
                ImmoToolSetupDbPanel.this.backupFileCountField.setEnabled(n > 1);
            }
        });
    }

    private void buildForm() {
        this.backupTypeBox = new JComboBox<Object>(new Object[]{"", this.BACKUP_NEVER, this.BACKUP_EVERY_PROGRAM_START, this.BACKUP_EVERY_PROGRAM_CLOSE, this.BACKUP_EVERY_DAY, this.BACKUP_EVERY_1_WEEK, this.BACKUP_EVERY_2_WEEKS, this.BACKUP_EVERY_MONTH});
        this.backupTypeBox.setName("backupTypeBox");
        this.backupTypeBox.setSelectedIndex(0);
        this.backupDirField = new JTextField();
        this.backupDirField.setName("backupDirField");
        this.backupDirField.setEditable(false);
        this.backupDirButton = new JButton(this.actionMap.get("doSelectBackupDir"));
        this.backupDirButton.setName("backupDirButton");
        this.backupFileCountField = new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        this.backupFileCountField.setName("backupFileCountField");
        this.validationHandler.putRule(this.backupTypeBox, new NonEmptyComboBoxRule(this.backupTypeBox));
        this.validationHandler.putRule(this.backupDirField, new ValidationRule(){

            @Override
            public boolean isValid(Object object) {
                if (object == null) {
                    return false;
                }
                return new File((String)object).isDirectory();
            }
        });
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder("right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, pref");
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator(this.resourceMap.getString("backupTitle", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("backupDirTitle", new Object[0]), (Component)this.backupDirField, 3);
        defaultFormBuilder.append((Component)this.backupDirButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("backupTypeTitle", new Object[0]), (Component)this.backupTypeBox);
        defaultFormBuilder.append(this.resourceMap.getString("backupFileCountTitle", new Object[0]), (Component)this.backupFileCountField);
        defaultFormBuilder.nextLine();
        this.setLayout(new BorderLayout());
        this.add(defaultFormBuilder.getPanel(), "Center");
    }

    @Override
    public void doLoad() throws ImmoToolException {
        this.backupDirField.setText(ImmoToolApp.getApplication().getProject().getBackupDirectory().getAbsolutePath());
        this.backupFileCountField.setValue(ImmoToolApp.getApplication().getProject().getBackupFileCount());
        this.backupTypeBox.setSelectedIndex(0);
        int n = ImmoToolApp.getApplication().getProject().getBackupMode();
        for (int i = 1; i < this.backupTypeBox.getItemCount(); ++i) {
            int n2 = ((BackupType)this.backupTypeBox.getItemAt(i)).getType();
            if (n2 != n) continue;
            this.backupTypeBox.setSelectedIndex(i);
            this.backupFileCountField.setEnabled(i > 1);
            break;
        }
        this.validationHandler.init();
    }

    @Override
    public void doSave() throws ImmoToolException {
        ImmoToolApp.getApplication().getProject().setProperty("Backup.Dir", this.backupDirField.getText());
        ImmoToolApp.getApplication().getProject().setProperty("Backup.Mode", ((BackupType)this.backupTypeBox.getSelectedItem()).getType());
        ImmoToolApp.getApplication().getProject().setProperty("Backup.FileCount", ((Number)this.backupFileCountField.getValue()).intValue());
    }

    @Action
    public void doSelectBackupDir() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.resourceMap.getString("message.selectBackupDirectory", new Object[0]));
        jFileChooser.setApproveButtonText(this.resourceMap.getString("message.chooseBackupDirectory", new Object[0]));
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setSelectedFile(new File(this.backupDirField.getText()));
        int n = jFileChooser.showSaveDialog((Component)((Object)this));
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (!file.exists()) {
            if (!ImmoToolUtils.showQuestionDialog(this.resourceMap.getString("question.createBackupDirectory", new Object[0]))) {
                return;
            }
            if (!file.mkdirs()) {
                ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantCreateBackupDirectory", new Object[0]));
                return;
            }
        }
        this.backupDirField.setText(file.getAbsolutePath());
    }

    @Override
    public boolean doValidate() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("panelTitle", new Object[0]);
    }

    public class BackupType {
        private int backupType;

        public BackupType(int n) {
            this.backupType = n;
        }

        public int getType() {
            return this.backupType;
        }

        public String toString() {
            switch (this.getType()) {
                case 0: {
                    return " " + ImmoToolSetupDbPanel.this.resourceMap.getString("backupType.NEVER", new Object[0]);
                }
                case 1: {
                    return " " + ImmoToolSetupDbPanel.this.resourceMap.getString("backupType.EVERY_PROJECT_START", new Object[0]);
                }
                case 2: {
                    return " " + ImmoToolSetupDbPanel.this.resourceMap.getString("backupType.EVERY_PROJECT_CLOSE", new Object[0]);
                }
                case 3: {
                    return " " + ImmoToolSetupDbPanel.this.resourceMap.getString("backupType.EVERY_DAY", new Object[0]);
                }
                case 4: {
                    return " " + ImmoToolSetupDbPanel.this.resourceMap.getString("backupType.EVERY_1_WEEK", new Object[0]);
                }
                case 5: {
                    return " " + ImmoToolSetupDbPanel.this.resourceMap.getString("backupType.EVERY_2_WEEKS", new Object[0]);
                }
                case 6: {
                    return " " + ImmoToolSetupDbPanel.this.resourceMap.getString("backupType.EVERY_MONTH", new Object[0]);
                }
            }
            return "";
        }
    }
}

