/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolPlugin;
import com.openindex.openestate.tool.ImmoToolSetupDbPanel;
import com.openindex.openestate.tool.ImmoToolSetupNetworkPanel;
import com.openindex.openestate.tool.ImmoToolSetupPanel;
import com.openindex.openestate.tool.ImmoToolSetupSyndicationPanel;
import com.openindex.openestate.tool.ImmoToolSetupSystemPanel;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class ImmoToolSetupDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolSetupDialog.class);
    public static final int OPENED = 0;
    public static final int CANCELLED = 1;
    public static final int APPROVED = 2;
    private int status = 0;
    private ResourceMap resourceMap;
    private Map<SetupTreeNode, ImmoToolSetupPanel> selectedNodes = null;
    private JButton closeButton;
    private JXPanel formPanel;
    private JButton helpButton;
    private JScrollPane jScrollPane1;
    private JXHyperlink projectLink;
    private JTree setupTree;
    private JButton submitButton;
    private JXTitledSeparator titleLabel;

    public ImmoToolSetupDialog() {
        this((Frame)ImmoToolApp.getApplication().getMainFrame(), true);
    }

    public ImmoToolSetupDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.setContentPane((Container)new JXPanel());
        this.build();
        this.setLocationRelativeTo(frame);
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolSetupDialog.class);
        this.initComponents();
        this.selectedNodes = new HashMap<SetupTreeNode, ImmoToolSetupPanel>();
        this.formPanel.setOpaque(false);
        this.buildSetupTree();
        for (int i = 0; i < this.setupTree.getRowCount(); ++i) {
            this.setupTree.expandRow(i);
        }
        this.setupTree.getSelectionModel().setSelectionMode(1);
        this.setupTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                ImmoToolSetupDialog.this.setupTree.getSelectionCount();
                if (ImmoToolSetupDialog.this.setupTree.getSelectionCount() <= 0) {
                    return;
                }
                ImmoToolSetupDialog.this.showSetupNode((SetupTreeNode)ImmoToolSetupDialog.this.setupTree.getSelectionPath().getLastPathComponent());
            }
        });
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.submitButton.setOpaque(false);
            this.closeButton.setOpaque(false);
            this.helpButton.setOpaque(false);
        }
        ImmoToolUtils.configureDialog(this, (JXPanel)this.getContentPane());
    }

    private void buildSetupTree() {
        SetupTreeNode setupTreeNode = new SetupTreeNode();
        SetupTreeNode setupTreeNode2 = new SetupTreeNode(this.resourceMap.getString("setupNode.program", new Object[0]));
        setupTreeNode2.add(new SetupTreeNode(new ImmoToolSetupSystemPanel()));
        setupTreeNode2.add(new SetupTreeNode(new ImmoToolSetupNetworkPanel()));
        setupTreeNode.add(setupTreeNode2);
        if (ImmoToolApp.getApplication().getProject() != null) {
            SetupTreeNode setupTreeNode3 = new SetupTreeNode(this.resourceMap.getString("setupNode.project", new Object[0]));
            setupTreeNode3.add(new SetupTreeNode(new ImmoToolSetupDbPanel()));
            setupTreeNode3.add(new SetupTreeNode(new ImmoToolSetupSyndicationPanel()));
            setupTreeNode.add(setupTreeNode3);
            for (String string : ImmoToolApp.getApplication().getProject().getPluginNames()) {
                ImmoToolPlugin immoToolPlugin = ImmoToolApp.getApplication().getProject().getPlugin(string);
                List<ImmoToolSetupPanel> list = immoToolPlugin.createSetupPanels();
                if (list.isEmpty()) continue;
                SetupTreeNode setupTreeNode4 = new SetupTreeNode(immoToolPlugin.getTitle());
                for (ImmoToolSetupPanel immoToolSetupPanel : list) {
                    setupTreeNode4.add(new SetupTreeNode(immoToolSetupPanel));
                }
                setupTreeNode.add(setupTreeNode4);
            }
        }
        this.setupTree.setModel(new DefaultTreeModel(setupTreeNode));
    }

    @Action
    public void doClose() {
        this.status = 1;
        this.setVisible(false);
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog("app.settings", true);
    }

    @Action
    public void doSubmit() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ImmoToolSetupPanel immoToolSetupPanel : this.selectedNodes.values()) {
            if (immoToolSetupPanel.doValidate()) continue;
            arrayList.add(this.resourceMap.getString("message.formIsInvalid", new Object[]{immoToolSetupPanel.getTitle()}));
        }
        if (!arrayList.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantSaveForm", new Object[0]), arrayList);
            return;
        }
        try {
            for (ImmoToolSetupPanel immoToolSetupPanel : this.selectedNodes.values()) {
                immoToolSetupPanel.doSave();
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"setup-save-error!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantSaveSetup", new Object[0]), exception);
            return;
        }
        this.status = 2;
        this.setVisible(false);
    }

    public int getStatus() {
        return this.status;
    }

    private void showSetupNode(SetupTreeNode setupTreeNode) {
        if (setupTreeNode.getType() != 2) {
            this.formPanel.removeAll();
            this.formPanel.setOpaque(false);
            this.formPanel.repaint();
            return;
        }
        ImmoToolSetupPanel immoToolSetupPanel = null;
        if (this.selectedNodes.containsKey(setupTreeNode)) {
            immoToolSetupPanel = this.selectedNodes.get(setupTreeNode);
        } else {
            try {
                immoToolSetupPanel = setupTreeNode.getForm();
                immoToolSetupPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                immoToolSetupPanel.doLoad();
                this.selectedNodes.put(setupTreeNode, immoToolSetupPanel);
            }
            catch (Exception exception) {
                LOGGER.error((Object)"could not load setup-form!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantCreateSetupForm", new Object[0]), exception);
                return;
            }
        }
        immoToolSetupPanel.setOpaque(true);
        this.formPanel.removeAll();
        this.formPanel.setOpaque(true);
        this.formPanel.setLayout((LayoutManager)new BorderLayout());
        this.formPanel.add((Component)((Object)immoToolSetupPanel), (Object)"Center");
        this.formPanel.revalidate();
        this.formPanel.repaint();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.setupTree = new JTree();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.submitButton = new JButton();
        this.titleLabel = ImmoToolUtils.createHead1Separator("");
        this.formPanel = new JXPanel();
        this.projectLink = new JXHyperlink();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ImmoToolSetupDialog.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.jScrollPane1.setName("jScrollPane1");
        this.setupTree.setName("setupTree");
        this.setupTree.setRootVisible(false);
        this.jScrollPane1.setViewportView(this.setupTree);
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(ImmoToolSetupDialog.class, (Object)this);
        this.helpButton.setAction(applicationActionMap.get("doHelp"));
        this.helpButton.setName("helpButton");
        this.closeButton.setAction(applicationActionMap.get("doClose"));
        this.closeButton.setName("closeButton");
        this.submitButton.setAction(applicationActionMap.get("doSubmit"));
        this.submitButton.setName("submitButton");
        this.titleLabel.setIcon(resourceMap.getIcon("titleLabel.icon"));
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle(resourceMap.getString("titleLabel.title", new Object[0]));
        this.formPanel.setBorder((Border)new SoftBevelBorder(0));
        this.formPanel.setName("formPanel");
        GroupLayout groupLayout = new GroupLayout((Container)this.formPanel);
        this.formPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 532, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 448, Short.MAX_VALUE));
        this.projectLink.setAction(applicationActionMap.get("openProjectWebsite"));
        this.projectLink.setText("http://openestate.org/");
        this.projectLink.setName("projectLink");
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.titleLabel, -1, 728, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 184, -2).addComponent((Component)this.projectLink, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton)).addComponent((Component)this.formPanel, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 454, Short.MAX_VALUE).addComponent((Component)this.formPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.helpButton).addComponent(this.closeButton).addComponent(this.submitButton)).addComponent((Component)this.projectLink, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private final class SetupTreeNode
    extends DefaultMutableTreeNode
    implements ImmoToolSetupPanel.SetupPanelListener {
        public static final int NODE_ROOT = 0;
        public static final int NODE_CAT = 1;
        public static final int NODE_FORM = 2;
        private int nodeType;
        private String nodeTitle;
        private ImmoToolSetupPanel nodeForm;

        public SetupTreeNode() {
            this.nodeType = 0;
            this.nodeTitle = ImmoToolSetupDialog.this.resourceMap.getString("Form.title", new Object[0]);
            this.nodeForm = null;
        }

        public SetupTreeNode(String string) {
            this.nodeType = 1;
            this.nodeTitle = string;
            this.nodeForm = null;
        }

        public SetupTreeNode(ImmoToolSetupPanel immoToolSetupPanel) {
            this.nodeType = 2;
            this.nodeTitle = immoToolSetupPanel.getTitle();
            this.nodeForm = immoToolSetupPanel;
            ImmoToolSetupPanel[] immoToolSetupPanelArray = immoToolSetupPanel.getPanelChildren();
            if (immoToolSetupPanelArray != null && immoToolSetupPanelArray.length > 0) {
                for (ImmoToolSetupPanel immoToolSetupPanel2 : immoToolSetupPanelArray) {
                    this.add(new SetupTreeNode(immoToolSetupPanel2));
                }
            }
            immoToolSetupPanel.addSetupPanelListener(this);
        }

        @Override
        public void childPanelAdded(ImmoToolSetupPanel immoToolSetupPanel) {
            this.add(new SetupTreeNode(immoToolSetupPanel));
            ImmoToolSetupDialog.this.setupTree.repaint();
        }

        @Override
        public void childPanelRemoved(int n) {
            ImmoToolSetupDialog.this.selectedNodes.remove((SetupTreeNode)this.getChildAt(n));
            this.remove(n);
            ImmoToolSetupDialog.this.setupTree.repaint();
        }

        @Override
        public void childSelected(int n) {
            TreePath treePath = ImmoToolSetupDialog.this.setupTree.getSelectionPath();
            ImmoToolSetupDialog.this.setupTree.setSelectionPath(treePath.pathByAddingChild(this.getChildAt(n)));
        }

        @Override
        public void expandSelection() {
            ImmoToolSetupDialog.this.setupTree.expandPath(ImmoToolSetupDialog.this.setupTree.getSelectionPath());
        }

        public ImmoToolSetupPanel getForm() {
            return this.nodeForm;
        }

        public String getTitle() {
            return this.nodeTitle;
        }

        public int getType() {
            return this.nodeType;
        }

        @Override
        public void parentPanelSelected() {
            TreePath treePath = ImmoToolSetupDialog.this.setupTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            ImmoToolSetupDialog.this.setupTree.setSelectionPath(treePath.getParentPath());
        }

        @Override
        public String toString() {
            return this.getTitle();
        }
    }
}

