/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolSetupPanel;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.FormatterRule;
import com.openindex.openestate.tool.utils.RegexFormatter;
import com.openindex.openestate.tool.utils.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.lang.SystemUtils;
import org.jdesktop.application.ResourceMap;

public class ImmoToolSetupNetworkPanel
extends ImmoToolSetupPanel {
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ImmoToolSetupNetworkPanel.class);
    private ValidationHandler validationHandler = ImmoToolUtils.createValidationHandler();
    private JCheckBox httpProxyDisableBox;
    private JTextField httpProxyHostField;
    private JFormattedTextField httpProxyPortField;
    private JCheckBox ftpProxyDisableBox;
    private JTextField ftpProxyHostField;
    private JFormattedTextField ftpProxyPortField;
    private JTextField ftpActiveHostField;
    private JFormattedTextField ftpActivePortRangeField;

    public ImmoToolSetupNetworkPanel() {
        this.buildForm();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.httpProxyDisableBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImmoToolSetupNetworkPanel.this.httpProxyHostField.setEnabled(!ImmoToolSetupNetworkPanel.this.httpProxyDisableBox.isSelected());
                ImmoToolSetupNetworkPanel.this.httpProxyPortField.setEnabled(!ImmoToolSetupNetworkPanel.this.httpProxyDisableBox.isSelected());
                ImmoToolSetupNetworkPanel.this.validationHandler.validate();
            }
        });
        this.ftpProxyDisableBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImmoToolSetupNetworkPanel.this.ftpProxyHostField.setEnabled(!ImmoToolSetupNetworkPanel.this.ftpProxyDisableBox.isSelected());
                ImmoToolSetupNetworkPanel.this.ftpProxyPortField.setEnabled(!ImmoToolSetupNetworkPanel.this.ftpProxyDisableBox.isSelected());
                ImmoToolSetupNetworkPanel.this.validationHandler.validate();
            }
        });
        if (SystemUtils.IS_OS_MAC_OSX) {
            // empty if block
        }
    }

    private void buildForm() {
        this.httpProxyDisableBox = new JCheckBox();
        this.httpProxyDisableBox.setName("httpProxyDisableBox");
        this.httpProxyHostField = new JTextField();
        this.httpProxyHostField.setName("httpProxyHostField");
        this.httpProxyPortField = new JFormattedTextField(new RegexFormatter("\\d{1,5}"));
        this.httpProxyPortField.setName("httpProxyPortField");
        this.ftpProxyDisableBox = new JCheckBox();
        this.ftpProxyDisableBox.setName("ftpProxyDisableBox");
        this.ftpProxyHostField = new JTextField();
        this.ftpProxyHostField.setName("ftpProxyHostField");
        this.ftpProxyPortField = new JFormattedTextField(new RegexFormatter("\\d{1,5}"));
        this.ftpProxyPortField.setName("ftpProxyPortField");
        this.ftpActiveHostField = new JTextField();
        this.ftpActiveHostField.setName("ftpActiveHostField");
        this.ftpActivePortRangeField = new JFormattedTextField(new RegexFormatter("\\d{1,5}\\-\\d{1,5}"));
        this.ftpActivePortRangeField.setName("ftpActivePortRangeField");
        this.ftpActivePortRangeField.setText("6000-7000");
        this.validationHandler.putRule(this.httpProxyHostField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule(this.httpProxyPortField, new FormatterRule(this.httpProxyPortField));
        this.validationHandler.putRule(this.ftpProxyHostField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule(this.ftpProxyPortField, new FormatterRule(this.ftpProxyPortField));
        this.validationHandler.putRule(this.ftpActivePortRangeField, new FormatterRule(this.ftpActivePortRangeField));
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder("right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, pref, 3dlu, 30dlu");
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator(this.resourceMap.getString("label.httpProxy", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.httpProxy.host", new Object[0]), (Component)this.httpProxyHostField);
        defaultFormBuilder.append(this.resourceMap.getString("label.httpProxy.port", new Object[0]), (Component)this.httpProxyPortField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(" ", (Component)this.httpProxyDisableBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator(this.resourceMap.getString("label.ftpProxy", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.ftpProxy.host", new Object[0]), (Component)this.ftpProxyHostField);
        defaultFormBuilder.append(this.resourceMap.getString("label.ftpProxy.port", new Object[0]), (Component)this.ftpProxyPortField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(" ", (Component)this.ftpProxyDisableBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator(this.resourceMap.getString("label.ftpActive", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.ftpActive.host", new Object[0]), (Component)this.ftpActiveHostField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.ftpActive.portRange", new Object[0]), (Component)this.ftpActivePortRangeField, 5);
        defaultFormBuilder.nextLine();
        this.setLayout(new BorderLayout());
        this.add(defaultFormBuilder.getPanel(), "Center");
    }

    @Override
    public void doLoad() throws ImmoToolException {
        String string = ImmoToolApp.getApplicationHttpProxyHost();
        Integer n = ImmoToolApp.getApplicationHttpProxyPort();
        boolean bl = string != null && n != null;
        this.httpProxyDisableBox.setSelected(!bl);
        this.httpProxyHostField.setEnabled(bl);
        this.httpProxyHostField.setText(string != null ? string : "");
        this.httpProxyPortField.setEnabled(bl);
        this.httpProxyPortField.setText(n != null ? n.toString() : "");
        String string2 = ImmoToolApp.getApplicationFtpProxyHost();
        Integer n2 = ImmoToolApp.getApplicationFtpProxyPort();
        boolean bl2 = string2 != null && n2 != null;
        this.ftpProxyDisableBox.setSelected(!bl2);
        this.ftpProxyHostField.setEnabled(bl2);
        this.ftpProxyHostField.setText(string2 != null ? string2 : "");
        this.ftpProxyPortField.setEnabled(bl2);
        this.ftpProxyPortField.setText(n2 != null ? n2.toString() : "");
        String string3 = ImmoToolApp.getApplicationFtpActiveHost();
        String string4 = ImmoToolApp.getApplicationFtpActivePortRange();
        this.ftpActiveHostField.setText(string3 != null ? string3.trim() : "");
        this.ftpActivePortRangeField.setText(string4 != null ? string4.trim() : "");
        this.validationHandler.validate();
    }

    @Override
    public void doSave() throws ImmoToolException {
        try {
            ImmoToolApp.setApplicationHttpProxy(!this.httpProxyDisableBox.isSelected() ? this.httpProxyHostField.getText().trim() : null, !this.httpProxyDisableBox.isSelected() ? Integer.valueOf(this.httpProxyPortField.getText()) : null);
            ImmoToolApp.setApplicationFtpProxy(!this.ftpProxyDisableBox.isSelected() ? this.ftpProxyHostField.getText().trim() : null, !this.ftpProxyDisableBox.isSelected() ? Integer.valueOf(this.ftpProxyPortField.getText()) : null);
            String string = this.ftpActiveHostField.getText().trim();
            String string2 = this.ftpActivePortRangeField.getText().trim();
            ImmoToolApp.setApplicationFtpActive(string.length() > 0 ? string : null, string2.length() > 0 ? string2 : null);
        }
        catch (Exception exception) {
            throw new ImmoToolException(this.resourceMap.getString("message.cantSaveProxySetup", new Object[]{exception.getLocalizedMessage()}), exception);
        }
    }

    @Override
    public boolean doValidate() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("panelTitle", new Object[0]);
    }
}

