/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolException;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.swingx.JXPanel;

public abstract class ImmoToolSetupPanel
extends JXPanel {
    private ImmoToolSetupPanel panelParent = null;
    private final List<ImmoToolSetupPanel> panelChildren;
    private final List<SetupPanelListener> panelListeners;

    protected ImmoToolSetupPanel() {
        this.setOpaque(false);
        this.panelChildren = new ArrayList<ImmoToolSetupPanel>();
        this.panelListeners = new ArrayList<SetupPanelListener>();
    }

    public void addChildPanel(ImmoToolSetupPanel immoToolSetupPanel) {
        this.panelChildren.add(immoToolSetupPanel);
        immoToolSetupPanel.setPanelParent(this);
        for (SetupPanelListener setupPanelListener : this.panelListeners) {
            setupPanelListener.childPanelAdded(immoToolSetupPanel);
        }
    }

    public void addSetupPanelListener(SetupPanelListener setupPanelListener) {
        this.panelListeners.add(setupPanelListener);
    }

    public abstract void doLoad() throws ImmoToolException;

    public abstract void doSave() throws ImmoToolException;

    public abstract boolean doValidate();

    public void expandSelection() {
        for (SetupPanelListener setupPanelListener : this.panelListeners) {
            setupPanelListener.expandSelection();
        }
    }

    public ImmoToolSetupPanel[] getPanelChildren() {
        return this.panelChildren.toArray(new ImmoToolSetupPanel[this.panelChildren.size()]);
    }

    public ImmoToolSetupPanel getPanelParent() {
        return this.panelParent;
    }

    public abstract String getTitle();

    public void removeChildPanel(int n) {
        if (this.panelChildren.size() > n && n >= 0) {
            this.panelChildren.remove(n);
            for (SetupPanelListener setupPanelListener : this.panelListeners) {
                setupPanelListener.childPanelRemoved(n);
            }
        }
    }

    public final void removeChildPanel(ImmoToolSetupPanel immoToolSetupPanel) {
        int n = this.panelChildren.indexOf((Object)immoToolSetupPanel);
        if (n >= 0) {
            this.removeChildPanel(n);
        }
    }

    public void removeSetupPanelListener(SetupPanelListener setupPanelListener) {
        if (this.panelListeners.contains(setupPanelListener)) {
            this.panelListeners.remove(setupPanelListener);
        }
    }

    protected void selectChildPanel(int n) {
        for (SetupPanelListener setupPanelListener : this.panelListeners) {
            setupPanelListener.childSelected(n);
        }
    }

    protected void selectChildPanel(ImmoToolSetupPanel immoToolSetupPanel) {
        int n = this.panelChildren.indexOf((Object)immoToolSetupPanel);
        if (n >= 0) {
            this.selectChildPanel(n);
        }
    }

    protected void selectParentPanel() {
        for (SetupPanelListener setupPanelListener : this.panelListeners) {
            setupPanelListener.parentPanelSelected();
        }
    }

    private void setPanelParent(ImmoToolSetupPanel immoToolSetupPanel) {
        this.panelParent = immoToolSetupPanel;
    }

    public static interface SetupPanelListener {
        public void childPanelAdded(ImmoToolSetupPanel var1);

        public void childPanelRemoved(int var1);

        public void childSelected(int var1);

        public void expandSelection();

        public void parentPanelSelected();
    }
}

