/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolSetupPanel;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.SyndicationFeed;
import com.openindex.openestate.tool.utils.SyndicationFeedDialog;
import com.openindex.openestate.tool.utils.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXTable;

public class ImmoToolSetupSyndicationPanel
extends ImmoToolSetupPanel {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolSetupSyndicationPanel.class);
    private final ActionMap actionMap = ImmoToolUtils.getActionMap(ImmoToolSetupSyndicationPanel.class, (Object)this);
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ImmoToolSetupSyndicationPanel.class);
    private final ValidationHandler validationHandler = ImmoToolUtils.createValidationHandler();
    private JButton addFeedButton = null;
    private JButton editFeedButton = null;
    private JButton removeFeedButton = null;
    private JXTable feedTable = null;
    private FeedTableModel feedTableModel = null;
    private JLabel feedInfoLabel = null;

    public ImmoToolSetupSyndicationPanel() {
        this.buildForm();
        ImmoToolUtils.configureTable(this.feedTable);
        this.resourceMap.injectComponents((Component)((Object)this));
    }

    private void buildForm() {
        this.feedInfoLabel = new JLabel();
        this.feedInfoLabel.setName("feedInfoLabel");
        this.feedTable = new JXTable();
        this.feedTableModel = new FeedTableModel();
        this.feedTable.setModel((TableModel)this.feedTableModel);
        this.feedTable.setName("feedTable");
        this.feedTable.setEditable(false);
        this.feedTable.getSelectionModel().setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane((Component)this.feedTable);
        this.addFeedButton = new JButton(this.actionMap.get("doAddFeed"));
        this.addFeedButton.setName("addFeedButton");
        this.editFeedButton = new JButton(this.actionMap.get("doEditFeed"));
        this.editFeedButton.setName("editFeedButton");
        this.removeFeedButton = new JButton(this.actionMap.get("doRemoveFeed"));
        this.removeFeedButton.setName("removeFeedButton");
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.addFeedButton);
        jPanel.add(this.editFeedButton);
        jPanel.add(this.removeFeedButton);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder("pref:grow, 3dlu, pref");
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator(this.resourceMap.getString("feedInfoTitle", new Object[0])));
        defaultFormBuilder.append((Component)jPanel);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.feedInfoLabel, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "), 3);
        defaultFormBuilder.nextLine();
        this.setLayout(new BorderLayout());
        this.add(defaultFormBuilder.getPanel(), "North");
        this.add(jScrollPane, "Center");
    }

    @Action
    public void doAddFeed() {
        SyndicationFeedDialog syndicationFeedDialog = new SyndicationFeedDialog();
        syndicationFeedDialog.setVisible(true);
        int n = syndicationFeedDialog.getStatus();
        if (n != 2) {
            return;
        }
        try {
            SyndicationFeed syndicationFeed = new SyndicationFeed();
            syndicationFeed.setTitle(syndicationFeedDialog.getFeedTitle());
            syndicationFeed.setUrl(syndicationFeedDialog.getFeedUrl());
            this.feedTableModel.addFeed(syndicationFeed);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not add syndication-feed!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    @Action
    public void doEditFeed() {
        int n = this.feedTable.getSelectedRow();
        if (n < 0) {
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.noEditableFeedSelected", new Object[0]));
            return;
        }
        SyndicationFeedDialog syndicationFeedDialog = new SyndicationFeedDialog();
        syndicationFeedDialog.load(this.feedTableModel.getFeedTitleAt(n), this.feedTableModel.getFeedUrlAt(n));
        syndicationFeedDialog.setVisible(true);
        int n2 = syndicationFeedDialog.getStatus();
        if (n2 != 2) {
            return;
        }
        try {
            this.feedTableModel.setValueAt(syndicationFeedDialog.getFeedTitle(), n, 0);
            this.feedTableModel.setValueAt(syndicationFeedDialog.getFeedUrl(), n, 1);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not modify syndication-feed!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    @Override
    public void doLoad() throws ImmoToolException {
        this.feedTableModel.clear();
        for (SyndicationFeed syndicationFeed : SyndicationFeed.loadSyndicationFeeds()) {
            this.feedTableModel.addFeed(syndicationFeed);
        }
        this.feedTable.packAll();
    }

    @Action
    public void doRemoveFeed() {
        int n = this.feedTable.getSelectedRow();
        if (n < 0) {
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.noDeletableFeedSelected", new Object[0]));
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog(this.resourceMap.getString("question.reallyDeleteSelectedFeed", new Object[0]));
        if (!bl) {
            return;
        }
        this.feedTable.getSelectionModel().clearSelection();
        this.feedTableModel.removeRow(n);
    }

    @Override
    public void doSave() throws ImmoToolException {
        ArrayList<SyndicationFeed> arrayList = new ArrayList<SyndicationFeed>();
        for (int i = 0; i < this.feedTableModel.getRowCount(); ++i) {
            String string = this.feedTableModel.getFeedTitleAt(i);
            URL uRL = this.feedTableModel.getFeedUrlAt(i);
            SyndicationFeed syndicationFeed = new SyndicationFeed(string, uRL);
            arrayList.add(syndicationFeed);
        }
        SyndicationFeed.storeSyndicationFeeds(arrayList.toArray(new SyndicationFeed[arrayList.size()]));
    }

    @Override
    public boolean doValidate() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("panelTitle", new Object[0]);
    }

    private class FeedTableModel
    extends DefaultTableModel {
        public static final int COLUMN_TITLE = 0;
        public static final int COLUMN_URL = 1;
        private final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
        private final Map<Integer, Class> COLUMN_CLASSES;

        public FeedTableModel() {
            this.COLUMN_NAMES.put(0, ImmoToolSetupSyndicationPanel.this.resourceMap.getString("feedTableCol.title", new Object[0]));
            this.COLUMN_NAMES.put(1, ImmoToolSetupSyndicationPanel.this.resourceMap.getString("feedTableCol.url", new Object[0]));
            this.COLUMN_CLASSES = new HashMap<Integer, Class>();
            this.COLUMN_CLASSES.put(0, String.class);
            this.COLUMN_CLASSES.put(1, URL.class);
            this.setColumnCount(this.COLUMN_NAMES.size());
        }

        public void addFeed(SyndicationFeed syndicationFeed) {
            this.addRow(this.buildRow(syndicationFeed));
        }

        private Object[] buildRow(SyndicationFeed syndicationFeed) {
            TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
            treeMap.put(0, syndicationFeed.getTitle() != null ? syndicationFeed.getTitle() : "");
            treeMap.put(1, syndicationFeed.getUrl());
            return treeMap.values().toArray(new Object[treeMap.size()]);
        }

        public void clear() {
            while (this.getRowCount() > 0) {
                this.removeRow(0);
            }
        }

        public Class getColumnClass(int n) {
            return this.COLUMN_CLASSES.containsKey(n) ? this.COLUMN_CLASSES.get(n) : null;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES.containsKey(n) ? this.COLUMN_NAMES.get(n) : null;
        }

        public String getFeedTitleAt(int n) {
            int n2 = n;
            return (String)this.getValueAt(n2, 0);
        }

        public URL getFeedUrlAt(int n) {
            int n2 = n;
            return (URL)this.getValueAt(n2, 1);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

