/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolSetupPanel;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.roydesign.io.ApplicationFile;
import net.roydesign.ui.ApplicationDialog;
import org.apache.commons.lang.SystemUtils;
import org.jdesktop.application.ResourceMap;

public class ImmoToolSetupSystemPanel
extends ImmoToolSetupPanel {
    private static File lastAppLocation = null;
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ImmoToolSetupSystemPanel.class);
    private ValidationHandler validationHandler = ImmoToolUtils.createValidationHandler();
    private JLabel autoUpdateInfoLabel;
    private JCheckBox autoUpdateProgramBox;
    private JCheckBox autoUpdateModulesBox;
    private JTextField applicationBrowserField;
    private JTextField applicationPdfReaderField;
    private JButton applicationBrowserButton;
    private JButton applicationPdfReaderButton;

    public ImmoToolSetupSystemPanel() {
        this.buildForm();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.applicationBrowserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImmoToolSetupSystemPanel.this.selectWebBrowser();
            }
        });
        this.applicationPdfReaderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImmoToolSetupSystemPanel.this.selectPdfReader();
            }
        });
    }

    private void buildForm() {
        this.autoUpdateInfoLabel = new JLabel();
        this.autoUpdateInfoLabel.setName("autoUpdateInfoLabel");
        this.autoUpdateProgramBox = new JCheckBox();
        this.autoUpdateProgramBox.setName("autoUpdateProgramBox");
        this.autoUpdateProgramBox.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        this.autoUpdateModulesBox = new JCheckBox();
        this.autoUpdateModulesBox.setName("autoUpdateModulesBox");
        this.autoUpdateModulesBox.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        this.applicationBrowserField = new JTextField();
        this.applicationBrowserField.setName("applicationBrowserField");
        this.applicationBrowserButton = new JButton();
        this.applicationBrowserButton.setName("applicationBrowserButton");
        this.applicationPdfReaderField = new JTextField();
        this.applicationPdfReaderField.setName("applicationPdfReaderField");
        this.applicationPdfReaderButton = new JButton();
        this.applicationPdfReaderButton.setName("applicationPdfReaderButton");
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder("right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, pref");
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator(this.resourceMap.getString("label.autoUpdate", new Object[0])), 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.autoUpdateInfoLabel, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.autoUpdateProgramBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.autoUpdateModulesBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "), 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator(this.resourceMap.getString("label.applications", new Object[0])), 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.applications.browser", new Object[0]), (Component)this.applicationBrowserField);
        defaultFormBuilder.append((Component)this.applicationBrowserButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.applications.pdfReader", new Object[0]), (Component)this.applicationPdfReaderField);
        defaultFormBuilder.append((Component)this.applicationPdfReaderButton);
        defaultFormBuilder.nextLine();
        this.setLayout(new BorderLayout());
        this.add(defaultFormBuilder.getPanel(), "Center");
    }

    @Override
    public void doLoad() throws ImmoToolException {
        String string = ImmoToolApp.getApplicationPathToWebBrowser();
        String string2 = ImmoToolApp.getApplicationPathToPdfReader();
        this.autoUpdateProgramBox.setSelected(ImmoToolApp.isApplicationAutoUpdateProgram());
        this.autoUpdateModulesBox.setSelected(ImmoToolApp.isApplicationAutoUpdateAddons());
        this.applicationBrowserField.setText(string != null ? string : "");
        this.applicationPdfReaderField.setText(string2 != null ? string2 : "");
    }

    @Override
    public void doSave() throws ImmoToolException {
        String string = this.applicationBrowserField.getText().trim();
        String string2 = this.applicationPdfReaderField.getText().trim();
        ImmoToolApp.setApplicationAutoUpdateProgram(this.autoUpdateProgramBox.isSelected());
        ImmoToolApp.setApplicationAutoUpdateAddons(this.autoUpdateModulesBox.isSelected());
        ImmoToolApp.setApplicationPathToWebBrowser(string.length() > 0 ? string : null);
        ImmoToolApp.setApplicationPathToPdfReader(string2.length() > 0 ? string2 : null);
    }

    @Override
    public boolean doValidate() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("panelTitle", new Object[0]);
    }

    private void selectPdfReader() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            ApplicationDialog applicationDialog = new ApplicationDialog((Frame)ImmoToolApp.getApplication().getMainFrame(), this.resourceMap.getString("message.selectPdfReader", new Object[0]));
            applicationDialog.show();
            ApplicationFile applicationFile = applicationDialog.getApplicationFile();
            if (applicationFile == null) {
                return;
            }
            this.applicationPdfReaderField.setText(applicationFile.getAbsolutePath());
            this.applicationPdfReaderField.setCaretPosition(0);
        } else {
            int n;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(this.resourceMap.getString("message.selectPdfReader", new Object[0]));
            jFileChooser.setApproveButtonText(this.resourceMap.getString("message.selectExecutableFile", new Object[0]));
            if (lastAppLocation != null) {
                jFileChooser.setSelectedFile(new File(lastAppLocation.getPath() + File.separator + "."));
            }
            if ((n = jFileChooser.showOpenDialog(null)) != 0) {
                return;
            }
            lastAppLocation = jFileChooser.getSelectedFile().getParentFile().getAbsoluteFile();
            this.applicationPdfReaderField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            this.applicationPdfReaderField.setCaretPosition(0);
        }
    }

    private void selectWebBrowser() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            ApplicationDialog applicationDialog = new ApplicationDialog((Frame)ImmoToolApp.getApplication().getMainFrame(), this.resourceMap.getString("message.selectWebBrowser", new Object[0]));
            applicationDialog.show();
            ApplicationFile applicationFile = applicationDialog.getApplicationFile();
            if (applicationFile == null) {
                return;
            }
            this.applicationBrowserField.setText(applicationFile.getAbsolutePath());
            this.applicationBrowserField.setCaretPosition(0);
        } else {
            int n;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(this.resourceMap.getString("message.selectWebBrowser", new Object[0]));
            jFileChooser.setApproveButtonText(this.resourceMap.getString("message.selectExecutableFile", new Object[0]));
            if (lastAppLocation != null) {
                jFileChooser.setSelectedFile(new File(lastAppLocation.getPath() + File.separator + "."));
            }
            if ((n = jFileChooser.showOpenDialog(null)) != 0) {
                return;
            }
            lastAppLocation = jFileChooser.getSelectedFile().getParentFile().getAbsoluteFile();
            this.applicationBrowserField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            this.applicationBrowserField.setCaretPosition(0);
        }
    }
}

