/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolTaskCancelledException;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolTaskException;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;

public abstract class ImmoToolTask<ResultType>
extends Task<ResultType, Void> {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolTask.class);
    private ImmoToolTaskDialog taskDialog = null;
    private String taskName = null;
    private ResourceMap taskResourceMap = null;
    private List<TaskMessageListener> messageListeners;

    public ImmoToolTask() {
        this(null);
    }

    public ImmoToolTask(String string) {
        super(Application.getInstance());
        String[] stringArray = ((Object)((Object)this)).getClass().getName().split("\\.");
        this.taskName = stringArray[stringArray.length - 1];
        this.taskResourceMap = ImmoToolUtils.getResourceMap(ImmoToolTask.class);
        this.messageListeners = new ArrayList<TaskMessageListener>();
        if (string != null) {
            this.setTitle(string);
        }
    }

    public void addMessageListener(TaskMessageListener taskMessageListener) {
        this.messageListeners.add(taskMessageListener);
    }

    protected void checkCancelled() throws ImmoToolTaskCancelledException {
        if (this.isCancelled()) {
            throw new ImmoToolTaskCancelledException("Task was cancelled.");
        }
    }

    public Callback createCallback() {
        return new Callback(this);
    }

    protected final ResultType doInBackground() throws ImmoToolTaskException {
        try {
            return this.executeTask();
        }
        catch (ImmoToolTaskException immoToolTaskException) {
            throw immoToolTaskException;
        }
        catch (Exception exception) {
            throw new ImmoToolTaskException(exception.getLocalizedMessage(), exception);
        }
    }

    protected void cancelled() {
        super.cancelled();
        LOGGER.error((Object)("[" + this.taskName + "] task was cancelled"));
        this.setMessage(this.taskResourceMap.getString("message.taskCancelled", new Object[0]));
    }

    protected abstract ResultType executeTask() throws Exception;

    protected void failed(Throwable throwable) {
        if (throwable instanceof ImmoToolTaskCancelledException || throwable.getCause() instanceof ImmoToolTaskCancelledException) {
            LOGGER.error((Object)("[" + this.taskName + "] task was cancelled"));
            this.setMessage(this.taskResourceMap.getString("message.taskCancelled", new Object[0]));
        } else {
            String string = throwable.getLocalizedMessage();
            if (string == null) {
                string = "null";
            }
            LOGGER.error((Object)("[" + this.taskName + "] task failed"));
            LOGGER.error((Object)("[" + this.taskName + "] > " + throwable.getLocalizedMessage()));
            this.setMessage(this.taskResourceMap.getString("message.taskError", new Object[0]));
            this.setMessage("> " + this.taskResourceMap.getString("message.checkProtocolAndContactDevelopers", new Object[0]));
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.setMessage("> " + string + SystemUtils.LINE_SEPARATOR + "----- " + this.taskResourceMap.getString("message.taskErrorStackBegin", new Object[0]) + " -----" + SystemUtils.LINE_SEPARATOR + stringWriter.toString().trim() + SystemUtils.LINE_SEPARATOR + "----- " + this.taskResourceMap.getString("message.taskErrorStackEnd", new Object[0]) + " -----");
            this.setMessage(this.taskResourceMap.getString("message.taskFailed", new Object[0]));
        }
        super.failed(throwable);
    }

    protected void finished() {
        super.finished();
    }

    public ImmoToolTaskDialog getTaskDialog() {
        return this.taskDialog;
    }

    public void removeMessageListener(TaskMessageListener taskMessageListener) {
        this.messageListeners.remove(taskMessageListener);
    }

    protected void setMessage(String string) {
        if (string != null) {
            for (TaskMessageListener taskMessageListener : this.messageListeners) {
                taskMessageListener.taskMessage(string);
            }
        }
        super.setMessage(string);
    }

    public void setTaskDialog(ImmoToolTaskDialog immoToolTaskDialog) {
        this.taskDialog = immoToolTaskDialog;
    }

    protected void succeeded(ResultType ResultType) {
        super.succeeded(ResultType);
    }

    public static interface TaskMessageListener {
        public void taskMessage(String var1);
    }

    public static class Callback {
        private ImmoToolTask task;

        private Callback(ImmoToolTask immoToolTask) {
            this.task = immoToolTask;
        }

        public void checkCancelled() throws ImmoToolTaskCancelledException {
            this.task.checkCancelled();
        }

        public ImmoToolTask getTask() {
            return this.task;
        }

        public void setMessage(String string) {
            this.getTask().setMessage(string);
        }

        public void setProgress(int n, int n2, int n3) {
            this.getTask().setProgress(n, n2, n3);
        }
    }
}

