/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskCancelledException;
import java.util.ArrayList;
import java.util.List;

public class ImmoToolTaskContainer
extends ImmoToolTask<Boolean> {
    private List<ImmoToolTask> children = new ArrayList<ImmoToolTask>();
    private boolean cancelOnFail = true;
    private ImmoToolTask.TaskMessageListener messageListener = new ImmoToolTask.TaskMessageListener(){

        @Override
        public void taskMessage(String string) {
            ImmoToolTaskContainer.this.setMessage("> " + string);
        }
    };

    public ImmoToolTaskContainer() {
    }

    public ImmoToolTaskContainer(String string) {
        this();
        this.setTitle(string);
    }

    public void add(ImmoToolTask immoToolTask) {
        immoToolTask.addMessageListener(this.messageListener);
        this.children.add(immoToolTask);
    }

    @Override
    protected void cancelled() {
        super.cancelled();
        for (ImmoToolTask immoToolTask : this.children) {
            if (immoToolTask.isCancelled()) continue;
            immoToolTask.cancel(true);
        }
    }

    protected void cancelTask(ImmoToolTask immoToolTask) {
        immoToolTask.cancelled();
    }

    public int count() {
        return this.children.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Boolean executeTask() throws Exception {
        int n = 0;
        for (ImmoToolTask immoToolTask : this.children) {
            this.checkCancelled();
            if (++n > 1) {
                this.setMessage("--------------");
            }
            this.setMessage(n + ". " + immoToolTask.getTitle());
            this.prepareTask(immoToolTask);
            try {
                Object ResultType = immoToolTask.executeTask();
                this.succeedTask(immoToolTask, ResultType);
            }
            catch (ImmoToolTaskCancelledException immoToolTaskCancelledException) {
                this.setMessage("Cancel main task.");
                break;
            }
            catch (Throwable throwable) {
                if (throwable.getCause() instanceof ImmoToolTaskCancelledException) {
                    this.setMessage("Cancel main task.");
                    break;
                }
                this.failTask(immoToolTask, throwable);
                if (!this.isCancelOnFail()) continue;
                throw new Exception("A child task failed!", throwable);
            }
            finally {
                this.finishTask(immoToolTask);
            }
        }
        return true;
    }

    protected void failTask(ImmoToolTask immoToolTask, Throwable throwable) {
        immoToolTask.failed(throwable);
    }

    protected void finishTask(ImmoToolTask immoToolTask) {
        immoToolTask.finished();
    }

    public List<ImmoToolTask> getChildren() {
        return this.children;
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public boolean isCancelOnFail() {
        return this.cancelOnFail;
    }

    protected void prepareTask(ImmoToolTask immoToolTask) {
    }

    public void setCancelOnFail(boolean bl) {
        this.cancelOnFail = bl;
    }

    protected void succeedTask(ImmoToolTask immoToolTask, Object object) {
        immoToolTask.succeeded(object);
    }
}

