/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class ImmoToolTaskDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolTaskDialog.class);
    private static final String LN = SystemUtils.LINE_SEPARATOR;
    private static File lastSaveLocation = null;
    private ResourceMap resourceMap = null;
    private ArrayList<ImmoToolTask> tasks = new ArrayList();
    private boolean taskError = false;
    private boolean taskCancel = false;
    private Task mainTask = null;
    private JCheckBox autoCloseDialogBox;
    private JXPanel bgPanel;
    private JXBusyLabel busyLabel;
    private JButton cancelActionButton;
    private JButton closeWindowButton;
    private JScrollPane protocolScroller;
    private JTextArea protocolTextArea;
    private JXTitledSeparator protocolTitle;
    private JButton saveProtocolButton;
    private JXTitledSeparator titleLabel;

    public ImmoToolTaskDialog() {
        this((Frame)ImmoToolApp.getApplication().getMainFrame(), true);
    }

    public ImmoToolTaskDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolTaskDialog.class);
        this.initComponents();
        this.setLocationRelativeTo(frame);
        this.bgPanel.setBackgroundPainter(ImmoToolUtils.getBackgroundPainter(this.getSize().height));
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.saveProtocolButton.setOpaque(false);
            this.closeWindowButton.setOpaque(false);
            this.cancelActionButton.setOpaque(false);
        }
    }

    public void addTask(ImmoToolTask immoToolTask) {
        immoToolTask.setTaskDialog(this);
        this.tasks.add(immoToolTask);
    }

    @Action
    public void doCancelAction() {
        this.taskCancel = true;
        if (this.mainTask != null) {
            LOGGER.debug((Object)"CANCEL MAIN TASK");
            this.mainTask.cancel(true);
        }
    }

    @Action
    public void doCloseWindow() {
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Action
    public void doSaveProtocol() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.resourceMap.getString("question.saveProtocolLocation", new Object[0]));
        String string = this.resourceMap.getString("message.defaultProtocolFile", new Object[]{System.currentTimeMillis()});
        Object object = this;
        synchronized (object) {
            if (lastSaveLocation != null) {
                jFileChooser.setSelectedFile(new File(lastSaveLocation.getAbsolutePath() + File.separator + string));
            } else {
                jFileChooser.setSelectedFile(new File(string));
            }
            int n = jFileChooser.showSaveDialog(this);
            if (n != 0) {
                return;
            }
            lastSaveLocation = jFileChooser.getSelectedFile().getParentFile();
        }
        object = null;
        try {
            object = new FileWriter(jFileChooser.getSelectedFile());
            ((Writer)object).write(this.protocolTextArea.getText().trim());
            ((OutputStreamWriter)object).close();
            ImmoToolUtils.showMessageInfoDialog(this.resourceMap.getString("message.protocolSaved", new Object[]{jFileChooser.getSelectedFile().getPath()}));
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not save protocol!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantSaveProtocol", new Object[0]), exception);
        }
    }

    public void execute() {
        LOGGER.debug((Object)("Executing " + this.tasks.size() + " tasks..."));
        this.closeWindowButton.setEnabled(false);
        this.saveProtocolButton.setEnabled(false);
        final TaskListener taskListener = new TaskListener(){

            public void doInBackground(TaskEvent taskEvent) {
            }

            public void process(TaskEvent taskEvent) {
            }

            public void succeeded(TaskEvent taskEvent) {
            }

            public void failed(TaskEvent taskEvent) {
                ImmoToolTaskDialog.this.writeProtocolLine("> FAILED");
                ImmoToolTaskDialog.this.taskError = true;
                ImmoToolTaskDialog.this.setAutoCloseSelected(false);
            }

            public void cancelled(TaskEvent taskEvent) {
                ImmoToolTaskDialog.this.writeProtocolLine("> CANCELLED");
                ImmoToolTaskDialog.this.taskError = true;
                ImmoToolTaskDialog.this.taskCancel = true;
            }

            public void interrupted(TaskEvent taskEvent) {
                ImmoToolTaskDialog.this.writeProtocolLine("> INTERRUPTED");
                ImmoToolTaskDialog.this.taskError = true;
                ImmoToolTaskDialog.this.taskCancel = true;
            }

            public void finished(TaskEvent taskEvent) {
            }
        };
        final ImmoToolTask.TaskMessageListener taskMessageListener = new ImmoToolTask.TaskMessageListener(){

            @Override
            public void taskMessage(String string) {
                ImmoToolTaskDialog.this.writeProtocolLine("> " + string);
            }
        };
        this.mainTask = new ImmoToolTask<Boolean>(){

            @Override
            protected Boolean executeTask() throws Exception {
                ImmoToolTaskDialog.this.busyLabel.setBusy(true);
                ImmoToolTaskDialog.this.busyLabel.setText(ImmoToolTaskDialog.this.resourceMap.getString("message.taskIsRunning", new Object[0]));
                int n = 0;
                for (ImmoToolTask immoToolTask : ImmoToolTaskDialog.this.tasks) {
                    if (ImmoToolTaskDialog.this.taskCancel) {
                        throw new Exception("Tasks cancelled.");
                    }
                    immoToolTask.addMessageListener(taskMessageListener);
                    immoToolTask.addTaskListener(taskListener);
                    if (++n > 1) {
                        ImmoToolTaskDialog.this.writeProtocolLine("");
                    }
                    ImmoToolTaskDialog.this.writeProtocolLine(n + ". " + immoToolTask.getTitle());
                    ImmoToolTaskDialog.this.busyLabel.setText(immoToolTask.getTitle());
                    ImmoToolTaskDialog.this.busyLabel.setToolTipText(immoToolTask.getDescription());
                    ImmoToolUtils.executeTask(immoToolTask);
                    while (!immoToolTask.isDone()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            ImmoToolTaskDialog.this.taskError = true;
                            throw exception;
                        }
                    }
                }
                return true;
            }

            @Override
            protected void cancelled() {
                super.cancelled();
                LOGGER.debug((Object)"main-task cancelled");
                for (ImmoToolTask immoToolTask : ImmoToolTaskDialog.this.tasks) {
                    LOGGER.debug((Object)("> cancel child-task '" + immoToolTask.getTitle() + "'"));
                    immoToolTask.cancel(true);
                }
            }

            @Override
            protected void finished() {
                super.finished();
                ImmoToolTaskDialog.this.setFinished();
            }
        };
        ImmoToolUtils.executeTask(this.mainTask);
        try {
            this.setVisible(true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't show task-dialog!");
            LOGGER.error((Object)"> Execution will be cancelled.");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            this.doCancelAction();
        }
    }

    public static void execute(ImmoToolTask immoToolTask) {
        if (immoToolTask == null) {
            return;
        }
        ImmoToolTaskDialog immoToolTaskDialog = new ImmoToolTaskDialog();
        immoToolTaskDialog.addTask(immoToolTask);
        immoToolTaskDialog.execute();
    }

    public static void execute(ImmoToolTask[] immoToolTaskArray) {
        ImmoToolTaskDialog immoToolTaskDialog = new ImmoToolTaskDialog();
        for (ImmoToolTask immoToolTask : immoToolTaskArray) {
            if (immoToolTask == null) continue;
            immoToolTaskDialog.addTask(immoToolTask);
        }
        if (!immoToolTaskDialog.tasks.isEmpty()) {
            immoToolTaskDialog.execute();
        }
    }

    public boolean isAutoCloseSelected() {
        return this.autoCloseDialogBox.isSelected();
    }

    public void setAutoCloseSelected(boolean bl) {
        this.autoCloseDialogBox.setSelected(bl);
    }

    public void setCancellingAllowed(boolean bl) {
        this.cancelActionButton.setEnabled(bl);
    }

    private void setFinished() {
        this.busyLabel.setBusy(false);
        this.busyLabel.setText(this.resourceMap.getString(this.taskError ? "error.taskFailed" : "message.taskExecuted", new Object[0]));
        this.closeWindowButton.setEnabled(true);
        this.saveProtocolButton.setEnabled(true);
        this.autoCloseDialogBox.setEnabled(false);
        this.cancelActionButton.setEnabled(false);
        if (!this.taskError && this.autoCloseDialogBox.isSelected()) {
            this.setVisible(false);
        }
    }

    public boolean wasSuccessful() {
        return !this.taskError;
    }

    private synchronized void writeProtocolLine(String string) {
        try {
            if (!StringUtils.isEmpty((String)this.protocolTextArea.getText())) {
                this.protocolTextArea.append(LN);
            }
            this.protocolTextArea.append(string);
            int n = this.protocolTextArea.getText().length() - string.length();
            if (n > 0) {
                this.protocolTextArea.setCaretPosition(n);
            } else {
                n = this.protocolTextArea.getText().length();
                if (n > 0) {
                    this.protocolTextArea.setCaretPosition(n);
                }
            }
        }
        catch (Error error) {
            LOGGER.warn((Object)("Can't write protocol line: \"" + string + "\""));
            LOGGER.warn((Object)("> " + error.getLocalizedMessage()), (Throwable)error);
        }
    }

    private void initComponents() {
        this.bgPanel = new JXPanel();
        this.titleLabel = ImmoToolUtils.createHead1Separator("");
        this.busyLabel = new JXBusyLabel();
        this.protocolTitle = ImmoToolUtils.createHead1Separator("");
        this.protocolScroller = new JScrollPane();
        this.protocolTextArea = new RTextArea();
        this.autoCloseDialogBox = new JCheckBox();
        this.saveProtocolButton = new JButton();
        this.closeWindowButton = new JButton();
        this.cancelActionButton = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ImmoToolTaskDialog.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setMinimumSize(new Dimension(450, 350));
        this.setName("Form");
        this.bgPanel.setName("bgPanel");
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle(resourceMap.getString("titleLabel.title", new Object[0]));
        this.busyLabel.setText("busyLabel");
        this.busyLabel.setIconTextGap(10);
        this.busyLabel.setName("busyLabel");
        this.protocolTitle.setName("protocolTitle");
        this.protocolTitle.setTitle(resourceMap.getString("protocolTitle.title", new Object[0]));
        this.protocolScroller.setName("protocolScroller");
        this.protocolTextArea.setColumns(20);
        this.protocolTextArea.setEditable(false);
        this.protocolTextArea.setFont(new Font("Courier New", 0, 14));
        this.protocolTextArea.setRows(5);
        this.protocolTextArea.setTabSize(4);
        this.protocolTextArea.setName("protocolTextArea");
        this.protocolScroller.setViewportView(this.protocolTextArea);
        this.autoCloseDialogBox.setSelected(true);
        this.autoCloseDialogBox.setText(resourceMap.getString("autoCloseDialogBox.text", new Object[0]));
        this.autoCloseDialogBox.setContentAreaFilled(false);
        this.autoCloseDialogBox.setName("autoCloseDialogBox");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(ImmoToolTaskDialog.class, (Object)this);
        this.saveProtocolButton.setAction(applicationActionMap.get("doSaveProtocol"));
        this.saveProtocolButton.setName("saveProtocolButton");
        this.closeWindowButton.setAction(applicationActionMap.get("doCloseWindow"));
        this.closeWindowButton.setName("closeWindowButton");
        this.cancelActionButton.setAction(applicationActionMap.get("doCancelAction"));
        this.cancelActionButton.setName("cancelActionButton");
        GroupLayout groupLayout = new GroupLayout((Container)this.bgPanel);
        this.bgPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.protocolScroller, GroupLayout.Alignment.LEADING, -1, 454, Short.MAX_VALUE).addComponent((Component)this.titleLabel, GroupLayout.Alignment.LEADING, -1, 454, Short.MAX_VALUE).addComponent((Component)this.busyLabel, -1, 454, Short.MAX_VALUE).addComponent((Component)this.protocolTitle, -1, 454, Short.MAX_VALUE).addComponent(this.autoCloseDialogBox, GroupLayout.Alignment.LEADING, -1, 454, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.cancelActionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 223, Short.MAX_VALUE).addComponent(this.saveProtocolButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeWindowButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.busyLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.protocolTitle, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.protocolScroller, -1, 288, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.autoCloseDialogBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeWindowButton).addComponent(this.saveProtocolButton).addComponent(this.cancelActionButton)).addContainerGap()));
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.bgPanel, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.bgPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }
}

