/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolErrorDialog;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolHelpDialog;
import com.openindex.openestate.tool.ImmoToolPlugin;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolView;
import com.openindex.openestate.tool.utils.ModificationHandler;
import com.openindex.openestate.tool.utils.TabComponent;
import com.openindex.openestate.tool.utils.ValidationHandler;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.MimeUtil2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.IDN;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.text.BreakIterator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.roydesign.io.ApplicationFile;
import net.roydesign.mac.MRJAdapter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.log4j.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import sun.awt.AppContext;

public class ImmoToolUtils {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolUtils.class);
    public static final Color BG_COLOR_1 = Color.WHITE;
    public static final Color BG_COLOR_2 = new Color(66, 105, 173);
    public static final Color TABLE_HIGHLIGHT_COLOR = HighlighterFactory.BEIGE;
    public static final MimeType UNKNOWN_MIME_TYPE = MimeUtil2.UNKNOWN_MIME_TYPE;
    private static List<String> COUNTRY_CODES = null;
    private static List<String> CURRENCY_CODES = null;
    private static ImmoToolHelpDialog helpDialog;

    private ImmoToolUtils() {
    }

    public static JPanel buildButtonBar(JButton ... jButtonArray) {
        return ImmoToolUtils.buildButtonBar(null, jButtonArray);
    }

    public static JPanel buildButtonBar(JXTitledSeparator jXTitledSeparator, JButton ... jButtonArray) {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        jPanel.setOpaque(false);
        jPanel.setBorder(Borders.EMPTY);
        for (JButton jButton : jButtonArray) {
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setOpaque(false);
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            jPanel2.add((Component)jButton, "Center");
            jPanel.add(jPanel2);
        }
        if (jXTitledSeparator == null) {
            return jPanel;
        }
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setOpaque(false);
        jPanel3.setBorder(Borders.EMPTY);
        jPanel3.add((Component)jXTitledSeparator, "Center");
        jPanel3.add((Component)jPanel, "East");
        return jPanel3;
    }

    public static void configureDialog(JDialog jDialog) {
        ImmoToolUtils.configureDialog(jDialog, null);
    }

    public static void configureDialog(JDialog jDialog, JXPanel jXPanel) {
        String string = jDialog.getTitle();
        if (string == null || string.trim().length() == 0) {
            string = ImmoToolApp.getApplicationTitle();
        }
        jDialog.setTitle(string);
        jDialog.setLocationRelativeTo(null);
        if (jXPanel != null) {
            jXPanel.setBackgroundPainter(ImmoToolUtils.getBackgroundPainter(jDialog.getSize().height));
        }
    }

    public static void configureFrame(JFrame jFrame, String string) {
        jFrame.setTitle(string + " | " + ImmoToolApp.getApplicationTitle() + " " + ImmoToolApp.getApplicationVersion());
    }

    public static void configureTable(JXTable jXTable) {
        jXTable.setBackground(Color.WHITE);
        jXTable.setHighlighters(new Highlighter[]{HighlighterFactory.createSimpleStriping((Color)TABLE_HIGHLIGHT_COLOR)});
    }

    public static DefaultFormBuilder createFormBuilder(String string) {
        return ImmoToolUtils.createFormBuilder(new FormLayout(string), null);
    }

    public static DefaultFormBuilder createFormBuilder(FormLayout formLayout) {
        return ImmoToolUtils.createFormBuilder(formLayout, null);
    }

    public static DefaultFormBuilder createFormBuilder(String string, JPanel jPanel) {
        return ImmoToolUtils.createFormBuilder(new FormLayout(string), jPanel);
    }

    public static DefaultFormBuilder createFormBuilder(FormLayout formLayout, JPanel jPanel) {
        DefaultFormBuilder defaultFormBuilder;
        DefaultFormBuilder defaultFormBuilder2 = defaultFormBuilder = jPanel != null ? new DefaultFormBuilder(formLayout, jPanel) : new DefaultFormBuilder(formLayout);
        if (SystemUtils.IS_OS_MAC_OSX) {
            defaultFormBuilder.opaque(true);
        }
        return defaultFormBuilder;
    }

    public static FTPClient createFtpClient() throws IOException, IllegalStateException {
        FTPClient fTPClient = new FTPClient();
        fTPClient.addProtocolCommandListener(new ProtocolCommandListener(){

            public void protocolCommandSent(ProtocolCommandEvent protocolCommandEvent) {
                String string;
                String string2 = string = protocolCommandEvent != null && protocolCommandEvent.getMessage() != null ? protocolCommandEvent.getMessage().trim() : "";
                if (string.toLowerCase().startsWith("pass")) {
                    string = string.substring(0, 4) + " XXXXXXXX";
                }
                LOGGER.debug((Object)("[FTP] > " + string));
            }

            public void protocolReplyReceived(ProtocolCommandEvent protocolCommandEvent) {
                String string = protocolCommandEvent != null && protocolCommandEvent.getMessage() != null ? protocolCommandEvent.getMessage().trim() : "";
                LOGGER.debug((Object)("[FTP] < " + string));
            }
        });
        return fTPClient;
    }

    public static JXTitledSeparator createHead1Separator(String string) {
        JXTitledSeparator jXTitledSeparator = new JXTitledSeparator();
        jXTitledSeparator.setTitle(string);
        jXTitledSeparator.setFont(jXTitledSeparator.getFont().deriveFont(1, jXTitledSeparator.getFont().getSize() + 2));
        jXTitledSeparator.setInheritAlpha(false);
        return jXTitledSeparator;
    }

    public static JXTitledSeparator createHead2Separator(String string) {
        JXTitledSeparator jXTitledSeparator = new JXTitledSeparator();
        jXTitledSeparator.setTitle(string);
        jXTitledSeparator.setFont(jXTitledSeparator.getFont().deriveFont(1));
        jXTitledSeparator.setInheritAlpha(false);
        return jXTitledSeparator;
    }

    public static HttpClient createHttpClient() {
        return ImmoToolUtils.createHttpClient(null, null);
    }

    public static HttpClient createHttpClient(String string, String string2) {
        return ImmoToolUtils.createHttpClient(string, string2, 30000);
    }

    public static HttpClient createHttpClient(String string, String string2, int n) {
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)basicHttpParams, (String)"UTF-8");
        HttpProtocolParams.setUseExpectContinue((HttpParams)basicHttpParams, (boolean)true);
        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)n);
        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)n);
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient((HttpParams)basicHttpParams);
        String string3 = ImmoToolApp.getApplicationHttpProxyHost();
        Integer n2 = ImmoToolApp.getApplicationHttpProxyPort();
        if (string3 != null && n2 != null && n2 > 0) {
            ProxySelectorRoutePlanner proxySelectorRoutePlanner = new ProxySelectorRoutePlanner(defaultHttpClient.getConnectionManager().getSchemeRegistry(), ImmoToolUtils.createHttpProxySelector(string3, n2));
            defaultHttpClient.setRoutePlanner((HttpRoutePlanner)proxySelectorRoutePlanner);
        }
        if (string != null && string2 != null) {
            defaultHttpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(string, string2));
        }
        return defaultHttpClient;
    }

    public static ProxySelector createHttpProxySelector(String string, int n) {
        final Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n));
        return new ProxySelector(){

            @Override
            public List<Proxy> select(URI uRI) {
                ArrayList<Proxy> arrayList = new ArrayList<Proxy>();
                arrayList.add(proxy);
                return arrayList;
            }

            @Override
            public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
                LOGGER.warn((Object)"Connection to proxy-server failed!");
                LOGGER.warn((Object)("> url   : " + uRI));
                LOGGER.warn((Object)("> proxy : " + socketAddress));
                LOGGER.warn((Object)("> " + iOException.getLocalizedMessage()), (Throwable)iOException);
            }
        };
    }

    public static ModificationHandler createModificationHandler() {
        return new ModificationHandler();
    }

    public static ValidationHandler createValidationHandler() {
        return new ValidationHandler(new Color(255, 244, 191), new Color(191, 255, 206), new Color(255, 202, 191));
    }

    public static BufferedImage cropImageToRatio(BufferedImage bufferedImage, int n, int n2) {
        int n3;
        double d = (double)n / (double)n2;
        int n4 = bufferedImage.getWidth(null);
        double d2 = (double)n4 / (double)(n3 = bufferedImage.getHeight(null));
        if (d > d2) {
            int n5 = (int)((double)n2 * (double)n4 / (double)n);
            return bufferedImage.getSubimage(0, (n3 - n5) / 2, n4, n5);
        }
        if (d < d2) {
            int n6 = (int)((double)n * (double)n3 / (double)n2);
            return bufferedImage.getSubimage((n4 - n6) / 2, 0, n6, n3);
        }
        return bufferedImage;
    }

    public static void deleteRecursively(FTPClient fTPClient, String string) throws IOException {
        fTPClient.sendNoOp();
        for (FTPFile fTPFile : fTPClient.listFiles(string)) {
            ImmoToolUtils.deleteRecursively(fTPClient, string, fTPFile);
        }
        fTPClient.removeDirectory(string);
    }

    public static void deleteRecursively(FTPClient fTPClient, String string, FTPFile fTPFile) throws IOException {
        if (fTPFile.getName().equals(".") || fTPFile.getName().equals("..")) {
            return;
        }
        fTPClient.sendNoOp();
        if (fTPFile.isDirectory()) {
            String string2 = string + "/" + fTPFile.getName();
            for (FTPFile fTPFile2 : fTPClient.listFiles(string2)) {
                ImmoToolUtils.deleteRecursively(fTPClient, string2, fTPFile2);
            }
            fTPClient.removeDirectory(string2);
        } else if (fTPFile.isFile()) {
            String string3 = string + "/" + fTPFile.getName();
            fTPClient.deleteFile(string3);
        }
    }

    public static void executeTask(Task task) {
        if (task != null) {
            Application.getInstance().getContext().getTaskService().execute(task);
        }
    }

    public static BufferedImage flipImageHorizontal(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n2, n3, n);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                bufferedImage2.setRGB(n2 - i - 1, j, bufferedImage.getRGB(i, j));
            }
        }
        return bufferedImage2;
    }

    public static BufferedImage flipImageVertical(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n2, n3, n);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                bufferedImage2.setRGB(i, n3 - j - 1, bufferedImage.getRGB(i, j));
            }
        }
        return bufferedImage2;
    }

    public static Action getAction(Object object, String string) {
        return ImmoToolUtils.getAction(object.getClass(), object, string);
    }

    public static Action getAction(Class clazz, Object object, String string) {
        return ImmoToolUtils.getActionMap(clazz, object).get(string);
    }

    public static ActionMap getActionMap(Object object) {
        return ImmoToolUtils.getActionMap(object.getClass(), object);
    }

    public static ActionMap getActionMap(Class clazz, Object object) {
        return new ApplicationActionMap(((ImmoToolApp)Application.getInstance(ImmoToolApp.class)).getContext(), clazz, object, ImmoToolUtils.getResourceMap(clazz));
    }

    public static Painter getBackgroundPainter(int n) {
        return new MattePainter((Paint)new GradientPaint(new Point2D.Double(0.0, 100.0), BG_COLOR_1, new Point2D.Double(0.0, n), BG_COLOR_2));
    }

    public static Object getComponentValue(JComponent jComponent) {
        if (jComponent instanceof JTextField) {
            return ((JTextField)jComponent).getText();
        }
        if (jComponent instanceof JTextArea) {
            return ((JTextArea)jComponent).getText();
        }
        if (jComponent instanceof JComboBox) {
            return ((JComboBox)jComponent).getSelectedItem();
        }
        if (jComponent instanceof JXDatePicker) {
            return ((JXDatePicker)jComponent).getDate();
        }
        if (jComponent instanceof JSpinner) {
            return ((JSpinner)jComponent).getValue();
        }
        if (jComponent instanceof JCheckBox) {
            return ((JCheckBox)jComponent).isSelected();
        }
        if (jComponent instanceof JRadioButton) {
            return ((JRadioButton)jComponent).isSelected();
        }
        return null;
    }

    public static List<String> getCountryCodes() {
        if (COUNTRY_CODES == null) {
            ImmoToolUtils.initCountryCodes();
        }
        return COUNTRY_CODES;
    }

    public static String getCountryCodeFromText(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        if ("d".equalsIgnoreCase(string = string.trim())) {
            return Locale.GERMANY.getCountry();
        }
        for (Locale locale : Locale.getAvailableLocales()) {
            String string2;
            Locale[] localeArray = locale.getCountry();
            if (StringUtils.isBlank((String)localeArray)) continue;
            if (localeArray.equalsIgnoreCase(string)) {
                return localeArray;
            }
            try {
                string2 = locale.getISO3Country();
                if (!StringUtils.isBlank((String)string2) && string2.equalsIgnoreCase(string)) {
                    return localeArray;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string2 = locale.getDisplayCountry();
                if (StringUtils.isBlank((String)string2) || !string2.equalsIgnoreCase(string)) continue;
                return localeArray;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (Locale locale : Locale.getAvailableLocales()) {
            for (Locale locale2 : Locale.getAvailableLocales()) {
                try {
                    String string3 = locale.getDisplayCountry(locale2);
                    if (StringUtils.isBlank((String)string3) || !string3.equalsIgnoreCase(string)) continue;
                    return locale.getCountry();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static String getCountryName(String string) {
        return new Locale(string.toLowerCase(), string.toUpperCase()).getDisplayCountry();
    }

    public static List<String> getCurrencyCodes() {
        if (CURRENCY_CODES == null) {
            ImmoToolUtils.initCurrencyCodes();
        }
        return CURRENCY_CODES;
    }

    public static String getCurrencySymbol(String string) {
        return Currency.getInstance(string).getSymbol();
    }

    public static Color getHexColor(String string) {
        if (!string.startsWith("0x")) {
            string = "0x" + string;
        }
        return Color.decode(string);
    }

    public static String getHumanReadableByteCount(long l) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMaximumFractionDigits(2);
        return ImmoToolUtils.getHumanReadableByteCount(l, numberFormat);
    }

    public static String getHumanReadableByteCount(long l, NumberFormat numberFormat) {
        if (l / 0x40000000L > 0L) {
            double d = (double)l / 1.073741824E9;
            return numberFormat.format(d) + " GB";
        }
        if (l / 0x100000L > 0L) {
            double d = (double)l / 1048576.0;
            return numberFormat.format(d) + " MB";
        }
        if (l / 1024L > 0L) {
            double d = (double)l / 1024.0;
            return numberFormat.format(d) + " KB";
        }
        return numberFormat.format(l) + " bytes";
    }

    @Deprecated
    public static URL getIdnaUrl(String string) {
        return ImmoToolUtils.toIdnUrl(string);
    }

    @Deprecated
    public static URL getIdnaUrl(URL uRL) {
        return ImmoToolUtils.toIdnUrl(uRL);
    }

    public static double getImageScaleFactor(int n, int n2, int n3, int n4) {
        double d = (double)n3 / (double)n;
        double d2 = (double)n4 / (double)n2;
        return Math.min(d, d2);
    }

    public static MimeType getMimeType(File file) {
        return (MimeType)MimeUtil.getMimeTypes((File)file).iterator().next();
    }

    public static MimeType getMimeType(InputStream inputStream) {
        return (MimeType)MimeUtil.getMimeTypes((InputStream)inputStream).iterator().next();
    }

    public static ImmoToolPlugin getPlugin(String string) {
        Map<String, ImmoToolPlugin> map = ImmoToolPlugin.listAvailablePlugins();
        return map.containsKey(string) ? map.get(string) : null;
    }

    public static Set<String> getPluginNames() {
        return ImmoToolPlugin.listAvailablePlugins().keySet();
    }

    public static Boolean getPropertyAsBoolean(String string, Boolean bl, Properties properties) {
        try {
            String string2 = properties.getProperty(string, null);
            if (string2 != null && string2.trim().length() > 0) {
                return Boolean.valueOf(string2.trim());
            }
            return bl;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not load boolean-property!");
            LOGGER.warn((Object)("> " + string));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return bl;
        }
    }

    public static Color getPropertyAsColor(String string, Color color, Properties properties) {
        try {
            String string2 = properties.getProperty(string, null);
            if (string2 != null && string2.trim().length() > 0) {
                return ImmoToolUtils.getHexColor(string2.trim());
            }
            return color;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not load color-property!");
            LOGGER.warn((Object)("> " + string));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return color;
        }
    }

    public static Date getPropertyAsDate(String string, Date date, Properties properties) {
        try {
            Long l = ImmoToolUtils.getPropertyAsLong(string, date != null ? Long.valueOf(date.getTime()) : null, properties);
            if (l == null) {
                return date;
            }
            Date date2 = new Date();
            date2.setTime(l);
            return date2;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not load date-property!");
            LOGGER.warn((Object)("> " + string));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return date;
        }
    }

    public static Float getPropertyAsFloat(String string, Float f, Properties properties) {
        try {
            String string2 = properties.getProperty(string, null);
            if (string2 != null && string2.trim().length() > 0) {
                return Float.valueOf(string2.trim());
            }
            return f;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not load float-property!");
            LOGGER.warn((Object)("> " + string));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return f;
        }
    }

    public static Integer getPropertyAsInteger(String string, Integer n, Properties properties) {
        try {
            String string2 = properties.getProperty(string, null);
            if (string2 != null && string2.trim().length() > 0) {
                return Float.valueOf(string2.trim()).intValue();
            }
            return n;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not load integer-property!");
            LOGGER.warn((Object)("> " + string));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return n;
        }
    }

    public static Long getPropertyAsLong(String string, Long l, Properties properties) {
        try {
            String string2 = properties.getProperty(string, null);
            if (string2 != null && string2.trim().length() > 0) {
                return Float.valueOf(string2.trim()).longValue();
            }
            return l;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not load long-property!");
            LOGGER.warn((Object)("> " + string));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return l;
        }
    }

    public static ResourceBundle getResourceBundle(Class clazz, Locale locale) {
        String string = ImmoToolUtils.getResourcePath(clazz, null).substring(1);
        string = string.substring(0, string.lastIndexOf(".properties"));
        return ResourceBundle.getBundle(string, locale);
    }

    public static ResourceMap getResourceMap(Class clazz) {
        return Application.getInstance().getContext().getResourceMap(clazz);
    }

    public static String getResourcePath(Class clazz) {
        return ImmoToolUtils.getResourcePath(clazz, Locale.getDefault());
    }

    public static String getResourcePath(Class clazz, Locale locale) {
        String string = clazz.getName();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        if (locale != null) {
            string2 = string2 + "_" + locale.getLanguage();
        }
        string = string.substring(0, string.lastIndexOf("."));
        string = string.replaceAll("\\.", "/");
        return "/" + string + "/resources/" + string2 + ".properties";
    }

    public static String getStringResource(Class clazz, String string) {
        return ImmoToolUtils.getResourceMap(clazz).getString(string, new Object[0]);
    }

    public static boolean hasPanel(String string) {
        ImmoToolView immoToolView = ImmoToolApp.getApplication().getFrameView();
        if (immoToolView == null) {
            return false;
        }
        int n = immoToolView.getTabIndex(string);
        return n >= 0;
    }

    private static synchronized void initCountryCodes() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : Locale.getISOCountries()) {
            if (string == null || treeSet.contains(string)) continue;
            treeSet.add(string);
        }
        COUNTRY_CODES = Collections.unmodifiableList(new ArrayList(treeSet));
    }

    private static synchronized void initCurrencyCodes() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : Locale.getISOCountries()) {
            Locale locale = new Locale(string, string);
            try {
                String string2;
                Currency currency = Currency.getInstance(locale);
                if (currency == null || (string2 = currency.getCurrencyCode()) == null || treeSet.contains(string2)) continue;
                treeSet.add(string2);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("Can't find currency for country: " + string));
            }
        }
        CURRENCY_CODES = Collections.unmodifiableList(new ArrayList(treeSet));
    }

    public static boolean isValidHostname(String string) {
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        String string2 = StringUtils.trimToEmpty((String)string).toLowerCase();
        if (string2.length() != string.length()) {
            return false;
        }
        Pattern pattern = Pattern.compile("[a-z0-9]+");
        Pattern pattern2 = Pattern.compile("[a-z0-9][a-z0-9\\-]*[a-z0-9]");
        for (String string3 : StringUtils.splitPreserveAllTokens((String)string2, (String)".")) {
            if (StringUtils.isBlank((String)string3)) {
                return false;
            }
            String string4 = null;
            try {
                string4 = IDN.toASCII(string3);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("Can't read IDN label \"" + string3 + "\"!"));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                return false;
            }
            if (!(string4.length() < 3 ? !pattern.matcher(string4).matches() : !pattern2.matcher(string4).matches())) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidMailAddress(String string) {
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        if (!string.contains("@")) {
            return false;
        }
        String[] stringArray = StringUtils.splitPreserveAllTokens((String)string, (String)"@");
        if (stringArray.length != 2) {
            return false;
        }
        if (!ImmoToolUtils.isValidHostname(stringArray[1])) {
            return false;
        }
        Pattern pattern = Pattern.compile("[a-zA-Z0-9!#$%&'*+\\-/=?^_`\\{\\|\\}\\.]+");
        return pattern.matcher(stringArray[0]).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFileContent(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            int n;
            byte[] byArray = new byte[1024];
            fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = fileInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static void loadFileIntoZipStream(File file, ZipOutputStream zipOutputStream) throws IOException {
        ImmoToolUtils.loadFileIntoZipStream(file, zipOutputStream, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFileIntoZipStream(File file, ZipOutputStream zipOutputStream, String string) throws IOException {
        block5: {
            block4: {
                if (!file.isFile()) break block4;
                ZipEntry zipEntry = new ZipEntry(string + file.getName());
                zipOutputStream.putNextEntry(zipEntry);
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
                    zipOutputStream.flush();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileInputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fileInputStream);
                break block5;
            }
            if (file.isDirectory()) {
                zipOutputStream.putNextEntry(new ZipEntry(string + file.getName() + "/"));
                for (File file2 : file.listFiles()) {
                    ImmoToolUtils.loadFileIntoZipStream(file2, zipOutputStream, string + file.getName() + "/");
                }
            }
        }
    }

    public static FTPClient openFtpClient(String string, int n, boolean bl) throws IOException, IllegalStateException {
        FTPClient fTPClient = ImmoToolUtils.createFtpClient();
        LOGGER.info((Object)("opening ftp-connection to " + string + ":" + n));
        fTPClient.connect(string, n);
        LOGGER.info((Object)("> " + (bl ? "PASSIVE MODE" : "ACTIVE MODE")));
        if (bl) {
            fTPClient.enterLocalPassiveMode();
        } else {
            fTPClient.enterLocalActiveMode();
        }
        fTPClient.setBufferSize(0);
        return fTPClient;
    }

    public static void openPDF(String string) {
        if (!StringUtils.isBlank((String)string)) {
            ImmoToolUtils.openPDF(new File(string));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void openPDF(File file) {
        Object object;
        ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ImmoToolUtils.class);
        if (file == null) {
            LOGGER.warn((Object)"Empty PDF document provided!");
            return;
        }
        if (!file.isFile()) {
            LOGGER.warn((Object)"Provided PDF document is not readable!");
            LOGGER.warn((Object)("> " + file.getAbsolutePath()));
            return;
        }
        try {
            object = ImmoToolApp.getApplicationPathToPdfReader();
            if (!StringUtils.isBlank((String)object)) {
                if (!SystemUtils.IS_OS_MAC_OSX) {
                    Runtime.getRuntime().exec(new String[]{object, file.getAbsolutePath()});
                    return;
                }
                ApplicationFile applicationFile = new ApplicationFile((String)object);
                if (!applicationFile.openDocument(file)) {
                    throw new Exception(resourceMap.getString("error.cantOpenDocument", new Object[0]));
                }
            } else if (SystemUtils.IS_OS_MAC_OSX) {
                MRJAdapter.openURL((String)file.toURI().toURL().toString());
                return;
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't open PDF with configured reader!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        try {
            if (Desktop.isDesktopSupported() && ((Desktop)(object = Desktop.getDesktop())).isSupported(Desktop.Action.OPEN)) {
                ((Desktop)object).open(file);
                return;
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't open PDF in desktop environment!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        LOGGER.error((Object)"Can't open PDF document!");
        ImmoToolUtils.showMessageErrorDialog(resourceMap.getString("error.cantExecuteExternalApplication", new Object[0]));
    }

    public static void openURL(String string) {
        try {
            if (!StringUtils.isBlank((String)string)) {
                ImmoToolUtils.openURL(new URL(string));
            }
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.warn((Object)("Can't read URL from \"" + string + "\"!"));
            LOGGER.warn((Object)("> " + malformedURLException.getLocalizedMessage()), (Throwable)malformedURLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void openURL(URL uRL) {
        Object object;
        ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ImmoToolUtils.class);
        if (uRL == null) {
            LOGGER.warn((Object)"Empty URL provided!");
            return;
        }
        try {
            object = ImmoToolApp.getApplicationPathToWebBrowser();
            if (!StringUtils.isBlank((String)object)) {
                if (!SystemUtils.IS_OS_MAC_OSX) {
                    Runtime.getRuntime().exec(new String[]{object, uRL.toString()});
                    return;
                }
                ApplicationFile applicationFile = new ApplicationFile((String)object);
                if (applicationFile.open(new String[]{uRL.toString()}) == null) {
                    throw new Exception(resourceMap.getString("error.cantOpenDocument", new Object[0]));
                }
            } else if (SystemUtils.IS_OS_MAC_OSX) {
                MRJAdapter.openURL((String)uRL.toString());
                return;
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't open URL with configured browser!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        try {
            if (Desktop.isDesktopSupported() && ((Desktop)(object = Desktop.getDesktop())).isSupported(Desktop.Action.BROWSE)) {
                ((Desktop)object).browse(uRL.toURI());
                return;
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't open URL in desktop environment!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        LOGGER.error((Object)"Can't open URL!");
        ImmoToolUtils.showMessageErrorDialog(resourceMap.getString("error.cantExecuteExternalApplication", new Object[0]));
    }

    public static void print(Printable printable) throws PrinterException {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(MediaSizeName.ISO_A4);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(printable, printerJob.defaultPage());
        if (!printerJob.printDialog(hashPrintRequestAttributeSet)) {
            return;
        }
        printerJob.print(hashPrintRequestAttributeSet);
    }

    public static String readApplicationResource(String string) throws IOException {
        return OpenEstateUtils.readResource("/com/openindex/openestate/tool/resources/".substring(1) + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        FileReader fileReader = null;
        try {
            int n;
            fileReader = new FileReader(file);
            char[] cArray = new char[1024];
            while ((n = fileReader.read(cArray, 0, cArray.length)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
        }
    }

    public static boolean removePanel(String string) {
        return ImmoToolUtils.removePanel(string, false);
    }

    public static boolean removePanel(String string, boolean bl) {
        ImmoToolView immoToolView = ImmoToolApp.getApplication().getFrameView();
        if (immoToolView == null) {
            return false;
        }
        int n = immoToolView.getTabIndex(string);
        return n >= 0 ? immoToolView.removeTab(n, bl) : false;
    }

    public static String replaceTags(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("<[^>]*>", "");
    }

    public static BufferedImage rotateImageToLeft(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n3, n2, n);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                bufferedImage2.setRGB(j, n2 - i - 1, bufferedImage.getRGB(i, j));
            }
        }
        return bufferedImage2;
    }

    public static BufferedImage rotateImageToRight(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n3, n2, n);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                bufferedImage2.setRGB(n3 - j - 1, i, bufferedImage.getRGB(i, j));
            }
        }
        return bufferedImage2;
    }

    public static BufferedImage scaleImageAndKeepRatio(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getType();
        if (n3 == 0) {
            n3 = bufferedImage.getTransparency() == 1 ? 1 : 2;
        }
        return ImmoToolUtils.scaleImageAndKeepRatio(bufferedImage, n, n2, n3);
    }

    public static BufferedImage scaleImageAndKeepRatio(BufferedImage bufferedImage, int n, int n2, int n3) {
        int n4 = bufferedImage.getWidth(null);
        int n5 = bufferedImage.getHeight(null);
        double d = ImmoToolUtils.getImageScaleFactor(n4, n5, n, n2);
        int n6 = (int)((double)n4 * d);
        int n7 = (int)((double)n5 * d);
        if (n6 < 1) {
            n6 = 1;
        }
        if (n7 < 1) {
            n7 = 1;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n6, n7, n3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(bufferedImage, 0, 0, n6, n7, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage scaleImageToResolution(BufferedImage bufferedImage, int n, int n2, int n3) {
        int n4 = n3 > 72 ? n3 : 72;
        float f = (float)n4 / 72.0f * (float)n;
        float f2 = (float)n4 / 72.0f * (float)n2;
        if (f < 1.0f) {
            f = 1.0f;
        }
        if (f2 < 1.0f) {
            f2 = 1.0f;
        }
        if (f >= (float)bufferedImage.getWidth() && f2 >= (float)bufferedImage.getHeight()) {
            return bufferedImage;
        }
        return ImmoToolUtils.scaleImageAndKeepRatio(bufferedImage, (int)f, (int)f2);
    }

    public static boolean selectPanel(String string) {
        ImmoToolView immoToolView = ImmoToolApp.getApplication().getFrameView();
        if (immoToolView == null) {
            return false;
        }
        int n = immoToolView.getTabIndex(string);
        if (n < 0) {
            return false;
        }
        immoToolView.selectTab(n);
        return true;
    }

    public static synchronized void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("An empty locale was provided!");
        }
        System.setProperty("user.language", locale.getLanguage());
        if (!StringUtils.isEmpty((String)locale.getCountry())) {
            System.setProperty("user.country", locale.getCountry());
        } else {
            System.getProperties().remove("user.country");
        }
        if (!StringUtils.isEmpty((String)locale.getVariant())) {
            System.setProperty("user.variant", locale.getVariant());
        } else {
            System.getProperties().remove("user.variant");
        }
        Locale.setDefault(new Locale(System.getProperty("user.language"), System.getProperty("user.country", ""), System.getProperty("user.variant", "")));
        AppContext appContext = AppContext.getAppContext();
        if (appContext != null) {
            appContext.put("JComponent.defaultLocale", Locale.getDefault());
        }
    }

    public static void showHelpDialog() {
        ImmoToolUtils.showHelpDialog(null);
    }

    public static void showHelpDialog(String string) {
        ImmoToolUtils.showHelpDialog(string, false);
    }

    public static void showHelpDialog(String string, boolean bl) {
        if (bl) {
            ImmoToolHelpDialog immoToolHelpDialog = new ImmoToolHelpDialog();
            immoToolHelpDialog.setModal(true);
            if (string != null) {
                immoToolHelpDialog.setHelpId(string);
            } else {
                immoToolHelpDialog.setHelpId("app.index");
            }
            immoToolHelpDialog.setVisible(true);
        } else {
            if (helpDialog == null) {
                helpDialog = new ImmoToolHelpDialog();
                helpDialog.setModal(false);
            }
            if (string != null) {
                helpDialog.setHelpId(string);
            } else {
                helpDialog.setHelpId("app.index");
            }
            if (!helpDialog.isVisible()) {
                ImmoToolApp.getApplication().show(helpDialog);
            } else {
                helpDialog.toFront();
            }
        }
    }

    public static String showInputDialog(String string) {
        return ImmoToolUtils.showInputDialog(string, "");
    }

    public static String showInputDialog(String string, String string2) {
        return JOptionPane.showInputDialog(ImmoToolApp.getApplication().getMainFrame(), string, string2);
    }

    public static void showMessageDialog(String string, String string2, int n) {
        ImmoToolUtils.showMessageDialog(string, string2, n, ImmoToolApp.getApplication().getMainFrame());
    }

    public static void showMessageDialog(String string, String string2, int n, Component component) {
        JOptionPane.showMessageDialog(component, string, string2, n);
    }

    public static void showMessageErrorDialog(String string) {
        ImmoToolUtils.showMessageErrorDialog(string, (Component)null);
    }

    public static void showMessageErrorDialog(String string, Component component) {
        ImmoToolUtils.showMessageDialog(string, ImmoToolUtils.getResourceMap(ImmoToolUtils.class).getString("label.error", new Object[0]), 0, component);
    }

    public static void showMessageErrorDialog(String string, Throwable throwable) {
        ImmoToolErrorDialog immoToolErrorDialog = new ImmoToolErrorDialog();
        immoToolErrorDialog.showDialog(string, throwable);
    }

    public static void showMessageErrorDialog(String string, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(string);
        stringBuilder.append("<ul>");
        for (String string2 : list) {
            stringBuilder.append("<li>").append(string2).append("</li>");
        }
        stringBuilder.append("</ul>");
        stringBuilder.append("</html>");
        ImmoToolUtils.showMessageDialog(stringBuilder.toString(), ImmoToolUtils.getResourceMap(ImmoToolUtils.class).getString("label.error", new Object[0]), 0, null);
    }

    public static void showMessageErrorDialog(String string, Map<String, List<String>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(string);
        stringBuilder.append("<ul>");
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            stringBuilder.append("<li>").append(entry.getKey()).append("<ul>");
            for (String string2 : entry.getValue()) {
                stringBuilder.append("<li>").append(string2).append("</li>");
            }
            stringBuilder.append("</ul>").append("</li>");
        }
        stringBuilder.append("</ul>");
        stringBuilder.append("</html>");
        ImmoToolUtils.showMessageDialog(stringBuilder.toString(), ImmoToolUtils.getResourceMap(ImmoToolUtils.class).getString("label.error", new Object[0]), 0, null);
    }

    public static void showMessageErrorDialog(String string, String string2) {
        ImmoToolUtils.showMessageDialog(string, string2, 0, null);
    }

    public static void showMessageInfoDialog(String string) {
        ImmoToolUtils.showMessageInfoDialog(string, (Component)null);
    }

    public static void showMessageInfoDialog(String string, Component component) {
        ImmoToolUtils.showMessageInfoDialog(string, ImmoToolUtils.getResourceMap(ImmoToolUtils.class).getString("label.info", new Object[0]), component);
    }

    public static void showMessageInfoDialog(String string, String string2) {
        ImmoToolUtils.showMessageInfoDialog(string, string2, null);
    }

    public static void showMessageInfoDialog(String string, String string2, Component component) {
        ImmoToolUtils.showMessageDialog(string, string2, 1, component);
    }

    public static void showMessageWarningDialog(String string) {
        ImmoToolUtils.showMessageDialog(string, ImmoToolUtils.getResourceMap(ImmoToolUtils.class).getString("label.warning", new Object[0]), 2, null);
    }

    public static void showMessageWarningDialog(String string, String string2) {
        ImmoToolUtils.showMessageDialog(string, string2, 2, null);
    }

    public static void showPanel(TabComponent tabComponent) {
        ImmoToolUtils.showPanel(tabComponent, true);
    }

    public static void showPanel(TabComponent tabComponent, boolean bl) {
        ImmoToolView immoToolView = ImmoToolApp.getApplication().getFrameView();
        try {
            if (immoToolView != null && tabComponent != null) {
                immoToolView.addTab(tabComponent, bl);
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not show tab-panel!");
            LOGGER.error((Object)("> " + tabComponent.getTabTitle()));
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    public static boolean showQuestionDialog(String string) {
        return ImmoToolUtils.showQuestionDialog(string, null);
    }

    public static boolean showQuestionDialog(String string, Component component) {
        int n = JOptionPane.showConfirmDialog(component, string, ImmoToolUtils.getResourceMap(ImmoToolUtils.class).getString("label.question", new Object[0]), 0, 3);
        return n == 0;
    }

    public static Boolean showQuestionWithCancelDialog(String string) {
        return ImmoToolUtils.showQuestionWithCancelDialog(string, null);
    }

    public static Boolean showQuestionWithCancelDialog(String string, Component component) {
        int n = JOptionPane.showConfirmDialog(component, string, ImmoToolUtils.getResourceMap(ImmoToolUtils.class).getString("label.question", new Object[0]), 1, 3);
        if (n == 2) {
            return null;
        }
        return n == 0;
    }

    public static ImageIcon toGray(ImageIcon imageIcon) {
        Image image = imageIcon != null ? ImmoToolUtils.toGray(imageIcon.getImage()) : null;
        return image != null ? new ImageIcon(image) : null;
    }

    public static Image toGray(Image image) {
        return image != null ? GrayFilter.createDisabledImage(image) : null;
    }

    public static URL toIdnUrl(String string) {
        try {
            return ImmoToolUtils.toIdnUrl(new URL(string));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Can't convert \"" + string + "\" to an IDN URL!"));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public static URL toIdnUrl(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.getProtocol();
        if (!("http".equalsIgnoreCase(string) || "https".equalsIgnoreCase(string) || "ftp".equalsIgnoreCase(string) || "ftps".equalsIgnoreCase(string))) {
            return uRL;
        }
        try {
            return new URL(uRL.getProtocol(), IDN.toASCII(uRL.getHost()), uRL.getPort(), uRL.getFile());
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Can't convert \"" + uRL.toString() + "\" to an IDN URL!"));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public static void updateProgram(ImmoToolProject immoToolProject, ImmoToolDb immoToolDb, String string, String string2) throws ImmoToolException {
    }

    public static void updateProgramPlugin(ImmoToolProject immoToolProject, ImmoToolPlugin immoToolPlugin, ImmoToolDb immoToolDb, String string, String string2) throws ImmoToolException {
        immoToolPlugin.update(immoToolProject, immoToolDb, string, string2);
    }

    public static void updateTabs() {
        ImmoToolApp.getApplication().getFrameView().updateTabs();
    }

    public static String wrapAndIndentString(String string, String string2, int n) {
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        List<String> list = ImmoToolUtils.wrapStringToArray(string, n, breakIterator, true);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : list) {
            stringBuilder.append(string2).append(string3).append('\n');
        }
        return stringBuilder.toString();
    }

    public static List<String> wrapStringToArray(String string, int n, BreakIterator breakIterator, boolean bl) {
        int n2;
        int n3;
        String[] stringArray;
        block14: {
            if (string.length() == 0) {
                return Arrays.asList(string);
            }
            if (bl) {
                string = string.trim();
                string = string.replace('\n', ' ');
                stringArray = new String[]{string};
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                n3 = stringTokenizer.countTokens();
                stringArray = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    stringArray[n2] = stringTokenizer.nextToken();
                }
            }
            if (n < 1) {
                n = 1;
            }
            if (string.length() <= n) {
                return Arrays.asList(stringArray);
            }
            boolean bl2 = true;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                boolean bl3 = bl2 = bl2 && stringArray[n3].length() < n;
                if (bl2) {
                    continue;
                }
                break block14;
            }
            return Arrays.asList(stringArray);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        n3 = 0;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].length() < n) {
                arrayList.add(stringArray[n2]);
                continue;
            }
            breakIterator.setText(stringArray[n2]);
            int n4 = breakIterator.next();
            int n5 = 0;
            while (true) {
                if (n4 - n3 < n && n4 != -1) {
                    n5 = n4;
                    n4 = breakIterator.next();
                    continue;
                }
                if (n4 == -1) {
                    n4 = n5 = stringArray[n2].length();
                }
                if (n5 == 0) {
                    n5 = n4;
                }
                arrayList.add(stringArray[n2].substring(n3, n5));
                n3 = n5;
                n5 = 0;
                if (n3 >= stringArray[n2].length()) break;
            }
            n3 = 0;
        }
        return arrayList;
    }

    public static String writeException(Throwable throwable) {
        return OpenEstateUtils.writeException(throwable);
    }

    public static String writeHexColor(Color color) {
        String string;
        String string2;
        String string3 = Integer.toHexString(color.getRed()).trim();
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        if ((string2 = Integer.toHexString(color.getGreen()).trim()).length() == 1) {
            string2 = "0" + string2;
        }
        if ((string = Integer.toHexString(color.getBlue()).trim()).length() == 1) {
            string = "0" + string;
        }
        return string3 + string2 + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileToStream(File file, OutputStream outputStream) throws FileNotFoundException, IOException {
        if (outputStream == null) {
            throw new IOException("invalid output-stream!");
        }
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeURLToStream(URL uRL, OutputStream outputStream) throws FileNotFoundException, IOException {
        if (outputStream == null) {
            throw new IOException("invalid output-stream!");
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
            byte[] byArray = new byte[1024];
            while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStreamToFile(InputStream inputStream, File file) throws FileNotFoundException, IOException {
        if (inputStream == null) {
            throw new IOException("invalid input-stream!");
        }
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }
}

