/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.impl.CompanyAdressImpl;
import com.openindex.openestate.tool.ImmoToolAboutDialog;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbAdminDialog;
import com.openindex.openestate.tool.ImmoToolDbBackupTask;
import com.openindex.openestate.tool.ImmoToolDbRestoreTask;
import com.openindex.openestate.tool.ImmoToolDbSnapshot;
import com.openindex.openestate.tool.ImmoToolFrontpagePanel;
import com.openindex.openestate.tool.ImmoToolLanguagePack;
import com.openindex.openestate.tool.ImmoToolLicenseSetupDialog;
import com.openindex.openestate.tool.ImmoToolPlugin;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolProjectCloseTask;
import com.openindex.openestate.tool.ImmoToolProjectOpenTask;
import com.openindex.openestate.tool.ImmoToolProtocolPanel;
import com.openindex.openestate.tool.ImmoToolSetupDialog;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUpdateTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.ImmoToolWizardDialog;
import com.openindex.openestate.tool.utils.JOptionFileChooser;
import com.openindex.openestate.tool.utils.MemoryMonitorDialog;
import com.openindex.openestate.tool.utils.SyndicationFeed;
import com.openindex.openestate.tool.utils.TabComponent;
import com.openindex.openestate.tool.utils.engine.PlugEngine;
import com.openindex.openestate.tool.utils.engine.Pluggable;
import com.openindex.openestate.tool.utils.engine.ui.swing.firefoxstyle.PluginDialog;
import com.openindex.openestate.tool.utils.tabs.CloseAndMaxTabbedPane;
import com.openindex.openestate.tool.utils.tabs.CloseListener;
import com.openindex.openestate.tool.utils.tabs.CloseTabPaneUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.painter.AbstractLayoutPainter;
import org.jdesktop.swingx.painter.AlphaPainter;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.ImagePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.ShapePainter;

public class ImmoToolView
extends FrameView {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolView.class);
    private Timer messageTimer;
    private Timer busyIconTimer;
    private Icon idleIcon;
    private Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private CloseAndMaxTabbedPane tabContainer;
    private boolean projectLoaded = false;
    private JXLabel companyLabel = null;
    BufferedImage logoImg = null;
    private int lastRepaintPosition = -1;
    private JMenuItem aboutMenuItem;
    private JMenuItem autoUpdateMenuItem;
    private JMenuItem closeProjectMenuItem;
    private JMenuItem closeTabMenuItem;
    private JMenuItem createProjectMenuItem;
    private JMenuItem dbAdminMenuItem;
    private JMenuItem dbExportForUpgradeMenuItem;
    private JMenu dbMenu;
    private JMenu dbMenuExport;
    private JMenu dbMenuImport;
    private JMenu dbMenuManage;
    private JMenuItem doDbExportToFileItem;
    private JMenuItem doDbExportToSnapshotItem;
    private JMenuItem doDbImportFromFileItem;
    private JMenuItem doDbImportFromSnapshotItem;
    private JMenuItem doDbRebuildItem;
    private JMenuItem doDbReloadItem;
    private JMenuItem doDbRemoveSnapshotItem;
    private JMenu extrasMenu;
    private JMenuItem helpMenuItem;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JMenu languageMenu;
    private JMenuItem licenseMenuItem;
    private JXPanel mainPanel;
    private JMenuItem memoryMenuItem;
    private JMenuBar menuBar;
    private JMenuItem openProjectMenuItem;
    private JMenuItem pluginSetupItem;
    private JMenu programMenu;
    private JMenuItem programSetupMenuItem;
    private JXTaskPane programTaskPane;
    private JProgressBar progressBar;
    private JMenuItem protocolsMenuItem;
    private JMenuItem quitMenuItem;
    private JMenuItem refreshTabMenuItem;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JMenuItem switchNextTabMenuItem;
    private JMenuItem switchPrevTabMenuItem;
    private JXPanel tabPanel;
    private JXTaskPaneContainer taskPanel;

    public ImmoToolView(ImmoToolApp immoToolApp) {
        super((Application)immoToolApp);
        this.build(immoToolApp);
    }

    public void addTab(TabComponent tabComponent, boolean bl) {
        JComponent jComponent = (JComponent)((Object)tabComponent);
        jComponent.putClientProperty("isClosable", tabComponent.isTabClosable());
        String string = " " + tabComponent.getTabTitle() + " ";
        this.tabContainer.addTab(string, tabComponent.getTabIcon(), jComponent, tabComponent.getTabInfo());
        if (bl) {
            this.selectTab(this.tabContainer.getTabCount() - 1);
        }
    }

    private void build(ImmoToolApp immoToolApp) {
        String string;
        this.initComponents();
        this.getResourceMap().injectComponents((Component)this.getFrame());
        try {
            string = "/com/openindex/openestate/tool/resources/icons/32x32/ImmoTool.png";
            this.getFrame().setIconImage(ImageIO.read(ImmoToolView.class.getResource(string)));
        }
        catch (Exception exception) {
            this.getFrame().setIconImage(null);
            LOGGER.warn((Object)"could not load frame-icon!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.statusMessageLabel.setForeground(Color.WHITE);
        this.getFrame().setMinimumSize(new Dimension(640, 480));
        this.getFrame().setPreferredSize(new Dimension(Toolkit.getDefaultToolkit().getScreenSize().width - 100, Toolkit.getDefaultToolkit().getScreenSize().height - 75));
        this.companyLabel = new JXLabel();
        this.companyLabel.setHorizontalAlignment(4);
        this.companyLabel.setHorizontalTextPosition(2);
        this.programTaskPane.add(ImmoToolUtils.getAction((Object)this, "doShowSummary"));
        this.programTaskPane.add(ImmoToolUtils.getAction((Object)this, "doShowHelpDialog"));
        if (SystemUtils.IS_OS_WINDOWS) {
            this.programTaskPane.addPropertyChangeListener("collapsed", (PropertyChangeListener)new TaskPaneCollapseListener());
        }
        this.tabContainer = new CloseAndMaxTabbedPane(true);
        this.tabContainer.setVisible(false);
        this.tabContainer.setBorder(Borders.EMPTY);
        this.tabContainer.setBackground(Color.WHITE);
        try {
            this.tabContainer.setCloseIcon(ImageIO.read(((Object)((Object)this)).getClass().getResource("/com/openindex/openestate/tool/resources/icons/16x16/button_cancel.png")));
            this.tabContainer.addCloseListener(new CloseListener(){

                @Override
                public void closeOperation(MouseEvent mouseEvent) {
                    ImmoToolView.this.tabContainer.remove(ImmoToolView.this.tabContainer.getOverTabIndex());
                }
            });
        }
        catch (Exception exception) {
            this.tabContainer.setCloseIcon(false);
            LOGGER.warn((Object)"could not load tab-close-icon!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        try {
            this.tabContainer.setMaxIcon(false);
        }
        catch (Exception exception) {
            this.tabContainer.setMaxIcon(false);
            LOGGER.warn((Object)"could not load tab-max-icon!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.tabContainer.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                ImmoToolView.this.refreshTabMenuItem.setEnabled(ImmoToolView.this.tabContainer.getTabCount() > 0);
                ImmoToolView.this.switchNextTabMenuItem.setEnabled(ImmoToolView.this.tabContainer.getTabCount() > 1);
                ImmoToolView.this.switchPrevTabMenuItem.setEnabled(ImmoToolView.this.tabContainer.getTabCount() > 1);
                ImmoToolView.this.closeTabMenuItem.setEnabled(ImmoToolView.this.tabContainer.getTabCount() > 0);
                if (ImmoToolView.this.tabContainer.getTabCount() > 0) {
                    ImmoToolView.this.tabContainer.setVisible(true);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                ImmoToolView.this.refreshTabMenuItem.setEnabled(ImmoToolView.this.tabContainer.getTabCount() > 0);
                ImmoToolView.this.switchNextTabMenuItem.setEnabled(ImmoToolView.this.tabContainer.getTabCount() > 1);
                ImmoToolView.this.switchPrevTabMenuItem.setEnabled(ImmoToolView.this.tabContainer.getTabCount() > 1);
                ImmoToolView.this.closeTabMenuItem.setEnabled(ImmoToolView.this.tabContainer.getTabCount() > 0);
                if (ImmoToolView.this.tabContainer.getTabCount() < 1) {
                    ImmoToolView.this.tabContainer.setVisible(false);
                }
            }
        });
        this.tabPanel.setLayout((LayoutManager)new BorderLayout());
        this.tabPanel.add((Component)this.companyLabel, (Object)"North");
        this.tabPanel.add((Component)this.tabContainer, (Object)"Center");
        this.statusPanel.setBackground(ImmoToolUtils.BG_COLOR_2);
        string = this.getResourceMap();
        int n = string.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImmoToolView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int n2 = string.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = string.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(n2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImmoToolView.this.busyIconIndex = (ImmoToolView.this.busyIconIndex + 1) % ImmoToolView.this.busyIcons.length;
                ImmoToolView.this.statusAnimationLabel.setIcon(ImmoToolView.this.busyIcons[ImmoToolView.this.busyIconIndex]);
            }
        });
        this.idleIcon = string.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("started".equals(string)) {
                    if (!ImmoToolView.this.busyIconTimer.isRunning()) {
                        ImmoToolView.this.statusAnimationLabel.setIcon(ImmoToolView.this.busyIcons[0]);
                        ImmoToolView.this.busyIconIndex = 0;
                        ImmoToolView.this.busyIconTimer.start();
                    }
                    ImmoToolView.this.progressBar.setVisible(true);
                    ImmoToolView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(string)) {
                    ImmoToolView.this.busyIconTimer.stop();
                    ImmoToolView.this.statusAnimationLabel.setIcon(ImmoToolView.this.idleIcon);
                    ImmoToolView.this.progressBar.setVisible(false);
                    ImmoToolView.this.progressBar.setValue(0);
                } else if ("message".equals(string)) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    ImmoToolView.this.statusMessageLabel.setText(string2 == null ? "" : string2);
                    ImmoToolView.this.messageTimer.restart();
                } else if ("progress".equals(string)) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    ImmoToolView.this.progressBar.setVisible(true);
                    ImmoToolView.this.progressBar.setIndeterminate(false);
                    ImmoToolView.this.progressBar.setValue(n);
                }
            }
        });
        this.getFrame().addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ImmoToolView.this.updateBackground();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        this.getFrame().setDefaultCloseOperation(0);
        this.getFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ImmoToolApp.getApplication().exit(windowEvent);
            }
        });
        if (SystemUtils.IS_OS_WINDOWS) {
            this.taskPanel.setOpaque(true);
            this.taskPanel.setBackground(new Color(255, 255, 255, 0));
        }
        if (immoToolApp.getProject() != null) {
            this.loadProject(immoToolApp.getProject());
        } else {
            this.unloadProject();
        }
    }

    private void buildLanguageMenu(ImmoToolProject immoToolProject) {
        this.languageMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean bl = immoToolProject == null;
        for (ImmoToolLanguagePack immoToolLanguagePack : ImmoToolLanguagePack.listAvailableLanguagePacks(bl).values()) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(immoToolLanguagePack.getLocale().getDisplayName(immoToolLanguagePack.getLocale()) + " / " + immoToolLanguagePack.getLocale().getDisplayName());
            jRadioButtonMenuItem.setIcon(new ImageIcon(immoToolLanguagePack.getFlag()));
            buttonGroup.add(jRadioButtonMenuItem);
            if (immoToolLanguagePack.getLocale().equals(Locale.getDefault())) {
                jRadioButtonMenuItem.setSelected(true);
            }
            this.languageMenu.add(jRadioButtonMenuItem);
            final Locale locale = immoToolLanguagePack.getLocale();
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ImmoToolView.this.switchLanguage(locale);
                }
            });
        }
    }

    private void buildMenu(ImmoToolProject immoToolProject) {
        Application application = Application.getInstance(ImmoToolApp.class);
        ActionMap actionMap = ImmoToolUtils.getActionMap((Object)this);
        ApplicationActionMap applicationActionMap = new ApplicationActionMap(application.getContext(), Application.class, (Object)application, ImmoToolUtils.getResourceMap(ImmoToolApp.class));
        this.createProjectMenuItem.setAction(actionMap.get("doCreateProject"));
        this.openProjectMenuItem.setAction(actionMap.get("doOpenProject"));
        this.closeProjectMenuItem.setAction(actionMap.get("doCloseProject"));
        this.closeProjectMenuItem.setEnabled(immoToolProject != null);
        this.refreshTabMenuItem.setAction(actionMap.get("doRefreshTab"));
        this.refreshTabMenuItem.setEnabled(immoToolProject != null && this.tabContainer.getTabCount() > 0);
        this.switchNextTabMenuItem.setAction(actionMap.get("doSwitchNextTab"));
        this.switchNextTabMenuItem.setEnabled(immoToolProject != null && this.tabContainer.getTabCount() > 1);
        this.switchPrevTabMenuItem.setAction(actionMap.get("doSwitchPrevTab"));
        this.switchPrevTabMenuItem.setEnabled(immoToolProject != null && this.tabContainer.getTabCount() > 1);
        this.closeTabMenuItem.setAction(actionMap.get("doCloseTab"));
        this.closeTabMenuItem.setEnabled(immoToolProject != null && this.tabContainer.getTabCount() > 0);
        this.quitMenuItem.setAction(applicationActionMap.get("quit"));
        this.pluginSetupItem.setAction(actionMap.get("doShowPluginDialog"));
        this.autoUpdateMenuItem.setAction(actionMap.get("doAutoUpdate"));
        this.autoUpdateMenuItem.setEnabled(!ImmoToolApp.isApplicationBetaVersion() && !ImmoToolApp.isApplicationUpdateDisabled());
        this.doDbExportToFileItem.setAction(actionMap.get("doDbExportToFile"));
        this.doDbExportToSnapshotItem.setAction(actionMap.get("doDbExportToSnapshot"));
        this.doDbImportFromFileItem.setAction(actionMap.get("doDbImportFromFile"));
        this.doDbImportFromSnapshotItem.setAction(actionMap.get("doDbImportFromSnapshot"));
        this.dbAdminMenuItem.setAction(actionMap.get("doDbAdmin"));
        this.programSetupMenuItem.setAction(actionMap.get("doShowProgramSetup"));
        this.licenseMenuItem.setAction(actionMap.get("doShowLicenseDialog"));
        this.helpMenuItem.setAction(actionMap.get("doShowHelpDialog"));
        this.protocolsMenuItem.setAction(actionMap.get("doShowProtocols"));
        this.memoryMenuItem.setAction(actionMap.get("doShowMemoryDialog"));
        this.aboutMenuItem.setAction(actionMap.get("doShowAboutBox"));
        this.menuBar.removeAll();
        this.menuBar.setVisible(false);
        this.menuBar.add(this.programMenu);
        if (immoToolProject != null) {
            for (String string : immoToolProject.getPluginNames()) {
                ImmoToolPlugin immoToolPlugin = immoToolProject.getPlugin(string);
                JMenu jMenu = immoToolPlugin.createMenu();
                if (jMenu == null) continue;
                this.menuBar.add(jMenu);
            }
        }
        this.menuBar.add(this.extrasMenu);
        this.menuBar.setVisible(true);
        this.buildLanguageMenu(immoToolProject);
        this.getResourceMap().injectComponents((Component)this.menuBar);
    }

    private void buildTaskPanel(ImmoToolProject immoToolProject) {
        ActionMap actionMap = ImmoToolUtils.getActionMap((Object)this);
        this.taskPanel.setVisible(false);
        this.taskPanel.removeAll();
        this.programTaskPane.removeAll();
        this.programTaskPane.add(actionMap.get("doShowSummary"));
        this.programTaskPane.add(actionMap.get("doShowHelpDialog"));
        this.taskPanel.add((Component)this.programTaskPane);
        if (immoToolProject != null) {
            for (String string : immoToolProject.getPluginNames()) {
                ImmoToolPlugin immoToolPlugin = immoToolProject.getPlugin(string);
                JXTaskPane jXTaskPane = immoToolPlugin.createTaskPane();
                if (jXTaskPane == null) continue;
                jXTaskPane.setAnimated(false);
                if (SystemUtils.IS_OS_WINDOWS) {
                    jXTaskPane.addPropertyChangeListener("collapsed", (PropertyChangeListener)new TaskPaneCollapseListener());
                }
                this.taskPanel.add((Component)jXTaskPane);
            }
        }
        this.taskPanel.setVisible(true);
    }

    public boolean canRemoveTab(int n) {
        if (n < 0 || n >= this.tabContainer.getTabCount()) {
            return false;
        }
        Component component = this.tabContainer.getComponentAt(n);
        if (component instanceof TabComponent) {
            TabComponent tabComponent = (TabComponent)((Object)component);
            return ImmoToolTabPanel.checkForModifications(tabComponent, this);
        }
        return true;
    }

    public Boolean canSaveModificationsBeforeContinue() {
        return ImmoToolUtils.showQuestionWithCancelDialog(this.getResourceMap().getString("question.saveModificationsBeforeContinue", new Object[0]), this.getFrame());
    }

    @Action
    public void doAutoUpdate() {
        ImmoToolTaskDialog.execute(new ImmoToolUpdateTask(false, true));
    }

    @Action
    public void doCloseProject() {
        if (!this.isProjectLoaded()) {
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog(this.getResourceMap().getString("question.reallyCloseProject", new Object[0]), this.getFrame());
        if (!bl) {
            return;
        }
        ImmoToolTaskDialog immoToolTaskDialog = new ImmoToolTaskDialog((Frame)this.getFrame(), true);
        immoToolTaskDialog.addTask(new ImmoToolProjectCloseTask());
        immoToolTaskDialog.execute();
        if (!immoToolTaskDialog.wasSuccessful()) {
            ImmoToolUtils.showMessageErrorDialog("<html>" + this.getResourceMap().getString("error.cantCloseProject", new Object[0]) + "</html>", this.getFrame());
        }
    }

    @Action
    public void doCloseTab() {
        if (this.tabContainer.getTabCount() <= 0) {
            return;
        }
        int n = this.tabContainer.getSelectedIndex();
        if (n < 0) {
            return;
        }
        try {
            TabComponent tabComponent = (TabComponent)((Object)this.tabContainer.getComponentAt(n));
            ImmoToolUtils.removePanel(tabComponent.getTabTitle());
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not close tab!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    @Action
    public void doCreateProject() {
        if (this.isProjectLoaded()) {
            this.doCloseProject();
            if (this.isProjectLoaded()) {
                return;
            }
        }
        ImmoToolWizardDialog immoToolWizardDialog = new ImmoToolWizardDialog();
        ImmoToolApp.getApplication().show(immoToolWizardDialog);
        int n = immoToolWizardDialog.getStatus();
        if (n != 2 && n != 3) {
            return;
        }
        ImmoToolTaskDialog immoToolTaskDialog = new ImmoToolTaskDialog((Frame)this.getFrame(), true);
        immoToolTaskDialog.addTask(immoToolWizardDialog.getProjectTask());
        immoToolTaskDialog.execute();
        if (!immoToolTaskDialog.wasSuccessful()) {
            ImmoToolUtils.showMessageErrorDialog("<html>" + this.getResourceMap().getString("error.cantCreateProject", new Object[0]) + "</html>", this.getFrame());
        }
    }

    @Action
    public Task doDbAdmin() {
        final ResourceMap resourceMap = this.getResourceMap();
        return new ImmoToolTask<ImmoToolDbAdminDialog>(){

            @Override
            protected ImmoToolDbAdminDialog executeTask() throws Exception {
                return new ImmoToolDbAdminDialog();
            }

            @Override
            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog(resourceMap.getString("error.cantLoadDbAdministration", new Object[0]), throwable);
            }

            @Override
            protected void succeeded(ImmoToolDbAdminDialog immoToolDbAdminDialog) {
                super.succeeded(immoToolDbAdminDialog);
                ImmoToolApp.getApplication().show(immoToolDbAdminDialog);
            }
        };
    }

    @Action
    public void doDbExportForUpgrade() {
        Object object;
        Object object2;
        final ImmoToolDb immoToolDb = ImmoToolApp.getApplication().getDatabase();
        final ImmoToolProject immoToolProject = ImmoToolApp.getApplication().getProject();
        final ResourceMap resourceMap = this.getResourceMap();
        if (immoToolDb == null || immoToolProject == null) {
            return;
        }
        LinkedHashMap<String, JOptionFileChooser.OptionField> linkedHashMap = new LinkedHashMap<String, JOptionFileChooser.OptionField>();
        for (String string : immoToolProject.getPluginNames()) {
            object2 = immoToolProject.getPlugin(string);
            if (object2 == null || (object = ((ImmoToolPlugin)object2).getExportDatabaseSettings()) == null || object.isEmpty()) continue;
            linkedHashMap.putAll((Map<String, JOptionFileChooser.OptionField>)object);
        }
        final JOptionFileChooser jOptionFileChooser = new JOptionFileChooser(linkedHashMap);
        jOptionFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return resourceMap.getString("label.zipArchive", new Object[0]) + " (*.zip)";
            }
        });
        jOptionFileChooser.setSelectedFile(new File("ImmoTool-Export_" + System.currentTimeMillis() + ".zip"));
        int n = jOptionFileChooser.showSaveDialog(this.getFrame());
        if (n != 0) {
            return;
        }
        object2 = jOptionFileChooser.getSelectedFile();
        object = new ImmoToolTask<Boolean>((File)object2, resourceMap){
            final /* synthetic */ File val$exportFile;
            final /* synthetic */ ResourceMap val$viewResourceMap;
            {
                this.val$exportFile = file;
                this.val$viewResourceMap = resourceMap;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Boolean executeTask() throws Exception {
                Serializable serializable;
                this.setMessage("Create temp directory...");
                File file = new File(SystemUtils.getJavaIoTmpDir().getAbsolutePath() + File.separator + "export_" + System.currentTimeMillis());
                if (!file.exists() && !file.mkdir()) {
                    throw new Exception("Can't create directory: " + file.getAbsolutePath());
                }
                FileOutputStream fileOutputStream = null;
                DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
                String string = "exported at " + dateFormat.format(new Date());
                try {
                    serializable = new Properties();
                    ((Properties)serializable).putAll((Map<?, ?>)immoToolProject.getProperties());
                    ((Properties)serializable).setProperty("Project.Type", "local");
                    fileOutputStream = new FileOutputStream(new File(file.getAbsolutePath() + File.separator + "project.xml"));
                    ((Properties)serializable).storeToXML(fileOutputStream, "project settings, " + string);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileOutputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
                try {
                    serializable = new Properties();
                    ((Properties)serializable).putAll((Map<?, ?>)ImmoToolApp.getApplicationProperties());
                    ((Properties)serializable).putAll((Map<?, ?>)ImmoToolApp.getApplication().getUserProperties());
                    fileOutputStream = new FileOutputStream(new File(file.getAbsolutePath() + File.separator + "app.xml"));
                    ((Properties)serializable).storeToXML(fileOutputStream, "application settings, " + string);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)fileOutputStream);
                }
                serializable = new File(file.getAbsolutePath() + File.separator + "OpenEstate-Tool-News");
                if (!((File)serializable).exists() && !((File)serializable).mkdir()) {
                    throw new Exception("Can't create directory: " + ((File)serializable).getAbsolutePath());
                }
                int n = 0;
                for (SyndicationFeed syndicationFeed : SyndicationFeed.loadSyndicationFeeds()) {
                    try {
                        Properties serializable2 = new Properties();
                        syndicationFeed.save(serializable2, 0);
                        fileOutputStream = new FileOutputStream(new File(((File)serializable).getAbsolutePath() + File.separator + ++n + ".xml"));
                        serializable2.storeToXML(fileOutputStream, "news feeds, " + string);
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)fileOutputStream);
                    }
                }
                for (String string2 : immoToolProject.getPluginNames()) {
                    this.setMessage("Export for plugin '" + string2 + "'...");
                    ImmoToolPlugin immoToolPlugin = immoToolProject.getPlugin(string2);
                    if (immoToolPlugin == null) {
                        this.setMessage("PLUGIN NOT FOUND!");
                        continue;
                    }
                    immoToolPlugin.exportDatabase(file, immoToolDb, immoToolProject, jOptionFileChooser, this.createCallback());
                }
                Object object = null;
                try {
                    this.setMessage("Save files into a ZIP file...");
                    object = new ZipOutputStream(new FileOutputStream(this.val$exportFile));
                    for (File file2 : file.listFiles()) {
                        if (file2.getName().equals(".") || file2.getName().equals("..")) continue;
                        ImmoToolUtils.loadFileIntoZipStream(file2, (ZipOutputStream)object);
                    }
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)object);
                    FileUtils.deleteQuietly((File)file);
                }
                return true;
            }

            @Override
            protected void failed(Throwable throwable) {
                super.failed(throwable);
                LOGGER.error((Object)"Error during database export!");
                LOGGER.error((Object)("> " + throwable.getLocalizedMessage()), throwable);
                ImmoToolUtils.showMessageErrorDialog(this.val$viewResourceMap.getString("error.cantExportDatatabase", new Object[0]), throwable);
            }

            @Override
            protected void succeeded(Boolean bl) {
                super.succeeded(bl);
                if (!Boolean.TRUE.equals(bl)) {
                    return;
                }
                ImmoToolUtils.showMessageInfoDialog(this.val$viewResourceMap.getString("message.databaseExported", new Object[]{this.val$exportFile.getAbsolutePath()}), this.getTaskDialog());
            }
        };
        ImmoToolTaskDialog.execute(object);
    }

    @Action
    public void doDbExportToFile() {
        ImmoToolProject immoToolProject = ImmoToolApp.getApplication().getProject();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(this.getResourceMap().getString("label.backupDirectory", new Object[0]));
        jFileChooser.setApproveButtonText(this.getResourceMap().getString("label.selectDirectory", new Object[0]));
        jFileChooser.setSelectedFile(new File(immoToolProject.getBackupDirectory().getAbsolutePath() + File.separator + "."));
        int n = jFileChooser.showSaveDialog(this.getFrame());
        if (n != 0) {
            return;
        }
        final ResourceMap resourceMap = this.getResourceMap();
        ImmoToolDbBackupTask immoToolDbBackupTask = new ImmoToolDbBackupTask(ImmoToolApp.getApplication().getProject(), jFileChooser.getSelectedFile(), false){

            @Override
            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog(resourceMap.getString("error.cantExportDatatabase", new Object[0]), throwable);
            }

            @Override
            protected void succeeded(File file) {
                super.succeeded(file);
                ImmoToolUtils.showMessageInfoDialog(resourceMap.getString("message.databaseExported", new Object[]{file.getAbsolutePath()}), ImmoToolView.this.getFrame());
            }
        };
        ImmoToolTaskDialog.execute(immoToolDbBackupTask);
    }

    @Action
    public Task doDbExportToSnapshot() {
        final ResourceMap resourceMap = this.getResourceMap();
        return new ImmoToolTask<Boolean>(resourceMap.getString("label.createSnapshot", new Object[0])){

            @Override
            protected Boolean executeTask() throws Exception {
                ImmoToolDbSnapshot immoToolDbSnapshot = new ImmoToolDbSnapshot(new Date());
                immoToolDbSnapshot.createSnapshot();
                return true;
            }

            @Override
            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog(resourceMap.getString("error.cantCreateDatatabaseSnapshot", new Object[0]), throwable);
            }

            @Override
            protected void succeeded(Boolean bl) {
                super.succeeded(bl);
                ImmoToolUtils.showMessageInfoDialog(resourceMap.getString("message.databaseSnapshortCreated", new Object[0]), ImmoToolView.this.getFrame());
            }
        };
    }

    @Action
    public void doDbImportFromFile() {
        final ResourceMap resourceMap = this.getResourceMap();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setApproveButtonText(resourceMap.getString("message.openDatabaseBackup", new Object[0]));
        jFileChooser.setDialogTitle(resourceMap.getString("message.selectDatabaseBackup", new Object[0]));
        jFileChooser.setSelectedFile(new File(ImmoToolApp.getApplication().getProject().getBackupDirectory().getAbsolutePath() + File.separator + ""));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return resourceMap.getString("label.zipArchive", new Object[0]) + " (*.zip)";
            }
        });
        int n = jFileChooser.showOpenDialog(this.getFrame());
        if (n != 0) {
            return;
        }
        final Boolean bl = ImmoToolUtils.showQuestionWithCancelDialog(resourceMap.getString("question.createSnapshotBeforeImport", new Object[0]), this.getFrame());
        if (bl == null) {
            return;
        }
        this.unloadProject();
        final ImmoToolTaskDialog immoToolTaskDialog = new ImmoToolTaskDialog((Frame)this.getFrame(), true);
        ImmoToolDbRestoreTask immoToolDbRestoreTask = new ImmoToolDbRestoreTask(ImmoToolApp.getApplication().getProject(), jFileChooser.getSelectedFile(), true){

            @Override
            protected Boolean executeTask() throws Exception {
                if (Boolean.TRUE.equals(bl)) {
                    ImmoToolDbSnapshot immoToolDbSnapshot = new ImmoToolDbSnapshot(new Date());
                    immoToolDbSnapshot.createSnapshot();
                }
                return super.executeTask();
            }

            @Override
            protected void failed(Throwable throwable) {
                super.failed(throwable);
                immoToolTaskDialog.setAutoCloseSelected(false);
                this.setMessage(resourceMap.getString("error.cantImportDatatabase", new Object[0]));
                ImmoToolUtils.showMessageErrorDialog(resourceMap.getString("error.cantImportDatatabase", new Object[0]), throwable);
            }

            @Override
            protected void finished() {
                super.finished();
                ImmoToolView.this.loadProject(ImmoToolApp.getApplication().getProject());
            }

            @Override
            protected void succeeded(Boolean bl2) {
                super.succeeded(bl2);
                ImmoToolUtils.showMessageInfoDialog(resourceMap.getString("message.databaseImported", new Object[0]), ImmoToolView.this.getFrame());
            }
        };
        immoToolTaskDialog.addTask(immoToolDbRestoreTask);
        immoToolTaskDialog.execute();
    }

    @Action
    public void doDbImportFromSnapshot() {
        final ResourceMap resourceMap = this.getResourceMap();
        this.unloadProject();
        final ImmoToolTaskDialog immoToolTaskDialog = new ImmoToolTaskDialog((Frame)this.getFrame(), true);
        ImmoToolTask<Boolean> immoToolTask = new ImmoToolTask<Boolean>(resourceMap.getString("label.restoreSnapshot", new Object[0])){

            @Override
            protected Boolean executeTask() throws Exception {
                ImmoToolDb immoToolDb = ImmoToolApp.getApplication().getDatabase();
                ImmoToolDbSnapshot immoToolDbSnapshot = new ImmoToolDbSnapshot(null);
                ImmoToolDbSnapshot[] immoToolDbSnapshotArray = ImmoToolDbSnapshot.loadSnapshots();
                if (immoToolDbSnapshotArray == null) {
                    ImmoToolUtils.showMessageInfoDialog(resourceMap.getString("message.noSnapshotsFound", new Object[0]), this.getTitle(), ImmoToolView.this.getFrame());
                    return false;
                }
                ImmoToolDbSnapshot immoToolDbSnapshot2 = ImmoToolDbSnapshot.selectSnapshot(immoToolTaskDialog, immoToolDbSnapshotArray, resourceMap.getString("message.selectSnapshotToRestore", new Object[0]));
                if (immoToolDbSnapshot2 == null) {
                    return false;
                }
                Boolean bl = ImmoToolUtils.showQuestionWithCancelDialog(resourceMap.getString("question.createSnapshotBeforeImport", new Object[0]), ImmoToolView.this.getFrame());
                if (bl == null) {
                    return false;
                }
                if (Boolean.TRUE.equals(bl)) {
                    this.setMessage(resourceMap.getString("label.createSnapshot", new Object[0]));
                    ImmoToolDbSnapshot immoToolDbSnapshot3 = new ImmoToolDbSnapshot(new Date());
                    immoToolDbSnapshot3.createSnapshot(immoToolDb);
                }
                this.setMessage(resourceMap.getString("message.writeTempBackup", new Object[0]));
                immoToolDbSnapshot.removeSnapshot(immoToolDb);
                immoToolDbSnapshot.createSnapshot(immoToolDb);
                immoToolDb.removeCollection("ImmoTool");
                this.setMessage(resourceMap.getString("message.restoreSnapshot", new Object[0]));
                immoToolDbSnapshot2.restoreSnapshot(immoToolDb);
                this.setMessage(resourceMap.getString("message.removeTempBackup", new Object[0]));
                immoToolDbSnapshot.removeSnapshot(immoToolDb);
                return true;
            }

            @Override
            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog(resourceMap.getString("error.cantRestoreSnapshot", new Object[0]), throwable);
            }

            @Override
            protected void finished() {
                super.finished();
                ImmoToolView.this.loadProject(ImmoToolApp.getApplication().getProject());
            }

            @Override
            protected void succeeded(Boolean bl) {
                super.succeeded(bl);
                if (Boolean.TRUE.equals(bl)) {
                    ImmoToolUtils.showMessageInfoDialog(resourceMap.getString("message.snapshotRestored", new Object[0]), this.getTitle(), ImmoToolView.this.getFrame());
                }
            }
        };
        immoToolTaskDialog.addTask(immoToolTask);
        immoToolTaskDialog.execute();
    }

    @Action
    public void doDbRebuild() {
        final ResourceMap resourceMap = this.getResourceMap();
        this.unloadProject();
        ImmoToolTask<Boolean> immoToolTask = new ImmoToolTask<Boolean>(resourceMap.getString("label.rebuildDatabase", new Object[0])){

            @Override
            protected Boolean executeTask() throws Exception {
                ImmoToolProject immoToolProject = ImmoToolApp.getApplication().getProject();
                this.setMessage(resourceMap.getString("message.backupDatabase", new Object[0]));
                File file = new ImmoToolDbBackupTask(immoToolProject, immoToolProject.getTempDirectory(), "xmldb:exist:///db", false).executeTask();
                if (file == null) {
                    throw new Exception("Can't create backup!");
                }
                this.setMessage(resourceMap.getString("message.closeDatabase", new Object[0]));
                ImmoToolDb immoToolDb = ImmoToolApp.getApplication().getDatabase();
                immoToolDb.close();
                this.setMessage(resourceMap.getString("message.saveDatabaseDirectory", new Object[0]));
                File file2 = new File(immoToolDb.getDataDir().getParentFile().getPath() + File.separator + "data_old");
                if (file2.exists()) {
                    FileUtils.deleteQuietly((File)file2);
                }
                if (!immoToolDb.getDataDir().renameTo(file2)) {
                    throw new Exception("Can't move data-directory!");
                }
                this.setMessage(resourceMap.getString("message.reopenDatabase", new Object[0]));
                if (!immoToolDb.getDataDir().mkdir()) {
                    throw new Exception("Can't create new data-directory!");
                }
                immoToolDb.open();
                this.setMessage(resourceMap.getString("message.reloadBackup", new Object[0]));
                Boolean bl = new ImmoToolDbRestoreTask(immoToolProject, file, "xmldb:exist:///db", false).executeTask();
                if (!Boolean.TRUE.equals(bl)) {
                    throw new Exception("Can't restore backup!");
                }
                this.setMessage(resourceMap.getString("message.removeTempFiles", new Object[0]));
                FileUtils.deleteQuietly((File)file2);
                if (!file.delete()) {
                    LOGGER.warn((Object)("Can't delete '" + file.getAbsolutePath() + "'!"));
                }
                return true;
            }

            @Override
            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog(resourceMap.getString("error.cantRebuildDatabase", new Object[0]), throwable);
            }

            @Override
            protected void finished() {
                super.finished();
                ImmoToolView.this.loadProject(ImmoToolApp.getApplication().getProject());
            }

            @Override
            protected void succeeded(Boolean bl) {
                super.succeeded(bl);
                if (Boolean.TRUE.equals(bl)) {
                    ImmoToolUtils.showMessageInfoDialog(resourceMap.getString("message.databaseWasRebuild", new Object[0]), this.getTitle(), ImmoToolView.this.getFrame());
                }
            }
        };
        ImmoToolTaskDialog.execute(immoToolTask);
    }

    @Action
    public void doDbReload() {
        final ResourceMap resourceMap = this.getResourceMap();
        ImmoToolTask<Boolean> immoToolTask = new ImmoToolTask<Boolean>(resourceMap.getString("label.reloadDatabase", new Object[0])){

            @Override
            protected Boolean executeTask() throws Exception {
                Object object;
                ImmoToolDb immoToolDb = ImmoToolApp.getApplication().getDatabase();
                ImmoToolTask.Callback callback = this.createCallback();
                Boolean bl = ImmoToolUtils.showQuestionWithCancelDialog(resourceMap.getString("question.createSnapshotBeforeRebuild", new Object[0]), ImmoToolView.this.getFrame());
                if (bl == null) {
                    return false;
                }
                if (Boolean.TRUE.equals(bl)) {
                    this.setMessage(resourceMap.getString("label.createSnapshot", new Object[0]));
                    object = new ImmoToolDbSnapshot(new Date());
                    ((ImmoToolDbSnapshot)object).createSnapshot(immoToolDb);
                }
                object = ImmoToolApp.getApplication().getProject();
                for (String string : ((ImmoToolProject)object).getPluginNames()) {
                    this.setMessage(string);
                    ImmoToolPlugin immoToolPlugin = ((ImmoToolProject)object).getPlugin(string);
                    immoToolPlugin.rebuildDatabase(immoToolDb, (ImmoToolProject)object, callback);
                }
                this.setMessage(resourceMap.getString("label.reindexDatabase", new Object[0]));
                immoToolDb.reindexCollection("ImmoTool");
                return true;
            }

            @Override
            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog(resourceMap.getString("error.cantReloadDatabase", new Object[0]), throwable);
            }

            @Override
            protected void finished() {
                super.finished();
                ImmoToolView.this.loadProject(ImmoToolApp.getApplication().getProject());
            }

            @Override
            protected void succeeded(Boolean bl) {
                super.succeeded(bl);
                if (Boolean.TRUE.equals(bl)) {
                    ImmoToolUtils.showMessageInfoDialog(resourceMap.getString("message.databaseWasReloaded", new Object[0]), this.getTitle(), ImmoToolView.this.getFrame());
                }
            }
        };
        ImmoToolTaskDialog.execute(immoToolTask);
    }

    @Action
    public Task doDbRemoveSnapshot() {
        final ResourceMap resourceMap = this.getResourceMap();
        return new ImmoToolTask<Boolean>(resourceMap.getString("label.removeSnapshot", new Object[0])){

            @Override
            protected Boolean executeTask() throws Exception {
                ImmoToolDbSnapshot[] immoToolDbSnapshotArray = ImmoToolDbSnapshot.loadSnapshots();
                if (immoToolDbSnapshotArray == null) {
                    ImmoToolUtils.showMessageInfoDialog(resourceMap.getString("message.noSnapshotsFound", new Object[0]), this.getTitle(), ImmoToolView.this.getFrame());
                    return false;
                }
                ImmoToolDbSnapshot immoToolDbSnapshot = ImmoToolDbSnapshot.selectSnapshot(ImmoToolView.this.getFrame(), immoToolDbSnapshotArray, resourceMap.getString("message.selectSnapshotToRemove", new Object[0]));
                if (immoToolDbSnapshot == null) {
                    return false;
                }
                ImmoToolApp.getApplication().getDatabase().removeCollection(immoToolDbSnapshot.getCollection());
                return true;
            }

            @Override
            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog(resourceMap.getString("error.cantRemoveSnapshot", new Object[0]), throwable);
            }

            @Override
            protected void succeeded(Boolean bl) {
                super.succeeded(bl);
                if (Boolean.TRUE.equals(bl)) {
                    ImmoToolUtils.showMessageInfoDialog(resourceMap.getString("message.snapshotRemoved", new Object[0]), this.getTitle(), ImmoToolView.this.getFrame());
                }
            }
        };
    }

    @Action
    public void doOpenProject() {
        if (this.isProjectLoaded()) {
            this.doCloseProject();
            if (this.isProjectLoaded()) {
                return;
            }
        }
        ResourceMap resourceMap = this.getResourceMap();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(resourceMap.getString("message.openProjectDirectory", new Object[0]));
        jFileChooser.setApproveButtonText(resourceMap.getString("message.selectProjectDirectory", new Object[0]));
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setCurrentDirectory(new File(ImmoToolApp.APP_PROJECT_DIR));
        int n = jFileChooser.showOpenDialog(this.getFrame());
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (!ImmoToolProject.isValidProjectDirectory(file)) {
            ImmoToolUtils.showMessageErrorDialog("<html>" + resourceMap.getString("error.invalidProjectDirectory", new Object[0]) + "</html>", this.getFrame());
            return;
        }
        ImmoToolTaskDialog immoToolTaskDialog = new ImmoToolTaskDialog((Frame)this.getFrame(), true);
        immoToolTaskDialog.addTask(new ImmoToolProjectOpenTask(file));
        immoToolTaskDialog.execute();
        if (!immoToolTaskDialog.wasSuccessful()) {
            ImmoToolUtils.showMessageErrorDialog("<html>" + resourceMap.getString("error.cantOpenProject", new Object[0]) + "</html>", this.getFrame());
        }
    }

    @Action
    public void doRefreshTab() {
        if (this.tabContainer.getTabCount() <= 0) {
            return;
        }
        int n = this.tabContainer.getSelectedIndex();
        if (n < 0) {
            return;
        }
        try {
            TabComponent tabComponent = (TabComponent)((Object)this.tabContainer.getComponentAt(n));
            tabComponent.refreshTab();
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not refresh tab!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    @Action
    public void doShowAboutBox() {
        try {
            ImmoToolAboutDialog immoToolAboutDialog = new ImmoToolAboutDialog((Frame)this.getFrame(), true);
            immoToolAboutDialog.setVisible(true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load about-box!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    @Action
    public void doShowHelpDialog() {
        ImmoToolUtils.showHelpDialog();
    }

    @Action
    public void doShowLicenseDialog() {
        ImmoToolLicenseSetupDialog immoToolLicenseSetupDialog = new ImmoToolLicenseSetupDialog((Frame)this.getFrame(), true);
        immoToolLicenseSetupDialog.setVisible(true);
        if (immoToolLicenseSetupDialog.getStatus() != 2) {
            return;
        }
        try {
            String string = immoToolLicenseSetupDialog.getLicenseKey();
            if (string == null || string.trim().length() == 0) {
                throw new Exception(this.getResourceMap().getString("error.invalidLicenseKey", new Object[0]));
            }
            ImmoToolApp.setApplicationLicenseKey(string);
            ImmoToolApp.setApplicationLicenseRemindStamp(-1L);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not save license-key!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog(this.getResourceMap().getString("error.cantSaveLicenseKey", new Object[0]), exception);
        }
    }

    @Action
    public void doShowMemoryDialog() {
        MemoryMonitorDialog memoryMonitorDialog = new MemoryMonitorDialog((Frame)this.getFrame(), false);
        memoryMonitorDialog.start();
        memoryMonitorDialog.setVisible(true);
    }

    @Action
    public Task doShowPluginDialog() {
        final ResourceMap resourceMap = this.getResourceMap();
        PluginDialog pluginDialog = new PluginDialog((Frame)this.getFrame(), true, ImmoToolUtils.createHttpClient());
        pluginDialog.setVisible(true);
        return new ImmoToolTask<Boolean>(){

            @Override
            protected Boolean executeTask() throws Exception {
                boolean bl = false;
                for (Pluggable pluggable : PlugEngine.getInstance().getAllPluggables()) {
                    boolean bl2;
                    boolean bl3 = bl2 = ImmoToolApp.getApplication().getProject().getPlugin(pluggable.getName()) != null;
                    if (PlugEngine.getInstance().isEnabled(pluggable)) {
                        PlugEngine.getInstance().startPluggable(pluggable);
                        if (bl2) continue;
                        ImmoToolApp.getApplication().getProject().registerPlugin((ImmoToolPlugin)pluggable);
                        bl = true;
                        continue;
                    }
                    if (!bl2) continue;
                    ImmoToolApp.getApplication().getProject().unregisterPlugin((ImmoToolPlugin)pluggable);
                    bl = true;
                }
                if (bl) {
                    this.setMessage("reload project");
                    ImmoToolApp.getApplication().loadProject(ImmoToolApp.getApplication().getProject(), ImmoToolApp.getApplication().getDatabase(), this.createCallback());
                }
                return bl;
            }

            @Override
            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog(resourceMap.getString("error.cantUpdateModules", new Object[0]), throwable);
            }

            @Override
            protected void succeeded(Boolean bl) {
                super.succeeded(bl);
                if (bl.booleanValue()) {
                    ImmoToolUtils.showMessageInfoDialog(resourceMap.getString("message.modulesChanged", new Object[0]), ImmoToolView.this.getFrame());
                }
            }
        };
    }

    @Action
    public Task doShowProgramSetup() {
        return new ImmoToolTask<ImmoToolSetupDialog>(){

            @Override
            protected ImmoToolSetupDialog executeTask() throws Exception {
                return new ImmoToolSetupDialog();
            }

            @Override
            protected void succeeded(ImmoToolSetupDialog immoToolSetupDialog) {
                super.succeeded(immoToolSetupDialog);
                immoToolSetupDialog.setVisible(true);
                if (immoToolSetupDialog.getStatus() == 2 && ImmoToolApp.getApplication() != null) {
                    ImmoToolApp.getApplication().saveSettings();
                }
            }
        };
    }

    @Action
    public Task doShowProtocols() {
        String string = ImmoToolProtocolPanel.getInstanceTabTitle();
        if (ImmoToolUtils.selectPanel(string)) {
            return null;
        }
        return new ImmoToolTask<ImmoToolProtocolPanel>(){

            @Override
            protected ImmoToolProtocolPanel executeTask() throws Exception {
                return new ImmoToolProtocolPanel();
            }

            @Override
            protected void succeeded(ImmoToolProtocolPanel immoToolProtocolPanel) {
                super.succeeded(immoToolProtocolPanel);
                ImmoToolUtils.showPanel(immoToolProtocolPanel);
            }
        };
    }

    @Action
    public Task doShowSummary() {
        String string = ImmoToolFrontpagePanel.getInstanceTabTitle();
        if (ImmoToolUtils.selectPanel(string)) {
            return null;
        }
        return new ImmoToolTask<ImmoToolFrontpagePanel>(){

            @Override
            protected ImmoToolFrontpagePanel executeTask() throws Exception {
                return new ImmoToolFrontpagePanel();
            }

            @Override
            protected void succeeded(ImmoToolFrontpagePanel immoToolFrontpagePanel) {
                super.succeeded(immoToolFrontpagePanel);
                ImmoToolUtils.showPanel(immoToolFrontpagePanel);
            }
        };
    }

    @Action
    public void doSwitchNextTab() {
        if (this.tabContainer.getTabCount() <= 0) {
            return;
        }
        int n = this.tabContainer.getSelectedIndex();
        if (++n >= this.tabContainer.getTabCount()) {
            n = 0;
        }
        if (this.tabContainer.getSelectedIndex() != n) {
            this.selectTab(n);
        }
    }

    @Action
    public void doSwitchPrevTab() {
        if (this.tabContainer.getTabCount() <= 0) {
            return;
        }
        int n = this.tabContainer.getSelectedIndex();
        if (--n < 0) {
            n = this.tabContainer.getTabCount() - 1;
        }
        if (this.tabContainer.getSelectedIndex() != n) {
            this.selectTab(n);
        }
    }

    public int getTabIndex(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < this.tabContainer.getTabCount(); ++i) {
            if (!this.tabContainer.getTitleAt(i).trim().equals(string.trim())) continue;
            return i;
        }
        return -1;
    }

    public boolean isProjectLoaded() {
        return this.projectLoaded;
    }

    public void loadProject(ImmoToolProject immoToolProject) {
        this.projectLoaded = true;
        this.setProjectEnabled(true);
        this.setProjectCompany(immoToolProject.getAdress());
        this.buildMenu(immoToolProject);
        this.buildTaskPanel(immoToolProject);
        ImmoToolUtils.configureFrame(this.getFrame(), immoToolProject.getName());
        this.doShowSummary();
    }

    public boolean removeTab(int n) {
        return this.removeTab(n, false);
    }

    public boolean removeTab(int n, boolean bl) {
        if (!bl && !this.canRemoveTab(n)) {
            return false;
        }
        this.tabContainer.removeTabAt(n);
        return true;
    }

    public void selectTab(int n) {
        this.tabContainer.setSelectedIndex(n);
        this.updateTabs();
        if (n > 0) {
            CloseTabPaneUI closeTabPaneUI = (CloseTabPaneUI)this.tabContainer.getUI();
            closeTabPaneUI.scroll(n);
        }
    }

    public void setProjectCompany(CompanyAdressImpl companyAdressImpl) {
        if (companyAdressImpl == null) {
            this.companyLabel.setVisible(false);
            this.companyLabel.setText("");
            return;
        }
        this.companyLabel.setText("<html><div align=\"right\"><b style=\"font-size:1.4em;\">" + companyAdressImpl.getCompanyName() + "</b><br>" + companyAdressImpl.getPersonFirstName() + " " + companyAdressImpl.getPersonLastName() + "</div></html>");
        this.companyLabel.setVisible(true);
    }

    public void setProjectCompanyLogo(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            this.companyLabel.setIcon(null);
        } else {
            BufferedImage bufferedImage2 = ImmoToolUtils.scaleImageAndKeepRatio(bufferedImage, 80, 50);
            this.companyLabel.setIcon((Icon)new ImageIcon(bufferedImage2));
        }
    }

    private void setProjectEnabled(boolean bl) {
        this.dbMenu.setEnabled(bl);
        this.createProjectMenuItem.setEnabled(!bl);
        this.openProjectMenuItem.setEnabled(!bl);
        this.closeProjectMenuItem.setEnabled(bl);
        this.pluginSetupItem.setEnabled(bl);
    }

    public void switchLanguage(Locale locale) {
        if (this.tabContainer.getTabCount() > 0) {
            boolean bl = ImmoToolUtils.showQuestionDialog(this.getResourceMap().getString("question.reallyChangeLanguageAndCloseTabs", new Object[0]), this.getFrame());
            if (!bl) {
                return;
            }
            this.tabContainer.removeAll();
        }
        Locale locale2 = Locale.getDefault();
        try {
            ImmoToolUtils.setLocale(locale);
            for (Pluggable pluggable : PlugEngine.getInstance().getAllPluggables()) {
                ((ImmoToolPlugin)pluggable).clearResources();
            }
            if (ImmoToolApp.getApplication().getProject() != null) {
                this.buildMenu(ImmoToolApp.getApplication().getProject());
                this.buildTaskPanel(ImmoToolApp.getApplication().getProject());
                this.getResourceMap().injectComponents((Component)this.getFrame());
            } else {
                this.buildMenu(null);
                this.buildTaskPanel(null);
            }
            ImmoToolApp.getApplication().getUserProperties().setProperty("languageCode", locale.getLanguage());
            ImmoToolApp.getApplication().saveSettings();
        }
        catch (Exception exception) {
            ImmoToolUtils.setLocale(locale2);
            LOGGER.error((Object)"Can't change language!");
            LOGGER.error((Object)("> switch back to " + locale2.toString()));
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    private void updateBackground() {
        int n = this.mainPanel.getSize().height;
        if (this.lastRepaintPosition == n) {
            return;
        }
        this.lastRepaintPosition = n;
        Painter painter = ImmoToolUtils.getBackgroundPainter(n);
        try {
            Graphics2D graphics2D;
            Object object;
            if (this.logoImg == null) {
                object = ImageIO.read(((Object)((Object)this)).getClass().getResource("/com/openindex/openestate/tool/resources/logos/openindex.png"));
                int n2 = ((BufferedImage)object).getWidth() + 15;
                int n3 = ((BufferedImage)object).getHeight() + 17;
                this.logoImg = new BufferedImage(n2, n3, 2);
                graphics2D = this.logoImg.createGraphics();
                graphics2D.drawImage((Image)object, 17, (n3 - ((BufferedImage)object).getHeight()) / 2, null);
            }
            object = new Rectangle2D.Double(0.0, -5.0, this.getFrame().getSize().getWidth(), 80.0);
            ShapePainter shapePainter = new ShapePainter((Shape)object);
            shapePainter.setHorizontalAlignment(AbstractLayoutPainter.HorizontalAlignment.LEFT);
            shapePainter.setVerticalAlignment(AbstractLayoutPainter.VerticalAlignment.BOTTOM);
            shapePainter.setFillPaint((Paint)Color.WHITE);
            AlphaPainter alphaPainter = new AlphaPainter();
            alphaPainter.setAlpha(0.35f);
            alphaPainter.setPainters(new Painter[]{shapePainter});
            graphics2D = new ImagePainter(this.logoImg, AbstractLayoutPainter.HorizontalAlignment.LEFT, AbstractLayoutPainter.VerticalAlignment.BOTTOM);
            graphics2D.setAntialiasing(true);
            this.mainPanel.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{painter, alphaPainter, graphics2D}));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not paint background!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            this.mainPanel.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{painter}));
        }
    }

    public void updateTabs() {
        for (int i = 0; i < this.tabContainer.getTabCount(); ++i) {
            TabComponent tabComponent = (TabComponent)((Object)this.tabContainer.getComponentAt(i));
            if (tabComponent == null) continue;
            this.tabContainer.setTitleAt(i, tabComponent.getTabTitle() != null ? tabComponent.getTabTitle() : "(Tab " + i + ")");
            String string = tabComponent.getTabInfo();
            String string2 = "<html><div style=\"padding:5px;\"><b style=\"margin:0;font-size:1.2em;\">" + this.tabContainer.getTitleAt(i) + "</b>";
            if (string != null) {
                string2 = string2 + "<hr>" + string;
            }
            string2 = string2 + "</div></html>";
            this.tabContainer.setToolTipTextAt(i, string2);
            Icon icon = tabComponent.getTabIcon();
            if (icon == null) continue;
            this.tabContainer.setIconAt(i, tabComponent.getTabIcon());
        }
    }

    public void unloadProject() {
        this.projectLoaded = false;
        this.setProjectEnabled(false);
        this.setProjectCompany(null);
        this.setProjectCompanyLogo(null);
        while (this.tabContainer.getTabCount() > 0) {
            this.tabContainer.remove(0);
        }
        this.buildMenu(null);
        this.buildTaskPanel(null);
        ImmoToolUtils.configureFrame(this.getFrame(), "(" + this.getResourceMap().getString("label.projectClosed", new Object[0]) + ")");
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.programMenu = new JMenu();
        this.createProjectMenuItem = new JMenuItem();
        this.openProjectMenuItem = new JMenuItem();
        this.closeProjectMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.refreshTabMenuItem = new JMenuItem();
        this.switchPrevTabMenuItem = new JMenuItem();
        this.switchNextTabMenuItem = new JMenuItem();
        this.closeTabMenuItem = new JMenuItem();
        JSeparator jSeparator = new JSeparator();
        this.quitMenuItem = new JMenuItem();
        this.extrasMenu = new JMenu();
        this.pluginSetupItem = new JMenuItem();
        this.autoUpdateMenuItem = new JMenuItem();
        this.programSetupMenuItem = new JMenuItem();
        this.licenseMenuItem = new JMenuItem();
        this.protocolsMenuItem = new JMenuItem();
        this.memoryMenuItem = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.dbMenu = new JMenu();
        this.dbMenuExport = new JMenu();
        this.doDbExportToFileItem = new JMenuItem();
        this.doDbExportToSnapshotItem = new JMenuItem();
        this.dbMenuImport = new JMenu();
        this.doDbImportFromFileItem = new JMenuItem();
        this.doDbImportFromSnapshotItem = new JMenuItem();
        this.dbMenuManage = new JMenu();
        this.doDbReloadItem = new JMenuItem();
        this.doDbRebuildItem = new JMenuItem();
        this.doDbRemoveSnapshotItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.dbAdminMenuItem = new JMenuItem();
        this.dbExportForUpgradeMenuItem = new JMenuItem();
        this.languageMenu = new JMenu();
        this.jSeparator3 = new JSeparator();
        this.helpMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator jSeparator2 = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel = new JXPanel();
        this.taskPanel = new JXTaskPaneContainer();
        this.programTaskPane = new JXTaskPane();
        this.tabPanel = new JXPanel();
        this.menuBar.setName("menuBar");
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ImmoToolView.class);
        this.programMenu.setText(resourceMap.getString("programMenu.text", new Object[0]));
        this.programMenu.setName("programMenu");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(ImmoToolView.class, (Object)this);
        this.createProjectMenuItem.setAction(applicationActionMap.get("doCreateProject"));
        this.createProjectMenuItem.setName("createProjectMenuItem");
        this.programMenu.add(this.createProjectMenuItem);
        this.openProjectMenuItem.setAction(applicationActionMap.get("doOpenProject"));
        this.openProjectMenuItem.setName("openProjectMenuItem");
        this.programMenu.add(this.openProjectMenuItem);
        this.closeProjectMenuItem.setAction(applicationActionMap.get("doCloseProject"));
        this.closeProjectMenuItem.setName("closeProjectMenuItem");
        this.programMenu.add(this.closeProjectMenuItem);
        this.jSeparator4.setName("jSeparator4");
        this.programMenu.add(this.jSeparator4);
        this.refreshTabMenuItem.setAction(applicationActionMap.get("doRefreshTab"));
        this.refreshTabMenuItem.setName("refreshTabMenuItem");
        this.programMenu.add(this.refreshTabMenuItem);
        this.switchPrevTabMenuItem.setAction(applicationActionMap.get("doSwitchPrevTab"));
        this.switchPrevTabMenuItem.setName("switchPrevTabMenuItem");
        this.programMenu.add(this.switchPrevTabMenuItem);
        this.switchNextTabMenuItem.setAction(applicationActionMap.get("doSwitchNextTab"));
        this.switchNextTabMenuItem.setName("switchNextTabMenuItem");
        this.programMenu.add(this.switchNextTabMenuItem);
        this.closeTabMenuItem.setAction(applicationActionMap.get("doCloseTab"));
        this.closeTabMenuItem.setName("closeTabMenuItem");
        this.programMenu.add(this.closeTabMenuItem);
        jSeparator.setName("jSeparator2");
        this.programMenu.add(jSeparator);
        this.quitMenuItem.setAction(applicationActionMap.get("quit"));
        this.quitMenuItem.setName("quitMenuItem");
        this.programMenu.add(this.quitMenuItem);
        this.menuBar.add(this.programMenu);
        this.extrasMenu.setText(resourceMap.getString("extrasMenu.text", new Object[0]));
        this.extrasMenu.setName("extrasMenu");
        this.pluginSetupItem.setAction(applicationActionMap.get("doShowPluginDialog"));
        this.pluginSetupItem.setName("pluginSetupItem");
        this.extrasMenu.add(this.pluginSetupItem);
        this.autoUpdateMenuItem.setAction(applicationActionMap.get("doAutoUpdate"));
        this.autoUpdateMenuItem.setName("autoUpdateMenuItem");
        this.extrasMenu.add(this.autoUpdateMenuItem);
        this.programSetupMenuItem.setAction(applicationActionMap.get("doShowProgramSetup"));
        this.programSetupMenuItem.setName("programSetupMenuItem");
        this.extrasMenu.add(this.programSetupMenuItem);
        this.licenseMenuItem.setAction(applicationActionMap.get("doShowLicenseDialog"));
        this.licenseMenuItem.setName("licenseMenuItem");
        this.extrasMenu.add(this.licenseMenuItem);
        this.protocolsMenuItem.setAction(applicationActionMap.get("doShowProtocols"));
        this.protocolsMenuItem.setName("protocolsMenuItem");
        this.extrasMenu.add(this.protocolsMenuItem);
        this.memoryMenuItem.setAction(applicationActionMap.get("doShowMemoryDialog"));
        this.memoryMenuItem.setName("memoryMenuItem");
        this.extrasMenu.add(this.memoryMenuItem);
        this.jSeparator5.setName("jSeparator5");
        this.extrasMenu.add(this.jSeparator5);
        this.dbMenu.setText(resourceMap.getString("dbMenu.text", new Object[0]));
        this.dbMenu.setName("dbMenu");
        this.dbMenu.setOpaque(true);
        this.dbMenuExport.setText(resourceMap.getString("dbMenuExport.text", new Object[0]));
        this.dbMenuExport.setName("dbMenuExport");
        this.dbMenuExport.setOpaque(true);
        this.doDbExportToFileItem.setAction(applicationActionMap.get("doDbExportToFile"));
        this.doDbExportToFileItem.setName("doDbExportToFileItem");
        this.dbMenuExport.add(this.doDbExportToFileItem);
        this.doDbExportToSnapshotItem.setAction(applicationActionMap.get("doDbExportToSnapshot"));
        this.doDbExportToSnapshotItem.setName("doDbExportToSnapshotItem");
        this.dbMenuExport.add(this.doDbExportToSnapshotItem);
        this.dbMenu.add(this.dbMenuExport);
        this.dbMenuImport.setText(resourceMap.getString("dbMenuImport.text", new Object[0]));
        this.dbMenuImport.setName("dbMenuImport");
        this.dbMenuImport.setOpaque(true);
        this.doDbImportFromFileItem.setAction(applicationActionMap.get("doDbImportFromFile"));
        this.doDbImportFromFileItem.setName("doDbImportFromFileItem");
        this.dbMenuImport.add(this.doDbImportFromFileItem);
        this.doDbImportFromSnapshotItem.setAction(applicationActionMap.get("doDbImportFromSnapshot"));
        this.doDbImportFromSnapshotItem.setName("doDbImportFromSnapshotItem");
        this.dbMenuImport.add(this.doDbImportFromSnapshotItem);
        this.dbMenu.add(this.dbMenuImport);
        this.dbMenuManage.setText(resourceMap.getString("dbMenuManage.text", new Object[0]));
        this.dbMenuManage.setName("dbMenuManage");
        this.dbMenuManage.setOpaque(true);
        this.doDbReloadItem.setAction(applicationActionMap.get("doDbReload"));
        this.doDbReloadItem.setName("doDbReloadItem");
        this.dbMenuManage.add(this.doDbReloadItem);
        this.doDbRebuildItem.setAction(applicationActionMap.get("doDbRebuild"));
        this.doDbRebuildItem.setName("doDbRebuildItem");
        this.dbMenuManage.add(this.doDbRebuildItem);
        this.doDbRemoveSnapshotItem.setAction(applicationActionMap.get("doDbRemoveSnapshot"));
        this.doDbRemoveSnapshotItem.setName("doDbRemoveSnapshotItem");
        this.dbMenuManage.add(this.doDbRemoveSnapshotItem);
        this.dbMenu.add(this.dbMenuManage);
        this.jSeparator1.setName("jSeparator1");
        this.dbMenu.add(this.jSeparator1);
        this.dbAdminMenuItem.setAction(applicationActionMap.get("doDbAdmin"));
        this.dbAdminMenuItem.setName("dbAdminMenuItem");
        this.dbMenu.add(this.dbAdminMenuItem);
        this.dbExportForUpgradeMenuItem.setAction(applicationActionMap.get("doDbExportForUpgrade"));
        this.dbExportForUpgradeMenuItem.setName("dbExportForUpgradeMenuItem");
        this.dbMenu.add(this.dbExportForUpgradeMenuItem);
        this.extrasMenu.add(this.dbMenu);
        this.languageMenu.setText(resourceMap.getString("languageMenu.text", new Object[0]));
        this.languageMenu.setName("languageMenu");
        this.languageMenu.setOpaque(true);
        this.extrasMenu.add(this.languageMenu);
        this.jSeparator3.setName("jSeparator3");
        this.extrasMenu.add(this.jSeparator3);
        this.helpMenuItem.setAction(applicationActionMap.get("doShowHelpDialog"));
        this.helpMenuItem.setName("helpMenuItem");
        this.extrasMenu.add(this.helpMenuItem);
        this.aboutMenuItem.setAction(applicationActionMap.get("doShowAboutBox"));
        this.aboutMenuItem.setName("aboutMenuItem");
        this.extrasMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.extrasMenu);
        this.statusPanel.setName("statusPanel");
        jSeparator2.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout groupLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jSeparator2, -1, 726, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 542, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(jSeparator2, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.mainPanel.setName("mainPanel");
        this.taskPanel.setName("taskPanel");
        this.taskPanel.setOpaque(false);
        this.taskPanel.setPreferredSize(new Dimension(200, 70));
        this.programTaskPane.setAnimated(false);
        this.programTaskPane.setName("programTaskPane");
        this.programTaskPane.setTitle(resourceMap.getString("programTaskPane.title", new Object[0]));
        this.taskPanel.add((Component)this.programTaskPane);
        this.tabPanel.setName("tabPanel");
        this.tabPanel.setOpaque(false);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.tabPanel);
        this.tabPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 508, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 426, Short.MAX_VALUE));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent((Component)this.taskPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.tabPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.taskPanel, -1, 450, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addGap(12, 12, 12).addComponent((Component)this.tabPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.setComponent((JComponent)this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private class TaskPaneCollapseListener
    implements PropertyChangeListener {
        private Boolean oldValue = null;

        private TaskPaneCollapseListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Boolean bl;
            if ("collapsed".equals(propertyChangeEvent.getPropertyName()) && (bl = (Boolean)propertyChangeEvent.getNewValue()) != null && (this.oldValue == null || !bl.equals(this.oldValue))) {
                ImmoToolView.this.getFrame().repaint();
                this.oldValue = bl;
            }
        }
    }
}

