/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.impl.CompanyAdressImpl;
import com.openindex.openestate.tool.ImmoToolAboutDialog;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolPlugin;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolProjectCreateTask;
import com.openindex.openestate.tool.ImmoToolProjectOpenTask;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.JAdressPanel;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.engine.PlugEngine;
import com.openindex.openestate.tool.utils.engine.ui.swing.firefoxstyle.PluginDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class ImmoToolWizardDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(ImmoToolWizardDialog.class);
    public static final int STATUS_UNDEFINED = 0;
    public static final int STATUS_CANCELLED = 1;
    public static final int STATUS_PROJECT_CREATED = 2;
    public static final int STATUS_PROJECT_OPENED = 3;
    private int status = 0;
    private ActionMap actionMap = null;
    private ResourceMap resourceMap = null;
    private JAdressPanel companyAdressPanel = null;
    private ValidationHandler validationHandler = null;
    private JTextField projectNameField = null;
    private JTextField projectDirField = null;
    private JEditorPane licenseTextArea = null;
    private JCheckBox licenseAcceptButton = null;
    private JButton doChooseDirButton = null;
    private JButton doManagePluginsButton = null;
    private List<PluginCheckBox> pluginBoxes = null;
    private File baseDir = null;
    private ImmoToolTask wizardTask = null;
    private JXPanel bgPanel;
    private JPanel companyPanel;
    private JButton doCancelButton;
    private JButton doHelpButton;
    private JButton doProjectCreateButton;
    private JButton doProjectOpenButton;
    private JTabbedPane mainTabbedPane;
    private JPanel pluginsPanel;
    private JPanel projectPanel;
    private JXTitledSeparator titleLabel;

    public ImmoToolWizardDialog() {
        this(ImmoToolApp.getApplication().getMainFrame());
    }

    public ImmoToolWizardDialog(Frame frame) {
        super(frame, true);
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(ImmoToolWizardDialog.class, this);
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoToolWizardDialog.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.initComponents();
        this.buildProjectPanel();
        this.buildCompanyPanel();
        this.buildPluginsPanel();
        this.resourceMap.injectComponents((Component)this);
        this.setBaseDir(new File(ImmoToolApp.APP_PROJECT_DIR).getAbsoluteFile());
        this.setLocationRelativeTo(null);
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.doCancelButton.setOpaque(false);
            this.doHelpButton.setOpaque(false);
            this.doProjectCreateButton.setOpaque(false);
            this.doProjectOpenButton.setOpaque(false);
        }
        try {
            this.licenseTextArea.setText(ImmoToolAboutDialog.buildLicensePage());
            this.licenseTextArea.setCaretPosition(0);
            HyperlinkListener hyperlinkListener = new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType())) {
                        ImmoToolUtils.openURL(hyperlinkEvent.getURL());
                    }
                }
            };
            this.licenseTextArea.addHyperlinkListener(hyperlinkListener);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not read license-text!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            this.licenseTextArea.setText(this.resourceMap.getString("error.cantLoadLicenseText", new Object[]{exception.getLocalizedMessage()}));
            this.licenseTextArea.setCaretPosition(0);
        }
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ImmoToolWizardDialog.this.doCancel();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }
        });
        ImmoToolUtils.configureDialog(this, this.bgPanel);
    }

    private void buildCompanyPanel() {
        this.companyAdressPanel = new JAdressPanel(){

            @Override
            protected void init() {
                this.registerValidation(this.adressStreetField);
                this.registerValidation(this.adressStreetNrField);
                this.registerValidation(this.adressCityField);
                this.registerValidation(this.adressPostalCodeField);
                this.registerValidation(this.personFirstNameField);
                this.registerValidation(this.personLastNameField);
                this.registerValidation(this.personMailField);
                this.registerValidation(this.personPhoneField);
                this.registerValidation(this.companyMailField);
                this.registerValidation(this.companyNameField);
                this.registerValidation(this.companyPhoneField);
            }
        };
        this.companyAdressPanel.loadAdress(new CompanyAdressImpl());
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder("pref:grow");
        defaultFormBuilder.border(Borders.DIALOG);
        defaultFormBuilder.append((Component)this.companyAdressPanel);
        defaultFormBuilder.nextLine();
        JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
        jScrollPane.setBorder(Borders.EMPTY);
        this.companyPanel.setLayout(new BorderLayout());
        this.companyPanel.add((Component)jScrollPane, "Center");
        this.companyPanel.revalidate();
        this.companyPanel.repaint();
    }

    private void buildPluginsPanel() {
        this.pluginBoxes = new ArrayList<PluginCheckBox>();
        this.doManagePluginsButton = new JButton(this.actionMap.get("doManagePlugins"));
        JPanel jPanel = ImmoToolUtils.buildButtonBar(this.doManagePluginsButton);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder("pref:grow");
        for (String string : ImmoToolUtils.getPluginNames()) {
            ImmoToolPlugin immoToolPlugin = ImmoToolUtils.getPlugin(string);
            PluginCheckBox pluginCheckBox = new PluginCheckBox(immoToolPlugin);
            this.pluginBoxes.add(pluginCheckBox);
            pluginCheckBox.setSelected(PlugEngine.getInstance().isEnabled(immoToolPlugin));
            defaultFormBuilder.append((Component)pluginCheckBox);
            defaultFormBuilder.nextLine();
        }
        JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
        jScrollPane.setBorder(Borders.EMPTY);
        this.pluginsPanel.setBorder(Borders.DIALOG);
        this.pluginsPanel.setLayout(new BorderLayout(5, 5));
        this.pluginsPanel.add((Component)ImmoToolUtils.createHead2Separator(this.resourceMap.getString("label.availableModules", new Object[0])), "North");
        this.pluginsPanel.add((Component)jScrollPane, "Center");
        this.pluginsPanel.add((Component)jPanel, "South");
        this.pluginsPanel.revalidate();
        this.pluginsPanel.repaint();
    }

    private void buildProjectPanel() {
        this.projectNameField = new JTextField();
        this.projectNameField.setName("projectNameField");
        this.projectNameField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\uffff') {
                    return;
                }
                if (keyEvent.getKeyCode() == 8) {
                    // empty if block
                }
                String string = ImmoToolWizardDialog.this.projectNameField.getText();
                ImmoToolWizardDialog.this.setProjectDir(string);
            }
        });
        this.projectDirField = new JTextField();
        this.projectDirField.setName("projectDirField");
        this.projectDirField.setEditable(false);
        this.licenseTextArea = new JEditorPane();
        this.licenseTextArea.setName("licenseTextArea");
        this.licenseTextArea.setContentType("text/html");
        this.licenseTextArea.setEditable(false);
        this.licenseTextArea.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.licenseAcceptButton = new JCheckBox();
        this.licenseAcceptButton.setName("licenseAcceptButton");
        this.doChooseDirButton = new JButton(this.actionMap.get("doChooseBaseDir"));
        this.validationHandler.putRule(this.projectNameField, ValidationHandler.NOT_BLANK);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder("right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, pref");
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator(this.resourceMap.getString("label.projectSettings", new Object[0])), 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.projectSettings.name", new Object[0]), (Component)this.projectNameField, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.projectSettings.directory", new Object[0]), (Component)this.projectDirField);
        defaultFormBuilder.append((Component)this.doChooseDirButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(" ");
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator(this.resourceMap.getString("label.licenseAgreement", new Object[0])), 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.licenseAcceptButton, 5);
        defaultFormBuilder.nextLine();
        this.projectPanel.setLayout(new BorderLayout(5, 5));
        this.projectPanel.setBorder(Borders.DIALOG);
        this.projectPanel.add((Component)defaultFormBuilder.getPanel(), "North");
        this.projectPanel.add((Component)new JScrollPane(this.licenseTextArea), "Center");
        this.projectPanel.revalidate();
        this.projectPanel.repaint();
    }

    @Action
    public void doCancel() {
        this.status = 1;
        this.setVisible(false);
    }

    @Action
    public void doChooseBaseDir() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.resourceMap.getString("message.pleaseSelectBaseDirectory", new Object[0]));
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setSelectedFile(this.baseDir);
        jFileChooser.setApproveButtonText(this.resourceMap.getString("message.selectDirectory", new Object[0]));
        int n = jFileChooser.showSaveDialog(this);
        if (n != 0) {
            return;
        }
        this.setBaseDir(jFileChooser.getSelectedFile());
    }

    @Action
    public void doCreateProject() {
        try {
            this.validationHandler.validate();
            this.companyAdressPanel.validateInputs();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!this.validationHandler.isValid() || !this.companyAdressPanel.isValidInput()) {
                arrayList.add(this.resourceMap.getString("error.invalidInput", new Object[0]));
            }
            if (!this.licenseAcceptButton.isSelected()) {
                arrayList.add(this.resourceMap.getString("error.invalidAgreement", new Object[0]));
            }
            if (this.getSelectedPlugins().length <= 0) {
                arrayList.add(this.resourceMap.getString("error.invalidModules", new Object[0]));
            }
            if (!arrayList.isEmpty()) {
                ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("message.pleaseCorrectErrors", new Object[0]), arrayList);
                return;
            }
            File file = new File(this.projectDirField.getText().trim());
            if (file.exists()) {
                throw new Exception(this.resourceMap.getString("error.projectAlreadyExists", new Object[0]));
            }
            this.wizardTask = new ImmoToolProjectCreateTask(this.projectNameField.getText().trim(), file, this);
            this.status = 2;
            this.setVisible(false);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not create project!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantCreateProject", new Object[]{exception.getLocalizedMessage()}));
        }
    }

    @Action
    public void doManagePlugins() {
        PluginDialog pluginDialog = new PluginDialog((Dialog)this, true, ImmoToolUtils.createHttpClient());
        pluginDialog.setVisible(true);
        this.pluginsPanel.removeAll();
        this.buildPluginsPanel();
    }

    @Action
    public void doOpenProject() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.resourceMap.getString("message.pleaseSelectProjectDirectory", new Object[0]));
        jFileChooser.setApproveButtonText(this.resourceMap.getString("message.selectDirectory", new Object[0]));
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setSelectedFile(new File(this.baseDir.getAbsolutePath() + File.separator + "."));
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        try {
            File file = jFileChooser.getSelectedFile();
            if (!ImmoToolProject.isValidProjectDirectory(file)) {
                throw new Exception(this.resourceMap.getString("error.invalidProjectDirectory", new Object[0]));
            }
            this.wizardTask = new ImmoToolProjectOpenTask(file);
            this.status = 3;
            this.setVisible(false);
        }
        catch (Exception exception) {
            this.wizardTask = null;
            LOGGER.error((Object)"could not open project!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantOpenProject", new Object[]{exception.getLocalizedMessage()}));
        }
    }

    @Action
    public void doShowWizardHelp() {
        ImmoToolUtils.showHelpDialog("app.wizard", true);
    }

    public ImmoToolTask getProjectTask() {
        return this.wizardTask;
    }

    public int getStatus() {
        return this.status;
    }

    public void loadProject(ImmoToolProject immoToolProject) {
        this.companyAdressPanel.saveAdress(immoToolProject.getAdress());
        for (ImmoToolPlugin immoToolPlugin : this.getSelectedPlugins()) {
            immoToolProject.registerPlugin(immoToolPlugin);
        }
    }

    private ImmoToolPlugin[] getSelectedPlugins() {
        ArrayList<ImmoToolPlugin> arrayList = new ArrayList<ImmoToolPlugin>();
        for (PluginCheckBox pluginCheckBox : this.pluginBoxes) {
            if (!pluginCheckBox.isSelected()) continue;
            arrayList.add(pluginCheckBox.getPlugin());
        }
        return arrayList.toArray(new ImmoToolPlugin[arrayList.size()]);
    }

    private void setBaseDir(File file) {
        this.baseDir = file.getAbsoluteFile();
        this.setProjectDir(this.projectNameField.getText());
    }

    private void setProjectDir(String string) {
        String string2 = string.replaceAll("\\W", "-").trim();
        while (string2.contains("--")) {
            string2 = string2.replaceAll("\\-\\-", "-");
        }
        if (this.baseDir.getParentFile() == null) {
            this.projectDirField.setText(this.baseDir.getPath() + string2);
        } else {
            this.projectDirField.setText(this.baseDir.getPath() + File.separator + string2);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.mainTabbedPane.setSelectedIndex(0);
    }

    private void initComponents() {
        this.bgPanel = new JXPanel();
        this.titleLabel = ImmoToolUtils.createHead1Separator("");
        this.mainTabbedPane = new JTabbedPane();
        this.projectPanel = new JPanel();
        this.companyPanel = new JPanel();
        this.pluginsPanel = new JPanel();
        this.doProjectCreateButton = new JButton();
        this.doProjectOpenButton = new JButton();
        this.doCancelButton = new JButton();
        this.doHelpButton = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ImmoToolWizardDialog.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.bgPanel.setName("bgPanel");
        this.titleLabel.setIcon(resourceMap.getIcon("titleLabel.icon"));
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle(resourceMap.getString("titleLabel.title", new Object[0]));
        this.mainTabbedPane.setName("mainTabbedPane");
        this.projectPanel.setName("projectPanel");
        GroupLayout groupLayout = new GroupLayout(this.projectPanel);
        this.projectPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 805, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 475, Short.MAX_VALUE));
        this.mainTabbedPane.addTab(resourceMap.getString("projectPanel.TabConstraints.tabTitle", new Object[0]), this.projectPanel);
        this.companyPanel.setName("companyPanel");
        GroupLayout groupLayout2 = new GroupLayout(this.companyPanel);
        this.companyPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 805, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 475, Short.MAX_VALUE));
        this.mainTabbedPane.addTab(resourceMap.getString("companyPanel.TabConstraints.tabTitle", new Object[0]), this.companyPanel);
        this.pluginsPanel.setName("pluginsPanel");
        GroupLayout groupLayout3 = new GroupLayout(this.pluginsPanel);
        this.pluginsPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 805, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 475, Short.MAX_VALUE));
        this.mainTabbedPane.addTab(resourceMap.getString("pluginsPanel.TabConstraints.tabTitle", new Object[0]), this.pluginsPanel);
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(ImmoToolWizardDialog.class, (Object)this);
        this.doProjectCreateButton.setAction(applicationActionMap.get("doCreateProject"));
        this.doProjectCreateButton.setName("doProjectCreateButton");
        this.doProjectOpenButton.setAction(applicationActionMap.get("doOpenProject"));
        this.doProjectOpenButton.setName("doProjectOpenButton");
        this.doCancelButton.setAction(applicationActionMap.get("doCancel"));
        this.doCancelButton.setName("doCancelButton");
        this.doHelpButton.setAction(applicationActionMap.get("doShowWizardHelp"));
        this.doHelpButton.setName("doHelpButton");
        GroupLayout groupLayout4 = new GroupLayout((Container)this.bgPanel);
        this.bgPanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainTabbedPane, -1, 810, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addComponent(this.doHelpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 498, Short.MAX_VALUE).addComponent(this.doProjectCreateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.doProjectOpenButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.doCancelButton)).addComponent((Component)this.titleLabel, -1, 810, Short.MAX_VALUE)).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mainTabbedPane, -1, 502, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.doCancelButton).addComponent(this.doProjectOpenButton).addComponent(this.doProjectCreateButton).addComponent(this.doHelpButton)).addContainerGap()));
        GroupLayout groupLayout5 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.bgPanel, -1, -1, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.bgPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private class PluginCheckBox
    extends JCheckBox {
        private String pluginName = null;

        public PluginCheckBox(ImmoToolPlugin immoToolPlugin) {
            this.setText("<html>&nbsp;<b>" + immoToolPlugin.getTitle() + " v" + immoToolPlugin.getVersion() + "</b>" + "<div style=\"font-size:10px; padding-left:15px;padding-top:2px;\">" + "<i>" + immoToolPlugin.getDescription() + "</i><br>" + "<i>" + ImmoToolWizardDialog.this.resourceMap.getString("label.module.author", new Object[0]) + " " + immoToolPlugin.getAuthor() + ", " + ImmoToolWizardDialog.this.resourceMap.getString("label.module.license", new Object[0]) + " " + immoToolPlugin.getLicense() + ", " + ImmoToolWizardDialog.this.resourceMap.getString("label.module.website", new Object[0]) + " " + immoToolPlugin.getWebsite() + "</i>" + "</div>" + "</html>");
            this.pluginName = immoToolPlugin.getName();
        }

        public ImmoToolPlugin getPlugin() {
            return ImmoToolUtils.getPlugin(this.pluginName);
        }

        public String getPluginName() {
            return this.pluginName;
        }
    }
}

