/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.Autoscroll;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class AutoscrollSupport
implements Autoscroll {
    Component comp;
    Insets insets;
    Insets scrollUnits;

    public AutoscrollSupport(Component component, Insets insets) {
        this(component, insets, insets);
    }

    public AutoscrollSupport(Component component, Insets insets, Insets insets2) {
        this.comp = component;
        this.insets = insets;
        this.scrollUnits = insets2;
    }

    @Override
    public void autoscroll(Point point) {
        JViewport jViewport = this.getViewport();
        if (jViewport == null) {
            return;
        }
        Point point2 = jViewport.getViewPosition();
        int n = jViewport.getExtentSize().height;
        int n2 = jViewport.getExtentSize().width;
        if (point.y - point2.y < this.insets.top) {
            jViewport.setViewPosition(new Point(point2.x, Math.max(point2.y - this.scrollUnits.top, 0)));
        } else if (point2.y + n - point.y < this.insets.bottom) {
            jViewport.setViewPosition(new Point(point2.x, Math.min(point2.y + this.scrollUnits.bottom, this.comp.getHeight() - n)));
        } else if (point.x - point2.x < this.insets.left) {
            jViewport.setViewPosition(new Point(Math.max(point2.x - this.scrollUnits.left, 0), point2.y));
        } else if (point2.x + n2 - point.x < this.insets.right) {
            jViewport.setViewPosition(new Point(Math.min(point2.x + this.scrollUnits.right, this.comp.getWidth() - n2), point2.y));
        }
    }

    @Override
    public Insets getAutoscrollInsets() {
        int n = this.comp.getHeight();
        int n2 = this.comp.getWidth();
        return new Insets(n, n2, n, n2);
    }

    JViewport getViewport() {
        return (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this.comp);
    }
}

