/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ClipboardTextGrabber {
    private static final Logger LOGGER = Logger.getLogger(ClipboardTextGrabber.class);

    public static String getClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return "";
        }
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            LOGGER.error((Object)"Unssuported flavor!");
            LOGGER.error((Object)("> " + unsupportedFlavorException.getLocalizedMessage()), (Throwable)unsupportedFlavorException);
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"Can't read clipboard!");
            LOGGER.error((Object)("> " + iOException.getLocalizedMessage()), (Throwable)iOException);
        }
        return null;
    }
}

