/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public abstract class CsvExportTask<CsvType>
extends ImmoToolTask<Long> {
    private static final Logger LOGGER = Logger.getLogger(CsvExportTask.class);
    private File csvFile = null;
    private Charset csvCharset = null;
    private ResourceMap resourceMap = null;

    public CsvExportTask(File file, Charset charset) {
        this.csvFile = file;
        this.csvCharset = charset;
        this.resourceMap = ImmoToolUtils.getResourceMap(CsvExportTask.class);
        this.setTitle(this.resourceMap.getString("title", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long executeExport() throws ImmoToolException, IOException {
        Long l;
        if (this.csvFile.isDirectory()) {
            throw new ImmoToolException("CSV file is invalid!");
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.csvFile), this.csvCharset != null ? this.csvCharset : Charset.defaultCharset());
            CsvType[] CsvTypeArray = this.loadCsvObjects();
            String[] stringArray = this.getHeadlineValues();
            if (stringArray != null) {
                boolean bl = true;
                for (String string : stringArray) {
                    if (bl) {
                        bl = false;
                    } else {
                        outputStreamWriter.write(",");
                    }
                    outputStreamWriter.write("\"");
                    if (string != null) {
                        outputStreamWriter.write(string.replace("\"", "'").trim());
                    }
                    outputStreamWriter.write("\"");
                }
                outputStreamWriter.write(SystemUtils.LINE_SEPARATOR);
            }
            long l2 = 0L;
            for (CsvType CsvType : CsvTypeArray) {
                try {
                    int exception;
                    stringArray = this.loadEmptyContainer();
                    this.writeValues(CsvType, stringArray);
                    for (exception = 0; exception < stringArray.length; ++exception) {
                        if (stringArray[exception] != null) continue;
                        stringArray[exception] = "";
                    }
                    exception = 1;
                    for (String string : stringArray) {
                        if (exception != 0) {
                            exception = 0;
                        } else {
                            outputStreamWriter.write(",");
                        }
                        outputStreamWriter.write("\"");
                        outputStreamWriter.write(string.replace("\"", "'"));
                        outputStreamWriter.write("\"");
                    }
                    outputStreamWriter.write(SystemUtils.LINE_SEPARATOR);
                    ++l2;
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't execute CSV export!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
            ((Writer)outputStreamWriter).flush();
            l = l2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outputStreamWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)outputStreamWriter);
        return l;
    }

    @Override
    protected Long executeTask() throws Exception {
        return this.executeExport();
    }

    protected abstract String getFieldTitle(int var1);

    protected String[] getHeadlineValues() {
        String[] stringArray = this.loadEmptyContainer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getFieldTitle(i);
        }
        return stringArray;
    }

    protected abstract CsvType[] loadCsvObjects() throws ImmoToolException;

    protected abstract String[] loadEmptyContainer();

    protected void writeValue(int n, String string, String[] stringArray) {
        if (n < 0 || stringArray.length <= n) {
            return;
        }
        if (string == null || string.trim().length() == 0) {
            return;
        }
        stringArray[n] = string.trim();
    }

    protected abstract void writeValues(CsvType var1, String[] var2);
}

