/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.CsvImportTask;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.skife.csv.CSVReader;
import org.skife.csv.SimpleReader;

public class CsvImportDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(CsvImportDialog.class);
    public static final int OPENED = 0;
    public static final int CANCELLED = 1;
    public static final int APPROVED = 2;
    private int status = 0;
    private ResourceMap resourceMap;
    private File csvFile;
    private CsvImportTask csvTask;
    private List<String[]> csvValues;
    private CsvTableModel csvTableModel;
    private ComboBoxModel csvFieldModel;
    private JComboBox charsetBox;
    private JLabel charsetLabel;
    private JButton closeButton;
    private JXTable csvTable;
    private JScrollPane csvTableScroller;
    private JButton helpButton;
    private JCheckBox ignoreFirstLineBox;
    private JComboBox quotingCharBox;
    private JLabel quotingCharLabel;
    private JButton refreshButton;
    private JComboBox separatorCharBox;
    private JLabel separatorCharLabel;
    private JButton submitButton;
    private JXTitledSeparator tableTitleLabel;
    private JXTitledSeparator titleLabel;
    private JCheckBox trimWhitespaceBox;

    public CsvImportDialog(File file, CsvImportTask csvImportTask) throws IOException {
        this(file, csvImportTask, ImmoToolApp.getApplication().getMainFrame(), true);
    }

    public CsvImportDialog(File file, CsvImportTask csvImportTask, Frame frame, boolean bl) throws IOException {
        super(frame, bl);
        this.csvTask = csvImportTask;
        this.build(file);
        this.setLocationRelativeTo(frame);
    }

    private void build(File file) throws IOException {
        this.resourceMap = ImmoToolUtils.getResourceMap(CsvImportDialog.class);
        this.setContentPane((Container)new JXPanel());
        this.initComponents();
        this.resourceMap.injectComponents((Component)this);
        this.charsetBox.setModel(new DefaultComboBoxModel());
        this.charsetBox.setSelectedIndex(-1);
        for (Charset charset : Charset.availableCharsets().values()) {
            ((DefaultComboBoxModel)this.charsetBox.getModel()).addElement(charset);
            if (!Charset.defaultCharset().equals(charset)) continue;
            this.charsetBox.setSelectedIndex(this.charsetBox.getModel().getSize() - 1);
        }
        ImmoToolUtils.configureTable(this.csvTable);
        this.csvTableModel = new CsvTableModel();
        this.csvTable.setModel((TableModel)this.csvTableModel);
        this.csvTable.setSortable(false);
        this.csvTable.getSelectionModel().setSelectionMode(0);
        this.csvFieldModel = this.csvTask.createFieldModel();
        this.csvTable.setDefaultRenderer(Integer.class, (TableCellRenderer)new CsvFieldRenderer());
        JComboBox jComboBox = new JComboBox(this.csvFieldModel);
        jComboBox.setRenderer(new CsvBoxRenderer());
        this.csvTable.setDefaultEditor(Integer.class, (TableCellEditor)new DefaultCellEditor(jComboBox));
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.closeButton.setOpaque(false);
            this.submitButton.setOpaque(false);
            this.helpButton.setOpaque(false);
            this.refreshButton.setOpaque(false);
        }
        this.helpButton.setEnabled(false);
        this.csvValues = new ArrayList<String[]>();
        this.loadCsvFile(file);
        ImmoToolUtils.configureDialog(this, (JXPanel)this.getContentPane());
    }

    public void configureTask(CsvImportTask csvImportTask) throws ImmoToolException {
        if (this.getStatus() != 2) {
            throw new ImmoToolException("dialog was not approved!");
        }
        csvImportTask.setupReader(this.getCsvReader(), this.getCsvCharset(), this.isFirstCsvLineIgnored());
        csvImportTask.getFieldMapping().clear();
        csvImportTask.getFieldMapping().putAll(this.getCsvFieldMapping());
    }

    @Action
    public void doCancel() {
        this.status = 1;
        this.setVisible(false);
    }

    @Action
    public void doHelp() {
    }

    @Action
    public void doRefresh() {
        try {
            int n;
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            for (n = 0; n < this.csvTableModel.getRowCount(); ++n) {
                Integer n2 = (Integer)this.csvTableModel.getValueAt(n, 0);
                if (n2 == null) continue;
                hashMap.put(n, n2);
            }
            this.loadCsvFile(this.csvFile);
            for (n = 0; n < this.csvTableModel.getRowCount(); ++n) {
                if (!hashMap.containsKey(n)) continue;
                this.csvTableModel.setValueAt(hashMap.get(n), n, 0);
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"csv-import-error!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantImportFile", new Object[0]), exception);
        }
    }

    @Action
    public void doSubmit() {
        try {
            Map<Integer, List<Integer>> map = this.getCsvFieldMapping();
            if (map == null || map.isEmpty()) {
                throw new Exception(this.resourceMap.getString("error.fieldMappingIsEmpty", new Object[0]));
            }
            this.status = 2;
            this.setVisible(false);
        }
        catch (Exception exception) {
            ImmoToolUtils.showMessageErrorDialog(this.resourceMap.getString("error.cantSaveFieldMapping", new Object[0]), exception);
            return;
        }
    }

    public boolean isFirstCsvLineIgnored() {
        return this.ignoreFirstLineBox.isSelected();
    }

    private Charset getCsvCharset() {
        int n = this.charsetBox.getSelectedIndex();
        return n >= 0 ? (Charset)this.charsetBox.getSelectedItem() : Charset.defaultCharset();
    }

    private Map<Integer, List<Integer>> getCsvFieldMapping() throws ImmoToolException {
        HashMap<Integer, List<Integer>> hashMap = new HashMap<Integer, List<Integer>>();
        for (int i = 0; i < this.csvTableModel.getRowCount(); ++i) {
            Integer n = (Integer)this.csvTableModel.getValueAt(i, 0);
            if (n == null) continue;
            if (hashMap.containsKey(n) && !this.csvTask.isMultipleSelectionAllowed(n)) {
                String string = n + " (" + this.csvTask.getFieldTitle(n) + ")";
                throw new ImmoToolException(this.resourceMap.getString("error.fieldIsAlreadyMapped", new Object[]{string}));
            }
            if (!hashMap.containsKey(n)) {
                hashMap.put(n, new ArrayList());
            }
            ((List)hashMap.get(n)).add(i);
        }
        return hashMap;
    }

    private CSVReader getCsvReader() {
        SimpleReader simpleReader = new SimpleReader();
        simpleReader.setTrim(this.trimWhitespaceBox.isSelected());
        String string = this.separatorCharBox.getSelectedItem().toString();
        simpleReader.setSeperator(string.length() > 0 ? string.charAt(0) : (char)',');
        String string2 = this.quotingCharBox.getSelectedItem().toString().trim();
        simpleReader.setQuoteCharacters(string2.length() > 0 ? string2.toCharArray() : new char[]{});
        return simpleReader;
    }

    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCsvFile(File file) throws IOException {
        this.csvFile = file;
        this.csvValues.clear();
        BufferedReader bufferedReader = null;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            bufferedReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), this.getCsvCharset()));
            String string = null;
            while ((string = ((LineNumberReader)bufferedReader).readLine()) != null && ((LineNumberReader)bufferedReader).getLineNumber() <= 4) {
                stringBuilder.append(string).append(SystemUtils.LINE_SEPARATOR);
            }
            CSVReader cSVReader = this.getCsvReader();
            this.csvValues.addAll(cSVReader.parse(stringBuilder.toString()));
            this.loadCsvTable();
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    private void loadCsvTable() {
        this.csvTableModel.clear();
        int n = 0;
        if (this.ignoreFirstLineBox.isSelected()) {
            ++n;
        }
        String[] stringArray = this.csvValues.size() > n ? this.csvValues.get(n) : new String[]{};
        String[] stringArray2 = this.csvValues.size() > ++n ? this.csvValues.get(n) : new String[]{};
        String[] stringArray3 = this.csvValues.size() > ++n ? this.csvValues.get(n) : new String[]{};
        int n2 = Math.max(stringArray.length, Math.max(stringArray2.length, stringArray3.length));
        for (int i = 0; i < n2; ++i) {
            this.csvTableModel.addCsvColumn(null, stringArray.length > i ? stringArray[i] : null, stringArray2.length > i ? stringArray2[i] : null, stringArray3.length > i ? stringArray3[i] : null);
        }
        this.csvTable.packAll();
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator("");
        this.charsetLabel = new JLabel();
        this.charsetBox = new JComboBox();
        this.separatorCharLabel = new JLabel();
        this.separatorCharBox = new JComboBox();
        this.ignoreFirstLineBox = new JCheckBox();
        this.quotingCharLabel = new JLabel();
        this.quotingCharBox = new JComboBox();
        this.trimWhitespaceBox = new JCheckBox();
        this.tableTitleLabel = ImmoToolUtils.createHead2Separator("");
        this.refreshButton = new JButton();
        this.csvTableScroller = new JScrollPane();
        this.csvTable = new JXTable();
        this.helpButton = new JButton();
        this.submitButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(CsvImportDialog.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.titleLabel.setIcon(resourceMap.getIcon("titleLabel.icon"));
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle(resourceMap.getString("titleLabel.title", new Object[0]));
        this.charsetLabel.setHorizontalAlignment(4);
        this.charsetLabel.setText(resourceMap.getString("charsetLabel.text", new Object[0]));
        this.charsetLabel.setName("charsetLabel");
        this.charsetBox.setName("charsetBox");
        this.separatorCharLabel.setHorizontalAlignment(4);
        this.separatorCharLabel.setText(resourceMap.getString("separatorCharLabel.text", new Object[0]));
        this.separatorCharLabel.setName("separatorCharLabel");
        this.separatorCharBox.setEditable(true);
        this.separatorCharBox.setModel(new DefaultComboBoxModel<String>(new String[]{",", ";", "|"}));
        this.separatorCharBox.setName("separatorCharBox");
        this.ignoreFirstLineBox.setText(resourceMap.getString("ignoreFirstLineBox.text", new Object[0]));
        this.ignoreFirstLineBox.setName("ignoreFirstLineBox");
        this.ignoreFirstLineBox.setOpaque(false);
        this.quotingCharLabel.setHorizontalAlignment(4);
        this.quotingCharLabel.setText(resourceMap.getString("quotingCharLabel.text", new Object[0]));
        this.quotingCharLabel.setName("quotingCharLabel");
        this.quotingCharBox.setEditable(true);
        this.quotingCharBox.setModel(new DefaultComboBoxModel<String>(new String[]{"'", "\""}));
        this.quotingCharBox.setName("quotingCharBox");
        this.trimWhitespaceBox.setSelected(true);
        this.trimWhitespaceBox.setText(resourceMap.getString("trimWhitespaceBox.text", new Object[0]));
        this.trimWhitespaceBox.setName("trimWhitespaceBox");
        this.trimWhitespaceBox.setOpaque(false);
        this.tableTitleLabel.setName("tableTitleLabel");
        this.tableTitleLabel.setTitle(resourceMap.getString("tableTitleLabel.title", new Object[0]));
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(CsvImportDialog.class, (Object)this);
        this.refreshButton.setAction(applicationActionMap.get("doRefresh"));
        this.refreshButton.setName("refreshButton");
        this.csvTableScroller.setName("csvTableScroller");
        this.csvTable.setName("csvTable");
        this.csvTableScroller.setViewportView((Component)this.csvTable);
        this.helpButton.setAction(applicationActionMap.get("doHelp"));
        this.helpButton.setName("helpButton");
        this.submitButton.setAction(applicationActionMap.get("doSubmit"));
        this.submitButton.setName("submitButton");
        this.closeButton.setAction(applicationActionMap.get("doCancel"));
        this.closeButton.setName("closeButton");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.csvTableScroller, -1, 485, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 254, Short.MAX_VALUE).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 483, Short.MAX_VALUE).addGap(14, 14, 14)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.quotingCharLabel, -1, -1, Short.MAX_VALUE).addComponent(this.separatorCharLabel, -1, -1, Short.MAX_VALUE).addComponent(this.charsetLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.separatorCharBox, 0, 100, Short.MAX_VALUE).addComponent(this.quotingCharBox, -2, 100, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ignoreFirstLineBox, -1, 348, Short.MAX_VALUE).addComponent(this.trimWhitespaceBox, -1, 348, Short.MAX_VALUE))).addComponent(this.charsetBox, 0, 450, Short.MAX_VALUE)).addGap(14, 14, 14)).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.tableTitleLabel, -1, 398, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.refreshButton).addContainerGap()))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.charsetLabel).addComponent(this.charsetBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.separatorCharBox, -2, -1, -2).addComponent(this.separatorCharLabel).addComponent(this.ignoreFirstLineBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.quotingCharBox, -2, -1, -2).addComponent(this.quotingCharLabel).addComponent(this.trimWhitespaceBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.refreshButton).addComponent((Component)this.tableTitleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.csvTableScroller, -1, 220, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.helpButton).addComponent(this.closeButton).addComponent(this.submitButton)).addContainerGap()));
        this.pack();
    }

    private final class CsvFieldRenderer
    extends JLabel
    implements TableCellRenderer {
        private CsvFieldRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Integer n3 = (Integer)object;
            if (n3 == null) {
                this.setText(CsvImportDialog.this.resourceMap.getString("label.emptyMapping", new Object[0]));
            } else if (n3 < CsvImportDialog.this.csvFieldModel.getSize()) {
                this.setText(CsvImportDialog.this.csvTask.getFieldTitle(n3));
            } else {
                this.setText(CsvImportDialog.this.resourceMap.getString("label.unknownMapping", new Object[0]));
            }
            this.setOpaque(true);
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            this.setBackground(bl ? jTable.getSelectionBackground() : (n % 2 == 0 ? jTable.getBackground() : ImmoToolUtils.BG_COLOR_2));
            return this;
        }
    }

    private final class CsvBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private CsvBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Integer n2 = (Integer)object;
            if (n2 == null) {
                this.setText("[ " + CsvImportDialog.this.resourceMap.getString("label.emptyMapping", new Object[0]) + " ]");
            } else if (n2 < CsvImportDialog.this.csvFieldModel.getSize()) {
                this.setText(CsvImportDialog.this.csvTask.getFieldTitle(n2));
            } else {
                this.setText("[ " + CsvImportDialog.this.resourceMap.getString("label.unknownMapping", new Object[0]) + " ]");
            }
            this.setOpaque(true);
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            return this;
        }
    }

    private final class CsvTableModel
    extends DefaultTableModel {
        public static final int COLUMN_MAPPING = 0;
        public static final int COLUMN_PREVIEW1 = 1;
        public static final int COLUMN_PREVIEW2 = 2;
        public static final int COLUMN_PREVIEW3 = 3;
        private Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
        private Map<Integer, Class> COLUMN_CLASSES;

        public CsvTableModel() {
            this.COLUMN_NAMES.put(0, CsvImportDialog.this.resourceMap.getString("csvTableCol.mapping", new Object[0]));
            this.COLUMN_NAMES.put(1, CsvImportDialog.this.resourceMap.getString("csvTableCol.firstRow", new Object[0]));
            this.COLUMN_NAMES.put(2, CsvImportDialog.this.resourceMap.getString("csvTableCol.secondRow", new Object[0]));
            this.COLUMN_NAMES.put(3, CsvImportDialog.this.resourceMap.getString("csvTableCol.thirdRow", new Object[0]));
            this.COLUMN_CLASSES = new HashMap<Integer, Class>();
            this.COLUMN_CLASSES.put(0, Integer.class);
            this.COLUMN_CLASSES.put(1, String.class);
            this.COLUMN_CLASSES.put(2, String.class);
            this.COLUMN_CLASSES.put(3, String.class);
            this.setColumnCount(this.COLUMN_NAMES.size());
        }

        public void addCsvColumn(Integer n, String string, String string2, String string3) {
            this.addRow(this.buildRow(n, string, string2, string3));
        }

        private Object[] buildRow(Integer n, String string, String string2, String string3) {
            TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
            treeMap.put(0, n);
            treeMap.put(1, string);
            treeMap.put(2, string2);
            treeMap.put(3, string3);
            return treeMap.values().toArray(new Object[treeMap.size()]);
        }

        public void clear() {
            while (this.getRowCount() > 0) {
                this.removeRow(0);
            }
        }

        public Class getColumnClass(int n) {
            return this.COLUMN_CLASSES.containsKey(n) ? this.COLUMN_CLASSES.get(n) : null;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES.containsKey(n) ? this.COLUMN_NAMES.get(n) : null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    }
}

