/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import org.skife.csv.CSVReader;

public abstract class CsvImportTask<CsvType>
extends ImmoToolTask<Long> {
    private static final Logger LOGGER = Logger.getLogger(CsvImportTask.class);
    private final Map<Integer, List<Integer>> fieldMapping;
    private final ResourceMap resourceMap;
    private final File csvFile;
    private CSVReader csvReader = null;
    private Charset csvCharset = null;
    private boolean csvReaderIgnoreFirstLine = false;

    protected CsvImportTask(File file) {
        this.csvFile = file;
        this.fieldMapping = new HashMap<Integer, List<Integer>>();
        this.resourceMap = ImmoToolUtils.getResourceMap(CsvImportTask.class);
        this.setTitle(this.resourceMap.getString("title", new Object[0]));
    }

    protected abstract CsvType createCsvObject();

    public ComboBoxModel createFieldModel() {
        TreeMap<Object, Integer> treeMap = new TreeMap<Object, Integer>();
        for (int i = 0; i < this.getDefinedFieldCount(); ++i) {
            String string = this.getFieldTitle(i);
            if (StringUtils.isEmpty((String)string) || treeMap.containsKey(string)) continue;
            treeMap.put(string, i);
        }
        DefaultComboBoxModel<Integer> defaultComboBoxModel = new DefaultComboBoxModel<Integer>();
        defaultComboBoxModel.addElement(null);
        for (Integer n : treeMap.values()) {
            defaultComboBoxModel.addElement(n);
        }
        return defaultComboBoxModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long executeImport() throws ImmoToolException, IOException {
        if (!this.csvFile.isFile()) {
            throw new ImmoToolException("csv-file does not exist!");
        }
        if (!this.csvFile.canRead()) {
            throw new ImmoToolException("csv-file is not readable!");
        }
        if (this.csvReader == null || this.csvCharset == null) {
            throw new ImmoToolException("csv-reader is not properly configured!");
        }
        Reader reader = null;
        try {
            this.setMessage(this.resourceMap.getString("message.readFile", new Object[]{this.csvFile.getPath()}));
            reader = new InputStreamReader((InputStream)new FileInputStream(this.csvFile), this.csvCharset);
            List list = this.csvReader.parse(reader);
            long l = 0L;
            this.setMessage(this.resourceMap.getString("message.readLines", new Object[]{list.size()}));
            for (int i = 0; i < list.size(); ++i) {
                try {
                    if (i == 0 && this.csvReaderIgnoreFirstLine) continue;
                    String[] stringArray = (String[])list.get(i);
                    CsvType CsvType = this.createCsvObject();
                    this.readValues(stringArray, CsvType);
                    boolean bl = this.saveCsvObject(CsvType);
                    if (!bl) continue;
                    ++l;
                    continue;
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)("Can't read line " + (i + 1) + "!"));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
            this.setMessage(this.resourceMap.getString("message.linesImported", new Object[]{l}));
            Long l2 = l;
            return l2;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    protected Long executeTask() throws Exception {
        return this.executeImport();
    }

    protected abstract int getDefinedFieldCount();

    public Map<Integer, List<Integer>> getFieldMapping() {
        return this.fieldMapping;
    }

    public File getCsvFile() {
        return this.csvFile;
    }

    protected abstract String getFieldTitle(int var1);

    public boolean isMultipleSelectionAllowed(int n) {
        return false;
    }

    protected String readValue(int n, String[] stringArray) {
        if (this.fieldMapping == null || this.fieldMapping.isEmpty()) {
            return n >= 0 && stringArray.length > n ? stringArray[n] : null;
        }
        if (n < 0 || !this.fieldMapping.containsKey(n)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        List<Integer> list = this.fieldMapping.get(n);
        for (Integer n2 : list) {
            if (n2 >= stringArray.length) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(SystemUtils.LINE_SEPARATOR).append(SystemUtils.LINE_SEPARATOR);
            }
            stringBuilder.append(stringArray[n2]);
        }
        return stringBuilder.toString();
    }

    protected abstract void readValues(String[] var1, CsvType var2);

    protected abstract boolean saveCsvObject(CsvType var1);

    public final void setupReader(CSVReader cSVReader) {
        this.setupReader(cSVReader, null, false);
    }

    public final void setupReader(CSVReader cSVReader, Charset charset) {
        this.setupReader(cSVReader, null, false);
    }

    public void setupReader(CSVReader cSVReader, Charset charset, boolean bl) {
        this.csvReader = cSVReader;
        this.csvReaderIgnoreFirstLine = bl;
        this.csvCharset = charset != null ? charset : Charset.defaultCharset();
    }
}

