/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class HashGenerator {
    private static final Logger LOGGER = Logger.getLogger(HashGenerator.class);
    public static final String ALGORITHM_SHA = "SHA";
    public static final String ALGORITHM_MD5 = "MD5";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createHashFile(File file, String string, String string2) throws IOException {
        File file2 = new File(file.getPath() + "." + string2.toLowerCase());
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file2);
            fileWriter.append(string);
            fileWriter.flush();
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    public static byte[] messageDigest(String string, String string2) throws NoSuchAlgorithmException, IOException {
        return HashGenerator.messageDigest(new BufferedInputStream(new ByteArrayInputStream(string.getBytes())), string2);
    }

    public static byte[] messageDigest(File file, String string) throws NoSuchAlgorithmException, IOException {
        return HashGenerator.messageDigest(new BufferedInputStream(new FileInputStream(file)), string);
    }

    public static byte[] messageDigest(InputStream inputStream, String string) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray = new byte[8192];
        int n = 0;
        while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
            messageDigest.update(byArray, 0, n);
        }
        return messageDigest.digest();
    }

    public static String messageDigestAsString(File file, String string) throws NoSuchAlgorithmException, IOException {
        return HashGenerator.messageDigestAsString(HashGenerator.messageDigest(file, string));
    }

    public static String messageDigestAsString(String string, String string2) throws NoSuchAlgorithmException, IOException {
        return HashGenerator.messageDigestAsString(HashGenerator.messageDigest(string, string2));
    }

    public static String messageDigestAsString(byte[] byArray) throws NoSuchAlgorithmException, IOException {
        String string = "";
        String string2 = "";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i <= byArray.length - 1; ++i) {
            string2 = Integer.toHexString(byArray[i]);
            switch (string2.length()) {
                case 1: {
                    string = "0" + Integer.toHexString(byArray[i]);
                    break;
                }
                case 2: {
                    string = Integer.toHexString(byArray[i]);
                    break;
                }
                case 8: {
                    string = Integer.toHexString(byArray[i]).substring(6, 8);
                    break;
                }
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static void generate(File file, String string, Map<String, String> map, boolean bl) throws Exception {
        HashGenerator.generate(file, new String[]{".jar", ".exe", ".sh", ".bat", ".txt", ".ini"}, string, map, bl);
    }

    public static void generate(File file, String[] stringArray, String string, Map<String, String> map, boolean bl) throws Exception {
        final String[] stringArray2 = stringArray;
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String string = file.getName().toLowerCase().trim();
                for (String string2 : stringArray2) {
                    if (!string.toLowerCase().endsWith(string2)) continue;
                    return true;
                }
                return false;
            }
        };
        HashGenerator.generate(file, fileFilter, string, map, bl);
    }

    public static void generate(File file, FileFilter fileFilter, String string, Map<String, String> map, boolean bl) throws Exception {
        if (!file.isDirectory()) {
            return;
        }
        for (File file2 : file.listFiles()) {
            if (bl && file2.isDirectory()) {
                HashGenerator.generate(file2, fileFilter, string, map, bl);
                continue;
            }
            if (!file2.isFile() || !fileFilter.accept(file2)) continue;
            String string2 = HashGenerator.messageDigestAsString(file2, string);
            if (map == null) {
                HashGenerator.createHashFile(file2, string2, string);
                continue;
            }
            map.put(file2.getName(), string2);
        }
    }

    public static void main(String[] stringArray) {
        DOMConfigurator.configure((URL)HashGenerator.class.getResource("/com/openindex/openestate/tool/resources/log4j_verbose.xml"));
        try {
            HashGenerator.generate(new File("."), ALGORITHM_SHA, null, true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load hash-values!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }
}

