/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.utils;

import com.openindex.openestate.tool.ImmoToolUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.application.ResourceMap;

public class ImageWritingFileFilter
extends FileFilter {
    private final Set<String> formats;
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ImageWritingFileFilter.class);

    public ImageWritingFileFilter() {
        this.formats = new TreeSet<String>();
        for (String string : ImageIO.getWriterFormatNames()) {
            if (this.formats.contains(string = string.toLowerCase())) continue;
            this.formats.add(string);
        }
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        for (String string : this.formats) {
            if (!file.getName().toLowerCase().endsWith("." + string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.formats) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("*.").append(string);
            arrayList.add(string);
        }
        return this.resourceMap.getString("label.images", new Object[]{stringBuilder.toString()});
    }
}

